/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.piccolo2d.PNode;
import repast.simphony.space.graph.Network;
import repast.simphony.space.graph.RepastEdge;
import repast.simphony.space.projection.Projection;
import repast.simphony.space.projection.ProjectionEvent;
import repast.simphony.space.projection.ProjectionListener;
import repast.simphony.visualization.VisualizedObjectContainer;
import repast.simphony.visualization.editor.AddListener;
import repast.simphony.visualization.editor.AgentCloner;
import repast.simphony.visualization.editor.AgentEditor;
import repast.simphony.visualization.editor.DisplayEditor;
import repast.simphony.visualization.editor.EditorNotifier;
import repast.simphony.visualization.editor.PEditorEventListener;
import repast.simphony.visualization.editor.PNodeSelectionListener;
import repast.simphony.visualization.editor.SelectionHandler;
import repast.simphony.visualization.editor.VizEditorForm;
import repast.simphony.visualization.visualization2D.Display2D;
import simphony.util.messages.MessageCenter;

public class DisplayEditor2D
implements DisplayEditor,
PNodeSelectionListener,
ProjectionListener {
    private static final MessageCenter msg = MessageCenter.getMessageCenter(DisplayEditor2D.class);
    private Display2D display;
    private JPanel panel;
    private JPanel editorPanel;
    private List<PEditorEventListener> modelessListeners = new ArrayList<PEditorEventListener>();
    private Map<DisplayEditor.Mode, PEditorEventListener> modalListeners = new HashMap<DisplayEditor.Mode, PEditorEventListener>();
    private AddListener addListener;
    private PEditorEventListener currentListener;
    private VizEditorForm palette;
    private AgentEditor agentEditor;
    private List<Network> networks = new ArrayList<Network>();
    private Network selectedNetwork;
    private EditorNotifier notifier;
    private Object objToAdd;

    DisplayEditor2D(Display2D display, JPanel panel, EditorNotifier notifier) {
        this.display = display;
        this.panel = panel;
        for (Projection proj : display.getInitData().getProjections()) {
            if (!(proj instanceof Network)) continue;
            this.networks.add((Network)proj);
        }
        if (this.networks.size() > 0) {
            this.selectedNetwork = this.networks.get(0);
        }
        this.notifier = notifier;
    }

    void addModelessListener(PEditorEventListener listener) {
        this.modelessListeners.add(listener);
    }

    void addModalListener(DisplayEditor.Mode mode, PEditorEventListener listener) {
        this.modalListeners.put(mode, listener);
    }

    void initAddListener(AddListener listener) {
        this.addListener = listener;
    }

    @Override
    public void modeSwitched(DisplayEditor.Mode mode) {
        if (this.currentListener != null) {
            this.currentListener.stop();
        }
        this.currentListener = this.modalListeners.get((Object)mode);
        if (this.currentListener != null) {
            this.currentListener.start();
        }
    }

    @Override
    public void pNodesSelected(List<PNode> nodes) {
        ArrayList<Object> agents = new ArrayList<Object>();
        ArrayList<Object> edges = new ArrayList<Object>();
        for (PNode node : nodes) {
            Object obj = node.getAttribute((Object)"AGENT");
            if (obj != null) {
                agents.add(obj);
                continue;
            }
            obj = node.getAttribute((Object)"Relationship");
            if (obj == null) continue;
            edges.add(obj);
        }
        this.agentEditor.edgesSelected(edges);
        this.agentEditor.agentsSelected(agents);
    }

    public RepastEdge addEdge(Object source, Object target) {
        RepastEdge edge = this.selectedNetwork.addEdge(source, target);
        this.agentEditor.edgeAdded(edge, true);
        return edge;
    }

    @Override
    public void agentsSelected(Object[] objs) {
        if (this.objToAdd == null) {
            this.palette.setMode(DisplayEditor.Mode.SELECT);
            ((SelectionHandler)this.currentListener).objectsSelected(objs);
        }
    }

    @Override
    public void edgesSelected(Object[] objs) {
        this.palette.setMode(DisplayEditor.Mode.SELECT);
        ((SelectionHandler)this.currentListener).objectsSelected(objs);
    }

    @Override
    public void addAgent(Class clazz) {
        try {
            Object agent = clazz.newInstance();
            this.doAddAgent(agent);
        }
        catch (IllegalAccessException e) {
            String info = "Error while creating a new agent: see the error log for details.";
            JOptionPane.showMessageDialog(this.editorPanel, info, "Editor Error", 0);
            msg.error((Object)info, (Throwable)e, new Object[0]);
        }
        catch (InstantiationException e) {
            String info = "Error while creating a new agent: see the error log for details.";
            JOptionPane.showMessageDialog(this.editorPanel, info, "Editor Error", 0);
            msg.error((Object)info, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public boolean removeEdges(RepastEdge[] edges) {
        int res = JOptionPane.showConfirmDialog(this.editorPanel, "Are you sure you want to delete the selected edges?", "Delete Edges", 0);
        if (res == 0) {
            RepastEdge[] repastEdgeArray = edges;
            int n = edges.length;
            int n2 = 0;
            while (n2 < n) {
                RepastEdge edge = repastEdgeArray[n2];
                for (Network net : this.networks) {
                    if (!net.containsEdge(edge)) continue;
                    net.removeEdge(edge);
                    break;
                }
                ++n2;
            }
            this.notifier.editorEventOccurred();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAgents(Object[] agents) {
        int res = JOptionPane.showConfirmDialog(this.editorPanel, "Are you sure you want to delete the selected agents?", "Delete Agents", 0);
        if (res == 0) {
            VisualizedObjectContainer<Object> container = this.display.getInitData().getContainer();
            Object[] objectArray = agents;
            int n = agents.length;
            int n2 = 0;
            while (n2 < n) {
                Object agent = objectArray[n2];
                container.remove(agent);
                ++n2;
            }
            this.notifier.editorEventOccurred();
            return true;
        }
        return false;
    }

    @Override
    public void cloneAgent(Object agent) {
        AgentCloner cloner = new AgentCloner(agent);
        try {
            Object clone = cloner.createClone();
            this.doAddAgent(clone);
        }
        catch (Exception ex) {
            String info = "Error while cloning agent: see the error log for details.";
            JOptionPane.showMessageDialog(this.editorPanel, info, "Editor Error", 0);
        }
    }

    private void doAddAgent(Object obj) {
        if (this.addListener != null) {
            this.objToAdd = obj;
            this.currentListener.stop();
            this.addListener.getAddHandler().start();
        }
    }

    public void addCanceled() {
        this.objToAdd = null;
        this.addListener.postAdd();
        this.addListener.getAddHandler().stop();
        this.currentListener.start();
    }

    public void addAgentAt(double x, double y) {
        if (this.addListener.preAdd(this.objToAdd, x, y)) {
            this.addListener.getAddHandler().stop();
            this.display.getInitData().getContainer().add(this.objToAdd);
            this.notifier.editorEventOccurred();
            this.addListener.postAdd();
            this.agentEditor.agentAdded(this.objToAdd, true);
            this.currentListener.start();
            Object tmp = this.objToAdd;
            this.objToAdd = null;
            this.agentsSelected(new Object[]{tmp});
        } else {
            JOptionPane.showMessageDialog(this.panel, "Invalid location. Please try again.", "Error Adding Agent", 1);
        }
    }

    public void run() {
        int width;
        int height;
        this.display.update();
        this.display.render();
        for (Projection proj : this.display.getInitData().getProjections()) {
            proj.addProjectionListener((ProjectionListener)this);
        }
        for (PEditorEventListener listener : this.modelessListeners) {
            listener.init();
            listener.start();
        }
        for (PEditorEventListener listener : this.modalListeners.values()) {
            listener.init();
        }
        this.editorPanel = new JPanel(new BorderLayout());
        JPanel parent = (JPanel)this.panel.getParent();
        parent.remove(this.panel);
        this.palette = new VizEditorForm();
        this.palette.init(this, this.networks);
        this.palette.setAddEdgeEnabled(this.networks.size() > 0);
        this.palette.setPreferredSize(new Dimension(-1, 28));
        this.agentEditor = new AgentEditor();
        ArrayList<RepastEdge> edges = new ArrayList<RepastEdge>();
        for (Network net : this.networks) {
            for (RepastEdge edge : net.getEdges()) {
                edges.add(edge);
            }
        }
        if (edges.isEmpty()) {
            edges = null;
        }
        if ((height = this.panel.getSize().height) == 0) {
            height = this.panel.getPreferredSize().height;
        }
        if ((width = this.panel.getSize().width) == 0) {
            width = this.panel.getPreferredSize().width;
        }
        this.agentEditor.init(this, this.display.getRegisteredClasses(), edges, height / 3);
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)this.panel, "Center");
        p.add((Component)this.palette, "North");
        JSplitPane splitPane = new JSplitPane(1, p, this.agentEditor);
        splitPane.setDividerLocation(width / 3 * 2);
        this.editorPanel.add((Component)splitPane, "Center");
        parent.add(this.editorPanel);
        parent.revalidate();
        parent.repaint();
    }

    public void stop() {
        if (this.addListener != null) {
            this.addListener.getAddHandler().stop();
        }
        for (PEditorEventListener listener : this.modelessListeners) {
            listener.stop();
            listener.destroy();
        }
        for (PEditorEventListener listener : this.modalListeners.values()) {
            listener.destroy();
        }
        for (Projection proj : this.display.getInitData().getProjections()) {
            proj.removeProjectionListener((ProjectionListener)this);
        }
        if (this.currentListener != null) {
            this.currentListener.stop();
        }
        Container parent = this.editorPanel.getParent();
        parent.remove(this.editorPanel);
        this.panel.getParent().remove(this.panel);
        this.editorPanel.removeAll();
        parent.add((Component)this.panel, "Center");
        this.panel.revalidate();
        this.panel.repaint();
        parent.invalidate();
        parent.repaint();
    }

    public void projectionEventOccurred(ProjectionEvent evt) {
        Object subject = evt.getSubject();
        ProjectionEvent.Type type = evt.getType();
        if (type == ProjectionEvent.OBJECT_ADDED) {
            this.agentEditor.agentAdded(subject, false);
        } else if (type == ProjectionEvent.OBJECT_REMOVED) {
            this.agentEditor.agentRemoved(subject);
        } else if (type == ProjectionEvent.EDGE_ADDED) {
            this.agentEditor.edgeAdded((RepastEdge)subject, false);
        } else if (type == ProjectionEvent.EDGE_REMOVED) {
            this.agentEditor.edgeRemoved((RepastEdge)subject);
        } else if (type == ProjectionEvent.OBJECT_MOVED) {
            this.agentEditor.agentMoved(subject);
        }
    }

    @Override
    public VisualizedObjectContainer getContainer() {
        return this.display.getInitData().getContainer();
    }

    @Override
    public void netSelected(Network network) {
        this.selectedNetwork = network;
    }
}

