/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.editor;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.piccolo2d.PCanvas;
import org.piccolo2d.PNode;
import org.piccolo2d.event.PDragSequenceEventHandler;
import org.piccolo2d.event.PInputEvent;
import org.piccolo2d.event.PInputEventListener;
import org.piccolo2d.util.PPickPath;
import org.piccolo2d.util.PStack;
import repast.simphony.space.Dimensions;
import repast.simphony.space.continuous.ContinuousSpace;
import repast.simphony.space.graph.Network;
import repast.simphony.visualization.editor.DefaultEdgeFinder;
import repast.simphony.visualization.editor.EdgeFinder;
import repast.simphony.visualization.editor.EditorNotifier;
import repast.simphony.visualization.editor.EmptyEdgeFinder;
import repast.simphony.visualization.editor.PEditorEventListener;
import repast.simphony.visualization.editor.PNodeSelector;
import repast.simphony.visualization.network.PEdge;
import repast.simphony.visualization.visualization2D.Display2D;
import repast.simphony.visualization.visualization2D.ShapeFactory2D;

public class ContSpaceMoveHandler
extends PDragSequenceEventHandler
implements PEditorEventListener {
    private ContinuousSpace space;
    private float unitSize;
    private PCanvas canvas;
    private Point2D nodesStartPosition;
    private List<PEdge> curEdges = new ArrayList<PEdge>();
    private PNode shape;
    private Display2D display;
    private PNodeSelector selector = new PNodeSelector();
    private EdgeFinder edgeFinder = new EmptyEdgeFinder();
    private EditorNotifier notifier;

    public ContSpaceMoveHandler(PCanvas canvas, Display2D display, ContinuousSpace space, List<Network> nets, EditorNotifier notifier) {
        this.canvas = canvas;
        this.space = space;
        this.display = display;
        this.unitSize = ((Float)display.getLayout().getLayoutProperties().getProperty("cellSize")).floatValue();
        if (nets.size() > 0) {
            this.edgeFinder = new DefaultEdgeFinder(nets, display);
        }
        this.notifier = notifier;
    }

    @Override
    public void init() {
        this.findBoundingShape();
    }

    @Override
    public void destroy() {
        if (this.shape != null) {
            this.canvas.getLayer().removeChild(this.shape);
        }
    }

    protected boolean shouldStartDragInteraction(PInputEvent event) {
        if (super.shouldStartDragInteraction(event)) {
            this.selectNodes(event.getPath());
            return this.selector.getSelectedNodes().size() > 0;
        }
        return false;
    }

    protected void startDrag(PInputEvent event) {
        super.startDrag(event);
        List<PNode> selectedNodes = this.selector.getSelectedNodes();
        selectedNodes.get(0).raiseToTop();
        this.nodesStartPosition = selectedNodes.get(0).getOffset();
        this.curEdges = this.edgeFinder.findEdges(selectedNodes.get(0));
    }

    protected void drag(PInputEvent event) {
        super.drag(event);
        Point2D start = this.canvas.getCamera().localToView((Point2D)this.getMousePressedCanvasPoint().clone());
        Point2D current = event.getPosition();
        Point2D.Double dest = new Point2D.Double();
        ((Point2D)dest).setLocation(this.nodesStartPosition.getX() + (current.getX() - start.getX()), this.nodesStartPosition.getY() + (current.getY() - start.getY()));
        for (PNode node : this.selector.getSelectedNodes()) {
            node.setOffset(((Point2D)dest).getX(), ((Point2D)dest).getY());
        }
        for (PEdge edge : this.curEdges) {
            edge.update();
        }
    }

    protected void endDrag(PInputEvent event) {
        super.endDrag(event);
        Point2D xy = event.getPosition();
        List<PNode> selectedNodes = this.selector.getSelectedNodes();
        if (xy == null) {
            for (PNode node : selectedNodes) {
                node.setOffset(this.nodesStartPosition.getX(), this.nodesStartPosition.getY());
            }
        } else {
            for (PNode node : selectedNodes) {
                Object obj = this.display.findObjForItem(node);
                double x = xy.getX() / (double)this.unitSize;
                double y = xy.getY() / (double)this.unitSize;
                if (x > this.space.getDimensions().getWidth() || x < 0.0 || y > this.space.getDimensions().getHeight() || y < 0.0) {
                    node.setOffset(this.nodesStartPosition.getX(), this.nodesStartPosition.getY());
                    continue;
                }
                double[] origin = this.space.getDimensions().originToDoubleArray(null);
                double xOffset = origin[0];
                double yOffset = origin[1];
                this.space.moveTo(obj, new double[]{xy.getX() / (double)this.unitSize - xOffset, xy.getY() / (double)this.unitSize - yOffset});
            }
            this.notifier.editorEventOccurred();
        }
        this.selector.unselectNodes();
        this.curEdges.clear();
    }

    @Override
    public void start() {
        this.canvas.addInputEventListener((PInputEventListener)this);
    }

    @Override
    public void stop() {
        this.selector.unselectNodes();
        this.canvas.removeInputEventListener((PInputEventListener)this);
    }

    private void selectNodes(PPickPath path) {
        PStack stack = path.getNodeStackReference();
        this.selector.selectNodes(stack, false);
    }

    private void findBoundingShape() {
        boolean shapeFound = false;
        for (Object obj : this.canvas.getRoot().getAllNodes()) {
            PNode node = (PNode)obj;
            Object type = node.getAttribute((Object)"DECORATOR_TYPE_KEY");
            if (type == null || !type.equals("CONTINUOUS_DECORATOR")) continue;
            shapeFound = true;
            break;
        }
        if (!shapeFound) {
            Dimensions dims = this.space.getDimensions();
            float width = (float)dims.getWidth();
            float height = (float)dims.getHeight();
            if (width != Float.NEGATIVE_INFINITY && height != Float.NEGATIVE_INFINITY) {
                this.shape = ShapeFactory2D.createBoundingBox(width * this.unitSize, height * this.unitSize, Color.BLACK);
                this.canvas.getLayer().addChild(this.shape);
            }
        }
    }
}

