/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.editor;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import groovy.lang.MetaClass;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jscience.physics.amount.Amount;
import repast.simphony.context.Context;
import repast.simphony.space.continuous.ContinuousSpace;
import repast.simphony.space.graph.RepastEdge;
import repast.simphony.space.grid.Grid;
import repast.simphony.ui.probe.GridLocationProbe;
import repast.simphony.ui.probe.ProbeID;
import repast.simphony.ui.probe.SpaceLocationProbe;
import repast.simphony.util.ClassUtilities;
import repast.simphony.util.ContextUtils;
import repast.simphony.visualization.editor.AmountPropertyEditor;
import repast.simphony.visualization.editor.DisplayEditor;
import repast.simphony.visualization.editor.PropertyDescriptorAdapter;

public class AgentEditor
extends JPanel {
    private static final String ADD_ICON = "add_user.png";
    private static final String REMOVE_ICON = "delete_user.png";
    private static final String CLONE_ICON = "add_group.png";
    private static final int EDGE_INDEX = 1;
    private static final int AGENT_INDEX = 0;
    private DisplayEditor editor;
    private int agentTitleIndex = 1;
    private boolean doFireSelection = true;
    private Map<Object, String> titleMap = new HashMap<Object, String>();
    private Map<Object, String> edgeTitleMap = new HashMap<Object, String>();
    private Object selectedObject;
    private List<Class> agentClasses;
    private JPanel panel1;
    private JButton addBtn;
    private JButton removeBtn;
    private JButton cloneBtn;
    private JSplitPane splitPane1;
    private JTabbedPane tabbedPane1;
    private JScrollPane scrollPane1;
    private JList agentList;
    private JScrollPane scrollPane2;
    private JList edgeList;
    private PropertySheetPanel agentProps;

    public AgentEditor() {
        this.initComponents();
        this.agentList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    label.setText((String)AgentEditor.this.titleMap.get(value));
                }
                return label;
            }
        });
        this.edgeList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    label.setText((String)AgentEditor.this.edgeTitleMap.get(value));
                }
                return label;
            }
        });
        this.addBtn.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(ADD_ICON)));
        this.addBtn.setToolTipText("Add a new agent");
        this.removeBtn.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(REMOVE_ICON)));
        this.removeBtn.setToolTipText("Remove selected agent(s)");
        this.cloneBtn.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(CLONE_ICON)));
        this.cloneBtn.setToolTipText("Clone selected agent");
    }

    public void init(DisplayEditor editor, List<Class> agentClasses, List<RepastEdge> edges, int dividerLoc) {
        this.editor = editor;
        this.tabbedPane1.setEnabledAt(1, edges != null);
        this.agentClasses = new ArrayList<Class>(agentClasses);
        Collections.sort(agentClasses, new Comparator<Class>(){

            @Override
            public int compare(Class o1, Class o2) {
                return o1.getSimpleName().compareTo(o2.getSimpleName());
            }
        });
        this.fillLists(edges);
        this.splitPane1.setDividerLocation(dividerLoc);
        this.addListeners();
        this.addBtn.setEnabled(true);
        this.removeBtn.setEnabled(false);
        this.cloneBtn.setEnabled(false);
    }

    private void addListeners() {
        this.agentList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    AgentEditor.this.performAgentSelection();
                    AgentEditor.this.removeBtn.setEnabled(AgentEditor.this.agentList.getSelectedIndices().length > 0 && AgentEditor.this.tabbedPane1.getSelectedIndex() == 0);
                    AgentEditor.this.cloneBtn.setEnabled(AgentEditor.this.agentList.getSelectedIndices().length == 1);
                }
            }
        });
        this.edgeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    AgentEditor.this.performEdgeSelection();
                    AgentEditor.this.removeBtn.setEnabled(AgentEditor.this.edgeList.getSelectedIndices().length > 0 && AgentEditor.this.tabbedPane1.getSelectedIndex() == 1);
                }
            }
        });
        this.tabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (AgentEditor.this.tabbedPane1.getSelectedIndex() == 0) {
                    AgentEditor.this.performAgentSelection();
                    AgentEditor.this.addBtn.setEnabled(true);
                    AgentEditor.this.removeBtn.setEnabled(AgentEditor.this.agentList.getSelectedIndices().length > 0);
                    AgentEditor.this.cloneBtn.setEnabled(AgentEditor.this.agentList.getSelectedIndices().length == 1);
                } else {
                    AgentEditor.this.performEdgeSelection();
                    AgentEditor.this.addBtn.setEnabled(false);
                    AgentEditor.this.cloneBtn.setEnabled(false);
                    AgentEditor.this.removeBtn.setEnabled(AgentEditor.this.edgeList.getSelectedIndices().length > 0);
                }
            }
        });
        this.agentProps.addPropertySheetChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Property prop = (Property)evt.getSource();
                prop.writeToObject(AgentEditor.this.selectedObject);
                String title = AgentEditor.this.probeForTitle(AgentEditor.this.selectedObject);
                if (title != null && !title.equals(AgentEditor.this.titleMap.get(AgentEditor.this.selectedObject))) {
                    AgentEditor.this.titleMap.put(AgentEditor.this.selectedObject, title);
                    AgentEditor.this.agentList.revalidate();
                    AgentEditor.this.agentList.repaint();
                    DefaultListModel model = (DefaultListModel)AgentEditor.this.edgeList.getModel();
                    int i = 0;
                    while (i < model.size()) {
                        RepastEdge edge = (RepastEdge)model.get(i);
                        if (edge.getSource().equals(AgentEditor.this.selectedObject) || edge.getTarget().equals(AgentEditor.this.selectedObject)) {
                            String edgeTitle = AgentEditor.this.createEdgeTitle(edge);
                            AgentEditor.this.edgeTitleMap.put(edge, edgeTitle);
                        }
                        ++i;
                    }
                    AgentEditor.this.edgeList.revalidate();
                    AgentEditor.this.edgeList.repaint();
                }
            }
        });
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (AgentEditor.this.agentClasses.size() > 1) {
                    JPopupMenu menu = new JPopupMenu();
                    for (Class clazz : AgentEditor.this.agentClasses) {
                        menu.add(new JMenuItem(new AddMenuAction(clazz)));
                    }
                    menu.show(AgentEditor.this.addBtn, 0, ((AgentEditor)AgentEditor.this).addBtn.getSize().height);
                } else {
                    new AddMenuAction((Class)AgentEditor.this.agentClasses.get(0)).actionPerformed(evt);
                }
            }
        });
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int tabIndex = AgentEditor.this.tabbedPane1.getSelectedIndex();
                if (tabIndex == 0) {
                    Object[] agents = AgentEditor.this.agentList.getSelectedValues();
                    AgentEditor.this.editor.removeAgents(agents);
                } else if (tabIndex == 1) {
                    Object[] objs = AgentEditor.this.edgeList.getSelectedValues();
                    RepastEdge[] edges = new RepastEdge[objs.length];
                    int i = 0;
                    Object[] objectArray = objs;
                    int n = objs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        edges[i++] = (RepastEdge)obj;
                        ++n2;
                    }
                    AgentEditor.this.editor.removeEdges(edges);
                }
            }
        });
        this.cloneBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Object obj = AgentEditor.this.agentList.getSelectedValues()[0];
                AgentEditor.this.editor.cloneAgent(obj);
            }
        });
    }

    public void agentAdded(Object agent, boolean select) {
        DefaultListModel model = (DefaultListModel)this.agentList.getModel();
        if (!model.contains(agent)) {
            this.titleMap.put(agent, this.createTitle(agent));
            model.addElement(agent);
            if (select) {
                int index = model.size() - 1;
                this.agentList.setSelectedIndex(index);
                this.agentList.scrollRectToVisible(this.agentList.getCellBounds(index, index));
                this.tabbedPane1.setSelectedIndex(0);
            }
        } else if (select) {
            int index = model.indexOf(agent);
            this.agentList.scrollRectToVisible(this.agentList.getCellBounds(index, index));
            this.tabbedPane1.setSelectedIndex(0);
            this.agentList.setSelectedIndex(index);
        }
    }

    public void agentRemoved(Object agent) {
        DefaultListModel model = (DefaultListModel)this.agentList.getModel();
        model.removeElement(agent);
    }

    public void agentMoved(Object agent) {
        if (this.selectedObject != null && agent.equals(this.selectedObject)) {
            this.updateProperties();
        }
    }

    public void edgeAdded(RepastEdge edge, boolean select) {
        this.tabbedPane1.setEnabledAt(1, true);
        this.doFireSelection = false;
        DefaultListModel model = (DefaultListModel)this.edgeList.getModel();
        if (!model.contains(edge)) {
            this.edgeTitleMap.put(edge, this.createEdgeTitle(edge));
            model.addElement(edge);
            if (select) {
                int index = model.size() - 1;
                this.edgeList.setSelectedIndex(index);
                this.edgeList.scrollRectToVisible(this.edgeList.getCellBounds(index, index));
                this.tabbedPane1.setSelectedIndex(1);
            }
        } else if (select) {
            int index = model.indexOf(edge);
            this.edgeList.setSelectedIndex(index);
            this.edgeList.scrollRectToVisible(this.edgeList.getCellBounds(index, index));
            this.tabbedPane1.setSelectedIndex(1);
        }
        this.doFireSelection = true;
    }

    public void edgeRemoved(RepastEdge edge) {
        DefaultListModel model = (DefaultListModel)this.edgeList.getModel();
        model.removeElement(edge);
    }

    public void edgesSelected(List<Object> edges) {
        this.doFireSelection = false;
        int[] indices = new int[edges.size()];
        int i = 0;
        for (Object obj : edges) {
            indices[i++] = ((DefaultListModel)this.edgeList.getModel()).indexOf(obj);
        }
        this.edgeList.setSelectedIndices(indices);
        if (indices.length > 0) {
            this.edgeList.scrollRectToVisible(this.edgeList.getCellBounds(indices[0], indices[0]));
            this.tabbedPane1.setSelectedIndex(1);
        }
        this.doFireSelection = true;
    }

    public void agentsSelected(List<Object> agents) {
        this.doFireSelection = false;
        int[] indices = new int[agents.size()];
        int i = 0;
        for (Object obj : agents) {
            indices[i++] = ((DefaultListModel)this.agentList.getModel()).indexOf(obj);
        }
        this.agentList.setSelectedIndices(indices);
        if (indices.length > 0) {
            this.agentList.scrollRectToVisible(this.agentList.getCellBounds(indices[0], indices[0]));
            this.tabbedPane1.setSelectedIndex(0);
        }
        this.doFireSelection = true;
    }

    private void performEdgeSelection() {
        Object[] edges = this.edgeList.getSelectedValues();
        if (this.doFireSelection) {
            this.editor.edgesSelected(edges);
        }
        this.selectedObject = edges.length == 1 ? edges[0] : null;
        this.updateProperties();
    }

    private void performAgentSelection() {
        Object[] agents = this.agentList.getSelectedValues();
        if (this.doFireSelection) {
            this.editor.agentsSelected(agents);
        }
        this.selectedObject = agents.length == 1 ? agents[0] : null;
        this.updateProperties();
    }

    private void updateProperties() {
        if (this.selectedObject == null) {
            this.agentProps.setProperties(new Property[0]);
        } else {
            BeanInfo beanInfo = null;
            try {
                beanInfo = Introspector.getBeanInfo(this.selectedObject.getClass(), Object.class);
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
            this.agentProps.setMode(0);
            this.agentProps.setDescriptionVisible(false);
            ArrayList<PropertyDescriptor> pds = new ArrayList<PropertyDescriptor>();
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = propertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor descriptor = propertyDescriptorArray[n2];
                if (descriptor.getReadMethod() != null && !descriptor.getReadMethod().getReturnType().equals(MetaClass.class)) {
                    pds.add(descriptor);
                }
                ++n2;
            }
            this.agentProps.setProperties(pds.toArray(new PropertyDescriptor[pds.size()]));
            this.agentProps.getEditorRegistry().registerEditor(Amount.class, (PropertyEditor)((Object)new AmountPropertyEditor()));
            Property[] properties = this.agentProps.getProperties();
            int i = 0;
            int c = properties.length;
            while (i < c) {
                try {
                    Property property = properties[i];
                    if (this.selectedObject instanceof RepastEdge && (property.getName().equalsIgnoreCase("source") || property.getName().equalsIgnoreCase("target"))) {
                        this.agentProps.getRendererRegistry().registerRenderer(property, (TableCellRenderer)new SourceTargetRenderer());
                    }
                    property.readFromObject(this.selectedObject);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
            this.createLocationProperties();
        }
    }

    private void createLocationProperties() {
        Context context = ContextUtils.getContext((Object)this.selectedObject);
        try {
            if (context != null) {
                PropertyDescriptor pd;
                BeanInfo info;
                for (Grid grid : context.getProjections(Grid.class)) {
                    info = Introspector.getBeanInfo(GridLocationProbe.class, Object.class);
                    pd = info.getPropertyDescriptors()[0];
                    pd.setDisplayName(String.valueOf(grid.getName()) + " Location");
                    PropertyDescriptorAdapter prop = new PropertyDescriptorAdapter(pd);
                    GridLocationProbe probe = new GridLocationProbe(this.selectedObject, grid);
                    prop.readFromObject(probe);
                    this.agentProps.addProperty((Property)prop);
                }
                for (ContinuousSpace space : context.getProjections(ContinuousSpace.class)) {
                    info = Introspector.getBeanInfo(SpaceLocationProbe.class, Object.class);
                    pd = info.getPropertyDescriptors()[0];
                    pd.setDisplayName(String.valueOf(space.getName()) + " Location");
                    SpaceLocationProbe probe = new SpaceLocationProbe(this.selectedObject, space);
                    PropertyDescriptorAdapter prop = new PropertyDescriptorAdapter(pd);
                    prop.readFromObject(probe);
                    this.agentProps.addProperty((Property)prop);
                }
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }

    private void fillLists(List<RepastEdge> edges) {
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        for (Object obj : this.editor.getContainer()) {
            this.titleMap.put(obj, this.createTitle(obj));
            model.addElement(obj);
        }
        this.agentList.setModel(model);
        model = new DefaultListModel();
        if (edges != null) {
            for (RepastEdge edge : edges) {
                model.addElement(edge);
                this.edgeTitleMap.put(edge, this.createEdgeTitle(edge));
            }
        }
        this.edgeList.setModel(model);
    }

    private String createEdgeTitle(RepastEdge edge) {
        Object source = edge.getSource();
        Object target = edge.getTarget();
        StringBuffer buf = new StringBuffer(this.titleMap.get(source));
        buf.append(edge.isDirected() ? " -> " : " <-> ");
        buf.append(this.titleMap.get(target));
        return buf.toString();
    }

    private String probeForTitle(Object obj) {
        Method method;
        Method[] methods = ClassUtilities.findMethods(obj.getClass(), (Class[])new Class[]{ProbeID.class});
        if (methods.length > 0 && !(method = methods[0]).getReturnType().equals(Void.TYPE) && method.getParameterTypes().length == 0) {
            try {
                return method.invoke(obj, new Object[0]).toString();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private String createTitle(Object obj) {
        String title = this.probeForTitle(obj);
        return title == null ? String.valueOf(obj.getClass().getSimpleName()) + " - " + this.agentTitleIndex++ : title;
    }

    private void initComponents() {
        this.panel1 = new JPanel();
        this.addBtn = new JButton();
        this.removeBtn = new JButton();
        this.cloneBtn = new JButton();
        this.splitPane1 = new JSplitPane();
        this.tabbedPane1 = new JTabbedPane();
        this.scrollPane1 = new JScrollPane();
        this.agentList = new JList();
        this.scrollPane2 = new JScrollPane();
        this.edgeList = new JList();
        this.agentProps = new PropertySheetPanel();
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)new FormLayout(ColumnSpec.decodeSpecs((String)"default:grow"), new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}));
        this.panel1.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.BUTTON_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.BUTTON_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.BUTTON_COLSPEC}, RowSpec.decodeSpecs((String)"default")));
        this.panel1.add((Component)this.addBtn, cc.xy(1, 1));
        this.panel1.add((Component)this.removeBtn, cc.xy(3, 1));
        this.panel1.add((Component)this.cloneBtn, cc.xy(5, 1));
        this.add((Component)this.panel1, cc.xy(1, 1));
        this.splitPane1.setOrientation(0);
        this.scrollPane1.setViewportView(this.agentList);
        this.tabbedPane1.addTab("Agents", this.scrollPane1);
        this.scrollPane2.setViewportView(this.edgeList);
        this.tabbedPane1.addTab("Links", this.scrollPane2);
        this.tabbedPane1.setEnabledAt(1, false);
        this.splitPane1.setTopComponent(this.tabbedPane1);
        this.splitPane1.setBottomComponent((Component)this.agentProps);
        this.add((Component)this.splitPane1, cc.xy(1, 3));
    }

    private class AddMenuAction
    extends AbstractAction {
        private Class clazz;

        public AddMenuAction(Class clazz) {
            super(clazz.getSimpleName());
            this.clazz = clazz;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AgentEditor.this.editor.addAgent(this.clazz);
        }
    }

    private class SourceTargetRenderer
    extends DefaultTableCellRenderer {
        private SourceTargetRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String title = (String)AgentEditor.this.titleMap.get(value);
            return super.getTableCellRendererComponent(table, title == null ? value : title, isSelected, hasFocus, row, column);
        }
    }
}

