/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.editedStyle;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.piccolo2d.PNode;
import org.piccolo2d.nodes.PImage;
import org.piccolo2d.nodes.PPath;
import org.piccolo2d.nodes.PText;
import repast.simphony.visualization.editedStyle.DefaultEditedStyleData2D;
import repast.simphony.visualization.editedStyle.EditedStyleData;
import repast.simphony.visualization.editedStyle.EditedStyleUtils;
import repast.simphony.visualization.gui.styleBuilder.IconFactory2D;
import repast.simphony.visualization.visualization2D.style.Style2D;

public class EditedStyle2D
implements Style2D<Object> {
    EditedStyleData<Object> innerStyle;
    private Image image;

    public EditedStyle2D(String userStyleFile) {
        this.innerStyle = EditedStyleUtils.getStyle(userStyleFile);
        if (this.innerStyle == null) {
            this.innerStyle = new DefaultEditedStyleData2D<Object>();
        }
        String iconFile = this.innerStyle.getIconFile2D();
        BufferedImage im = null;
        if (iconFile != null) {
            File file = new File(iconFile);
            try {
                im = ImageIO.read(file);
                PImage pimage = new PImage((Image)im);
                AffineTransform trans = new AffineTransform();
                trans.setToScale(1.0, -1.0);
                pimage.transformBy(trans);
                this.image = pimage.toImage();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Rectangle2D getBounds(Object object) {
        float size = EditedStyleUtils.getSize(this.innerStyle, object);
        return new Rectangle2D.Float(0.0f, 0.0f, size, size);
    }

    @Override
    public PNode getPNode(Object object, PNode node) {
        float size = EditedStyleUtils.getSize(this.innerStyle, object);
        if (this.image != null) {
            PImage pimage = new PImage(this.image);
            pimage.setBounds((Rectangle2D)new Rectangle2D.Float(0.0f, 0.0f, size, size));
            return pimage;
        }
        String wkt = this.innerStyle.getShapeWkt();
        Shape shape = IconFactory2D.getShape(wkt);
        PPath.Double path = new PPath.Double(shape);
        path.setBounds((Rectangle2D)new Rectangle2D.Float(0.0f, 0.0f, size, size));
        return path;
    }

    @Override
    public Paint getPaint(Object object) {
        return EditedStyleUtils.getColor(this.innerStyle, object);
    }

    @Override
    public double getRotation(Object object) {
        return 0.0;
    }

    @Override
    public Stroke getStroke(Object object) {
        return new BasicStroke(1.0f);
    }

    @Override
    public Paint getStrokePaint(Object object) {
        return Color.BLACK;
    }

    @Override
    public boolean isScaled(Object object) {
        return true;
    }

    @Override
    public PText getLabel(Object object) {
        PText label = null;
        label = new PText(EditedStyleUtils.getLabel(this.innerStyle, object));
        Font font = new Font(this.innerStyle.getLabelFontFamily(), this.innerStyle.getLabelFontType(), this.innerStyle.getLabelFontSize());
        if ("".equals(label.getText())) {
            return null;
        }
        label.setFont(font);
        double offSet = this.innerStyle.getLabelOffset();
        double xOffSet = 0.0;
        double yOffSet = 0.0;
        double width = this.getBounds(object).getWidth();
        double height = this.getBounds(object).getHeight();
        if ("right".equals(this.innerStyle.getLabelPosition())) {
            xOffSet = width + offSet;
            yOffSet = height / 2.0 + label.getBounds().height / 2.0;
        } else if ("left".equals(this.innerStyle.getLabelPosition())) {
            xOffSet = -label.getBounds().width - offSet;
            yOffSet = height / 2.0 + label.getBounds().height / 2.0;
        } else if ("top".equals(this.innerStyle.getLabelPosition())) {
            xOffSet = -(label.getWidth() / 2.0 - width / 2.0);
            yOffSet = height + label.getBounds().height + offSet;
        } else {
            xOffSet = -(label.getWidth() / 2.0 - width / 2.0);
            yOffSet = -offSet;
        }
        label.setOffset(xOffSet, yOffSet);
        float[] colorRGB = this.innerStyle.getLabelColor();
        label.setTextPaint((Paint)new Color(colorRGB[0], colorRGB[1], colorRGB[2]));
        return label;
    }
}

