/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.continuous;

import javax.vecmath.Point3f;
import repast.simphony.space.Dimensions;
import repast.simphony.space.continuous.ContinuousSpace;
import repast.simphony.space.continuous.NdPoint;
import repast.simphony.visualization.Box;
import repast.simphony.visualization.Layout;
import repast.simphony.visualization.VisualizationProperties;

public class Continuous2DLayout
implements Layout<Object, ContinuousSpace> {
    private ContinuousSpace space;
    protected float[] point = new float[2];
    private float unitSize = 15.0f;
    private Box box = null;
    private VisualizationProperties visualizationProps;

    public Continuous2DLayout() {
    }

    public Continuous2DLayout(ContinuousSpace space) {
        this.space = space;
    }

    public void setProjection(ContinuousSpace space) {
        this.space = space;
    }

    public void setLayoutProperties(VisualizationProperties props) {
        this.visualizationProps = props;
        Object obj = props.getProperty("cellSize");
        if (obj != null && obj instanceof Float) {
            this.unitSize = ((Float)obj).floatValue();
        }
    }

    public VisualizationProperties getLayoutProperties() {
        return this.visualizationProps;
    }

    public float[] getLocation(Object obj) {
        NdPoint gpoint = this.space.getLocation(obj);
        double[] origin = this.space.getDimensions().originToDoubleArray(null);
        float xOffset = (float)origin[0];
        float yOffset = (float)origin[1];
        if (gpoint == null) {
            this.point[0] = Float.POSITIVE_INFINITY;
            this.point[1] = Float.POSITIVE_INFINITY;
            return this.point;
        }
        float x = (float)gpoint.getX();
        float y = (float)gpoint.getY();
        this.point[0] = (x + xOffset) * this.unitSize;
        this.point[1] = (y + yOffset) * this.unitSize;
        return this.point;
    }

    public void update() {
    }

    public String getName() {
        return "Continuous 2D";
    }

    public Box getBoundingBox() {
        if (this.box == null) {
            Dimensions dims = this.space.getDimensions();
            double[] origin = this.space.getDimensions().originToDoubleArray(null);
            float xOffset = (float)origin[0];
            float yOffset = (float)origin[1];
            this.box = new Box(new Point3f(xOffset * this.unitSize, yOffset * this.unitSize, 0.0f), new Point3f(((float)dims.getWidth() + xOffset) * this.unitSize, ((float)dims.getHeight() + xOffset) * this.unitSize, 0.0f));
        }
        return this.box;
    }
}

