/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.cgd.util;

import java.awt.geom.Point2D;
import java.util.TreeSet;
import repast.simphony.visualization.cgd.graph.CGDGraph;
import repast.simphony.visualization.cgd.util.CGDTreeSet;
import repast.simphony.visualization.cgd.util.Clan;

public class ParseClanTree {
    public ParseClanTree parent = null;
    public ParseClanTree firstChild = null;
    public ParseClanTree nextSibling = null;
    public Clan clan = null;
    public double minx;
    public double maxx;
    public double centerx;
    public ParseClanTree leftSibling;
    public Point2D.Double size = new Point2D.Double(0.0, 0.0);
    public Point2D.Double position = new Point2D.Double(0.0, 0.0);
    public double extraheight = 0.0;
    public boolean dummy;
    public int heightInTree;
    private int id;
    private int numClans;

    public void addClan(Clan clan) {
        ParseClanTree newpct = new ParseClanTree();
        newpct.clan = clan;
        this.addChild(this, newpct);
    }

    public void addChild(ParseClanTree newnode) {
        this.addChild(this, newnode);
    }

    private void addChild(ParseClanTree node, ParseClanTree newnode) {
        ParseClanTree child;
        Clan clan = newnode.clan;
        int order = clan.order;
        block0: do {
            if (node.firstChild == null) {
                node.firstChild = newnode;
                newnode.parent = node;
                newnode.nextSibling = null;
                return;
            }
            child = node.firstChild;
            while (child != null) {
                if (((CGDTreeSet)child.clan.nodes).isSubset(clan.nodes)) {
                    node = child;
                    continue block0;
                }
                child = child.nextSibling;
            }
        } while (child != null);
        if (node.firstChild.clan.order > order) {
            newnode.nextSibling = node.firstChild;
            node.firstChild = newnode;
            newnode.parent = node;
            return;
        }
        ParseClanTree tmpnode = node.firstChild;
        while (tmpnode.nextSibling != null && tmpnode.nextSibling.clan.order <= order) {
            tmpnode = tmpnode.nextSibling;
        }
        newnode.nextSibling = tmpnode.nextSibling;
        tmpnode.nextSibling = newnode;
        newnode.parent = node;
    }

    private void moveChild(ParseClanTree node, ParseClanTree newnode) {
        Clan clan = newnode.clan;
        int order = clan.order;
        if (node.firstChild == null) {
            node.firstChild = newnode;
            newnode.parent = node;
            newnode.nextSibling = null;
            return;
        }
        if (node.firstChild.clan.order > order) {
            newnode.nextSibling = node.firstChild;
            node.firstChild = newnode;
            newnode.parent = node;
            return;
        }
        ParseClanTree tmpnode = node.firstChild;
        while (tmpnode.nextSibling != null && tmpnode.nextSibling.clan.order <= order) {
            tmpnode = tmpnode.nextSibling;
        }
        newnode.nextSibling = tmpnode.nextSibling;
        tmpnode.nextSibling = newnode;
        newnode.parent = node;
    }

    public void fixLinear(TreeSet node_subset, TreeSet[] child_relation, TreeSet[] parent_relation) {
        ParseClanTree child = this.firstChild;
        while (child != null) {
            child.fixLinear(node_subset, child_relation, parent_relation);
            child = child.nextSibling;
        }
        if (this.clan.clanType != 3) {
            return;
        }
        boolean is_linear = true;
        ParseClanTree last = this.firstChild;
        ParseClanTree cur = last.nextSibling;
        while (is_linear && cur != null) {
            CGDTreeSet last_children = new CGDTreeSet();
            last_children.union(child_relation[(Integer)last.clan.sinks.first()]);
            last_children.intersect(node_subset);
            CGDTreeSet cur_parents = new CGDTreeSet();
            cur_parents.union(parent_relation[(Integer)cur.clan.sources.first()]);
            cur_parents.intersect(node_subset);
            if (!((CGDTreeSet)cur.clan.nodes).isSubset(last_children) || !((CGDTreeSet)last.clan.nodes).isSubset(cur_parents)) {
                is_linear = false;
                break;
            }
            last = cur;
            cur = last.nextSibling;
        }
        if (is_linear) {
            this.clan.clanType = 2;
        }
    }

    public void reduce() {
        this.reduce(this);
    }

    private void reduce(ParseClanTree node) {
        int num_children = 0;
        ParseClanTree child = node.firstChild;
        while (child != null) {
            ++num_children;
            child = child.nextSibling;
        }
        ParseClanTree[] children = new ParseClanTree[num_children];
        child = node.firstChild;
        int i = 0;
        while (child != null) {
            children[i] = child;
            child = child.nextSibling;
            ++i;
        }
        i = 0;
        while (i < num_children) {
            this.reduce(children[i]);
            ++i;
        }
        int ptype = node.parent != null ? node.parent.clan.clanType : 0;
        int ntype = node.clan.clanType;
        if (node.parent != null && (ptype == ntype || ptype == 4 && ntype == 1 || ptype == 1 && ntype == 4)) {
            ParseClanTree tmpnode;
            if (ntype == 4) {
                node.parent.clan.clanType = 4;
            }
            while (node.firstChild != null) {
                tmpnode = node.firstChild;
                node.firstChild = node.firstChild.nextSibling;
                this.moveChild(node.parent, tmpnode);
            }
            if (node.parent.firstChild == node) {
                node.parent.firstChild = node.nextSibling;
            } else {
                tmpnode = node.parent.firstChild;
                while (tmpnode.nextSibling != node) {
                    tmpnode = tmpnode.nextSibling;
                }
                tmpnode.nextSibling = node.nextSibling;
            }
        }
    }

    public void setId(int _id) {
        this.id = _id;
        this.setId(this);
        this.numClans = this.id - _id;
    }

    private void setId(ParseClanTree node) {
        node.clan.id = node.clan.clanType == 5 ? (Integer)node.clan.nodes.first() : this.id++;
        ParseClanTree tmpnode = node.firstChild;
        while (tmpnode != null) {
            this.setId(tmpnode);
            tmpnode = tmpnode.nextSibling;
        }
    }

    public void reorder() {
        this.reorder(this);
    }

    private void reorder(ParseClanTree node) {
        ParseClanTree tmpnode;
        if (node.clan.clanType == 5) {
            return;
        }
        int numchildren = 0;
        int numdummies = 0;
        ParseClanTree tmp = node.firstChild;
        while (tmp != null) {
            this.reorder(tmp);
            ++numchildren;
            if (tmp.dummy) {
                ++numdummies;
            }
            tmp = tmp.nextSibling;
        }
        if (numchildren < 2 || node.clan.clanType != 1 && node.clan.clanType != 4) {
            return;
        }
        ParseClanTree[] children = new ParseClanTree[numchildren];
        int i = 0;
        tmp = node.firstChild;
        while (tmp != null) {
            children[i++] = tmp;
            tmp = tmp.nextSibling;
        }
        i = 0;
        while (i < numchildren - 1) {
            int j = i + 1;
            while (j < numchildren) {
                if (!children[i].dummy && !children[j].dummy && children[j].centerx < children[i].centerx || !children[i].dummy && children[j].dummy) {
                    tmpnode = children[i];
                    children[i] = children[j];
                    children[j] = tmpnode;
                }
                ++j;
            }
            ++i;
        }
        if (numdummies > 0) {
            int num_left = (numchildren - numdummies) / 2;
            i = 0;
            while (i < num_left) {
                tmpnode = children[i];
                children[i] = children[i + numdummies];
                children[i + numdummies] = tmpnode;
                ++i;
            }
        }
        node.firstChild = children[0];
        i = 0;
        while (i < numchildren - 1) {
            children[i].nextSibling = children[i + 1];
            ++i;
        }
        children[i].nextSibling = null;
    }

    public String toString() {
        return this._toString(0, null);
    }

    public String toString(CGDGraph graph) {
        return this._toString(0, graph);
    }

    private String _toString(int indent, CGDGraph graph) {
        String string = new String();
        int i = 0;
        while (i < indent) {
            string = String.valueOf(string) + "   ";
            ++i;
        }
        string = graph != null ? String.valueOf(string) + this.clan.toString(graph) : String.valueOf(string) + this.clan.toString();
        if (this.firstChild != null) {
            string = String.valueOf(string) + "\n";
            i = 0;
            while (i < indent + 1) {
                string = String.valueOf(string) + "   ";
                ++i;
            }
            string = String.valueOf(string) + "(\n";
            ParseClanTree tmpclan = this.firstChild;
            while (tmpclan != null) {
                string = String.valueOf(string) + tmpclan._toString(indent + 1, graph);
                string = String.valueOf(string) + "\n";
                tmpclan = tmpclan.nextSibling;
            }
            i = 0;
            while (i < indent + 1) {
                string = String.valueOf(string) + "   ";
                ++i;
            }
            string = String.valueOf(string) + ")";
        }
        return string;
    }
}

