/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.cgd.graph;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import repast.simphony.visualization.cgd.algorithm.ClanGraphDecompAlgorithm;
import repast.simphony.visualization.cgd.graph.CGDEdge;
import repast.simphony.visualization.cgd.graph.CGDNode;
import repast.simphony.visualization.cgd.graph.GraphUtil;
import repast.simphony.visualization.cgd.util.CGDTreeSet;
import repast.simphony.visualization.cgd.util.ParseClanTree;

public class CGDGraph
implements Cloneable {
    ArrayList nodes;
    HashMap edges;
    GraphUtil gu;

    public CGDGraph() {
        this(null, null);
    }

    public CGDGraph(ArrayList _nodes, HashMap _edges) {
        this.nodes = _nodes;
        this.edges = _edges;
        this.gu = new GraphUtil();
    }

    public void addNode(int index) {
        CGDNode node = new CGDNode(index);
        node.isDummy = true;
        this.nodes.add(node);
    }

    public void addDummyNode(int index) {
        CGDNode node = new CGDNode(index);
        node.isDummy = true;
        this.nodes.add(node);
    }

    public void setNodes(ArrayList _nodes) {
        this.nodes = _nodes;
    }

    public ArrayList getNodes() {
        return this.nodes;
    }

    public void setEdges(HashMap _edges) {
        this.edges = _edges;
    }

    public HashMap getEdges() {
        return this.edges;
    }

    public CGDEdge getEdge(int x, int y) {
        CGDEdge edge = null;
        edge = (CGDEdge)this.edges.get(new Point(x, y));
        return edge;
    }

    public CGDNode getNode(int ix) {
        CGDNode n = null;
        int i = 0;
        while (i < this.nodes.size()) {
            n = (CGDNode)this.nodes.get(i);
            if (n.getIndex() == ix) {
                return n;
            }
            ++i;
        }
        return null;
    }

    public Object clone() {
        try {
            CGDGraph newGraph = (CGDGraph)super.clone();
            newGraph.nodes = new ArrayList();
            newGraph.edges = new HashMap();
            int i = 0;
            while (i < this.nodes.size()) {
                CGDNode n = (CGDNode)this.nodes.get(i);
                CGDNode newN = new CGDNode(n.getIndex(), n.getIdentifier());
                newGraph.nodes.add(newN);
                ++i;
            }
            for (Point p : this.edges.keySet()) {
                CGDEdge e = (CGDEdge)this.edges.get(p);
                CGDEdge newE = new CGDEdge(e.getSource(), e.getTarget(), e.getIndex(), e.getIdentifier());
                newGraph.edges.put(p, newE);
            }
            return newGraph;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void copy(CGDGraph g) {
        this.edges = g.edges;
        this.nodes = g.nodes;
    }

    public void compute() {
        ClanGraphDecompAlgorithm alg = new ClanGraphDecompAlgorithm();
        alg.compute(this);
    }

    public TreeSet[] processChildRelation() {
        TreeSet[] result = new TreeSet[this.nodes.size()];
        Point edge = null;
        int y = 0;
        CGDNode node = null;
        Object[] eArray = this.edges.keySet().toArray();
        int i = 0;
        while (i < eArray.length) {
            edge = (Point)eArray[i];
            node = ((CGDEdge)this.edges.get(edge)).getSource();
            int x = (int)edge.getX();
            y = (int)edge.getY();
            if (node != null) {
                node.children.add(y);
            }
            ++i;
        }
        System.out.println("maxNIndex = " + CGDNode.maxNIndex + " ; nodes list size = " + this.nodes.size());
        int j = 0;
        while (j < this.nodes.size()) {
            node = (CGDNode)this.nodes.get(j);
            result[j] = node.children;
            ++j;
        }
        return result;
    }

    public void addEdge(int x, int y) {
        CGDNode source = this.getNode(x);
        CGDNode target = this.getNode(y);
        if (source == null || target == null) {
            System.out.println("CGDGraph.addEdge: Node does not exist: source=" + x + ", target=" + y + ".");
            return;
        }
        CGDEdge edge = new CGDEdge(source, target);
        edge.setIdentifier("" + ++CGDEdge.maxEIndex);
        edge.setIndex(CGDEdge.maxEIndex);
        this.edges.put(new Point(x, y), edge);
    }

    public void addEdge(int x, int y, Point2D.Double[] _edgePoints) {
        this.addEdge(x, y);
        CGDEdge edge = this.getEdge(x, y);
        edge.setPoints(_edgePoints);
    }

    public boolean removeEdge(int x, int y) {
        boolean result = false;
        Point newPoint = new Point(x, y);
        Object o = this.edges.remove(newPoint);
        if (o != null) {
            result = true;
        }
        return result;
    }

    public GraphUtil getGraphUtil() {
        return this.gu;
    }

    public void buildNodeLayout(ParseClanTree _root, int numNodes, int initialNumNodes, TreeSet[] parentRel) {
        this.gu.buildNodeLayout(this, _root, numNodes, initialNumNodes, parentRel);
    }

    public CGDTreeSet parents(int n) {
        CGDTreeSet parents = new CGDTreeSet();
        int i = 0;
        while (i < this.nodes.size()) {
            CGDNode node = (CGDNode)this.nodes.get(i);
            if (node.children.contains(n)) {
                parents.add(node.getIndex());
            }
            ++i;
        }
        return parents;
    }

    public CGDTreeSet children(int n) {
        return ((CGDNode)this.nodes.get(n)).getChildren();
    }

    public void dummysToEdgePaths() {
        this.gu.dummysToEdgePaths(this);
    }

    public int getMaxNIndex() {
        return CGDNode.maxNIndex;
    }

    public void setMaxNIndex(int i) {
        CGDNode.maxNIndex = i;
    }

    public int getMaxEIndex() {
        return CGDEdge.maxEIndex;
    }

    public void setMaxEIndex(int i) {
        CGDEdge.maxEIndex = i;
    }

    public int getNumOfNodes() {
        return this.nodes.size();
    }
}

