/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.cgd.algorithm;

import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import repast.simphony.visualization.cgd.algorithm.Parser;
import repast.simphony.visualization.cgd.graph.CGDGraph;
import repast.simphony.visualization.cgd.graph.CGDNode;
import repast.simphony.visualization.cgd.util.CGDTreeSet;
import repast.simphony.visualization.cgd.util.ParseClanTree;

public class ClanGraphDecompAlgorithm {
    CGDGraph graph;
    int numNodes;
    int initialNumNodes;
    private TreeSet[] childRelation;
    private TreeSet[] descendentRelation;
    private TreeSet[] parentRelation;
    private TreeSet[] ancestorRelation;
    private HashMap<Integer, Integer> topObjOrder;
    private ParseClanTree root;

    public String compute(CGDGraph _graph) {
        this.graph = _graph;
        if (this.graph.getNodes().size() < 2) {
            return "Graph needs to have more than one node.";
        }
        CGDGraph oldG = (CGDGraph)this.graph.clone();
        this.numNodes = this.initialNumNodes = this.graph.getNodes().size();
        this.childRelation = this.graph.processChildRelation();
        this.eliminateLongEdges();
        if (this.lookForCycles()) {
            this.graph.copy(oldG);
            return "Graph contains cycles.";
        }
        this.parentAncestorStructure();
        this.assignLevels();
        TreeSet<Integer> allNodes = this.fillAllNodes(this.numNodes);
        Parser parser = new Parser();
        parser.setTopObjOrder(this.topObjOrder);
        parser.setNumNodes(this.numNodes);
        this.root = parser.parseSet(this.childRelation, this.parentRelation, this.descendentRelation, this.ancestorRelation, allNodes);
        this.setNodesPosition(this.root);
        this.root.reorder();
        this.graph.buildNodeLayout(this.root, this.numNodes, this.initialNumNodes, this.parentRelation);
        this.graph.dummysToEdgePaths();
        return null;
    }

    public CGDGraph compute(CGDGraph _graph, boolean originalCall) {
        this.compute(_graph);
        return _graph;
    }

    private boolean eliminateLongEdges() {
        boolean result = false;
        TreeSet[] initChRelation = new TreeSet[this.numNodes];
        int i = 0;
        while (i < this.numNodes) {
            initChRelation[i] = (CGDTreeSet)this.childRelation[i].clone();
            ++i;
        }
        this.relationReduction();
        this.createDummyNodes(initChRelation);
        result = true;
        return result;
    }

    private void transitiveClosure() {
        int i = 0;
        while (i < this.numNodes) {
            int index = ((CGDNode)this.graph.getNodes().get(i)).getIndex();
            int j = 0;
            while (j < this.numNodes) {
                if (this.childRelation[j].contains(index)) {
                    ((CGDTreeSet)this.childRelation[j]).union(this.childRelation[i]);
                }
                ++j;
            }
            ++i;
        }
    }

    private void relationReduction() {
        this.transitiveClosure();
        int i = 0;
        while (i < this.numNodes) {
            int index = ((CGDNode)this.graph.getNodes().get(i)).getIndex();
            int j = 0;
            while (j < this.numNodes) {
                if (this.childRelation[j].contains(index)) {
                    ((CGDTreeSet)this.childRelation[j]).difference(this.childRelation[i]);
                }
                ++j;
            }
            ++i;
        }
    }

    private void createDummyNodes(TreeSet[] _initChRelation) {
        TreeSet ts = null;
        int added = 0;
        int i = 0;
        while (i < this.numNodes) {
            ts = _initChRelation[i];
            Iterator it1 = ts.iterator();
            while (it1.hasNext()) {
                if (this.childRelation[i].contains(it1.next())) continue;
                ++added;
            }
            ++i;
        }
        this.numNodes += added;
        TreeSet[] newChRelation = new TreeSet[this.numNodes];
        int i2 = 0;
        while (i2 < this.numNodes) {
            newChRelation[i2] = new CGDTreeSet();
            ++i2;
        }
        i2 = 0;
        while (i2 < this.initialNumNodes) {
            ts = this.childRelation[i2];
            Iterator it2 = ts.iterator();
            while (it2.hasNext()) {
                newChRelation[i2].add(it2.next());
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.initialNumNodes) {
            ts = _initChRelation[i3];
            for (Integer nodeIndex : ts) {
                if (this.childRelation[i3].contains(nodeIndex)) continue;
                int dummyIndex = ++CGDNode.maxNIndex;
                this.graph.addDummyNode(dummyIndex);
                this.graph.removeEdge(i3, nodeIndex);
                this.graph.addEdge(i3, dummyIndex);
                this.graph.getNode(i3).addChild(dummyIndex);
                this.graph.addEdge(dummyIndex, nodeIndex);
                this.graph.getNode(dummyIndex).addChild(nodeIndex);
                newChRelation[i3].add(dummyIndex);
                newChRelation[dummyIndex].add(nodeIndex);
            }
            ++i3;
        }
        this.childRelation = newChRelation;
    }

    private boolean lookForCycles() {
        boolean result = false;
        TreeSet[] tmpChRelation = new TreeSet[this.numNodes];
        int i = 0;
        while (i < this.numNodes) {
            tmpChRelation[i] = (CGDTreeSet)this.childRelation[i].clone();
            ++i;
        }
        this.transitiveClosure();
        this.descendentRelation = new TreeSet[this.numNodes];
        int j = 0;
        while (j < this.numNodes) {
            this.descendentRelation[j] = (CGDTreeSet)this.childRelation[j].clone();
            ++j;
        }
        this.childRelation = tmpChRelation;
        int k = 0;
        while (k < this.numNodes) {
            int index = ((CGDNode)this.graph.getNodes().get(k)).getIndex();
            if (this.descendentRelation[k].contains(index)) {
                result = true;
            }
            ++k;
        }
        return result;
    }

    private void parentAncestorStructure() {
        this.parentRelation = new TreeSet[this.numNodes];
        this.ancestorRelation = new TreeSet[this.numNodes];
        int i = 0;
        i = 0;
        while (i < this.numNodes) {
            this.parentRelation[i] = new CGDTreeSet();
            this.ancestorRelation[i] = new CGDTreeSet();
            ++i;
        }
        i = 0;
        while (i < this.numNodes) {
            Iterator it1 = this.childRelation[i].iterator();
            Iterator it2 = this.descendentRelation[i].iterator();
            while (it1.hasNext()) {
                int p = (Integer)it1.next();
                this.parentRelation[p].add(i);
            }
            while (it2.hasNext()) {
                int a = (Integer)it2.next();
                this.ancestorRelation[a].add(i);
            }
            ++i;
        }
    }

    private void assignLevels() {
        this.topObjOrder = new HashMap();
        int i = 0;
        while (i < this.numNodes) {
            int index = ((CGDNode)this.graph.getNodes().get(i)).getIndex();
            if (this.parentRelation[i].isEmpty()) {
                this.assignLevels(index, 0);
            }
            ++i;
        }
    }

    private void assignLevels(int node, int level) {
        Integer o = this.topObjOrder.get(node);
        if (o == null) {
            this.topObjOrder.put(node, level);
            TreeSet children = this.childRelation[node];
            Iterator it = children.iterator();
            while (it.hasNext()) {
                this.assignLevels((Integer)it.next(), level + 1);
            }
        }
    }

    private TreeSet<Integer> fillAllNodes(int number) {
        CGDTreeSet<Integer> ts = new CGDTreeSet<Integer>();
        int i = 0;
        while (i < number) {
            if (this.graph.getNode(i) != null) {
                int index = this.graph.getNode(i).getIndex();
                ts.add(index);
            }
            ++i;
        }
        return ts;
    }

    private void setNodesPosition(ParseClanTree node) {
        node.dummy = false;
        if (node.clan.clanType == 5) {
            int graphnode = (Integer)node.clan.nodes.first();
            if (graphnode < this.initialNumNodes) {
                node.maxx = node.centerx = this.graph.getNode(graphnode).getX();
                node.minx = node.centerx;
            } else {
                node.dummy = true;
            }
        } else {
            boolean firsttime = true;
            ParseClanTree tmp = node.firstChild;
            while (tmp != null) {
                this.setNodesPosition(tmp);
                if (!tmp.dummy) {
                    if (firsttime) {
                        node.minx = tmp.minx;
                        node.maxx = tmp.maxx;
                    } else {
                        if (tmp.minx < node.minx) {
                            node.minx = tmp.minx;
                        }
                        if (tmp.maxx > node.maxx) {
                            node.maxx = tmp.maxx;
                        }
                    }
                    firsttime = false;
                }
                tmp = tmp.nextSibling;
            }
            if (firsttime) {
                node.dummy = true;
            } else {
                node.centerx = (node.minx + node.maxx) / 2.0;
            }
        }
    }
}

