/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.cgd;

import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import repast.simphony.space.graph.Network;
import repast.simphony.space.graph.RepastEdge;
import repast.simphony.visualization.cgd.graph.CGDEdge;
import repast.simphony.visualization.cgd.graph.CGDGraph;
import repast.simphony.visualization.cgd.graph.CGDNode;

public class CGDProcessor {
    CGDGraph graph = new CGDGraph();
    Network rootGraph;
    HashMap<Network, CGDGraph> translation = new HashMap();
    HashMap<Object, Object> objectData = new HashMap();
    HashMap<Object, Integer> indexNumber = new HashMap();
    int rootNumbNodes = 0;

    public HashMap processGraph(Network rGraph) {
        HashMap result = new HashMap();
        this.createCGDGraph(rGraph);
        this.graph.compute();
        this.transferFromCGDGraphToOrig();
        return result;
    }

    private void createCGDGraph(Network rGraph) {
        ArrayList<CGDNode> nodes = new ArrayList<CGDNode>();
        HashMap<Point, CGDEdge> edges = new HashMap<Point, CGDEdge>();
        Iterator itN = rGraph.getNodes().iterator();
        Iterator itE = rGraph.getEdges().iterator();
        int eIndex = 0;
        int maxEIndex = 0;
        boolean nIndex = false;
        int maxNIndex = 0;
        int n = 0;
        while (itN.hasNext()) {
            Object fNode = itN.next();
            CGDNode node = new CGDNode();
            node.setIdentifier(rGraph.getName());
            node.setIndex(n);
            nodes.add(node);
            this.indexNumber.put(fNode, n);
            this.objectData.put(fNode, node);
            ++n;
        }
        this.rootNumbNodes = nodes.size();
        this.graph.setNodes(nodes);
        this.graph.setMaxNIndex(maxNIndex);
        while (itE.hasNext()) {
            RepastEdge fEdge = (RepastEdge)itE.next();
            Object fSource = fEdge.getSource();
            int s = this.indexNumber.get(fSource);
            CGDNode source = this.graph.getNode(s);
            Object fTarget = fEdge.getTarget();
            int t = this.indexNumber.get(fTarget);
            CGDNode target = this.graph.getNode(t);
            CGDEdge edge = new CGDEdge(source, target);
            edge.setIdentifier(rGraph.getName());
            eIndex = s;
            edge.setIndex(eIndex);
            if (maxEIndex < eIndex) {
                maxEIndex = eIndex;
            }
            edges.put(new Point(s, t), edge);
            ++n;
        }
        this.graph.setEdges(edges);
        this.translation.put(rGraph, this.graph);
    }

    public HashMap getFinalEdges() {
        HashMap results = new HashMap();
        return results;
    }

    public HashMap getFinalNodes() {
        HashMap results = new HashMap();
        return results;
    }

    private boolean transferFromCGDGraphToOrig() {
        boolean result = false;
        ArrayList nodes = this.graph.getNodes();
        HashMap edges = this.graph.getEdges();
        if (nodes == null) {
            return result;
        }
        if (nodes.size() != this.rootNumbNodes) {
            System.out.println("nodes.size=" + nodes.size() + " and origNumbNodes=" + this.rootNumbNodes);
            return result;
        }
        int i = 0;
        while (i < nodes.size()) {
            CGDNode cgdNode = (CGDNode)nodes.get(i);
            int nIndex = cgdNode.getIndex();
            Object node = null;
            for (Map.Entry<Object, Object> e : this.objectData.entrySet()) {
                CGDNode o = (CGDNode)e.getValue();
                if (!o.equals(cgdNode)) continue;
                node = e.getKey();
            }
            ++i;
        }
        result = true;
        return result;
    }

    public HashMap getObjectData() {
        return this.objectData;
    }
}

