/*
 * Decompiled with CFR 0.152.
 */
package aragost.repast.visualization;

import aragost.repast.visualization.DirtyRegion;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.awt.AWTTextureIO;
import java.awt.image.BufferedImage;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLProfile;
import javax.vecmath.Point3f;
import saf.v3d.picking.BoundingSphere;
import saf.v3d.render.RenderState;
import saf.v3d.render.Texture2D;

public class UpdatableTexture2D
extends Texture2D {
    private BufferedImage backingImg;
    private Texture texture;
    private TextureData textureData;
    private BoundingSphere sphere;
    private DirtyRegion dirtyRegion;
    private int listIndex;

    public UpdatableTexture2D(BufferedImage img, DirtyRegion dr) {
        super(img);
        this.dirtyRegion = dr;
        this.init(img);
    }

    private void init(BufferedImage img) {
        this.backingImg = img;
        this.sphere = new BoundingSphere(new Point3f(0.0f, 0.0f, 0.0f), Math.max((float)img.getHeight() / 2.0f, (float)img.getWidth() / 2.0f));
    }

    public void bind(GL2 gl) {
        if (this.texture == null) {
            this.createTexture(gl);
        }
        this.texture.bind((GL)gl);
    }

    public int getTarget(GL2 gl) {
        if (this.texture == null) {
            this.createTexture(gl);
        }
        return this.texture.getTarget();
    }

    public int enable(GL2 gl) {
        if (this.texture == null) {
            this.createTexture(gl);
        }
        this.texture.enable((GL)gl);
        return this.texture.getTarget();
    }

    public void disable(GL2 gl) {
        if (this.texture == null) {
            this.createTexture(gl);
        }
        this.texture.disable((GL)gl);
    }

    public BufferedImage getImage() {
        return this.backingImg;
    }

    public void dispose(GL2 gl) {
        this.texture.destroy((GL)gl);
        this.texture = null;
    }

    private void createTexture(GL2 gl) {
        this.textureData = AWTTextureIO.newTextureData((GLProfile)gl.getGLProfile(), (BufferedImage)this.backingImg, (boolean)true);
        this.texture = AWTTextureIO.newTexture((TextureData)this.textureData);
        float width = (float)this.texture.getWidth() / 2.0f;
        float height = (float)this.texture.getHeight() / 2.0f;
        this.listIndex = gl.glGenLists(1);
        gl.glNewList(this.listIndex, 4864);
        gl.glBegin(7);
        TextureCoords tc = this.texture.getImageTexCoords();
        gl.glTexCoord2f(tc.left(), tc.bottom());
        gl.glVertex2f(-width, -height);
        gl.glTexCoord2f(tc.right(), tc.bottom());
        gl.glVertex2f(width, -height);
        gl.glTexCoord2f(tc.right(), tc.top());
        gl.glVertex2f(width, height);
        gl.glTexCoord2f(tc.left(), tc.top());
        gl.glVertex2f(-width, height);
        gl.glEnd();
        gl.glEndList();
    }

    public float getWidth() {
        return this.texture.getWidth();
    }

    public float getHeight() {
        return this.texture.getHeight();
    }

    public BoundingSphere getBounds() {
        return this.sphere;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(GL2 gl, RenderState rState) {
        DirtyRegion dirtyRegion = this.dirtyRegion;
        synchronized (dirtyRegion) {
            if (this.dirtyRegion.getWidth() > 0 && this.dirtyRegion.getHeight() > 0) {
                this.texture.updateSubImage((GL)gl, this.textureData, 0, this.dirtyRegion.getX(), this.dirtyRegion.getY(), this.dirtyRegion.getX(), this.dirtyRegion.getY(), this.dirtyRegion.getWidth(), this.dirtyRegion.getHeight());
                this.dirtyRegion.reset();
            }
        }
        gl.glCallList(this.listIndex);
    }
}

