/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import repast.simphony.systemdynamics.support.ArrayReference;
import repast.simphony.systemdynamics.support.SubscriptCombination;
import repast.simphony.systemdynamics.support.Utilities;
import repast.simphony.systemdynamics.translator.Equation;
import repast.simphony.systemdynamics.translator.EquationGraphicValidation;
import repast.simphony.systemdynamics.translator.EquationProcessor;
import repast.simphony.systemdynamics.translator.FunctionDescription;
import repast.simphony.systemdynamics.translator.GraphicsProcessor;
import repast.simphony.systemdynamics.translator.InformationManagers;
import repast.simphony.systemdynamics.translator.Node;
import repast.simphony.systemdynamics.translator.Parser;
import repast.simphony.systemdynamics.translator.Reader;
import repast.simphony.systemdynamics.translator.ReaderConstants;
import repast.simphony.systemdynamics.translator.RepastSimphonyEnvironment;
import repast.simphony.systemdynamics.translator.SystemDynamicsObjectManager;
import repast.simphony.systemdynamics.translator.TreeTraversal;
import repast.simphony.systemdynamics.translator.View;

public class Translator {
    protected Reader reader;
    public static String target = "UNDEFINED";
    public static Properties PROPERTIES = new Properties();
    public static Properties UNITS_PROPERTIES = new Properties();
    protected String objectName;
    protected String dataType;
    protected String destinationDirectory;
    protected String miscDirectory;
    protected String packageName;
    protected String supportName;
    private boolean hybridCompatibility = true;
    protected String unitsConsistencyCheckMdlFile = "";
    protected String unitsConsistencyCheckResultsFile = "./UnitsConsistencyCheckResults.txt";
    protected boolean unitsConsistency;
    protected SystemDynamicsObjectManager sdObjectManager;
    protected boolean generateC;
    protected boolean generateJava;
    protected static String DEFAULT_PROPERTIES_FILE = "DefaultConverter.properties";
    protected static String UNITS_PROPERTIES_FILE = "units.properties";

    public SystemDynamicsObjectManager getSdObjectManager() {
        return this.sdObjectManager;
    }

    public Translator() {
    }

    public Translator(String mdlFile, String objectName, String target, String dataStructure) {
        this();
        this.reader = new Reader(mdlFile);
        this.objectName = objectName;
        if (target.equalsIgnoreCase("Java")) {
            Translator.target = "Java";
        } else if (target.equalsIgnoreCase("Javascript")) {
            Translator.target = "Javascript";
        } else if (target.equalsIgnoreCase("C")) {
            Translator.target = "C";
        }
    }

    public Translator(String mdlFile, String resultsFile) {
        this.unitsConsistencyCheckMdlFile = mdlFile;
        this.unitsConsistencyCheckResultsFile = resultsFile;
        this.reader = new Reader(this.unitsConsistencyCheckMdlFile);
        this.loadProperties();
        this.loadUnitsProperties();
        ReaderConstants.OUTPUT_DIRECTORY = "DontCare";
        ReaderConstants.GENERATED_CODE_DIRECTORY = "DontCare";
        InformationManagers.getInstance().getFunctionManager().load(PROPERTIES.getProperty("functionFile"));
        this.loadUnitsEquivalences();
        this.initializeForConsistencyCheck();
    }

    public void checkUnitsConsistency() {
        List<String> rawEquations = this.reader.readMDLFile();
        if (rawEquations == null) {
            return;
        }
        this.sdObjectManager = new SystemDynamicsObjectManager();
        HashMap<String, Equation> equations = new EquationProcessor().processRawEquations(this.sdObjectManager, rawEquations);
        this.processSubscriptDefinition(equations);
        this.processExponentiaion(equations);
        this.generateRPN(equations);
        this.generateTrees(equations);
        InformationManagers.getInstance().getArrayManager().populateArraySubscriptSpace();
        InformationManagers.getInstance().getUnitsManager().performUnitsConsistencyCheck(equations, this.unitsConsistencyCheckResultsFile);
    }

    public void initialize() {
    }

    public void initializeForConsistencyCheck() {
        this.objectName = "DontCare";
        target = "Java";
        this.dataType = "Arrays";
        this.destinationDirectory = "DontCare";
        this.miscDirectory = "DontCare";
        this.packageName = "DontCare";
        this.supportName = "DontCare";
        this.unitsConsistency = true;
        this.generateC = false;
        this.generateJava = false;
        target = "Java";
        System.out.println("**** Units Consistency ****");
        System.out.println("MDL File: " + this.unitsConsistencyCheckMdlFile);
        System.out.println("Results File: " + this.unitsConsistencyCheckResultsFile);
        System.out.println("********");
    }

    protected void loadUnitsEquivalences() {
        BufferedReader unitsReader = null;
        FileInputStream fstream = null;
        fstream = (FileInputStream)this.getClass().getResourceAsStream("/" + UNITS_PROPERTIES.getProperty("unitsEquivalenceFile"));
        DataInputStream in = new DataInputStream(fstream);
        try {
            unitsReader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String aLine = null;
        try {
            aLine = unitsReader.readLine();
            while (aLine != null) {
                String[] equiv = aLine.split("=");
                InformationManagers.getInstance().getUnitsManager().addEquivalence(equiv[0], equiv[1]);
                aLine = unitsReader.readLine();
            }
            unitsReader.close();
            fstream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void startProcess() {
        List<String> mdlContents = this.reader.readMDLFile();
        boolean success = this.execute(mdlContents);
        if (!success) {
            System.out.println("Errors Prevent completion of operation");
        }
    }

    private void printErrors(Map<String, Equation> errors) {
        for (String lhs : errors.keySet()) {
            Equation eqn = errors.get(lhs);
            System.out.println("ERROR: " + eqn.getVensimEquation());
            System.out.println("ERROR: " + eqn.getTokensOneLine());
            for (String msg : eqn.getSyntaxMessages()) {
                System.out.println(msg);
            }
            for (String msg : eqn.getSemanticMessages()) {
                System.out.println(msg);
            }
        }
    }

    protected boolean validateGenerate(List<String> mdlContents, boolean generateCode, List<String> messages) {
        boolean errors;
        this.sdObjectManager = InformationManagers.getInstance().getSystemDynamicsObjectManager();
        Map<String, View> graphics = new GraphicsProcessor().processGraphics(this.sdObjectManager, mdlContents);
        EquationProcessor equationProcessor = new EquationProcessor();
        HashMap<String, Equation> equations = equationProcessor.processRawEquations(this.sdObjectManager, mdlContents);
        boolean bl = errors = equationProcessor.getDuplicateLHS().size() > 0;
        if (errors) {
            messages.add("+++ Duplicate LHS +++");
            for (String lhs : equationProcessor.getDuplicateLHS()) {
                messages.add(lhs);
            }
            return false;
        }
        this.processSubscriptDefinition(equations);
        this.processExponentiaion(equations);
        Map<String, Equation> fatalErrors = equationProcessor.getFatalErrors(equations);
        boolean bl2 = errors = fatalErrors.size() > 0;
        if (errors) {
            this.printErrors(fatalErrors);
            this.generateErrorReport("Fatal Errors", fatalErrors, messages);
            return false;
        }
        Map<String, Equation> syntaxErrors = equationProcessor.getSyntaxErrors(equations);
        boolean bl3 = errors = syntaxErrors.size() > 0;
        if (errors) {
            this.printErrors(syntaxErrors);
            this.generateErrorReport("Syntax Errors", syntaxErrors, messages);
            return false;
        }
        InformationManagers.getInstance().getArrayManager().populateArraySubscriptSpace();
        equationProcessor.checkUsage(equations);
        Map<String, Equation> usageErrors = equationProcessor.getUsageErrors(equations);
        boolean bl4 = errors = usageErrors.size() > 0;
        if (errors) {
            this.printErrors(usageErrors);
            this.generateErrorReport("Usage Errors", usageErrors, messages);
            return false;
        }
        this.generateRPN(equations);
        this.generateTrees(equations);
        Map<String, Equation> unitsErrors = InformationManagers.getInstance().getUnitsManager().performUnitsConsistencyCheck(equations, this.unitsConsistencyCheckResultsFile);
        boolean bl5 = errors = unitsErrors.size() > 0;
        if (errors) {
            this.printErrors(unitsErrors);
            this.generateErrorReport("Units Errors", unitsErrors, messages);
        }
        List<EquationGraphicValidation> addedScreenNames = this.sdObjectManager.validate(equations);
        this.sdObjectManager.createSystemDynamicsObjectForNonGraphic(addedScreenNames, equations);
        if (!generateCode) {
            return true;
        }
        this.process(equations);
        return true;
    }

    protected void generateErrorReport(String title, Map<String, Equation> errors, List<String> messages) {
        Iterator<String> iter = errors.keySet().iterator();
        messages.add("+++ " + title + " +++");
        while (iter.hasNext()) {
            String lhs = iter.next();
            Equation eqn = errors.get(lhs);
            messages.add("Equation:");
            messages.add("\t" + StringEscapeUtils.escapeHtml((String)eqn.getVensimEquation().split("~")[0]));
            for (String msg : eqn.getSyntaxMessages()) {
                messages.add(msg);
            }
            for (String msg : eqn.getSemanticMessages()) {
                messages.add(msg);
            }
            for (String msg : eqn.getUnitsInconsistencyReport()) {
                messages.add(msg);
            }
            messages.add("----------");
        }
    }

    protected boolean execute(List<String> mdlContents) {
        boolean errors;
        if (mdlContents == null) {
            return false;
        }
        this.sdObjectManager = new SystemDynamicsObjectManager();
        Map<String, View> graphics = new GraphicsProcessor().processGraphics(this.sdObjectManager, mdlContents);
        EquationProcessor equationProcessor = new EquationProcessor();
        HashMap<String, Equation> equations = equationProcessor.processRawEquations(this.sdObjectManager, mdlContents);
        Map<String, Equation> syntaxErrors = equationProcessor.getSyntaxErrors(equations);
        boolean bl = errors = syntaxErrors.size() > 0;
        if (errors) {
            this.printErrors(syntaxErrors);
            return false;
        }
        Map<String, Equation> usageErrors = equationProcessor.getUsageErrors(equations);
        boolean bl2 = errors = usageErrors.size() > 0;
        if (errors) {
            this.printErrors(usageErrors);
            return false;
        }
        InformationManagers.getInstance().getUnitsManager().performUnitsConsistencyCheck(equations, this.unitsConsistencyCheckResultsFile);
        List<EquationGraphicValidation> addedScreenNames = this.sdObjectManager.validate(equations);
        this.sdObjectManager.createSystemDynamicsObjectForNonGraphic(addedScreenNames, equations);
        this.process(equations);
        return true;
    }

    protected void printGraphics(Map<String, View> graphics) {
        for (View view : graphics.values()) {
            view.print();
        }
    }

    protected void process(Map<String, Equation> equations) {
    }

    protected String asDirectoryPath(String packageName) {
        return packageName.replace(".", "/");
    }

    protected void processSubscriptDefinition(Map<String, Equation> equations) {
        for (String lhs : equations.keySet()) {
            Equation eqn = equations.get(lhs);
            eqn.processSubscriptDefinition();
        }
    }

    protected void processExponentiaion(Map<String, Equation> equations) {
        for (String lhs : equations.keySet()) {
            Equation eqn = equations.get(lhs);
            eqn.processExponentiation();
        }
    }

    protected void generateRPN(Map<String, Equation> equations) {
        for (String lhs : equations.keySet()) {
            Equation eqn = equations.get(lhs);
            try {
                eqn.generateRpn();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void generateTrees(Map<String, Equation> equations) {
        for (String lhs : equations.keySet()) {
            Equation eqn = equations.get(lhs);
            eqn.generateTree();
        }
    }

    protected void generateMemory() {
        InformationManagers.getInstance().getMappedSubscriptManager().makeConsistent();
        if (this.isGenerateC() || this.isGenerateJava()) {
            InformationManagers.getInstance().getMappedSubscriptManager().dumpMappings(Translator.openReport(String.valueOf(this.miscDirectory) + "/" + "SubscriptMappings_" + this.objectName + ".csv"));
            InformationManagers.getInstance().getNamedSubscriptManager().dumpMappings(Translator.openReport(String.valueOf(this.miscDirectory) + "/" + "SubscriptNameValues_" + this.objectName + ".csv"));
            InformationManagers.getInstance().getUnitsManager().dumpLhsUnits(Translator.openReport(String.valueOf(this.miscDirectory) + "/" + "Units_" + this.objectName + ".csv"));
            InformationManagers.getInstance().getUnitsManager().dumpLhsUnitsRaw(Translator.openReport(String.valueOf(this.miscDirectory) + "/" + "UnitsRaw_" + this.objectName + ".csv"));
            if (target.equals("Java")) {
                String SourceDirectory = String.valueOf(this.getSourceDirectory()) + this.asDirectoryPath(this.packageName) + "/";
                InformationManagers.getInstance().getNativeDataTypeManager().dumpLegalNames(Translator.openReport(String.valueOf(this.miscDirectory) + "/" + "LegalNames_" + this.objectName + ".csv"));
                String ScenarioDirectory = this.getScenarioDirectory();
                if (!this.isHybridCompatibility()) {
                    RepastSimphonyEnvironment.generateScenarioXml(Translator.openReport(String.valueOf(ScenarioDirectory) + "scenario.xml"), this.objectName);
                    RepastSimphonyEnvironment.generateUserPathXml(Translator.openReport(String.valueOf(ScenarioDirectory) + "user_path.xml"), this.objectName);
                    RepastSimphonyEnvironment.generateClassLoaderXml(Translator.openReport(String.valueOf(ScenarioDirectory) + "repast.simphony.dataLoader.engine.ClassNameDataLoaderAction_1.xml"), this.objectName, this);
                    RepastSimphonyEnvironment.generateContextXml(Translator.openReport(String.valueOf(ScenarioDirectory) + "context.xml"), this.objectName);
                    RepastSimphonyEnvironment.generateContextBuilder(Translator.openReport(String.valueOf(SourceDirectory) + "ContextBuilder" + this.objectName + ".java"), this.objectName, this);
                }
                InformationManagers.getInstance().getNativeDataTypeManager().generateMemoryJava(Translator.openReport(String.valueOf(SourceDirectory) + "Memory" + this.objectName + ".java"), this.objectName, this);
            } else if (!target.equals("Javascript") && target.equals("C")) {
                String SourceDirectory = String.valueOf(this.getSourceDirectory()) + this.asDirectoryPath(this.packageName) + "/";
                InformationManagers.getInstance().getNativeDataTypeManager().dumpLegalNames(Translator.openReport(String.valueOf(this.miscDirectory) + "/" + "LegalNames_" + this.objectName + ".csv"));
                InformationManagers.getInstance().getNativeDataTypeManager().generateMemoryC(Translator.openReport(String.valueOf(SourceDirectory) + "memory" + this.objectName + ".h"), this.objectName, this);
            }
            InformationManagers.getInstance().getArrayManager().dumpSubscriptSpace(Translator.openReport(String.valueOf(this.miscDirectory) + "/" + "SubscriptSpace_" + this.objectName + ".csv"));
        }
    }

    protected void analyzeDependencies(HashMap<String, HashSet<String>> requiresExpandedLhsExpandedRHS, HashMap<String, HashSet<String>> realLhsToExpandedLhsNotInitialized, Map<String, String> expandedLhsToRealLhsMap, Map<String, HashSet<String>> realLhsToExpandedLhsMap) {
        HashSet<String> hs;
        for (String expandedLHS : requiresExpandedLhsExpandedRHS.keySet()) {
            hs = requiresExpandedLhsExpandedRHS.get(expandedLHS);
            if (hs == null) continue;
            for (String expRHS : hs) {
                String realLHSforExpRHS = this.toRealLHS(expRHS, expandedLhsToRealLhsMap);
                if (!requiresExpandedLhsExpandedRHS.containsKey(expRHS)) {
                    System.out.println("No LHS for requiresExpandedLhsExpandedRHS <" + expRHS + "> used by " + expandedLHS);
                }
                if (realLhsToExpandedLhsNotInitialized.containsKey(realLHSforExpRHS)) continue;
                System.out.println("No LHS for realLhsToExpandedLhsNotInitialized <" + realLHSforExpRHS + "> used by " + expandedLHS);
            }
        }
        for (String realLHS : realLhsToExpandedLhsNotInitialized.keySet()) {
            hs = realLhsToExpandedLhsNotInitialized.get(realLHS);
            if (hs == null) continue;
            for (String expLHS : hs) {
                if (requiresExpandedLhsExpandedRHS.containsKey(expLHS)) continue;
                System.out.println("No LHS for requiresExpandedLhsExpandedRHS<" + expLHS + "> used by " + realLHS);
            }
        }
    }

    protected ArrayList<String> determineEvaluationOrderOrig(Map<String, Equation> equations) {
        HashMap<String, String> expandedLhsToRealLhsMap = new HashMap<String, String>();
        HashMap<String, HashSet<String>> realLhsToExpandedLhsMap = new HashMap<String, HashSet<String>>();
        HashMap<String, HashSet<String>> realLhsToExpandedLhsNotInitialized = new HashMap<String, HashSet<String>>();
        HashMap<String, HashSet<String>> requiresExpandedLhsExpandedRHS = new HashMap<String, HashSet<String>>();
        ArrayList<String> allRealLHS = new ArrayList<String>();
        ArrayList<String> evaluationOrder = new ArrayList<String>();
        for (String realLHS : equations.keySet()) {
            Equation currentEquation = equations.get(realLHS);
            allRealLHS.add(realLHS);
            realLhsToExpandedLhsMap.put(realLHS, new HashSet());
            realLhsToExpandedLhsNotInitialized.put(realLHS, new HashSet());
            if (ArrayReference.isArrayReference(realLHS)) {
                ArrayReference lhsArrayReference = new ArrayReference(realLHS);
                Object exceptions = new ArrayList();
                if (currentEquation.isHasException()) {
                    exceptions = currentEquation.getExceptions();
                }
                for (SubscriptCombination outerSub : InformationManagers.getInstance().getArrayManager().getSubscriptValueCombinations(lhsArrayReference.getSubscriptsAsArray())) {
                    if (exceptions.contains(outerSub.getSubscriptValue())) {
                        System.out.println("Skipping [" + outerSub.getSubscriptValue() + "] for " + realLHS);
                        continue;
                    }
                    String expandedLHS = "array." + lhsArrayReference.getArrayName() + "[" + outerSub.getSubscriptValue() + "]";
                    requiresExpandedLhsExpandedRHS.put(expandedLHS, new HashSet());
                    expandedLhsToRealLhsMap.put(expandedLHS, realLHS);
                    realLhsToExpandedLhsMap.get(realLHS).add(expandedLHS);
                    realLhsToExpandedLhsNotInitialized.get(realLHS).add(expandedLHS);
                    for (String rhsVar : equations.get(realLHS).getRHSVariables()) {
                        if (equations.get(realLHS).isGetExternalData()) continue;
                        if (!ArrayReference.isArrayReference(rhsVar)) {
                            requiresExpandedLhsExpandedRHS.get(expandedLHS).add(rhsVar);
                            continue;
                        }
                        ArrayReference rhsArrayReference = new ArrayReference(rhsVar);
                        String arrayName = null;
                        if (rhsArrayReference.hasRangeSubscript() || InformationManagers.getInstance().getNamedSubscriptManager().hasNamedSubscript(rhsArrayReference)) {
                            String[] rhsExpanded = rhsArrayReference.hasRangeSubscript() ? this.removeBang(rhsArrayReference.getRangeSubscriptsAsArray()) : InformationManagers.getInstance().getNamedSubscriptManager().getExpandedSubscripts(rhsArrayReference);
                            List<SubscriptCombination> combos = InformationManagers.getInstance().getArrayManager().getSubscriptValueCombinations(rhsExpanded);
                            for (SubscriptCombination rangeSub : combos) {
                                arrayName = "array." + rhsArrayReference.getArrayName() + "[";
                                int subNum = 0;
                                String[] stringArray = rhsArrayReference.getSubscriptsAsArray();
                                int n = stringArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String subscript = stringArray[n2];
                                    if (subNum++ > 0) {
                                        arrayName = String.valueOf(arrayName) + ",";
                                    }
                                    arrayName = ArrayReference.isRangeSubscript(subscript) ? String.valueOf(arrayName) + rangeSub.getSubscriptValue(subscript.replace("!", "")) : String.valueOf(arrayName) + outerSub.getSubscriptValue(subscript);
                                    ++n2;
                                }
                                if (expandedLHS.equals(arrayName = String.valueOf(arrayName) + "]")) continue;
                                requiresExpandedLhsExpandedRHS.get(expandedLHS).add(arrayName);
                            }
                            continue;
                        }
                        arrayName = "array." + rhsArrayReference.getArrayName() + "[";
                        int subNum = 0;
                        String[] stringArray = rhsArrayReference.getSubscriptsAsArray();
                        int n = stringArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            String subscript = stringArray[n3];
                            if (subNum++ > 0) {
                                arrayName = String.valueOf(arrayName) + ",";
                            }
                            arrayName = String.valueOf(arrayName) + outerSub.getSubscriptValue(subscript);
                            ++n3;
                        }
                        arrayName = String.valueOf(arrayName) + "]";
                        requiresExpandedLhsExpandedRHS.get(expandedLHS).add(arrayName);
                    }
                }
                continue;
            }
            expandedLhsToRealLhsMap.put(realLHS, realLHS);
            realLhsToExpandedLhsMap.get(realLHS).add(realLHS);
            requiresExpandedLhsExpandedRHS.put(realLHS, new HashSet());
            if (equations.get(realLHS).isRepeated()) {
                realLhsToExpandedLhsNotInitialized.get(realLHS).add(realLHS);
                for (String rhsVar : equations.get(realLHS).getRHSVariablesExpanded()) {
                    requiresExpandedLhsExpandedRHS.get(realLHS).add(rhsVar);
                }
                continue;
            }
            realLhsToExpandedLhsNotInitialized.put(realLHS, null);
        }
        this.dumpRequires("realLhsToExpandedLhsMap.txt", realLhsToExpandedLhsMap);
        boolean startChain = false;
        this.dumpRequiresExpanded("initialrequiresExpandedLhsExpandedRHS.txt", requiresExpandedLhsExpandedRHS, startChain);
        this.dumpRequiresExpanded("initialrealLhsToExpandedLhsNotInitialized.txt", realLhsToExpandedLhsNotInitialized, startChain);
        this.analyzeDependencies(requiresExpandedLhsExpandedRHS, realLhsToExpandedLhsNotInitialized, expandedLhsToRealLhsMap, realLhsToExpandedLhsMap);
        int lastCount = -1;
        int terminationLoopCount = 0;
        allRealLHS.clear();
        allRealLHS.addAll(realLhsToExpandedLhsNotInitialized.keySet());
        boolean pass1 = false;
        boolean done = false;
        int loopCount = 0;
        ArrayList lastToRemove = null;
        while (!done) {
            ArrayList<String> toRemoveFromRequires = new ArrayList<String>();
            for (String realLHS : allRealLHS) {
                if (realLhsToExpandedLhsNotInitialized.containsKey(realLHS) && realLhsToExpandedLhsNotInitialized.get(realLHS) != null && realLhsToExpandedLhsNotInitialized.get(realLHS).size() == 0) {
                    toRemoveFromRequires.add(realLHS);
                }
                if (realLhsToExpandedLhsNotInitialized.get(realLHS) == null) continue;
                for (String expandedLHS : realLhsToExpandedLhsNotInitialized.get(realLHS)) {
                    if (pass1) {
                        if (requiresExpandedLhsExpandedRHS.get(expandedLHS) != null && (requiresExpandedLhsExpandedRHS.get(expandedLHS) == null || requiresExpandedLhsExpandedRHS.get(expandedLHS).size() != 0)) continue;
                        toRemoveFromRequires.add(expandedLHS);
                        continue;
                    }
                    Equation eqn = equations.get(realLHS);
                    if (requiresExpandedLhsExpandedRHS.get(expandedLHS) != null && (requiresExpandedLhsExpandedRHS.get(expandedLHS) == null || requiresExpandedLhsExpandedRHS.get(expandedLHS).size() != 0)) continue;
                    toRemoveFromRequires.add(expandedLHS);
                }
            }
            pass1 = false;
            if (toRemoveFromRequires.size() > 0) {
                terminationLoopCount = 0;
                if (lastCount == toRemoveFromRequires.size()) {
                    ArrayList tmpRemove = new ArrayList(lastToRemove);
                    tmpRemove.removeAll(toRemoveFromRequires);
                    if (tmpRemove.size() == 0) {
                        System.out.println("LoopCount: " + ++loopCount);
                        if (loopCount > 4) {
                            System.out.println("Not makeing progress. Terminating due to LoopCount: " + loopCount);
                            break;
                        }
                    } else {
                        loopCount = 0;
                    }
                } else {
                    loopCount = 0;
                }
                lastToRemove = new ArrayList(toRemoveFromRequires);
                lastCount = toRemoveFromRequires.size();
                this.removeRequirement(toRemoveFromRequires, requiresExpandedLhsExpandedRHS, realLhsToExpandedLhsNotInitialized, expandedLhsToRealLhsMap, evaluationOrder, equations);
                System.out.println("Remaining Equations: " + realLhsToExpandedLhsNotInitialized.size());
                allRealLHS.clear();
                allRealLHS.addAll(realLhsToExpandedLhsNotInitialized.keySet());
                continue;
            }
            if (++terminationLoopCount <= 1) continue;
            if (realLhsToExpandedLhsNotInitialized.size() == 0) {
                System.out.println("Successfully ordered all equations");
                done = true;
                continue;
            }
            System.out.println("Cannot order these equations:");
            for (String lhs : realLhsToExpandedLhsNotInitialized.keySet()) {
                System.out.println("   >>> lhs <" + lhs + "> ");
                System.out.println(equations.get(lhs).getEquation());
                System.out.println(equations.get(lhs).getCleanEquation());
                this.printRequires(realLhsToExpandedLhsNotInitialized.get(lhs));
                done = true;
            }
        }
        boolean endChain = true;
        this.dumpRequiresExpanded("postOrderrequiresExpandedLhsExpandedRHS.txt", requiresExpandedLhsExpandedRHS, endChain);
        this.dumpRequiresExpanded("postrealLhsToExpandedLhsNotInitialized.txt", realLhsToExpandedLhsNotInitialized, endChain);
        int notInitSize = realLhsToExpandedLhsNotInitialized.keySet().size();
        System.out.println("Not initialized structure contains " + notInitSize + " records");
        for (String req : realLhsToExpandedLhsNotInitialized.keySet()) {
            if (realLhsToExpandedLhsNotInitialized.get(req) == null) {
                System.out.println("     " + req + " is null");
                continue;
            }
            System.out.println("     " + req + " " + realLhsToExpandedLhsNotInitialized.get(req).size());
        }
        evaluationOrder.addAll(realLhsToExpandedLhsNotInitialized.keySet());
        this.analyzeEvaluationOrder(evaluationOrder, equations, realLhsToExpandedLhsMap, expandedLhsToRealLhsMap);
        return evaluationOrder;
    }

    protected ArrayList<String> determineEvaluationOrder(Map<String, Equation> equations) {
        HashMap<String, String> expandedLhsToRealLhsMap = new HashMap<String, String>();
        HashMap<String, HashSet<String>> realLhsToExpandedLhsMap = new HashMap<String, HashSet<String>>();
        HashMap<String, HashSet<String>> realLhsToExpandedLhsNotInitialized = new HashMap<String, HashSet<String>>();
        HashMap<String, HashSet<String>> requiresExpandedLhsExpandedRHS = new HashMap<String, HashSet<String>>();
        ArrayList<String> allExpLHS = new ArrayList<String>();
        ArrayList<String> evaluationOrder = new ArrayList<String>();
        for (String realLHS : equations.keySet()) {
            Equation currentEquation = equations.get(realLHS);
            if (!currentEquation.isAssignment() && !currentEquation.isDefinesLookup()) continue;
            if (currentEquation.isDefinesLookup()) {
                evaluationOrder.add(realLHS);
                continue;
            }
            allExpLHS.add(realLHS);
            realLhsToExpandedLhsMap.put(realLHS, new HashSet());
            realLhsToExpandedLhsNotInitialized.put(realLHS, new HashSet());
            if (ArrayReference.isArrayReference(realLHS)) {
                ArrayReference lhsArrayReference = new ArrayReference(realLHS);
                List<Object> exceptions = new ArrayList();
                if (currentEquation.isHasException()) {
                    exceptions = currentEquation.getExceptions();
                }
                for (SubscriptCombination subscriptCombination : InformationManagers.getInstance().getArrayManager().getSubscriptValueCombinations(lhsArrayReference.getSubscriptsAsArray())) {
                    if (exceptions.contains(subscriptCombination.getSubscriptValue())) {
                        System.out.println("Skipping [" + subscriptCombination.getSubscriptValue() + "] for " + realLHS);
                        continue;
                    }
                    String expandedLHS = "array." + lhsArrayReference.getArrayName() + "[" + subscriptCombination.getSubscriptValue() + "]";
                    requiresExpandedLhsExpandedRHS.put(expandedLHS, new HashSet());
                    expandedLhsToRealLhsMap.put(expandedLHS, realLHS);
                    realLhsToExpandedLhsMap.get(realLHS).add(expandedLHS);
                    realLhsToExpandedLhsNotInitialized.get(realLHS).add(expandedLHS);
                    Set<String> variablesOfInterest = equations.get(realLHS).getRHSVariablesForOrdering();
                    if (currentEquation.isStock() || this.containsInitialValueFunction(currentEquation)) {
                        variablesOfInterest = currentEquation.getFunctionInitialVariables();
                    } else if (currentEquation.isReferencesLookup()) {
                        Set<Node> funcNodes = currentEquation.getLookupFunctionNodes(false);
                        variablesOfInterest = new HashSet<String>();
                        for (Node node : funcNodes) {
                            Node arg2 = TreeTraversal.getFunctionArgument(node, 2);
                            currentEquation.getRHSVariablesForOrdering(arg2, variablesOfInterest, false);
                        }
                    }
                    for (String rhsVar : variablesOfInterest) {
                        String[] stringArray;
                        if (currentEquation.isGetExternalData()) continue;
                        if (!ArrayReference.isArrayReference(rhsVar)) {
                            requiresExpandedLhsExpandedRHS.get(expandedLHS).add(InformationManagers.getInstance().getNativeDataTypeManager().getOriginalName(rhsVar));
                            continue;
                        }
                        ArrayReference rhsArrayReference = new ArrayReference(rhsVar);
                        boolean printit2 = false;
                        String arrayName = null;
                        if (rhsArrayReference.hasRangeSubscript() || InformationManagers.getInstance().getNamedSubscriptManager().hasNamedSubscript(rhsArrayReference)) {
                            String[] rhsExpanded;
                            if (rhsArrayReference.hasRangeSubscript()) {
                                printit2 = false;
                                rhsExpanded = this.removeBang(rhsArrayReference.getRangeSubscriptsAsArray());
                                if (printit2) {
                                    System.out.println("################ Range sub: " + rhsVar);
                                    stringArray = rhsExpanded;
                                    int n = rhsExpanded.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String s = stringArray[n2];
                                        System.out.println(s);
                                        ++n2;
                                    }
                                }
                            } else {
                                rhsExpanded = InformationManagers.getInstance().getNamedSubscriptManager().getExpandedSubscripts(rhsArrayReference);
                            }
                            List<SubscriptCombination> combos = InformationManagers.getInstance().getArrayManager().getSubscriptValueCombinations(rhsExpanded);
                            for (SubscriptCombination rangeSub : combos) {
                                arrayName = "array." + rhsArrayReference.getArrayName() + "[";
                                int subNum = 0;
                                String[] stringArray2 = rhsArrayReference.getSubscriptsAsArray();
                                int n = stringArray2.length;
                                int n3 = 0;
                                while (n3 < n) {
                                    String subscript = stringArray2[n3];
                                    if (subNum++ > 0) {
                                        arrayName = String.valueOf(arrayName) + ",";
                                    }
                                    arrayName = ArrayReference.isRangeSubscript(subscript) ? String.valueOf(arrayName) + rangeSub.getSubscriptValue(subscript.replace("!", "")) : String.valueOf(arrayName) + subscriptCombination.getSubscriptValue(subscript);
                                    ++n3;
                                }
                                arrayName = String.valueOf(arrayName) + "]";
                                if (printit2) {
                                    System.out.println("Expanded: " + arrayName);
                                }
                                requiresExpandedLhsExpandedRHS.get(expandedLHS).add(arrayName);
                                if (!printit2) continue;
                                System.out.println(String.valueOf(expandedLHS) + " LR " + arrayName);
                            }
                            continue;
                        }
                        arrayName = "array." + rhsArrayReference.getArrayName() + "[";
                        int subNum = 0;
                        stringArray = rhsArrayReference.getSubscriptsAsArray();
                        int n = stringArray.length;
                        int n4 = 0;
                        while (n4 < n) {
                            String subscript = stringArray[n4];
                            if (subNum++ > 0) {
                                arrayName = String.valueOf(arrayName) + ",";
                            }
                            arrayName = String.valueOf(arrayName) + subscriptCombination.getSubscriptValue(subscript);
                            ++n4;
                        }
                        arrayName = String.valueOf(arrayName) + "]";
                        requiresExpandedLhsExpandedRHS.get(expandedLHS).add(arrayName);
                    }
                }
                continue;
            }
            expandedLhsToRealLhsMap.put(realLHS, realLHS);
            realLhsToExpandedLhsMap.get(realLHS).add(realLHS);
            requiresExpandedLhsExpandedRHS.put(realLHS, new HashSet());
            if (currentEquation.isGetExternalData()) continue;
            realLhsToExpandedLhsNotInitialized.get(realLHS).add(realLHS);
            Set<String> variablesOfInterest = equations.get(realLHS).getRHSVariablesForOrdering(false);
            if (currentEquation.isStock()) {
                variablesOfInterest = currentEquation.getFunctionInitialVariables();
            } else if (currentEquation.isReferencesLookup()) {
                Set<Node> funcNodes = currentEquation.getLookupFunctionNodes(true);
                variablesOfInterest = new HashSet<String>();
                for (Node node : funcNodes) {
                    variablesOfInterest.add(TreeTraversal.getFunctionArgument(node, 2).getToken());
                }
            }
            for (String rhsVar : variablesOfInterest) {
                if (!ArrayReference.isArrayReference(rhsVar)) {
                    requiresExpandedLhsExpandedRHS.get(realLHS).add(InformationManagers.getInstance().getNativeDataTypeManager().getOriginalName(rhsVar));
                    continue;
                }
                ArrayReference rhsArrayReference = new ArrayReference(rhsVar);
                boolean printit = false;
                String arrayName = null;
                if (rhsArrayReference.hasRangeSubscript() || InformationManagers.getInstance().getNamedSubscriptManager().hasNamedSubscript(rhsArrayReference)) {
                    String[] rhsExpanded;
                    if (rhsArrayReference.hasRangeSubscript()) {
                        printit = false;
                        rhsExpanded = this.removeBang(rhsArrayReference.getRangeSubscriptsAsArray());
                    } else {
                        rhsExpanded = InformationManagers.getInstance().getNamedSubscriptManager().getExpandedSubscripts(rhsArrayReference);
                    }
                    List<SubscriptCombination> list = InformationManagers.getInstance().getArrayManager().getSubscriptValueCombinations(rhsExpanded);
                    for (SubscriptCombination rangeSub : list) {
                        arrayName = "array." + rhsArrayReference.getArrayName() + "[";
                        int subNum = 0;
                        String[] stringArray = rhsArrayReference.getSubscriptsAsArray();
                        int n = stringArray.length;
                        int n5 = 0;
                        while (n5 < n) {
                            String subscript = stringArray[n5];
                            if (subNum++ > 0) {
                                arrayName = String.valueOf(arrayName) + ",";
                            }
                            if (ArrayReference.isRangeSubscript(subscript)) {
                                arrayName = String.valueOf(arrayName) + rangeSub.getSubscriptValue(subscript.replace("!", ""));
                            }
                            ++n5;
                        }
                        arrayName = String.valueOf(arrayName) + "]";
                        if (printit) {
                            System.out.println("Expanded: " + arrayName);
                        }
                        requiresExpandedLhsExpandedRHS.get(realLHS).add(arrayName);
                        if (!printit) continue;
                        System.out.println(String.valueOf(realLHS) + " LR " + arrayName);
                    }
                    continue;
                }
                System.out.println("### ### ### We should not have gotten here!");
                System.out.println("realLHS = " + realLHS);
            }
        }
        for (String expLHS : requiresExpandedLhsExpandedRHS.keySet()) {
            Set aSetExpRHS = (Set)requiresExpandedLhsExpandedRHS.get(expLHS);
            if (aSetExpRHS == null || aSetExpRHS.size() == 0) continue;
            ArrayList aList = new ArrayList();
            aList.addAll(aSetExpRHS);
            for (String rhs : aList) {
                String rhsRealLHS = expandedLhsToRealLhsMap.get(rhs);
                if (rhsRealLHS == null) {
                    System.out.println("How can this be null in expandedLhsToRealLhsMap: " + rhs);
                    continue;
                }
                aSetExpRHS.add(rhsRealLHS);
            }
        }
        this.dumpRequires2("expandedLhsToRealLhsMap.txt", expandedLhsToRealLhsMap);
        this.dumpRequires("realLhsToExpandedLhsMap.txt", realLhsToExpandedLhsMap);
        boolean startChain = false;
        this.dumpRequiresExpanded("initialrequiresExpandedLhsExpandedRHS.txt", requiresExpandedLhsExpandedRHS, startChain);
        this.dumpRequiresExpanded("initialrealLhsToExpandedLhsNotInitialized.txt", realLhsToExpandedLhsNotInitialized, startChain);
        int lastCount = -1;
        boolean terminationLoopCount = false;
        allExpLHS.clear();
        boolean done = false;
        int loopCount = 0;
        Object var13_25 = null;
        allExpLHS.addAll(requiresExpandedLhsExpandedRHS.keySet());
        int startSize = evaluationOrder.size();
        int endSize = 0;
        while (!done) {
            ArrayList<String> toRemoveFromRequires = null;
            System.out.println("####################### Loop ############################### NumToProcess " + allExpLHS.size() + " eqn remaining " + realLhsToExpandedLhsNotInitialized.size());
            for (String expandedLHS : allExpLHS) {
                String realLHS = this.toRealLHS(expandedLHS, expandedLhsToRealLhsMap);
                toRemoveFromRequires = new ArrayList<String>();
                Equation eqn = equations.get(realLHS);
                if (requiresExpandedLhsExpandedRHS.get(expandedLHS) != null && (requiresExpandedLhsExpandedRHS.get(expandedLHS) == null || requiresExpandedLhsExpandedRHS.get(expandedLHS).size() != 0)) continue;
                toRemoveFromRequires.add(expandedLHS);
                this.removeRequirement(toRemoveFromRequires, requiresExpandedLhsExpandedRHS, realLhsToExpandedLhsNotInitialized, expandedLhsToRealLhsMap, evaluationOrder, equations);
            }
            endSize = evaluationOrder.size();
            if (endSize > startSize) {
                System.out.println("Making Progress");
                loopCount = 0;
            } else {
                System.out.println("No Progress " + ++loopCount);
            }
            startSize = endSize;
            if (loopCount < 5) {
                if (realLhsToExpandedLhsNotInitialized.size() == 0) {
                    System.out.println("Successfully ordered all equations");
                    done = true;
                    continue;
                }
                System.out.println("Remaining Equations: " + realLhsToExpandedLhsNotInitialized.size());
                allExpLHS.clear();
                allExpLHS.addAll(requiresExpandedLhsExpandedRHS.keySet());
                continue;
            }
            System.out.println("Not makeing progress. Terminating due to LoopCount: " + loopCount);
            System.out.println("Cannot order these equations:");
            for (String lhs : realLhsToExpandedLhsNotInitialized.keySet()) {
                System.out.println("   >>> lhs <" + lhs + "> ");
                System.out.println(equations.get(lhs).getEquation());
                System.out.println(equations.get(lhs).getCleanEquation());
                this.printRequires(realLhsToExpandedLhsNotInitialized.get(lhs));
                done = true;
            }
        }
        boolean endChain = false;
        this.dumpRequiresExpanded("postOrderrequiresExpandedLhsExpandedRHS.txt", requiresExpandedLhsExpandedRHS, endChain);
        this.dumpRequiresExpanded("postrealLhsToExpandedLhsNotInitialized.txt", realLhsToExpandedLhsNotInitialized, endChain);
        int notInitSize = realLhsToExpandedLhsNotInitialized.keySet().size();
        System.out.println("Not initialized structure contains " + notInitSize + " records");
        for (String string : realLhsToExpandedLhsNotInitialized.keySet()) {
            if (realLhsToExpandedLhsNotInitialized.get(string) == null) {
                System.out.println("     " + string + " is null");
                continue;
            }
            System.out.println("     " + string + " " + realLhsToExpandedLhsNotInitialized.get(string).size());
        }
        evaluationOrder.addAll(realLhsToExpandedLhsNotInitialized.keySet());
        this.analyzeEvaluationOrder(evaluationOrder, equations, realLhsToExpandedLhsMap, expandedLhsToRealLhsMap);
        return evaluationOrder;
    }

    protected String[] removeBang(String[] inList) {
        String[] outList = new String[inList.length];
        int i = 0;
        while (i < inList.length) {
            outList[i] = inList[i].replace("!", "");
            ++i;
        }
        return outList;
    }

    protected boolean containsInitialValueFunction(Equation equation) {
        for (String token : equation.getTokens()) {
            FunctionDescription fd;
            if (!Parser.isFunctionInvocation(token) || !(fd = InformationManagers.getInstance().getFunctionManager().getDescription(token)).isSuppliesInitialValue()) continue;
            return true;
        }
        return false;
    }

    protected boolean containsFunctionINTEG(String equation) {
        return equation.contains("INTEG");
    }

    protected boolean containsFunctionSMOOTHI(String equation) {
        return equation.contains("SMOOTHI");
    }

    protected boolean containsFunctionDELAY3I(String equation) {
        return equation.contains("DELAY3I");
    }

    protected boolean containsFunctionACTIVEINITIAL(String equation) {
        return equation.contains("ACTIVEINITIAL");
    }

    protected String removeValueOf(String var) {
        String retVar = var.replace("valueOf(", "").replaceAll("\"", "").replaceAll("\\)", "");
        return retVar;
    }

    protected void printRequires(HashSet<String> set) {
        if (set == null) {
            System.out.println("printRequires(HashSet<String> set) is NULL");
            return;
        }
        Iterator<String> iter = set.iterator();
        while (iter.hasNext()) {
            System.out.println("           " + iter.next());
        }
        System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
    }

    protected void removeRequirement(ArrayList<String> toRemoveFromRequires, HashMap<String, HashSet<String>> requiresExpandedLhsExpandedRHS, HashMap<String, HashSet<String>> realLhsToExpandedLhsNotInitialized, HashMap<String, String> expandedLhsToRealLhsMap, ArrayList<String> evaluationOrder, Map<String, Equation> equations) {
        String realLHS;
        HashSet<String> candidateLHS = new HashSet<String>();
        ArrayList<String> newlyFreed = new ArrayList<String>();
        for (String toRemove : toRemoveFromRequires) {
            if (!expandedLhsToRealLhsMap.containsKey(toRemove)) continue;
            candidateLHS.add(expandedLhsToRealLhsMap.get(toRemove));
        }
        for (String toRemove : toRemoveFromRequires) {
            realLHS = this.toRealLHS(toRemove, expandedLhsToRealLhsMap);
            requiresExpandedLhsExpandedRHS.remove(toRemove);
            if (realLhsToExpandedLhsNotInitialized.get(realLHS) != null) {
                realLhsToExpandedLhsNotInitialized.get(realLHS).remove(toRemove);
            }
            newlyFreed.addAll(this.removeFromRHS(toRemove, requiresExpandedLhsExpandedRHS));
            Set expLHSNotInit = realLhsToExpandedLhsNotInitialized.get(realLHS);
            if (expLHSNotInit != null) {
                expLHSNotInit.remove(toRemove);
                if (expLHSNotInit.size() != 0 || evaluationOrder.contains(realLHS)) continue;
                evaluationOrder.add(realLHS);
                System.out.println("Schedule1: " + realLHS);
                if (equations.get(realLHS).isStock()) {
                    equations.get(realLHS).setOrderedWithInitialValue(true);
                }
                realLhsToExpandedLhsNotInitialized.remove(realLHS);
                newlyFreed.addAll(this.removeFromRHS(realLHS, requiresExpandedLhsExpandedRHS));
                continue;
            }
            if (evaluationOrder.contains(realLHS)) continue;
            evaluationOrder.add(realLHS);
            System.out.println("Schedule2: " + realLHS);
            if (equations.get(realLHS).isStock()) {
                equations.get(realLHS).setOrderedWithInitialValue(true);
            }
            realLhsToExpandedLhsNotInitialized.remove(realLHS);
            this.removeFromRHS(realLHS, requiresExpandedLhsExpandedRHS);
        }
        for (String lhs : newlyFreed) {
            realLHS = this.toRealLHS(lhs, expandedLhsToRealLhsMap);
            if (!candidateLHS.contains(realLHS)) continue;
            if (realLhsToExpandedLhsNotInitialized.get(realLHS) != null) {
                if (realLhsToExpandedLhsNotInitialized.get(realLHS).size() != 0) continue;
                realLhsToExpandedLhsNotInitialized.remove(realLHS);
                if (evaluationOrder.contains(realLHS)) continue;
                System.out.println("############################### Schedule4: " + realLHS);
                evaluationOrder.add(realLHS);
                if (!equations.get(realLHS).isStock()) continue;
                equations.get(realLHS).setOrderedWithInitialValue(true);
                continue;
            }
            if (evaluationOrder.contains(realLHS)) continue;
            System.out.println("############################### Schedule5: " + realLHS + " not initialized is null");
            evaluationOrder.add(realLHS);
            if (!equations.get(realLHS).isStock()) continue;
            equations.get(realLHS).setOrderedWithInitialValue(true);
        }
    }

    private String toRealLHS(String lhs, Map<String, String> expandedLhsToRealLhsMap) {
        if (expandedLhsToRealLhsMap.containsKey(lhs)) {
            return expandedLhsToRealLhsMap.get(lhs);
        }
        return lhs;
    }

    protected boolean validateEO(String eoLHS, HashMap<String, HashSet<String>> requiresLhsScalarExpandedRhs, HashMap<String, HashSet<String>> requiresExpandedLhsExpandedRHS, HashMap<String, HashSet<String>> realLhsToExpandedLhsNotInitialized) {
        boolean valid = true;
        System.out.println("validateEO: " + eoLHS);
        if (this.inMap(eoLHS, requiresLhsScalarExpandedRhs, "requiresLhsScalarExpandedRhs")) {
            valid = false;
        }
        if (this.inMap(eoLHS, requiresExpandedLhsExpandedRHS, "requiresExpandedLhsExpandedRHS")) {
            valid = false;
        }
        if (this.inMap(eoLHS, realLhsToExpandedLhsNotInitialized, "realLhsToExpandedLhsNotInitialized")) {
            valid = false;
        }
        return valid;
    }

    protected boolean inMap(String eoLHS, Map<String, HashSet<String>> map, String name) {
        boolean in = false;
        if (map.containsKey(eoLHS) && map.get(eoLHS) != null && map.get(eoLHS).size() > 0) {
            in = true;
            System.out.println("inMap: " + name + " " + eoLHS);
            return in;
        }
        for (String k : map.keySet()) {
            if (!this.inSet(eoLHS, map.get(k), name)) continue;
            in = true;
        }
        return in;
    }

    protected boolean inSet(String eoLHS, HashSet<String> set, String name) {
        boolean in = false;
        if (set == null) {
            return in;
        }
        if (set.contains(eoLHS)) {
            in = true;
            System.out.println("inSet: " + name + " " + eoLHS);
        }
        return in;
    }

    protected List<String> removeFromRHS(String lhs, HashMap<String, HashSet<String>> requiresExpanded) {
        ArrayList<String> newlyFreed = new ArrayList<String>();
        newlyFreed.addAll(this.removeFromRHS(lhs, requiresExpanded, "requiresExpanded"));
        return newlyFreed;
    }

    protected List<String> removeFromRHS(String lhs, HashMap<String, HashSet<String>> requires, String tag) {
        ArrayList<String> newlyFreed = new ArrayList<String>();
        for (String req : requires.keySet()) {
            HashSet<String> hs = requires.get(req);
            if (hs == null || !hs.contains(lhs)) continue;
            hs.remove(lhs);
            if (hs.size() != 0) continue;
            newlyFreed.add(req);
        }
        return newlyFreed;
    }

    protected void dumpRequires2(String fileName, HashMap<String, String> requires) {
        BufferedWriter bw = Utilities.openFileForWriting(String.valueOf(this.miscDirectory) + "/" + fileName);
        ArrayList<String> allLHS = new ArrayList<String>();
        for (String lhs : requires.keySet()) {
            if (lhs == null) {
                System.out.println("Skipping null in requires");
                continue;
            }
            allLHS.add(lhs);
        }
        Collections.sort(allLHS);
        try {
            for (String lhs : allLHS) {
                bw.append("LHS: <" + lhs + ">  RHS: <" + requires.get(lhs) + "\n");
            }
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void dumpRequires(String fileName, HashMap<String, HashSet<String>> requires) {
        BufferedWriter bw = Utilities.openFileForWriting(String.valueOf(this.miscDirectory) + "/" + fileName);
        ArrayList<String> allLHS = new ArrayList<String>();
        for (String lhs : requires.keySet()) {
            if (lhs == null) {
                System.out.println("Skipping null in requires");
                continue;
            }
            allLHS.add(lhs);
        }
        Collections.sort(allLHS);
        try {
            for (String lhs : allLHS) {
                bw.append("LHS: <" + lhs + ">\n");
                for (String r : this.sortSet(requires.get(lhs))) {
                    bw.append("     RHS <" + r + ">\n");
                }
            }
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void dumpRequiresExpanded(String fileName, HashMap<String, HashSet<String>> requires, boolean printChain) {
        BufferedWriter bw = Utilities.openFileForWriting(String.valueOf(this.miscDirectory) + "/" + fileName);
        ArrayList<String> allLHS = new ArrayList<String>();
        for (String lhs : requires.keySet()) {
            if (lhs == null) {
                System.out.println("Skipping null in requires");
                continue;
            }
            allLHS.add(lhs);
        }
        Collections.sort(allLHS);
        try {
            for (String lhs : allLHS) {
                bw.append("LHS: <" + lhs + ">\n");
                int level = 1;
                if (printChain) {
                    this.printChain(bw, level, lhs, requires, new HashSet<String>());
                    continue;
                }
                for (String r : this.sortSet(requires.get(lhs))) {
                    bw.append("     RHS <" + r + ">\n");
                }
            }
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void printChain(BufferedWriter bw, int level, String lhs, HashMap<String, HashSet<String>> requires, HashSet<String> alreadyPrinted) {
        if (level > 50) {
            try {
                bw.append("Terminating recursion\n");
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        StringBuffer blanks = new StringBuffer();
        int i = 0;
        while (i < level) {
            blanks.append("  ");
            ++i;
        }
        for (String r : this.sortSet(requires.get(lhs))) {
            if (alreadyPrinted.contains(r)) {
                try {
                    bw.append("                      ### looping on " + r + "\n");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            try {
                bw.append(String.valueOf(blanks.toString()) + "RHS <" + r + "> \n");
                alreadyPrinted.add(r);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.printChain(bw, level + 1, r, requires, alreadyPrinted);
        }
    }

    protected List<String> sortSet(HashSet<String> set) {
        ArrayList<String> al = new ArrayList<String>();
        if (set == null) {
            return al;
        }
        Iterator<String> iter = set.iterator();
        while (iter.hasNext()) {
            al.add(iter.next());
        }
        Collections.sort(al);
        return al;
    }

    protected void analyzeEvaluationOrder(List<String> evaluationOrder, Map<String, Equation> equations, HashMap<String, HashSet<String>> lhsExpandedMap, HashMap<String, String> expandedLhsMap) {
        String lhs;
        boolean orderProblem = false;
        BufferedWriter bw = Translator.openReport(String.valueOf(this.miscDirectory) + "/" + "evaluationOrder.txt");
        HashMap<String, Integer> initializationLine = new HashMap<String, Integer>();
        int i = 0;
        while (i < evaluationOrder.size()) {
            initializationLine.put(evaluationOrder.get(i), i);
            lhs = evaluationOrder.get(i);
            if (expandedLhsMap.containsKey(lhs)) {
                String real = expandedLhsMap.get(lhs);
                initializationLine.put(real, i);
            }
            if (lhsExpandedMap.containsKey(lhs)) {
                for (String exp : lhsExpandedMap.get(lhs)) {
                    initializationLine.put(exp, i);
                }
            }
            ++i;
        }
        try {
            i = 0;
            while (i < evaluationOrder.size()) {
                lhs = evaluationOrder.get(i);
                bw.append("\n" + i);
                bw.append(" EQN: " + equations.get(lhs).getCleanEquation() + "\n");
                bw.append(" LHS: " + lhs + "\n");
                bw.flush();
                HashSet<String> rhsVars = null;
                if (equations.get(lhs).isRepeated()) {
                    rhsVars = equations.get(lhs).getRHSVariablesExpanded();
                }
                boolean problem = false;
                boolean orderingProblem = false;
                boolean missingProblem = false;
                if (rhsVars == null || rhsVars.size() == 0) {
                    bw.append("     None\n");
                    problem = false;
                    orderingProblem = false;
                    missingProblem = false;
                } else {
                    int r = 0;
                    for (String rhs : rhsVars) {
                        int n;
                        ArrayReference rhsArrayReference;
                        if (initializationLine.get(rhs) != null) {
                            r = (Integer)initializationLine.get(rhs);
                            if (i < r && !equations.get(lhs).isOrderedWithInitialValue()) {
                                orderingProblem = true;
                                bw.append("     <" + rhs + "> " + r + (i < r ? " <<<<<<<<" : "") + "\n");
                                continue;
                            }
                            bw.append("     <" + rhs + "> " + r + "\n");
                            continue;
                        }
                        String rLHS = expandedLhsMap.get(rhs);
                        if (initializationLine.containsKey(rLHS)) {
                            r = (Integer)initializationLine.get(rLHS);
                            bw.append("     <" + rLHS + "> " + r + (i < r ? " <<<<<<<<" : "") + "\n");
                            if (i >= r || equations.get(rLHS).isOrderedWithInitialValue()) continue;
                            orderingProblem = true;
                            continue;
                        }
                        bw.append(" >>>> initializtion line missing for <" + rhs + "> try individuals\n");
                        missingProblem = false;
                        if (rhs.contains("!") || !ArrayReference.isArrayReference(lhs)) {
                            if (!ArrayReference.isArrayReference(rhs)) continue;
                            rhsArrayReference = new ArrayReference(rhs.replace("!", ""));
                            for (SubscriptCombination subrCombo : InformationManagers.getInstance().getArrayManager().getSubscriptValueCombinations(rhsArrayReference.getSubscriptsAsArray())) {
                                String expandedRHS = "array." + rhsArrayReference.getArrayName() + "[";
                                int subn = 0;
                                String[] stringArray = rhsArrayReference.getSubscriptsAsArray();
                                n = stringArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String subscript = stringArray[n2];
                                    if (subn++ > 0) {
                                        expandedRHS = String.valueOf(expandedRHS) + ",";
                                    }
                                    expandedRHS = String.valueOf(expandedRHS) + subrCombo.getSubscriptValue(subscript);
                                    ++n2;
                                }
                                if (!initializationLine.containsKey(expandedRHS = String.valueOf(expandedRHS) + "]")) {
                                    bw.append(" >>>> initializtion line missing for individual <" + expandedRHS + ">\n");
                                    missingProblem = true;
                                    continue;
                                }
                                r = (Integer)initializationLine.get(expandedRHS);
                                bw.append(" >>>> initializtion line FOUND for individual <" + expandedRHS + "> " + r + "\n");
                            }
                            continue;
                        }
                        if (!ArrayReference.isArrayReference(lhs) || !ArrayReference.isArrayReference(rhs)) continue;
                        rhsArrayReference = new ArrayReference(rhs.replace("!", ""));
                        ArrayReference lhsArrayReference = new ArrayReference(lhs);
                        for (SubscriptCombination subrCombo : InformationManagers.getInstance().getArrayManager().getSubscriptValueCombinations(lhsArrayReference.getSubscriptsAsArray())) {
                            String expandedRHS = "array." + rhsArrayReference.getArrayName() + "[";
                            int subn = 0;
                            String[] stringArray = rhsArrayReference.getSubscriptsAsArray();
                            int n3 = stringArray.length;
                            n = 0;
                            while (n < n3) {
                                String subscript = stringArray[n];
                                if (subn++ > 0) {
                                    expandedRHS = String.valueOf(expandedRHS) + ",";
                                }
                                expandedRHS = String.valueOf(expandedRHS) + subrCombo.getSubscriptValue(subscript);
                                ++n;
                            }
                            if (!initializationLine.containsKey(expandedRHS = String.valueOf(expandedRHS) + "]")) {
                                bw.append(" >>>> initializtion line missing for individual <" + expandedRHS + ">\n");
                                missingProblem = true;
                                continue;
                            }
                            r = (Integer)initializationLine.get(expandedRHS);
                            bw.append(" >>>> initializtion line FOUND for individual <" + expandedRHS + "> " + r + "\n");
                        }
                    }
                }
                if (problem) {
                    bw.append("######### P R O B L E M ######### \n");
                    orderProblem = true;
                }
                if (orderingProblem) {
                    bw.append("######### ORDERING P R O B L E M #########\n");
                    orderProblem = true;
                }
                if (missingProblem) {
                    bw.append("######### MISSING P R O B L E M #########\n");
                    orderProblem = true;
                }
                ++i;
            }
            bw.flush();
            bw.close();
            if (!orderProblem) {
                System.out.println("Clean Evaluation Order");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static BufferedWriter openReport(String filename) {
        BufferedWriter report = null;
        try {
            File aFile = new File(filename);
            if (aFile.getParentFile() != null) {
                aFile.getParentFile().mkdirs();
            }
            report = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(aFile, false)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return report;
    }

    public static BufferedReader openForRead(String filename) {
        BufferedReader fileReader = null;
        System.out.println("Open for Read: " + filename);
        try {
            fileReader = new BufferedReader(new FileReader(new File(filename)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return fileReader;
    }

    public boolean loadProperties(String file) {
        try {
            PROPERTIES.load(this.getClass().getResourceAsStream("/" + file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean loadProperties() {
        return this.loadProperties(DEFAULT_PROPERTIES_FILE);
    }

    public boolean loadUnitsProperties(String file) {
        try {
            UNITS_PROPERTIES.load(this.getClass().getResourceAsStream("/" + file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean loadUnitsProperties() {
        return this.loadUnitsProperties(UNITS_PROPERTIES_FILE);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getTarget() {
        return target;
    }

    public void setTarget(String target) {
        Translator.target = target;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDestinationDirectory() {
        return this.destinationDirectory;
    }

    public void setDestinationDirectory(String destinationDirectory) {
        this.destinationDirectory = destinationDirectory;
    }

    public String getMiscDirectory() {
        if (this.miscDirectory == null) {
            this.miscDirectory = "miscOutput";
        }
        return this.miscDirectory;
    }

    public void setMiscDirectory(String miscDirectory) {
        this.miscDirectory = miscDirectory;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getSupportName() {
        return this.supportName;
    }

    public void setSupportName(String supportName) {
        this.supportName = supportName;
    }

    public boolean isUnitsConsistency() {
        return this.unitsConsistency;
    }

    public boolean isGenerateC() {
        return this.generateC;
    }

    public boolean isGenerateJava() {
        return this.generateJava;
    }

    public String getSourceDirectory() {
        return String.valueOf(this.destinationDirectory) + "/" + "src" + "/";
    }

    public String getScenarioDirectory() {
        return String.valueOf(this.destinationDirectory) + "/" + this.objectName + ".rs/";
    }

    public boolean isHybridCompatibility() {
        return this.hybridCompatibility;
    }

    public void setHybridCompatibility(boolean hybridCompatibility) {
        this.hybridCompatibility = hybridCompatibility;
    }
}

