/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import repast.simphony.systemdynamics.sdmodel.InfluenceLink;
import repast.simphony.systemdynamics.sdmodel.SystemModel;
import repast.simphony.systemdynamics.sdmodel.Variable;
import repast.simphony.systemdynamics.translator.Arrow;
import repast.simphony.systemdynamics.translator.Equation;
import repast.simphony.systemdynamics.translator.EquationGraphicValidation;
import repast.simphony.systemdynamics.translator.GraphicObject;
import repast.simphony.systemdynamics.translator.SystemDynamicsObject;
import repast.simphony.systemdynamics.translator.View;

public class SystemDynamicsObjectManager {
    private Map<String, SystemDynamicsObject> objectsMap = new HashMap<String, SystemDynamicsObject>();

    public void processRSD() {
    }

    public void clear() {
        this.objectsMap.clear();
    }

    public void populate(SystemModel model) {
        this.clear();
        for (Variable variable : model.getVariables()) {
            String screenName = variable.getName();
            this.addSystemDynamicsObject(screenName);
        }
        for (InfluenceLink influenceLink : model.getLinks()) {
        }
    }

    public List<EquationGraphicValidation> validate(Map<String, Equation> equations) {
        ArrayList<EquationGraphicValidation> validations = new ArrayList<EquationGraphicValidation>();
        for (SystemDynamicsObject sdo : this.objectsMap.values()) {
            EquationGraphicValidation egv = new EquationGraphicValidation(this, sdo, equations);
            egv.validate();
            if (egv.isValid()) continue;
            validations.add(egv);
        }
        return validations;
    }

    public void createSystemDynamicsObjectForNonGraphic(List<EquationGraphicValidation> validations, Map<String, Equation> equations) {
        for (EquationGraphicValidation egv : validations) {
            egv.apply();
        }
    }

    public List<Equation> findEquationsWithScreenName(String screenNameE, Map<String, Equation> equations) {
        String screenName = SystemDynamicsObjectManager.getScreenName(screenNameE);
        ArrayList<Equation> list = new ArrayList<Equation>();
        for (String lhs : equations.keySet()) {
            if (!SystemDynamicsObjectManager.getScreenName(lhs).equals(screenName)) continue;
            list.add(equations.get(lhs));
        }
        return list;
    }

    public void print() {
        for (SystemDynamicsObject obj : this.objectsMap.values()) {
            if (!obj.getType().equals("VARIABLE") && !obj.getType().equals("RATE") && !obj.getType().equals("CLOUD") && !obj.getType().equals("ARROW")) continue;
            obj.print();
        }
    }

    public static String getScreenName(String lhs) {
        String screenName = lhs.trim();
        if (lhs.contains("[")) {
            screenName = lhs.split("\\[")[0].trim();
        }
        return screenName.replace("memory.", "").replace("lookup.", "").replace("array.", "").replace("\"", "");
    }

    public List<SystemDynamicsObject> stockVariables() {
        ArrayList<SystemDynamicsObject> stocks = new ArrayList<SystemDynamicsObject>();
        for (SystemDynamicsObject obj : this.objectsMap.values()) {
            if (!obj.getType().equals("VARIABLE") || obj.getEquations().size() <= 0 || !obj.getEquations().get(0).isStock()) continue;
            stocks.add(obj);
        }
        return stocks;
    }

    public Iterable<String> screenNames() {
        return this.objectsMap.keySet();
    }

    public SystemDynamicsObject getObjectWithName(String screenNameE) {
        String screenName = SystemDynamicsObjectManager.getScreenName(screenNameE);
        return this.objectsMap.get(screenName);
    }

    public String getAssociatedVariableFor(String screenNameE) {
        String screenName = SystemDynamicsObjectManager.getScreenName(screenNameE);
        SystemDynamicsObject sdo = this.objectsMap.get(screenName);
        return sdo.getAssociatedVariableName();
    }

    public void addSystemDynamicsObject(String screenNameE) {
        String screenName = SystemDynamicsObjectManager.getScreenName(screenNameE);
        if (!this.objectsMap.containsKey(screenName)) {
            this.objectsMap.put(screenName, new SystemDynamicsObject(screenName));
        }
    }

    private void addSystemDynamicsObjectPlaceHolder(String screenNameE) {
        String screenName = SystemDynamicsObjectManager.getScreenName(screenNameE);
        this.objectsMap.put(screenName, new SystemDynamicsObject(screenName));
    }

    public void addGraphicObject(String screenNameE, GraphicObject graphicObject) {
        String screenName = SystemDynamicsObjectManager.getScreenName(screenNameE);
        if (!this.objectsMap.containsKey(screenName)) {
            this.addSystemDynamicsObjectPlaceHolder(screenName);
        }
        this.objectsMap.get(screenName).addGraphicObject(graphicObject);
    }

    public void addEquation(String screenNameE, Equation equation) {
        String screenName = SystemDynamicsObjectManager.getScreenName(screenNameE);
        if (!this.objectsMap.containsKey(screenName)) {
            this.addSystemDynamicsObjectPlaceHolder(screenName);
        }
        this.objectsMap.get(screenName).addEquation(equation);
    }

    public void addIncomingArrow(String screenNameE, Arrow incomingArrow) {
        String screenName = SystemDynamicsObjectManager.getScreenName(screenNameE);
        if (!this.objectsMap.containsKey(screenName)) {
            this.addSystemDynamicsObjectPlaceHolder(screenName);
        }
        this.objectsMap.get(screenName).addIncomingArrow(incomingArrow);
    }

    public void addOutgoingArrow(String screenNameE, Arrow incomingArrow) {
        String screenName = SystemDynamicsObjectManager.getScreenName(screenNameE);
        if (!this.objectsMap.containsKey(screenName)) {
            this.addSystemDynamicsObjectPlaceHolder(screenName);
        }
        this.objectsMap.get(screenName).addOutgoingArrow(incomingArrow);
    }

    public List<Equation> getEquations(String screenNameE) {
        String screenName = SystemDynamicsObjectManager.getScreenName(screenNameE);
        if (!this.objectsMap.containsKey(screenName)) {
            this.addSystemDynamicsObjectPlaceHolder(screenName);
        }
        return this.objectsMap.get(screenName).getEquations();
    }

    public List<GraphicObject> getGraphicObjects(String screenNameE) {
        String screenName = SystemDynamicsObjectManager.getScreenName(screenNameE);
        if (!this.objectsMap.containsKey(screenName)) {
            this.addSystemDynamicsObjectPlaceHolder(screenName);
        }
        return this.objectsMap.get(screenName).getGraphicObjects();
    }

    public List<Arrow> getIncomingArrows(String screenNameE) {
        String screenName = SystemDynamicsObjectManager.getScreenName(screenNameE);
        if (!this.objectsMap.containsKey(screenName)) {
            this.addSystemDynamicsObjectPlaceHolder(screenName);
        }
        return this.objectsMap.get(screenName).getIncomingArrows();
    }

    public List<Arrow> getOutgoingArrows(String screenNameE) {
        String screenName = SystemDynamicsObjectManager.getScreenName(screenNameE);
        if (!this.objectsMap.containsKey(screenName)) {
            this.addSystemDynamicsObjectPlaceHolder(screenName);
        }
        return this.objectsMap.get(screenName).getOutgoingArrows();
    }

    public void extractStructure(View view) {
        SystemDynamicsObject effectiveFrom;
        SystemDynamicsObject effectiveTo;
        SystemDynamicsObject sdTo;
        String name;
        String type;
        String id;
        HashMap<String, GraphicObject> idToGraphicObject = new HashMap<String, GraphicObject>();
        HashMap<String, String> idToName = new HashMap<String, String>();
        HashMap<String, String> nameToId = new HashMap<String, String>();
        HashMap<String, String> nameToType = new HashMap<String, String>();
        HashMap inArrows = new HashMap();
        HashMap outArrows = new HashMap();
        System.out.println("### Processing View: " + view.getName());
        for (GraphicObject go : view.getGraphicObjects()) {
            idToGraphicObject.put(go.getId(), go);
        }
        for (GraphicObject go : view.getGraphicObjects()) {
            if (go.isArrow()) continue;
            id = go.getId();
            type = view.translateCodeToString(go.getType());
            name = go.getName();
            idToName.put(id, name);
            nameToId.put(name, id);
            nameToType.put(name, type);
        }
        for (GraphicObject go : view.getGraphicObjects()) {
            List out;
            List in;
            boolean found;
            GraphicObject EffectiveToGO;
            if (!go.isArrow()) continue;
            id = go.getId();
            type = view.translateCodeToString(go.getType());
            name = go.getName();
            idToName.put(id, name);
            nameToId.put(name, id);
            nameToType.put(name, type);
            boolean swap = false;
            String arrowType = "Unknown";
            String direction = "Unknown";
            if (go.isInfluenceArrow()) {
                arrowType = "INFLUENCE";
            }
            if (go.isFlowArrow()) {
                arrowType = "FLOW";
            }
            if ((EffectiveToGO = (GraphicObject)idToGraphicObject.get(go.getTo())).isValve()) {
                EffectiveToGO = EffectiveToGO.getAssociatedVariable();
            }
            String toName = (String)idToName.get(EffectiveToGO.getId());
            GraphicObject EffectiveFromGO = (GraphicObject)idToGraphicObject.get(go.getFrom());
            if (EffectiveFromGO == null) {
                System.out.println("EffectiveFromGO == null ");
                go.print();
                for (String s : idToGraphicObject.keySet()) {
                    ((GraphicObject)idToGraphicObject.get(s)).print();
                }
            }
            if (EffectiveFromGO.isValve()) {
                if (go.isInFlowArrow()) {
                    swap = true;
                }
                EffectiveFromGO = EffectiveFromGO.getAssociatedVariable();
            }
            String fromName = (String)idToName.get(EffectiveFromGO.getId());
            if (swap) {
                String tmp = toName;
                toName = fromName;
                fromName = tmp;
            }
            if (!inArrows.containsKey(toName)) {
                inArrows.put(toName, new ArrayList());
            }
            if (!outArrows.containsKey(fromName)) {
                outArrows.put(fromName, new ArrayList());
            }
            if (!(found = this.hasArrowWithOtherEnd(in = (List)inArrows.get(toName), fromName))) {
                Arrow inArrow = new Arrow(fromName, "IN", arrowType);
                in.add(inArrow);
            }
            if (found = this.hasArrowWithOtherEnd(out = (List)outArrows.get(fromName), toName)) continue;
            Arrow outArrow = new Arrow(toName, "OUT", arrowType);
            out.add(outArrow);
        }
        for (GraphicObject go : view.getGraphicObjects()) {
            id = go.getId();
            String name2 = (String)idToName.get(id);
            String type2 = (String)nameToType.get(name2);
            if (go.isArrow()) continue;
            this.addSystemDynamicsObject(name2);
            this.addGraphicObject(name2, go);
        }
        for (String to : inArrows.keySet()) {
            for (Arrow from : (List)inArrows.get(to)) {
                sdTo = this.getObjectWithName(to);
                SystemDynamicsObject sdFrom = this.getObjectWithName(from.getOtherEnd());
                effectiveTo = sdTo;
                effectiveFrom = sdFrom;
                if (sdTo == null || sdFrom == null || !effectiveTo.getType().equals("VARIABLE") && !effectiveTo.getType().equals("RATE") && !effectiveTo.getType().equals("CLOUD") || !effectiveFrom.getType().equals("VARIABLE") && !effectiveFrom.getType().equals("RATE") && !effectiveFrom.getType().equals("CLOUD")) continue;
                this.addIncomingArrow(effectiveTo.getScreenName(), from);
            }
        }
        for (String from : outArrows.keySet()) {
            for (Arrow to : (List)outArrows.get(from)) {
                sdTo = this.getObjectWithName(to.getOtherEnd());
                SystemDynamicsObject sdFrom = this.getObjectWithName(from);
                effectiveTo = sdTo;
                effectiveFrom = sdFrom;
                if (sdTo == null || sdFrom == null || !effectiveTo.getType().equals("VARIABLE") && !effectiveTo.getType().equals("RATE") && !effectiveTo.getType().equals("CLOUD") || !effectiveFrom.getType().equals("VARIABLE") && !effectiveFrom.getType().equals("RATE") && !effectiveFrom.getType().equals("CLOUD")) continue;
                this.addOutgoingArrow(effectiveFrom.getScreenName(), to);
            }
        }
    }

    private boolean hasArrowWithOtherEnd(List<Arrow> in, String name) {
        boolean found = false;
        for (Arrow a : in) {
            if (!a.getOtherEnd().equals(name)) continue;
            found = true;
        }
        return found;
    }
}

