/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import repast.simphony.systemdynamics.support.MutableInteger;
import repast.simphony.systemdynamics.translator.InformationManagers;
import repast.simphony.systemdynamics.translator.Parser;

public class SimplifiedUnit {
    private static final int NUMERATOR = 1;
    private static final int DENOMINATOR = 2;
    private String originalUnit;
    private Map<String, MutableInteger> numerator;
    private Map<String, MutableInteger> denominator;
    private String simplified;
    private int destination = 1;

    public SimplifiedUnit(SimplifiedUnit other) {
        this.originalUnit = other.originalUnit;
        this.numerator = this.copyOf(other.getNumerator());
        this.denominator = this.copyOf(other.getDenominator());
        this.reduce();
    }

    public SimplifiedUnit(String originalUnit) {
        this.originalUnit = originalUnit;
        this.numerator = new HashMap<String, MutableInteger>();
        this.denominator = new HashMap<String, MutableInteger>();
        this.simplify();
        this.reduce();
    }

    private void simplify() {
        int parenCount = 0;
        Stack<Integer> stack = new Stack<Integer>();
        List<String> tokens = Parser.tokenize(this.originalUnit);
        for (String token : tokens) {
            if (token.equals("(")) {
                ++parenCount;
                stack.push(this.destination);
                continue;
            }
            if (token.equals(")")) {
                --parenCount;
                this.destination = (Integer)stack.pop();
                continue;
            }
            if (token.equals("*")) continue;
            if (token.equals("/")) {
                this.destination = 2;
                continue;
            }
            if (this.destination == 1) {
                this.addToNumerator(token);
                continue;
            }
            this.addToDenominator(token);
        }
    }

    public void print() {
        System.out.println("NUMERATOR:");
        this.print(this.numerator);
        System.out.println("DENOMINATOR:");
        this.print(this.denominator);
        System.out.println(" >> " + this.formUnit() + " <<");
    }

    public String formUnit() {
        StringBuffer sb = new StringBuffer();
        boolean hasDenom = this.hasDenominator();
        sb.append("(");
        sb.append(this.formUnit(this.numerator));
        if (hasDenom) {
            sb.append("/");
            sb.append(this.formUnit(this.denominator));
        }
        sb.append(")");
        return sb.toString();
    }

    public String formUnit(Map<String, MutableInteger> aMap) {
        StringBuffer sb = new StringBuffer();
        int j = 0;
        for (String key : aMap.keySet()) {
            MutableInteger i = new MutableInteger(aMap.get(key));
            while (i.value() > 0) {
                if (j++ > 0) {
                    sb.append("*");
                }
                if (this.isConstant(key)) {
                    sb.append("constant");
                } else {
                    sb.append(key);
                }
                i.add(-1);
            }
        }
        return sb.toString();
    }

    private boolean hasDenominator() {
        if (this.denominator.size() == 0) {
            return false;
        }
        boolean hasDenom = false;
        for (String key : this.denominator.keySet()) {
            if (key.equals("dmnl") || this.isConstant(key) || key.equals("1") || key.equals("fraction")) continue;
            hasDenom = true;
        }
        return hasDenom;
    }

    private boolean isConstant(String key) {
        return key.startsWith("constant#");
    }

    private int getConstantAsInt(String key) {
        return Integer.parseInt(key.split("#")[1]);
    }

    private String getConstantAsString(String key) {
        return key.split("#")[1];
    }

    private String getConstantAsString(Map<String, MutableInteger> map) {
        String constant = null;
        for (String key : map.keySet()) {
            if (!this.isConstant(key)) continue;
            return this.getConstantAsString(key);
        }
        return constant;
    }

    private String getConstantKey(Map<String, MutableInteger> map) {
        String constant = null;
        for (String key : map.keySet()) {
            if (!this.isConstant(key)) continue;
            return key;
        }
        return constant;
    }

    private double getConstantAsDouble(String key) {
        return Double.parseDouble(key.split("#")[1]);
    }

    private boolean containsConstant(Map<String, MutableInteger> map) {
        for (String key : map.keySet()) {
            if (!this.isConstant(key)) continue;
            return true;
        }
        return false;
    }

    private void removeConstant(Map<String, MutableInteger> map) {
        String keyToRemove = null;
        for (String key : map.keySet()) {
            if (!this.isConstant(key)) continue;
            keyToRemove = key;
            break;
        }
        if (keyToRemove != null) {
            map.remove(keyToRemove);
        }
    }

    private void removeEquivalent(Map<String, MutableInteger> map) {
        String keyToRemove = null;
        for (String key : map.keySet()) {
            if (!this.isMultiMatch(key) && !key.equals("dmnl")) continue;
            keyToRemove = key;
        }
        if (keyToRemove != null) {
            map.remove(keyToRemove);
        }
    }

    private void print(Map<String, MutableInteger> map) {
        for (String key : map.keySet()) {
            System.out.println(String.valueOf(key) + " " + map.get(key).value());
        }
    }

    private void addToNumerator(String tokenIn) {
        String token = InformationManagers.getInstance().getUnitsManager().getEffectiveUnits(tokenIn);
        if (this.numerator.containsKey(token)) {
            MutableInteger mi = this.numerator.get(token);
            mi.add(1);
        } else {
            this.numerator.put(token, new MutableInteger(1));
        }
    }

    private void addToDenominator(String tokenIn) {
        String token = InformationManagers.getInstance().getUnitsManager().getEffectiveUnits(tokenIn);
        if (this.denominator.containsKey(token)) {
            MutableInteger mi = this.denominator.get(token);
            mi.add(1);
        } else {
            this.denominator.put(token, new MutableInteger(1));
        }
    }

    public void reduce() {
        if (this.numerator.size() == 0) {
            return;
        }
        ArrayList<String> removeFromNumerator = new ArrayList<String>();
        ArrayList<String> removeFromDenominator = new ArrayList<String>();
        for (String key : this.numerator.keySet()) {
            if (this.isMultiMatch(key) || !this.denominator.containsKey(key)) continue;
            MutableInteger numer = this.numerator.get(key);
            MutableInteger denom = this.denominator.get(key);
            while (numer.value() > 0 && denom.value() > 0) {
                numer.add(-1);
                denom.add(-1);
            }
            if (numer.value() == 0) {
                removeFromNumerator.add(key);
            }
            if (denom.value() != 0) continue;
            removeFromDenominator.add(key);
        }
        for (String key : removeFromNumerator) {
            this.numerator.remove(key);
        }
        for (String key : removeFromDenominator) {
            this.denominator.remove(key);
        }
        removeFromNumerator.clear();
        removeFromDenominator.clear();
        for (String key : this.numerator.keySet()) {
            if (!this.isMultiMatch(key) || this.numerator.size() <= 1) continue;
            removeFromNumerator.add(key);
        }
        for (String key : this.denominator.keySet()) {
            if (!this.isMultiMatch(key) || this.denominator.size() <= 1) continue;
            removeFromNumerator.add(key);
        }
        for (String key : removeFromNumerator) {
            this.numerator.remove(key);
        }
        for (String key : removeFromDenominator) {
            this.denominator.remove(key);
        }
        if (this.numerator.containsKey("dmnl") && this.numerator.size() > 1) {
            this.numerator.remove("dmnl");
        }
        if (this.numerator.containsKey("dmnl") && this.numerator.size() == 1) {
            if (this.denominator.size() == 0) {
                this.numerator.get("dmnl").setValue(1);
            } else {
                this.numerator.put("1", new MutableInteger(1));
                this.numerator.remove("dmnl");
            }
        }
        if (this.denominator.containsKey("dmnl")) {
            this.denominator.remove("dmnl");
        }
        if (this.containsConstant(this.denominator)) {
            this.removeConstant(this.denominator);
        }
        if (this.numerator.size() == 0 && this.denominator.size() == 0) {
            this.numerator.put("dmnl", new MutableInteger(1));
        }
        if (this.numerator.size() == 0 && this.denominator.size() > 0) {
            this.numerator.put("1", new MutableInteger(1));
        }
    }

    private boolean isMultiMatch(String token) {
        return token.equalsIgnoreCase("any") || this.isConstant(token) || token.equalsIgnoreCase("fraction") || token.equalsIgnoreCase("percent") || token.equalsIgnoreCase("1");
    }

    public boolean hasSameUnitsOriginal(SimplifiedUnit other) {
        MutableInteger countOther;
        MutableInteger countThis;
        if (this.numerator.size() != other.getNumerator().size() || this.denominator.size() != other.getDenominator().size()) {
            return false;
        }
        for (String unit : this.numerator.keySet()) {
            if (other.getNumerator().containsKey(unit)) {
                countThis = this.numerator.get(unit);
                countOther = other.getNumerator().get(unit);
                if (countThis.value() == countOther.value()) continue;
                return false;
            }
            return false;
        }
        for (String unit : this.denominator.keySet()) {
            if (other.getDenominator().containsKey(unit)) {
                countThis = this.denominator.get(unit);
                if (countThis == (countOther = other.getDenominator().get(unit))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean isConstant() {
        if (this.numerator.size() == 1 && this.containsConstant(this.numerator)) {
            if (this.denominator.size() > 1) {
                System.out.println("??? constant with denominator ???");
            }
            return true;
        }
        return false;
    }

    public boolean isDmnl() {
        if (this.numerator.size() == 1 && this.numerator.containsKey("dmnl")) {
            if (this.denominator.size() > 1) {
                System.out.println("??? constant with denominator ???");
            }
            return true;
        }
        return false;
    }

    public boolean isArrayInitialization() {
        return this.isArrayInitialization();
    }

    public boolean isAny() {
        return this.numerator.containsKey("any");
    }

    public boolean hasSameUnits(SimplifiedUnit other) {
        if (this.isConstant() || other.isConstant()) {
            return true;
        }
        if (this.isAny() || other.isAny()) {
            return true;
        }
        Map<String, MutableInteger> thisNumerator = this.copyOf(this.numerator);
        Map<String, MutableInteger> thisDenominator = this.copyOf(this.denominator);
        Map<String, MutableInteger> otherNumerator = this.copyOf(other.getNumerator());
        Map<String, MutableInteger> otherDenominator = this.copyOf(other.getDenominator());
        this.removeSame(thisNumerator, otherNumerator);
        this.removeSame(thisDenominator, otherDenominator);
        if (thisNumerator.size() == 0 && otherNumerator.size() == 0 && thisDenominator.size() == 0 && otherDenominator.size() == 0) {
            return true;
        }
        this.removeMulti(thisNumerator, otherNumerator, thisDenominator, otherDenominator);
        if (!this.hasSameCount(thisNumerator, otherNumerator) || !this.hasSameCount(thisDenominator, otherDenominator)) {
            return false;
        }
        return thisNumerator.size() == 0 && otherNumerator.size() == 0 && thisDenominator.size() == 0 && otherDenominator.size() == 0;
    }

    private boolean hasSameCount(Map<String, MutableInteger> thisOne, Map<String, MutableInteger> otherOne) {
        return this.getCount(thisOne) == this.getCount(otherOne);
    }

    private int getCount(Map<String, MutableInteger> thisOne) {
        int thisCount = 0;
        for (String key : thisOne.keySet()) {
            thisCount += thisOne.get(key).value();
        }
        return thisCount;
    }

    private void removeMulti(Map<String, MutableInteger> thisNumerator, Map<String, MutableInteger> otherNumerator, Map<String, MutableInteger> thisDenominator, Map<String, MutableInteger> otherDenominator) {
        this.removeEquivalent(thisNumerator);
        this.removeEquivalent(otherNumerator);
        this.removeEquivalent(thisDenominator);
        this.removeEquivalent(otherDenominator);
    }

    private void removeSame(Map<String, MutableInteger> thisOne, Map<String, MutableInteger> otherOne) {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String key : thisOne.keySet()) {
            if (!otherOne.containsKey(key)) continue;
            MutableInteger miThis = thisOne.get(key);
            MutableInteger miOther = otherOne.get(key);
            if (miThis.value() == miOther.value()) {
                toRemove.add(key);
                continue;
            }
            if (miThis.value() > miOther.value()) {
                miThis.add(-miOther.value());
                continue;
            }
            if (miThis.value() >= miOther.value()) continue;
            miOther.add(-miThis.value());
        }
        for (String key : toRemove) {
            thisOne.remove(key);
            otherOne.remove(key);
        }
    }

    public boolean validForOperation(String operator, SimplifiedUnit otherSU) {
        if (operator == null) {
            System.out.println("Operator is null!");
        }
        if (operator.equals("+") || operator.equals("-") || operator.equals("==") || Parser.isBooleanOperator(operator)) {
            return this.hasSameUnits(otherSU);
        }
        if (operator.equals("*") || operator.equals("/")) {
            return true;
        }
        if (operator.equals("^")) {
            return otherSU.isConstant() || otherSU.isDmnl();
        }
        return false;
    }

    public void equals(SimplifiedUnit su) {
        this.numerator.clear();
        this.numerator.put("dmnl", new MutableInteger(1));
        this.denominator.clear();
    }

    public void plus(SimplifiedUnit su) {
    }

    public void minus(SimplifiedUnit su) {
    }

    public void exp(SimplifiedUnit su) {
        if (su.isConstant()) {
            String key = su.getConstantKey(su.getNumerator());
            String constant = su.getConstantAsString(key);
            SimplifiedUnit copy = new SimplifiedUnit(this);
            if (Parser.isInteger(constant)) {
                int con = Integer.parseInt(constant);
                int i = 0;
                while (i < con - 1) {
                    this.times(copy);
                    ++i;
                }
            }
        }
    }

    public void times(SimplifiedUnit su) {
        for (String key : su.getNumerator().keySet()) {
            if (this.numerator.containsKey(key)) {
                this.numerator.get(key).add(1);
                continue;
            }
            this.numerator.put(key, new MutableInteger(su.getNumerator().get(key).value()));
        }
        for (String key : su.getDenominator().keySet()) {
            if (this.denominator.containsKey(key)) {
                this.denominator.get(key).add(1);
                continue;
            }
            this.denominator.put(key, new MutableInteger(su.getDenominator().get(key).value()));
        }
    }

    public void dividedBy(SimplifiedUnit su) {
        this.times(su.invert());
    }

    public SimplifiedUnit invert() {
        SimplifiedUnit su = new SimplifiedUnit(this);
        su.setDenominator(this.numerator);
        su.setNumerator(this.denominator);
        return su;
    }

    public String getOriginalUnit() {
        return this.originalUnit;
    }

    public void setOriginalUnit(String originalUnit) {
        this.originalUnit = originalUnit;
    }

    public Map<String, MutableInteger> getNumerator() {
        return this.numerator;
    }

    public void setNumerator(Map<String, MutableInteger> numerator) {
        this.numerator = numerator;
    }

    public Map<String, MutableInteger> getDenominator() {
        return this.denominator;
    }

    public void setDenominator(Map<String, MutableInteger> denominator) {
        this.denominator = denominator;
    }

    public String getSimplified() {
        return this.simplified;
    }

    public void setSimplified(String simplified) {
        this.simplified = simplified;
    }

    private Map<String, MutableInteger> copyOf(Map<String, MutableInteger> map) {
        HashMap<String, MutableInteger> newMap = new HashMap<String, MutableInteger>();
        for (String key : map.keySet()) {
            MutableInteger mi = map.get(key);
            newMap.put(key, new MutableInteger(mi.value()));
        }
        return newMap;
    }
}

