/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import repast.simphony.systemdynamics.translator.InformationManagers;
import repast.simphony.systemdynamics.translator.NativeDataTypeManager;
import repast.simphony.systemdynamics.translator.Parser;
import repast.simphony.systemdynamics.translator.TreeTraversal;

public class Node {
    private Node parent = null;
    private Node child = null;
    private Node next = null;
    private Node previous = null;
    private String token;
    private boolean placeHolder = false;
    private boolean deleted = false;
    private String resultsVariable = null;
    private StringBuffer generatedCodeHead = new StringBuffer();
    private StringBuffer generatedCodeTail = new StringBuffer();
    private StringBuffer generatedCodeElse = new StringBuffer();
    private String replacedToken = "@";
    private boolean initialized = false;

    public Node(Node anotherNode) {
        this.parent = anotherNode.parent;
        this.child = anotherNode.child;
        this.next = anotherNode.next;
        this.previous = anotherNode.previous;
        this.token = new String(anotherNode.token);
    }

    public Node(String token) {
        this.token = token;
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public Node getChild() {
        return this.child;
    }

    public void setChild(Node child) {
        this.child = child;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public Node getNext() {
        return this.next;
    }

    public void setNext(Node next) {
        this.next = next;
    }

    public Node getPrevious() {
        return this.previous;
    }

    public void setPrevious(Node previous) {
        this.previous = previous;
    }

    public String getToken() {
        return this.token;
    }

    public String getUnits() {
        return InformationManagers.getInstance().getUnitsManager().getUnits(this.token);
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getInfo() {
        StringBuffer sb = new StringBuffer();
        String spacing = "      ";
        sb.append(String.valueOf(spacing) + "token: " + this.token + "\n");
        sb.append(String.valueOf(spacing) + "units: " + this.getUnits() + "\n");
        sb.append(String.valueOf(spacing) + "placeHolder: " + (this.placeHolder ? "True" : "False") + "\n");
        sb.append(String.valueOf(spacing) + "results variable: " + this.resultsVariable + "\n");
        sb.append(String.valueOf(spacing) + "head: " + this.generatedCodeHead + "\n");
        sb.append(String.valueOf(spacing) + "else: " + this.generatedCodeElse + "\n");
        sb.append(String.valueOf(spacing) + "tail: " + this.generatedCodeTail + "\n");
        sb.append(String.valueOf(spacing) + "parent: " + this.parent + "\n");
        sb.append(String.valueOf(spacing) + "child: " + this.child + "\n");
        sb.append(String.valueOf(spacing) + "next: " + this.next + "\n");
        sb.append(String.valueOf(spacing) + "previous: " + this.previous + "\n");
        return sb.toString();
    }

    public String getInfo(String blanks) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(blanks) + "token: " + this.token + "\n");
        sb.append(String.valueOf(blanks) + "units: " + InformationManagers.getInstance().getUnitsManager().getUnits(this.token) + "\n");
        sb.append(String.valueOf(blanks) + "placeHolder: " + (this.placeHolder ? "True" : "False") + "\n");
        sb.append(String.valueOf(blanks) + "results variable: " + this.resultsVariable + "\n");
        sb.append(String.valueOf(blanks) + "head: " + this.generatedCodeHead + "\n");
        sb.append(String.valueOf(blanks) + "else: " + this.generatedCodeElse + "\n");
        sb.append(String.valueOf(blanks) + "tail: " + this.generatedCodeTail + "\n");
        return sb.toString();
    }

    public String getInfoTerse(String blanks) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(blanks) + "token: " + this.token + "\n");
        sb.append(String.valueOf(blanks) + "units: " + InformationManagers.getInstance().getUnitsManager().getUnits(this.token) + "\n");
        return sb.toString();
    }

    public void setReplacedToken(String replacedToken) {
        this.replacedToken = replacedToken;
    }

    public StringBuffer getGeneratedCodeHead() {
        return this.generatedCodeHead;
    }

    public void setGeneratedCodeHead(StringBuffer generatedCode) {
        this.generatedCodeHead = generatedCode;
    }

    public StringBuffer getGeneratedCodeTail() {
        return this.generatedCodeTail;
    }

    public void setGeneratedCodeTail(StringBuffer generatedCodeTail) {
        this.generatedCodeTail = generatedCodeTail;
    }

    public String getResultsVariable() {
        return this.resultsVariable;
    }

    public void setResultsVariable(String resultsVariable) {
        this.resultsVariable = resultsVariable;
    }

    public StringBuffer getGeneratedCodeElse() {
        return this.generatedCodeElse;
    }

    public void setGeneratedCodeElse(StringBuffer generatedCodeElse) {
        this.generatedCodeElse = generatedCodeElse;
    }

    public boolean isPlaceHolder() {
        return this.placeHolder;
    }

    public void setPlaceHolder(boolean placeHolder) {
        this.placeHolder = placeHolder;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isTerminal() {
        return this.child == null;
    }

    public String toString() {
        return this.token;
    }

    public static String expand(Node node) {
        StringBuffer sb = new StringBuffer();
        Node.expand(node, sb);
        return sb.toString();
    }

    private static void expand(Node node, StringBuffer sb) {
        if (node == null) {
            return;
        }
        Node.expand(node.getChild(), sb);
        String vensimVar = InformationManagers.getInstance().getNativeDataTypeManager().getOriginalName(node.getToken());
        sb.append(vensimVar);
        Node.expand(node.getNext(), sb);
    }

    public static String generateExpression(Node node) {
        StringBuffer sb = new StringBuffer();
        NativeDataTypeManager ndtm = InformationManagers.getInstance().getNativeDataTypeManager();
        if (node != null) {
            if (Parser.isArithmeticOperator(node.getToken()) || Parser.isEqualSign(node.getToken())) {
                if (!Parser.isUnaryOperator(node.getToken())) {
                    sb.append(Node.generateExpression(TreeTraversal.getLhs(node)));
                    sb.append(ndtm.getOriginalNameQuotedIfNecessary(node.getToken()));
                    sb.append(Node.generateExpression(TreeTraversal.getRhs(node)));
                } else {
                    sb.append(Parser.translateUnaryOperator(node.getToken()));
                    sb.append(Node.generateExpression(node.getChild()));
                }
                return sb.toString();
            }
            sb.append(ndtm.getOriginalNameQuotedIfNecessary(node.getToken()));
        }
        return sb.toString();
    }

    public String generateExpression() {
        Node node = this;
        StringBuffer sb = new StringBuffer();
        NativeDataTypeManager ndtm = InformationManagers.getInstance().getNativeDataTypeManager();
        if (node != null) {
            if (Parser.isArithmeticOperator(node.getToken()) || Parser.isEqualSign(node.getToken())) {
                if (!Parser.isUnaryOperator(node.getToken())) {
                    sb.append(Node.generateExpression(TreeTraversal.getLhs(node)));
                    sb.append(ndtm.getOriginalNameQuotedIfNecessary(node.getToken()));
                    sb.append(Node.generateExpression(TreeTraversal.getRhs(node)));
                } else {
                    sb.append(Parser.translateUnaryOperator(node.getToken()));
                    sb.append(Node.generateExpression(node.getChild()));
                }
                return sb.toString();
            }
            sb.append(ndtm.getOriginalNameQuotedIfNecessary(node.getToken()));
        }
        return sb.toString();
    }
}

