/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import repast.simphony.systemdynamics.support.MutableInteger;
import repast.simphony.systemdynamics.translator.Macro;
import repast.simphony.systemdynamics.translator.Parser;

public class MacroManager {
    private Map<String, Macro> macros = new HashMap<String, Macro>();

    public void createNewMacro(String macroName, Macro macro) {
        this.macros.put(macroName, macro);
    }

    public boolean isMacroName(String macroName) {
        return this.macros.containsKey(macroName);
    }

    public String expand(String vensimEquation) {
        StringBuffer sb = new StringBuffer();
        String[] parts = vensimEquation.split("~", 2);
        List<String> tokens = Parser.tokenize(parts[0]);
        while (this.containsMacroInvocation(tokens)) {
            tokens = this.applyMacro(tokens);
        }
        sb.append(this.makeEquation(tokens));
        sb.append("~");
        sb.append(parts[1]);
        return sb.toString();
    }

    private List<String> applyMacro(List<String> tokens) {
        List<String> applied = new ArrayList<String>();
        int index = 0;
        for (String token : tokens) {
            if (this.isMacroName(token)) {
                Macro macro = this.macros.get(token);
                applied = macro.apply(tokens, index);
                break;
            }
            ++index;
        }
        return applied;
    }

    private String makeEquation(List<String> tokens) {
        StringBuffer eqn = new StringBuffer();
        for (String token : tokens) {
            eqn.append(token);
        }
        return eqn.toString();
    }

    public boolean containsMacroInvocation(List<String> tokens) {
        int index = 0;
        for (String token : tokens) {
            if (this.macros.containsKey(token) && index + 1 < tokens.size() && tokens.get(index + 1).equals("(")) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public boolean containsMacroInvocation(String vensimEquation) {
        String eqn = vensimEquation.split("~")[0];
        if (!eqn.contains("=")) {
            return false;
        }
        List<String> tokens = Parser.tokenize(Parser.extractRHS(eqn));
        for (String token : tokens) {
            if (!this.macros.containsKey(token)) continue;
            return true;
        }
        return false;
    }

    public boolean readMacroAndProcess(String eqn, List<String> rawEquations, MutableInteger linePtr) {
        String[] argString;
        ArrayList<String> arguments = new ArrayList<String>();
        String equation = new String(eqn).replace(":MACRO:", "").trim();
        String macroName = equation.split("\\(")[0].trim();
        String[] stringArray = argString = equation.split("\\(")[1].replace(")", "").trim().split(",");
        int n = argString.length;
        int n2 = 0;
        while (n2 < n) {
            String anArg = stringArray[n2];
            arguments.add(anArg.trim());
            ++n2;
        }
        Macro aMacro = new Macro(macroName, arguments);
        this.createNewMacro(macroName, aMacro);
        String aLine = rawEquations.get(linePtr.valueAndInc());
        while (!aLine.contains(":END OF MACRO:")) {
            String concat = "";
            if (aLine.endsWith("\\")) {
                concat = aLine.replace("\\", "");
                aLine = rawEquations.get(linePtr.valueAndInc());
                while (aLine.endsWith("\\")) {
                    concat = String.valueOf(concat) + aLine.replace("\\", "");
                    aLine = rawEquations.get(linePtr.valueAndInc());
                }
            }
            while (true) {
                if (aLine.endsWith("|")) break;
                concat = String.valueOf(concat) + aLine;
                aLine = rawEquations.get(linePtr.valueAndInc());
            }
            concat = String.valueOf(concat) + aLine;
            aMacro.addEquation(concat);
            aLine = rawEquations.get(linePtr.valueAndInc());
            while (aLine.length() == 0) {
                aLine = rawEquations.get(linePtr.valueAndInc());
            }
        }
        aMacro.expand();
        System.out.println(aMacro.getExpandedMacroEquation());
        return true;
    }

    public int getNumArgumentsFor(String macroName) {
        return this.macros.get(macroName).getArguments().size();
    }

    public void printMacros() {
        for (String macroName : this.macros.keySet()) {
            Macro macro = this.macros.get(macroName);
            System.out.println("Macro Name: " + macroName);
            System.out.println(macro.getExpandedMacroEquation());
        }
    }
}

