/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import repast.simphony.systemdynamics.translator.Parser;
import repast.simphony.systemdynamics.translator.SystemDynamicsObjectManager;
import repast.simphony.systemdynamics.translator.View;

public class GraphicObject {
    public static final long mask0 = 1L;
    public static final long mask1 = 2L;
    public static final long mask2 = 4L;
    public static final long mask3 = 8L;
    public static final long mask4 = 16L;
    public static final long mask5 = 32L;
    public static final long mask6 = 64L;
    public static final long mask7 = 128L;
    public static final long mask8 = 256L;
    public static final String ARROW = "1";
    public static final String VARIABLE = "10";
    public static final String VALVE = "11";
    public static final String COMMENT = "12";
    public static final String BITMAP = "30";
    public static final String METAFILE = "31";
    public static final String RATE = "99";
    public static final String CLOUD = "48";
    private View view;
    private String rawObject;
    private String type;
    private String id;
    private String from;
    private String to;
    private String shape;
    private String hidden;
    private String polarity;
    private String thickness;
    private String hasFont;
    private String delayType;
    private String reserved;
    private String color;
    private String font;
    private String numPoints;
    private String pointList;
    private String name;
    private String x;
    private String y;
    private String width;
    private String height;
    private String bits;
    private String textPos;
    private String boxWidth;
    private String nav1;
    private String nav2;
    private String boxColor;
    private String fillColor;
    private String additionalText;
    private SystemDynamicsObjectManager sdObjectManager;
    private GraphicObject associatedVariable;

    public GraphicObject(SystemDynamicsObjectManager sdObjectManager, View view, String rawObject) {
        this.rawObject = new String(rawObject);
        this.view = view;
        this.sdObjectManager = sdObjectManager;
        this.parse();
    }

    public void parse() {
        String[] fields = Parser.splitQuoted(this.rawObject, ",");
        this.type = fields[0];
        this.id = fields[1];
        if (this.type.equals(ARROW)) {
            this.parseAsArrow(fields);
        } else if (this.type.equals(VARIABLE)) {
            this.parseAsVariable(fields);
        } else if (this.type.equals(VALVE)) {
            this.parseAsValve(fields);
        } else if (this.type.equals(COMMENT)) {
            this.parseAsComment(fields);
        } else if (this.type.equals(BITMAP)) {
            this.parseAsBitmap(fields);
        } else if (this.type.equals(METAFILE)) {
            this.parseAsMetafile(fields);
        }
    }

    public boolean isValve() {
        return this.type.equals(VALVE);
    }

    public boolean isVariable() {
        return this.type.equals(VARIABLE);
    }

    public boolean isRate() {
        return this.type.equals(RATE);
    }

    public boolean isArrow() {
        return this.type.equals(ARROW);
    }

    public boolean isComment() {
        return this.type.equals(COMMENT);
    }

    public boolean isBitmap() {
        return this.type.equals(BITMAP);
    }

    public boolean isMetafile() {
        return this.type.equals(METAFILE);
    }

    public boolean isCloud() {
        return this.type.equals(CLOUD);
    }

    private void parseAsArrow(String[] fields) {
        this.from = fields[2];
        this.to = fields[3];
        this.shape = fields[4];
        this.hidden = fields[5];
        this.polarity = fields[6];
        this.thickness = fields[7];
        this.hasFont = fields[8];
        this.delayType = fields[9];
        this.reserved = fields[10];
        this.color = fields[11];
        this.font = fields[12];
        this.numPoints = this.reconstructNumPoints(fields, 13);
        this.pointList = this.reconstructPointlist(fields, 13);
    }

    private String reconstructNumPoints(String[] fields, int index) {
        String[] result = fields[index].split("\\|");
        return result[0];
    }

    private String reconstructPointlist(String[] fields, int index) {
        StringBuffer sb = new StringBuffer();
        int i = index;
        while (i < fields.length) {
            if (i != index) {
                sb.append(",");
            }
            sb.append(fields[i]);
            ++i;
        }
        return sb.toString().split("\\|")[1];
    }

    private void parseAsVariable(String[] fields) {
        this.name = fields[2].replace("\"", "");
        this.x = fields[3];
        this.y = fields[4];
        this.width = fields[5];
        this.height = fields[6];
        this.shape = fields[7];
        this.bits = fields[8];
        if (this.bitwiseAnd(this.bits, 4L)) {
            this.additionalText = new String(this.view.getNextRawObject());
        }
        this.hidden = fields[9];
        this.hasFont = fields[10];
        this.textPos = fields[11];
        this.boxWidth = fields[12];
        this.nav1 = fields[13];
        this.nav2 = fields[14];
        if (this.nav1.equals("253") && this.nav2.equals("253")) {
            this.additionalText = new String(this.view.getNextRawObject());
        }
        if (!this.hasFont.equals("0")) {
            this.boxColor = fields[15];
            this.fillColor = fields[16];
            this.font = fields[17];
        }
    }

    private void parseAsValve(String[] fields) {
        this.name = fields[2].replace("\"", "");
        this.x = fields[3];
        this.y = fields[4];
        this.width = fields[5];
        this.height = fields[6];
        this.shape = fields[7];
        this.bits = fields[8];
        this.hidden = fields[9];
        this.hasFont = fields[10];
        this.textPos = fields[11];
        this.boxWidth = fields[12];
        this.nav1 = fields[13];
        this.nav2 = fields[14];
        if (!this.hasFont.equals("0")) {
            this.boxColor = fields[15];
            this.fillColor = fields[16];
            this.font = fields[17];
        }
        this.additionalText = new String(this.view.getNextRawObject());
        GraphicObject go = new GraphicObject(this.sdObjectManager, this.view, this.additionalText);
        if (go.getType().equals(VARIABLE)) {
            this.associatedVariable = go;
            go.setType(RATE);
            go.setAssociatedVariable(this);
        }
    }

    private void parseAsComment(String[] fields) {
        this.name = fields[2].replace("\"", "");
        if (this.name.equals(CLOUD)) {
            this.name = "CLOUD_" + this.id;
            this.type = CLOUD;
        }
        this.x = fields[3];
        this.y = fields[4];
        this.width = fields[5];
        this.height = fields[6];
        this.shape = fields[7];
        this.bits = fields[8];
        if (this.bitwiseAnd(this.bits, 4L)) {
            this.additionalText = new String(this.view.getNextRawObject());
        }
        this.hidden = fields[9];
        this.hasFont = fields[10];
        this.textPos = fields[11];
        this.boxWidth = fields[12];
        this.nav1 = fields[13];
        this.nav2 = fields[14];
        if (!this.hasFont.equals("0")) {
            this.boxColor = fields[15];
            this.fillColor = fields[16];
            this.font = fields[17];
        }
    }

    private void parseAsBitmap(String[] fields) {
        this.name = fields[2].replace("\"", "");
        this.x = fields[3];
        this.y = fields[4];
        this.width = fields[5];
        this.height = fields[6];
        this.shape = fields[7];
        this.bits = fields[8];
        this.hidden = fields[9];
        this.hasFont = fields[10];
        this.textPos = fields[11];
        this.boxWidth = fields[12];
        this.nav1 = fields[13];
        this.nav2 = fields[14];
        if (!this.hasFont.equals("0")) {
            this.boxColor = fields[15];
            this.fillColor = fields[16];
            this.font = fields[17];
        }
    }

    private void parseAsMetafile(String[] fields) {
        this.name = fields[2].replace("\"", "");
        this.x = fields[3];
        this.y = fields[4];
        this.width = fields[5];
        this.height = fields[6];
        this.shape = fields[7];
        this.bits = fields[8];
        this.hidden = fields[9];
        this.hasFont = fields[10];
        this.textPos = fields[11];
        this.boxWidth = fields[12];
        this.nav1 = fields[13];
        this.nav2 = fields[14];
        if (!this.hasFont.equals("0")) {
            this.boxColor = fields[15];
            this.fillColor = fields[16];
            this.font = fields[17];
        }
        this.additionalText = new String(this.view.getNextRawObject());
    }

    public void print() {
        System.out.println(">>>>");
        System.out.println("    ID: " + this.id);
        if (this.type.equals(ARROW)) {
            System.out.println("    Type: Arrow");
            System.out.println("    Name: " + this.name);
            System.out.println("    From: " + this.from);
            System.out.println("    To: " + this.to);
            System.out.println("    NumPoints: " + this.numPoints);
            System.out.println("    PointList: " + this.pointList);
            System.out.println("    Shape: " + this.shape);
        } else if (this.type.equals(VARIABLE)) {
            System.out.println("    Type: Variable");
            System.out.println("    Name: " + this.name);
            System.out.println("    X: " + this.x);
            System.out.println("    Y: " + this.y);
            System.out.println("    Width: " + this.width);
            System.out.println("    Height: " + this.height);
            System.out.println("    Shape: " + this.shape);
        } else if (this.type.equals(VALVE)) {
            System.out.println("    Type: Valve");
            System.out.println("    Name: " + this.name);
            System.out.println("    X: " + this.x);
            System.out.println("    Y: " + this.y);
            System.out.println("    Width: " + this.width);
            System.out.println("    Height: " + this.height);
            System.out.println("    Shape: " + this.shape);
        } else if (this.type.equals(COMMENT)) {
            System.out.println("    Type: Comment");
            System.out.println("    Name: " + this.name);
            System.out.println("    X: " + this.x);
            System.out.println("    Y: " + this.y);
            System.out.println("    Width: " + this.width);
            System.out.println("    Height: " + this.height);
            System.out.println("    Comment: " + this.additionalText);
            System.out.println("    Shape: " + this.shape);
        } else if (this.type.equals(CLOUD)) {
            System.out.println("    Type: Cloud");
            System.out.println("    Name: " + this.name);
            System.out.println("    X: " + this.x);
            System.out.println("    Y: " + this.y);
            System.out.println("    Width: " + this.width);
            System.out.println("    Height: " + this.height);
            System.out.println("    Comment: " + this.additionalText);
            System.out.println("    Shape: " + this.shape);
        } else if (this.type.equals(BITMAP)) {
            System.out.println("    Type: BitMap");
            System.out.println("    Name: " + this.name);
            System.out.println("    X: " + this.x);
            System.out.println("    Y: " + this.y);
            System.out.println("    Width: " + this.width);
            System.out.println("    Height: " + this.height);
            System.out.println("    Shape: " + this.shape);
        } else if (this.type.equals(METAFILE)) {
            System.out.println("    Type: Metafile");
            System.out.println("    Name: " + this.name);
            System.out.println("    X: " + this.x);
            System.out.println("    Y: " + this.y);
            System.out.println("    Width: " + this.width);
            System.out.println("    Height: " + this.height);
            System.out.println("    Shape: " + this.shape);
        } else if (this.type.equals(RATE)) {
            System.out.println("    Type: Rate");
            System.out.println("    Name: " + this.name);
            System.out.println("    X: " + this.x);
            System.out.println("    Y: " + this.y);
            System.out.println("    Width: " + this.width);
            System.out.println("    Height: " + this.height);
            System.out.println("    Shape: " + this.shape);
        }
    }

    public boolean isInfluenceArrow() {
        return this.type.equals(ARROW) && (this.shape.equals("0") || this.shape.equals(ARROW));
    }

    public boolean isFlowArrow() {
        return this.type.equals(ARROW) && (this.shape.equals("4") || this.shape.equals("100") || this.shape.equals("68"));
    }

    public boolean isInFlowArrow() {
        return this.isFlowArrow() && this.shape.equals("100");
    }

    public boolean isOutFlowArrow() {
        return this.isFlowArrow() && (this.shape.equals("4") || this.shape.equals("68"));
    }

    public boolean isInputOutput() {
        if (this.nav1 == null || this.nav2 == null) {
            return false;
        }
        return this.nav1.equals("253") && this.nav2.equals("253");
    }

    private boolean bitwiseAnd(String value, long mask) {
        long val = Long.parseLong(value);
        long result = val & mask;
        return result > 0L;
    }

    public View getView() {
        return this.view;
    }

    public String getRawObject() {
        return this.rawObject;
    }

    public String getType() {
        return this.type;
    }

    public String getTypeAsString() {
        return this.view.translateCodeToString(this.type);
    }

    public String getId() {
        return this.id;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getShape() {
        return this.shape;
    }

    public String getHidden() {
        return this.hidden;
    }

    public String getPolarity() {
        return this.polarity;
    }

    public String getThickness() {
        return this.thickness;
    }

    public String getHasFont() {
        return this.hasFont;
    }

    public String getDelayType() {
        return this.delayType;
    }

    public String getReserved() {
        return this.reserved;
    }

    public String getColor() {
        return this.color;
    }

    public String getFont() {
        return this.font;
    }

    public String getNumPoints() {
        return this.numPoints;
    }

    public String getPointList() {
        return this.pointList;
    }

    public String getName() {
        return this.name;
    }

    public String getX() {
        return this.x;
    }

    public String getY() {
        return this.y;
    }

    public String getWidth() {
        return this.width;
    }

    public String getHeight() {
        return this.height;
    }

    public String getBits() {
        return this.bits;
    }

    public String getTextPos() {
        return this.textPos;
    }

    public String getBoxWidth() {
        return this.boxWidth;
    }

    public String getNav1() {
        return this.nav1;
    }

    public String getNav2() {
        return this.nav2;
    }

    public String getBoxColor() {
        return this.boxColor;
    }

    public String getFillColor() {
        return this.fillColor;
    }

    public String getAdditionalText() {
        return this.additionalText;
    }

    public GraphicObject getAssociatedVariable() {
        return this.associatedVariable;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setAssociatedVariable(GraphicObject associatedVariable) {
        this.associatedVariable = associatedVariable;
    }
}

