/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import java.util.List;
import java.util.Stack;
import repast.simphony.systemdynamics.support.ArrayReference;
import repast.simphony.systemdynamics.support.MutableBoolean;
import repast.simphony.systemdynamics.support.MutableInteger;
import repast.simphony.systemdynamics.support.NamedSubscriptManager;
import repast.simphony.systemdynamics.translator.Equation;
import repast.simphony.systemdynamics.translator.InformationManagers;
import repast.simphony.systemdynamics.translator.OperationResult;
import repast.simphony.systemdynamics.translator.Parser;

public class GrammarChecker {
    public static final String ARRAY_INITIALIZATION = "ArrayInitialization";
    public static final String ASSIGNMENT = "Assignment";
    public static final String LOOKUP_DEFINITION = "LookupDefinition";
    public static final String SUBSCRIPT_DEFINITION = "SubscriptDefinition";
    public static final String COMMA = ",";
    public static final String SEMICOLON = ";";
    public static final String LEFT_PAREN = "(";
    public static final String RIGHT_PAREN = ")";
    public static final String VARIABLE_REFERENCE = "VariableReference";
    public static final String FUNCTION_REFERENCE = "FunctionReference";
    public static final String LOOKUP_REFERENCE = "LookupReference";
    public static final String BINARY_OPERATOR = "BinaryOperator";
    public static final String UNARY_OPERATOR = "UnaryOperator";
    public static final String ARRAY = "array.";
    public static final String FUNCTION = "sdFunctions.";
    public static final String SCALAR = "memory.";
    public static final String LOOKUP = "lookup.";
    Stack<MutableBoolean> functionStack = new Stack();
    Stack<MutableInteger> openParenStack = new Stack();
    private boolean debugPrint = false;
    private Equation equation;
    List<String> tokens;

    public GrammarChecker(Equation eqn, List<String> tokens) {
        this.tokens = tokens;
        this.equation = eqn;
    }

    public OperationResult checkGrammar() {
        OperationResult or = new OperationResult();
        String type = this.determineEquationType(or);
        if (!or.isOk()) {
            return or;
        }
        if (type.equals(ARRAY_INITIALIZATION)) {
            return this.checkArrayInitializationGrammar();
        }
        if (type.equals(ASSIGNMENT)) {
            return this.checkAssignmentGrammar();
        }
        if (type.equals(LOOKUP_DEFINITION)) {
            return this.checkLookupDefinitionGrammar();
        }
        if (type.equals(SUBSCRIPT_DEFINITION)) {
            return this.checkSubscriptDefinitionGrammar();
        }
        or.setErrorMessage("Cannot determine equation type for grammar check");
        return or;
    }

    private OperationResult checkArrayInitializationGrammar() {
        OperationResult or = new OperationResult();
        MutableInteger pos = new MutableInteger(0);
        ArrayReference arLHS = new ArrayReference(this.equation.getLhs());
        int numDimensions = arLHS.getSubscripts().size();
        boolean needSemiColon = numDimensions > 1;
        String token = this.tokens.get(pos.value());
        pos.add(1);
        token = this.tokens.get(pos.value());
        pos.add(1);
        token = this.tokens.get(pos.value());
        boolean done = false;
        needSemiColon = true;
        if (!needSemiColon) {
            while (!done) {
                if (pos.value() % 2 == 0) {
                    if (!Parser.isNumber(token)) {
                        or.setErrorMessage("Expected numeric value. Found " + token + " in position " + pos.value());
                        return or;
                    }
                } else if (!token.equals(COMMA)) {
                    or.setErrorMessage("Expected comma. Found " + token + " in position " + pos.value());
                    return or;
                }
                pos.add(1);
                if (pos.value() >= this.tokens.size()) {
                    if (pos.value() % 2 == 0) {
                        or.setErrorMessage("Array Initialization cannot end with a comma");
                    }
                    return or;
                }
                token = this.tokens.get(pos.value());
            }
        } else {
            int[] numValues = new int[2];
            List<String> subscripts = arLHS.getSubscripts();
            int sub = 0;
            NamedSubscriptManager nsm = InformationManagers.getInstance().getNamedSubscriptManager();
            for (String subr : subscripts) {
                int numV = nsm.getNumIndexFor(subr);
                if (sub < 2) {
                    numValues[sub] = numV;
                } else if (numV != 1) {
                    if (this.tokens.size() == 3 && Parser.isNumber(token)) {
                        return or;
                    }
                    or.setErrorMessage("Only the first two dimensions can vary in this array initialization");
                    return or;
                }
                ++sub;
            }
            while (pos.value() < this.tokens.size()) {
                if (token.equals("_")) {
                    pos.add(1);
                    if (pos.value() < this.tokens.size()) {
                        token = this.tokens.get(pos.value());
                    } else {
                        or.setErrorMessage("Unexpected end of data values");
                        return or;
                    }
                }
                if (!Parser.isNumber(token)) {
                    or.setErrorMessage("Expected numeric value. Found " + token + " in position " + pos.value());
                    return or;
                }
                pos.add(1);
                if (pos.value() >= this.tokens.size()) break;
                token = this.tokens.get(pos.value());
                if (!token.equals(COMMA) && !token.equals(SEMICOLON)) {
                    or.setErrorMessage("Expected Separator. Found " + token + " in position " + pos.value());
                    return or;
                }
                pos.add(1);
                if (pos.value() < this.tokens.size()) {
                    token = this.tokens.get(pos.value());
                    continue;
                }
                break;
            }
        }
        return or;
    }

    private OperationResult checkAssignmentGrammar() {
        OperationResult or = new OperationResult();
        MutableBoolean lookingForBinaryOperator = new MutableBoolean(false);
        MutableBoolean lookingForArgumentSeparator = new MutableBoolean(false);
        this.functionStack.push(new MutableBoolean(false));
        this.openParenStack.push(new MutableInteger(0));
        MutableInteger openParens = this.openParenStack.peek();
        MutableBoolean processingFunctionInvocation = this.functionStack.peek();
        MutableInteger pos = new MutableInteger();
        MutableBoolean lhs = new MutableBoolean(true);
        String previousToken = "";
        int calls = 0;
        while (pos.value() < this.tokens.size()) {
            int posIn = pos.value();
            String token = this.tokens.get(pos.value());
            this.grammerCheck(token, lhs, lookingForBinaryOperator, lookingForArgumentSeparator, previousToken, pos, or);
            int posOut = pos.value();
            ++calls;
            if (posIn != posOut) continue;
            or.setErrorMessage("Aborting loop stuck at pos = " + posIn);
            return or;
        }
        if (openParens.value() != 0) {
            or.setErrorMessage("Mismatched parens");
        }
        if (!lookingForBinaryOperator.value()) {
            or.setErrorMessage("Illegal final token in equation");
        }
        return or;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void grammerCheck(String token, MutableBoolean lhs, MutableBoolean lookingForBinaryOperator, MutableBoolean lookingForArgumentSeparator, String previousToken, MutableInteger pos, OperationResult or) {
        or.clear();
        MutableBoolean processingFunctionInvocation = this.functionStack.peek();
        MutableInteger openParens = this.openParenStack.peek();
        if (token.startsWith(ARRAY)) {
            if (lookingForBinaryOperator.value()) {
                or.setErrorMessage("[1] Looking for operator found " + token + " in pos " + pos.value());
                return;
            }
            if (lookingForArgumentSeparator.value()) {
                or.setErrorMessage("[2] Looking for argument separator found " + token + " in pos " + pos.value());
                return;
            }
            previousToken = token;
            pos.add(1);
            lookingForBinaryOperator.setValue(true);
            return;
        }
        if (token.startsWith(LOOKUP)) {
            if (lookingForBinaryOperator.value()) {
                or.setErrorMessage("[3] Looking for operator found " + token + " in pos " + pos.value());
                return;
            }
            if (lookingForArgumentSeparator.value()) {
                or.setErrorMessage("[4] Looking for argument separator found " + token + " in pos " + pos.value());
                return;
            }
            pos.add(1);
            lookingForBinaryOperator.setValue(true);
            return;
        }
        if (token.startsWith(FUNCTION)) {
            if (lookingForBinaryOperator.value()) {
                or.setErrorMessage("[5] Looking for operator found " + token + " in pos " + pos.value());
                return;
            }
            if (lookingForArgumentSeparator.value()) {
                or.setErrorMessage("[6] Looking for argument separator found " + token + " in pos " + pos.value());
                return;
            }
            this.consumeFunction(lookingForBinaryOperator, lookingForArgumentSeparator, previousToken, pos, or);
            if (!or.isOk()) {
                return;
            }
            pos.add(1);
            lookingForBinaryOperator.setValue(true);
            return;
        }
        if (token.startsWith(SCALAR)) {
            if (lookingForBinaryOperator.value()) {
                or.setErrorMessage("[7] Looking for operator found " + token + " in pos " + pos.value());
                return;
            }
            if (lookingForArgumentSeparator.value()) {
                or.setErrorMessage("[8] Looking for argument separator found " + token + " in pos " + pos.value());
                return;
            }
            previousToken = token;
            pos.add(1);
            lookingForBinaryOperator.setValue(true);
            return;
        }
        if (token.equals(LEFT_PAREN)) {
            if (lookingForBinaryOperator.value()) {
                or.setErrorMessage("[9] Looking for operator found " + token + " in pos " + pos.value());
                return;
            }
            if (lookingForArgumentSeparator.value()) {
                or.setErrorMessage("[10] Looking for argument separator found " + token + " in pos " + pos.value());
                return;
            }
            openParens.add(1);
            if (this.debugPrint) {
                System.out.println("GC: LP " + openParens.value());
            }
            pos.add(1);
            return;
        }
        if (token.equals(RIGHT_PAREN)) {
            if (lookingForBinaryOperator.value() && openParens.value() <= 0) {
                or.setErrorMessage("[11] Looking for operator found " + token + " in pos " + pos.value());
                return;
            }
            if (lookingForArgumentSeparator.value()) {
                or.setErrorMessage("[12] Looking for argument separator found " + token + " in pos " + pos.value());
                return;
            }
            openParens.add(-1);
            if (this.debugPrint) {
                System.out.println("GC: RP " + openParens.value());
            }
            pos.add(1);
            return;
        }
        if (token.equals(COMMA)) {
            if (!lookingForBinaryOperator.value() || processingFunctionInvocation.value()) return;
            or.setErrorMessage("[13] Looking for operator found " + token + " in pos " + pos.value());
            return;
        }
        if (Parser.isOperator(token)) {
            if (!lookingForBinaryOperator.value()) {
                if (Parser.isBinaryOperator(token)) {
                    or.setErrorMessage("[14] not expecting binary operator but found " + token + " in pos " + pos.value());
                    return;
                }
                if (!Parser.isUnaryOperator(token)) return;
                previousToken = token;
                pos.add(1);
                lookingForBinaryOperator.setValue(false);
                return;
            }
            previousToken = token;
            pos.add(1);
            lookingForBinaryOperator.setValue(false);
            return;
        }
        if (Parser.isNumber(token)) {
            if (lookingForBinaryOperator.value()) {
                or.setErrorMessage("[15] Looking for operator found " + token + " in pos " + pos.value());
                return;
            }
            if (lookingForArgumentSeparator.value()) {
                or.setErrorMessage("[16] Looking for argument separator found " + token + " in pos " + pos.value());
                return;
            }
            previousToken = token;
            pos.add(1);
            lookingForBinaryOperator.setValue(true);
            return;
        }
        if (Parser.isQuotedString(token)) {
            previousToken = token;
            pos.add(1);
            lookingForBinaryOperator.setValue(true);
            return;
        } else if (Parser.isLocalVariable(token)) {
            previousToken = token;
            pos.add(1);
            lookingForBinaryOperator.setValue(true);
            return;
        } else {
            or.setErrorMessage("Unknown token type " + token);
        }
    }

    private void consumeFunction(MutableBoolean lookingForBinaryOperator, MutableBoolean lookingForArgumentSeparator, String previousToken, MutableInteger pos, OperationResult or) {
        or.clear();
        this.functionStack.push(new MutableBoolean(true));
        this.openParenStack.push(new MutableInteger(0));
        MutableInteger openParens = this.openParenStack.peek();
        MutableBoolean processingFunctionInvocation = this.functionStack.peek();
        MutableBoolean lhs = new MutableBoolean(false);
        boolean done = false;
        pos.add(1);
        String token = this.tokens.get(pos.value());
        if (!token.equals(LEFT_PAREN)) {
            or.setErrorMessage("[17] expecting open paren for function found " + token + " in pos " + pos.value());
            return;
        }
        openParens.add(1);
        if (this.debugPrint) {
            System.out.println("CF: LP " + openParens.value());
        }
        pos.add(1);
        while (!done && pos.value() < this.tokens.size()) {
            token = this.tokens.get(pos.value());
            if (token.equals(RIGHT_PAREN)) {
                if (!lookingForBinaryOperator.value()) {
                    or.setErrorMessage("[19] Found ) while expecting a variable/function call");
                    return;
                }
                openParens.add(-1);
                if (this.debugPrint) {
                    System.out.println("CF: RP " + openParens.value());
                }
                if (openParens.value() == 0) {
                    done = true;
                    processingFunctionInvocation.setValue(false);
                    if (this.debugPrint) {
                        System.out.println("CF: pop stacks");
                    }
                    this.openParenStack.pop();
                    this.functionStack.pop();
                    return;
                }
                pos.add(1);
                continue;
            }
            this.grammerCheck(token, lhs, lookingForBinaryOperator, lookingForArgumentSeparator, previousToken, pos, or);
            if (!or.isOk()) {
                return;
            }
            if (pos.value() >= this.tokens.size() && openParens.value() > 0) {
                or.setErrorMessage("[18] Cannot locate end of function invocation. # open = " + openParens.value());
                return;
            }
            if (pos.value() >= this.tokens.size()) {
                return;
            }
            if (!this.tokens.get(pos.value()).equals(COMMA)) continue;
            pos.add(1);
            lookingForArgumentSeparator.setValue(false);
            lookingForBinaryOperator.setValue(false);
        }
        System.out.println("EOT, OpenParens = " + openParens.value());
        or.setErrorMessage("[20] reached end of tokens without complete statment?");
    }

    /*
     * Unable to fully structure code
     */
    private OperationResult checkLookupDefinitionGrammar() {
        block17: {
            or = new OperationResult();
            pos = new MutableInteger();
            pattern = new String[]{"(", "#", ",", "#", ")"};
            token = this.tokens.get(pos.value());
            if (!Parser.isWord(token) && !ArrayReference.isArrayReference(token)) {
                or.setErrorMessage("Invalid Lookup Name \"" + token + "\" in position " + pos.value());
                return or;
            }
            pos.add(1);
            token = this.tokens.get(pos.value());
            if (!this.tokens.get(pos.value()).equals("(")) {
                or.setErrorMessage("Missing opening (");
                return or;
            }
            pos.add(1);
            token = this.tokens.get(pos.value());
            if (!token.equals("[")) break block17;
            pos.add(1);
            if (!this.patternMatch(pattern, this.tokens, pos, or)) {
                return or;
            }
            token = this.tokens.get(pos.value());
            if (!token.equals("-")) {
                or.setErrorMessage("Invalid range separator(1) \"" + token + "\" in position " + pos.value());
                return or;
            }
            pos.add(1);
            if (!this.patternMatch(pattern, this.tokens, pos, or)) {
                return or;
            }
            token = this.tokens.get(pos.value());
            if (!token.equals("]")) {
                or.setErrorMessage("Invalid range terminator  \"" + token + "\" in position " + pos.value());
                return or;
            }
            pos.add(1);
            token = this.tokens.get(pos.value());
            if (!token.equals(",")) {
                or.setErrorMessage("Invalid range separator(2) \"" + token + "\" in position " + pos.value());
                return or;
            }
            pos.add(1);
            ** GOTO lbl76
        }
        if (token.equals("(")) ** GOTO lbl76
        numDataPoints = 0;
        while (pos.value() < this.tokens.size()) {
            if (pos.value() % 2 == 0) {
                if (!Parser.isNumber(this.tokens.get(pos.value()))) {
                    or.setErrorMessage("Invalid numeric value " + this.tokens.get(pos.value()));
                    System.out.println("Invalid numeric value " + this.tokens.get(pos.value()));
                    return or;
                }
                ++numDataPoints;
            } else if (!this.tokens.get(pos.value()).equals(",") && !this.tokens.get(pos.value()).equals(")")) {
                or.setErrorMessage("Invalid list separator " + this.tokens.get(pos.value()));
                System.out.println("Invalid numeric value " + this.tokens.get(pos.value()));
                return or;
            }
            tok = this.tokens.get(pos.value());
            pos.add(1);
            if (!tok.equals("(")) continue;
            if (numDataPoints == 0 || numDataPoints % 2 != 0) {
                or.setErrorMessage("incorrect number of data points provided in lookup table definition " + numDataPoints);
                System.out.println("incorrect number of data points provided in lookup table definition " + numDataPoints);
            }
            return or;
        }
        return or;
lbl-1000:
        // 1 sources

        {
            if (!this.patternMatch(pattern, this.tokens, pos, or)) {
                return or;
            }
            token = this.tokens.get(pos.value());
            if (pos.value() != this.tokens.size() - 1 && !token.equals(",")) {
                or.setErrorMessage("Invalid range separator(3) \"" + token + "\" in position " + pos.value());
                return or;
            }
            if (pos.value() == this.tokens.size() - 1) continue;
            pos.add(1);
lbl76:
            // 4 sources

            ** while (pos.value() < this.tokens.size() - pattern.length)
        }
lbl77:
        // 1 sources

        token = this.tokens.get(pos.value());
        if (!token.equals(")")) {
            or.setErrorMessage("Missing closing paren \"" + token + "\" in position " + pos.value());
            return or;
        }
        return or;
    }

    private boolean patternMatch(String[] pattern, List<String> tokens, MutableInteger pos, OperationResult or) {
        int i = 0;
        while (i < pattern.length) {
            if (pattern[i].equals("#")) {
                if (!Parser.isNumber(tokens.get(pos.value()))) {
                    or.setErrorMessage("Invalid numeric value " + tokens.get(pos.value()));
                    return false;
                }
            } else if (!pattern[i].equals(tokens.get(pos.value()))) {
                or.setErrorMessage("Invalid token " + tokens.get(pos.value()) + " expecting " + pattern[i]);
                return false;
            }
            pos.add(1);
            ++i;
        }
        return true;
    }

    private OperationResult checkSubscriptDefinitionGrammar() {
        OperationResult or = new OperationResult();
        String token = this.tokens.get(0);
        if (!Parser.isWord(token)) {
            or.setErrorMessage("Invalid LHS " + token);
        }
        if (!(token = this.tokens.get(1)).equals(":")) {
            or.setErrorMessage("Invalid operator " + token);
            return or;
        }
        int pos = 2;
        while (pos < this.tokens.size()) {
            token = this.tokens.get(pos);
            if (pos % 2 == 1) {
                if (!token.equals(COMMA)) {
                    or.setErrorMessage("Invalid separator " + token);
                    return or;
                }
            } else if (!Parser.isWord(token)) {
                or.setErrorMessage("Invalid subscript value " + token);
                return or;
            }
            ++pos;
        }
        return or;
    }

    private String determineEquationType(OperationResult or) {
        String type = "UNKNOWN";
        or.clear();
        boolean initialization = true;
        if (this.tokens.get(0).startsWith(ARRAY) && this.tokens.get(1).equals("=")) {
            int i = 2;
            while (i < this.tokens.size()) {
                if (i % 2 == 0) {
                    if (!Parser.isNumber(this.tokens.get(i))) {
                        initialization = false;
                        break;
                    }
                } else {
                    if (this.tokens.get(i).equals(COMMA) || this.tokens.get(i).equals(SEMICOLON)) break;
                    initialization = false;
                    break;
                }
                ++i;
            }
            if (initialization) {
                return ARRAY_INITIALIZATION;
            }
        }
        for (String token : this.tokens) {
            if (token.equals(":")) {
                return SUBSCRIPT_DEFINITION;
            }
            if (token.equals("=")) {
                return ASSIGNMENT;
            }
            if (!token.equals(LEFT_PAREN)) continue;
            return LOOKUP_DEFINITION;
        }
        or.setErrorMessage("Cannot determine equation type for grammar check");
        return type;
    }
}

