/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import repast.simphony.systemdynamics.support.MutableBoolean;
import repast.simphony.systemdynamics.support.MutableInteger;
import repast.simphony.systemdynamics.translator.Equation;
import repast.simphony.systemdynamics.translator.FunctionDescription;
import repast.simphony.systemdynamics.translator.OperationResult;

public class FunctionManager {
    private Map<String, FunctionDescription> allFunctions = new HashMap<String, FunctionDescription>();
    private String functionFile;

    public void load(String file) {
        try {
            System.out.println("OPENING " + file);
            System.out.println("LOCATION: " + new File(file).getAbsolutePath());
            this.load(new FileInputStream(file));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public OperationResult validateFunctionReference(Map<String, Equation> equations, Equation equation, MutableInteger pos, MutableBoolean lhs) {
        OperationResult or = new OperationResult();
        List<String> tokens = equation.getTokens();
        String token = tokens.get(pos.value());
        FunctionDescription fd = this.getDescription(token);
        if (fd != null) {
            return or;
        }
        or.setErrorMessage("Function not registered " + token);
        return or;
    }

    public void load(InputStream in) {
        BufferedReader fileReader = null;
        fileReader = new BufferedReader(new InputStreamReader(in));
        try {
            String aLine = fileReader.readLine();
            aLine = fileReader.readLine();
            while (aLine != null) {
                FunctionDescription fd = new FunctionDescription(aLine);
                this.allFunctions.put(fd.getExternalName().toUpperCase(), fd);
                this.allFunctions.put(this.clean(fd.getExternalName().toUpperCase()), fd);
                this.allFunctions.put(fd.getInternalName().toUpperCase(), fd);
                aLine = fileReader.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isFunction(String function) {
        return this.allFunctions.containsKey(function.replace("sdFunctions.", "").toUpperCase());
    }

    public FunctionDescription getDescription(String function) {
        if (this.allFunctions.get(function.replace("sdFunctions.", "").toUpperCase()) == null) {
            this.printFunctions();
            return null;
        }
        return this.allFunctions.get(function.replace("sdFunctions.", "").toUpperCase());
    }

    private void printFunctions() {
        ArrayList<String> funcs = new ArrayList<String>();
        for (String key : this.allFunctions.keySet()) {
            funcs.add(key);
        }
        Collections.sort(funcs);
        for (String func : funcs) {
            System.out.println("Function: " + func);
        }
    }

    public boolean canCheckUnitsConsistency(String eqn) {
        boolean canCheck = true;
        for (String functionName : this.allFunctions.keySet()) {
            FunctionDescription fd = this.allFunctions.get(functionName);
            if ((!fd.getReturnUnits().equals("NA") || !eqn.contains(functionName)) && (!functionName.equalsIgnoreCase("LOOKUP") || !eqn.contains(functionName))) continue;
            return false;
        }
        return canCheck;
    }

    private String clean(String s) {
        return s.replace(" ", "").replace(":", "_").replace("\t", "").replace("&", "_").replace("-", "_").replace("\"", "").replace("(", "_").replace(")", "_").replace("'", "");
    }
}

