/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import repast.simphony.systemdynamics.support.MutableInteger;
import repast.simphony.systemdynamics.translator.Equation;
import repast.simphony.systemdynamics.translator.InformationManagers;
import repast.simphony.systemdynamics.translator.Parser;
import repast.simphony.systemdynamics.translator.SystemDynamicsObjectManager;

public class EquationProcessor {
    public static HashSet<String> rhsvariables = new HashSet();
    public static HashSet<String> functions = new HashSet();
    public static HashSet<String> lookups = new HashSet();
    public static HashSet<String> subscripts = new HashSet();
    public static Map<String, List<String>> subscriptValues = new HashMap<String, List<String>>();
    private SystemDynamicsObjectManager sdObjectManager;
    private List<String> duplicateLHS = new ArrayList<String>();
    boolean processingMacroCode = false;

    public EquationProcessor() {
    }

    public EquationProcessor(boolean processingMacroCode) {
        this.processingMacroCode = processingMacroCode;
    }

    public void checkUsage(Map<String, Equation> equations) {
        for (Equation eqn : equations.values()) {
            eqn.checkUsage(equations);
        }
    }

    public Map<String, Equation> getFatalErrors(Map<String, Equation> equations) {
        HashMap<String, Equation> fatalErrors = new HashMap<String, Equation>();
        for (String lhs : equations.keySet()) {
            Equation eqn = equations.get(lhs);
            if (!eqn.isFatal()) continue;
            fatalErrors.put(lhs, eqn);
        }
        return fatalErrors;
    }

    public Map<String, Equation> getSyntaxErrors(Map<String, Equation> equations) {
        HashMap<String, Equation> syntaxErrors = new HashMap<String, Equation>();
        for (String lhs : equations.keySet()) {
            Equation eqn = equations.get(lhs);
            if (eqn.isSyntacticallyCorrect()) continue;
            syntaxErrors.put(lhs, eqn);
        }
        return syntaxErrors;
    }

    public Map<String, Equation> getUsageErrors(Map<String, Equation> equations) {
        HashMap<String, Equation> usageErrors = new HashMap<String, Equation>();
        for (String lhs : equations.keySet()) {
            Equation eqn = equations.get(lhs);
            if (eqn.isUsageCorrect()) continue;
            usageErrors.put(lhs, eqn);
        }
        return usageErrors;
    }

    public HashMap<String, Equation> processRawEquations(SystemDynamicsObjectManager sdObjectManager, List<String> rawEquations) {
        HashMap<String, Equation> equations = new HashMap<String, Equation>();
        this.sdObjectManager = sdObjectManager;
        if (InformationManagers.getInstance().getSystemModel() == null) {
            System.out.println("System Model is null - processRawEquations needs system model");
        }
        if (!this.processingMacroCode) {
            Equation timeEquation = new Equation("Time=0.0~" + InformationManagers.getInstance().getSystemModel().getUnits() + "~This is autogenerated");
            timeEquation.setAutoGenerated(true);
            equations.put(timeEquation.getLhs(), timeEquation);
            Equation naEquation = new Equation("NAREPLACEMENT = 0.0000001~any~This is autogenerated");
            naEquation.setAutoGenerated(true);
            equations.put(naEquation.getLhs(), naEquation);
        }
        return this.processRawEquations(equations, sdObjectManager, rawEquations);
    }

    /*
     * Unable to fully structure code
     */
    public HashMap<String, Equation> processRawEquations(HashMap<String, Equation> equations, SystemDynamicsObjectManager sdObjectManager, List<String> rawEquations) {
        linePtr = new MutableInteger(0);
        block0: while (true) {
            varPkgLine = 0;
            initialLineTerminator = "";
            insertedEqual = "";
            aLine = rawEquations.get(linePtr.valueAndInc());
            while (aLine.length() == 0) {
                if (linePtr.value() >= rawEquations.size() && this.processingMacroCode) {
                    this.markGenerated(equations);
                    return equations;
                }
                aLine = rawEquations.get(linePtr.valueAndInc());
            }
            if (aLine.contains("TABBED")) {
                aLine = String.valueOf(aLine.split("=", 2)[0]) + "=";
                anotherLine = rawEquations.get(linePtr.valueAndInc()).trim();
                while (!anotherLine.endsWith(")")) {
                    values = anotherLine.split("\t");
                    vPtr = 0;
                    var16_21 = values;
                    var15_19 = values.length;
                    var14_18 = 0;
                    while (var14_18 < var15_19) {
                        value = var16_21[var14_18];
                        if (vPtr++ > 0) {
                            aLine = String.valueOf(aLine) + ",";
                        }
                        aLine = String.valueOf(aLine) + value;
                        ++var14_18;
                    }
                    aLine = String.valueOf(aLine) + ";";
                    anotherLine = rawEquations.get(linePtr.valueAndInc()).trim();
                }
            } else if (aLine.endsWith("\\")) {
                concat = aLine.replace("\\", "");
                while (aLine.endsWith("\\")) {
                    aLine = rawEquations.get(linePtr.valueAndInc());
                    concat = String.valueOf(concat) + aLine.replace("\\", "");
                }
                aLine = concat;
            }
            isAssignment = false;
            isLookup = false;
            isVdmLookup = false;
            isSubscriptDefinition = false;
            unsure = true;
            isMulti = false;
            isMacroDefinition = false;
            if (aLine.contains("=")) {
                isAssignment = true;
                unsure = false;
                initialLineTerminator = aLine.substring(aLine.length() - 1, aLine.length());
            } else if (aLine.contains(":MACRO:")) {
                unsure = false;
                isMacroDefinition = true;
                initialLineTerminator = aLine.substring(aLine.length() - 1, aLine.length());
            } else if (Parser.containsNonquotedColon(aLine) || aLine.contains("<->")) {
                isSubscriptDefinition = true;
                unsure = false;
                initialLineTerminator = ":";
                initialLineTerminator = aLine.substring(aLine.length() - 1, aLine.length());
            } else if (aLine.endsWith("(")) {
                isLookup = true;
                unsure = false;
                initialLineTerminator = "(";
            } else if (aLine.endsWith("~~|")) {
                isVdmLookup = true;
                isMulti = true;
                unsure = false;
                initialLineTerminator = "~~|";
                lhs = aLine.replace("~~|", "").trim();
                aLine = String.valueOf(lhs) + " = VDMLOOKUP(\"" + lhs + "\")" + initialLineTerminator;
            } else {
                unsure = true;
            }
            ++varPkgLine;
            if (aLine.contains("---///")) {
                this.markGenerated(equations);
                return equations;
            }
            if (isMacroDefinition) {
                this.processMacro(aLine, rawEquations, linePtr);
                continue;
            }
            vensimEquation = new String(aLine).replace("\\", "");
            additionalLineCount = 0;
            while (true) {
                insertedEqual = "";
                aLine = rawEquations.get(linePtr.valueAndInc());
                if (aLine.endsWith("\\")) {
                    concat = aLine.replace("\\", "");
                    while (aLine.endsWith("\\")) {
                        aLine = rawEquations.get(linePtr.valueAndInc());
                        concat = String.valueOf(concat) + aLine.replace("\\", "");
                    }
                    aLine = concat;
                }
                ++additionalLineCount;
                ++varPkgLine;
                if (aLine == null) {
                    System.err.println("Unexpected EOF!!!");
                }
                if (aLine.contains("---///")) {
                    System.err.println("Found graphics marker in wrong place!");
                }
                if (aLine.endsWith("|") && !aLine.endsWith("~~|")) break;
                if (aLine.endsWith("~~|")) {
                    isMulti = true;
                }
                if (isMulti) {
                    if (isVdmLookup) {
                        lhs = aLine.replace("~~|", "").trim();
                        aLine = String.valueOf(lhs) + " = VDMLOOKUP(\"" + lhs + "\")" + initialLineTerminator;
                    }
                } else if (unsure) {
                    if (aLine.startsWith("~")) {
                        isVdmLookup = true;
                        unsure = false;
                        vensimEquation = String.valueOf(vensimEquation) + " = VDMLOOKUP(\"" + vensimEquation + "\")";
                    } else {
                        isAssignment = true;
                        unsure = false;
                        insertedEqual = " = ";
                    }
                }
                vensimEquation = String.valueOf(vensimEquation) + insertedEqual + aLine.replace("\\", "");
            }
            if (vensimEquation.startsWith("***")) continue;
            eqnToProcess = new ArrayList<E>();
            eqnToProcess = this.splitMultipleEquations(vensimEquation);
            var20_26 = eqnToProcess.iterator();
            while (true) {
                if (var20_26.hasNext()) ** break;
                continue block0;
                aVensimEquation = (String)var20_26.next();
                if (aVensimEquation.contains("WITH LOOKUP")) {
                    this.processWithLookup(aVensimEquation, equations);
                    continue;
                }
                equation = new Equation(aVensimEquation);
                if (!equation.isSyntacticallyCorrect()) {
                    if (!this.isDuplicate(equation.getLhs(), equations)) {
                        equations.put(equation.getLhs(), equation);
                        continue;
                    }
                    System.out.println("Not saved due to duplicate (1) " + equation.getLhs());
                    continue;
                }
                if (equation.getLhs() == null) {
                    System.out.println("Equation with no LHS: " + aVensimEquation);
                    if (this.isDuplicate(equation.getLhs(), equations)) continue;
                    equations.put(equation.getLhs(), equation);
                    continue;
                }
                if (!this.isDuplicate(equation.getLhs(), equations)) {
                    equations.put(equation.getLhs(), equation);
                    screenName = SystemDynamicsObjectManager.getScreenName(equation.getLhs());
                    if (!equation.isAssignment() && !equation.isDefinesLookup() && !equation.isDefinesSubscript()) continue;
                    sdObjectManager.addEquation(screenName, equation);
                    continue;
                }
                System.out.println("Not saved due to duplicate (2) " + equation.getLhs());
            }
            break;
        }
    }

    private void printVariableTypes(HashMap<String, Equation> equations) {
        System.out.println("###printVariableTypes###");
        for (String key : equations.keySet()) {
            if (equations.get(key).isDefinesSubscript()) continue;
            System.out.println(equations.get(key).getVensimEquationOnly());
            System.out.println(equations.get(key).getVariableType());
        }
    }

    private void markGenerated(HashMap<String, Equation> equations) {
        String[] stringArray = new String[]{"InitialTime", "FinalTime", "TimeStep", "Savper", "INITIAL_TIME", "FINAL_TIME", "TIME_STEP", "SAVPER", "INITIAL TIME", "FINAL TIME", "TIME STEP", "SAVEPER"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String lhs = stringArray[n2];
            if (equations.containsKey(lhs)) {
                equations.get(lhs).setAutoGenerated(true);
            }
            ++n2;
        }
    }

    private boolean isDuplicate(String lhs, Map<String, Equation> equations) {
        if (equations.containsKey(lhs)) {
            this.duplicateLHS.add(lhs);
            System.out.println("Duplicate LHS found: " + lhs + " " + equations.get(lhs).getVensimEquationOnly());
            return true;
        }
        return false;
    }

    private List<String> splitMultipleEquations(String vensimEquation) {
        ArrayList<String> eqn = new ArrayList<String>();
        if (vensimEquation.contains("~~|")) {
            String[] parts = vensimEquation.split("~\t", 2);
            String[] commands = parts[0].split("~~\\|");
            String units = "\t~\t" + parts[1];
            String[] stringArray = commands;
            int n = commands.length;
            int n2 = 0;
            while (n2 < n) {
                String cmd = stringArray[n2];
                eqn.add(String.valueOf(cmd) + units);
                ++n2;
            }
            return eqn;
        }
        eqn.add(vensimEquation);
        return eqn;
    }

    private void processMacro(String eqn, List<String> rawEquations, MutableInteger linePtr) {
        if (!InformationManagers.getInstance().getMacroManager().readMacroAndProcess(eqn, rawEquations, linePtr)) {
            System.out.println("Bad Macro");
        }
    }

    private void processWithLookup(String eqn, HashMap<String, Equation> equations) {
        String[] parts = eqn.split("=", 2);
        boolean withQuotes = false;
        if (parts[0].contains("\"")) {
            withQuotes = true;
        }
        String l = "";
        String lhsArrayReference = "";
        if (parts[0].contains("[")) {
            String[] withAR = parts[0].split("\\[");
            parts[0] = withAR[0];
            lhsArrayReference = "[" + withAR[1];
        }
        l = parts[0].replaceAll("\"", "");
        String newl = String.valueOf(l) + "_lookup";
        if (withQuotes) {
            newl = "\"" + newl + "\"";
        }
        StringBuffer rhsBuf = new StringBuffer();
        parts[1] = this.alterArrayReferenceCommas(parts[1]);
        String[] rhs = parts[1].split(",", 2);
        String newr = rhs[1].trim();
        newr = newr.substring(0, newr.length());
        Equation equation = new Equation(String.valueOf(newl) + newr);
        if (equation.getLhs() == null) {
            System.out.println("Equation with no LHS: " + newl + newr);
        } else {
            String screenName = SystemDynamicsObjectManager.getScreenName(equation.getLhs());
            this.sdObjectManager.addEquation(screenName, equation);
            equations.put(equation.getLhs(), equation);
        }
        String newEqn = String.valueOf(parts[0]) + lhsArrayReference + "=" + newl + rhs[0].replaceAll("WITH LOOKUP", "").replaceAll("###", ",") + ")";
        String[] extra = rhs[1].split("~");
        String comment = "";
        String units = "";
        if (extra.length > 1) {
            units = extra[1];
        }
        if (extra.length > 2) {
            comment = extra[2];
        }
        if ((equation = new Equation(String.valueOf(newEqn) + "~" + units + "~" + comment)).getLhs() == null) {
            System.out.println("Equation with no LHS: " + newEqn);
        } else if (!this.isDuplicate(equation.getLhs(), equations)) {
            equations.put(equation.getLhs(), equation);
            System.out.println("WithLookup: " + equation.getVensimEquationOnly());
            String screenName = SystemDynamicsObjectManager.getScreenName(equation.getLhs());
            this.sdObjectManager.addEquation(screenName, equation);
        }
    }

    private String alterArrayReferenceCommas(String rhs) {
        StringBuffer sb = new StringBuffer();
        boolean inArrayReference = false;
        boolean doneChecking = false;
        MutableInteger position = new MutableInteger(0);
        while (Parser.inRange(rhs, position)) {
            if (Parser.characterAt(rhs, position).equals("[") && !doneChecking) {
                inArrayReference = true;
                sb.append(Parser.characterAt(rhs, position));
            } else if (Parser.characterAt(rhs, position).equals("]") && !doneChecking) {
                inArrayReference = false;
                sb.append(Parser.characterAt(rhs, position));
            } else if (Parser.characterAt(rhs, position).equals(",") && !doneChecking) {
                if (inArrayReference) {
                    inArrayReference = false;
                    sb.append("###");
                } else {
                    sb.append(",");
                    doneChecking = true;
                }
            } else {
                sb.append(Parser.characterAt(rhs, position));
            }
            position.add(1);
        }
        return sb.toString();
    }

    public List<String> getDuplicateLHS() {
        return this.duplicateLHS;
    }
}

