/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import repast.simphony.systemdynamics.translator.Arrow;
import repast.simphony.systemdynamics.translator.Equation;
import repast.simphony.systemdynamics.translator.SystemDynamicsObject;
import repast.simphony.systemdynamics.translator.SystemDynamicsObjectManager;

public class EquationGraphicValidation {
    private SystemDynamicsObjectManager systemDynamicsObjectManager;
    private SystemDynamicsObject systemDynamicsObjectLHS;
    private Map<String, Equation> equations;
    private List<String> addedScreenNames;
    private List<Arrow> addedArrows;

    public EquationGraphicValidation(SystemDynamicsObjectManager systemDynamicsObjectManager, SystemDynamicsObject systemDynamicsObject, Map<String, Equation> equations) {
        this.systemDynamicsObjectManager = systemDynamicsObjectManager;
        this.systemDynamicsObjectLHS = systemDynamicsObject;
        this.equations = equations;
        this.addedScreenNames = new ArrayList<String>();
        this.addedArrows = new ArrayList<Arrow>();
    }

    public String getScreenName() {
        return this.systemDynamicsObjectLHS.getScreenName();
    }

    public void validate() {
        List<Arrow> incomingArrows = this.systemDynamicsObjectLHS.getIncomingArrows();
        List<Equation> eqns = this.systemDynamicsObjectLHS.getEquations();
        for (Equation eqn : eqns) {
            if (!eqn.isAssignment() || eqn.isGetExternalData()) continue;
            HashSet<String> rhsVars = eqn.getRHSVariables();
            for (String rhsVar : rhsVars) {
                Arrow flow;
                String rhsVarScreenName = SystemDynamicsObjectManager.getScreenName(rhsVar);
                if (Arrow.listContainsArrowWithOtherEnd(incomingArrows, rhsVarScreenName) || (flow = Arrow.getArrowWithOtherEnd(this.systemDynamicsObjectLHS.getOutgoingArrows(), rhsVarScreenName)) != null && flow.isFlow()) continue;
                Arrow arrow = new Arrow(rhsVarScreenName, "IN", "INFLUENCE");
                this.addedArrows.add(arrow);
                this.addedScreenNames.add(rhsVarScreenName);
            }
        }
    }

    public boolean isValid() {
        return this.addedArrows.size() == 0;
    }

    public void apply() {
        for (String addedScreenName : this.addedScreenNames) {
            this.systemDynamicsObjectManager.addSystemDynamicsObject(addedScreenName);
            List<Equation> eqns = this.systemDynamicsObjectManager.findEquationsWithScreenName(addedScreenName, this.equations);
            SystemDynamicsObject systemDynamicsObjectRHS = this.systemDynamicsObjectManager.getObjectWithName(addedScreenName);
            for (Equation eqn : eqns) {
                this.systemDynamicsObjectManager.addEquation(systemDynamicsObjectRHS.getScreenName(), eqn);
            }
        }
        for (Arrow arrow : this.addedArrows) {
            this.systemDynamicsObjectManager.addIncomingArrow(this.systemDynamicsObjectLHS.getScreenName(), arrow);
            this.systemDynamicsObjectManager.addOutgoingArrow(arrow.getOtherEnd(), new Arrow(this.systemDynamicsObjectLHS.getScreenName(), "OUT", "INFLUENCE"));
        }
    }

    public List<String> getAddedScreenNames() {
        return this.addedScreenNames;
    }

    public List<Arrow> getAddedArrows() {
        return this.addedArrows;
    }
}

