/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import repast.simphony.systemdynamics.support.ArrayReference;
import repast.simphony.systemdynamics.translator.CodeGenerator;
import repast.simphony.systemdynamics.translator.Equation;
import repast.simphony.systemdynamics.translator.InformationManagers;
import repast.simphony.systemdynamics.translator.Node;
import repast.simphony.systemdynamics.translator.Translator;

public class EquationArrayReferenceStructure {
    private Equation equation;
    private ArrayReference lhsArrayReference;
    private List<ArrayReference> rhsArrayReferences;
    private List<String> rangeSubscriptNames;
    private Set<String> localIndexArrays = new HashSet<String>();
    private boolean arrayInitialization = false;
    private int numberArrayInitializers = 0;
    private boolean hasLHSarrayReference = false;
    private boolean hasRHSarrayReference = false;
    private boolean hasRHSrangeArrayReference = false;
    private boolean hasRHSmappedArrayReference = false;
    private boolean requiresOuterIndexArray = false;
    private boolean requiresRangeIndexArray = false;
    private boolean requiresMappedIndexArray = false;
    private List<String> arraysRequiringOuterIndexArray = new ArrayList<String>();
    private List<String> arraysRequiringRangeIndexArray = new ArrayList<String>();
    private List<String> arraysRequiringMappedIndexArray = new ArrayList<String>();
    private Map<String, String> mappedSubscriptIndexMap = new HashMap<String, String>();
    private Map<String, Integer> rangeIndexMap = new HashMap<String, Integer>();
    Map<String, List<String>> uniqueBySubscript = new HashMap<String, List<String>>();
    Map<String, List<String>> uniqueRangeBySubscript = new HashMap<String, List<String>>();

    public EquationArrayReferenceStructure(Equation equation) {
        this.equation = equation;
        this.rhsArrayReferences = new ArrayList<ArrayReference>();
        this.analyze();
    }

    public List<String> getOuterArraySubscriptDimensionPacked() {
        ArrayList<String> al = new ArrayList<String>();
        int dim = 0;
        for (String outerSubscript : this.lhsArrayReference.getSubscripts()) {
            al.add(this.pack(this.lhsArrayReference.getArrayName(), outerSubscript, dim));
            ++dim;
        }
        for (String outerSubscript : this.lhsArrayReference.getSubscripts()) {
            for (ArrayReference ar : this.rhsArrayReferences) {
                List<String> subscripts = ar.getSubscripts();
                if (!subscripts.contains(outerSubscript)) continue;
                dim = subscripts.indexOf(outerSubscript);
                String packed = this.pack(ar.getArrayName(), outerSubscript, dim);
                if (al.contains(packed)) continue;
                al.add(packed);
            }
        }
        return al;
    }

    public List<String> getMappedArraySubscriptDimensionPacked() {
        ArrayList<String> al = new ArrayList<String>();
        if (!this.hasRHSmappedSubscripts()) {
            return al;
        }
        List<String> lhsSubscripts = this.lhsArrayReference.getSubscripts();
        for (ArrayReference ar : this.rhsArrayReferences) {
            for (String rhsSubscript1 : ar.getSubscripts()) {
                String rhsSubscript = rhsSubscript1.replace("!", "");
                if (lhsSubscripts.contains(rhsSubscript)) continue;
                int dim = ar.getSubscripts().indexOf(rhsSubscript);
                boolean foundMap = false;
                int i = 0;
                while (i < lhsSubscripts.size()) {
                    String lhsSubr = lhsSubscripts.get(i);
                    if (InformationManagers.getInstance().getMappedSubscriptManager().isMapBetween(rhsSubscript, lhsSubr)) {
                        foundMap = true;
                        String lhsPacked = this.pack(this.lhsArrayReference.getArrayName(), lhsSubr, i);
                        String packed = this.pack(ar.getArrayName(), rhsSubscript, dim);
                        if (!al.contains(packed)) {
                            al.add(packed);
                        }
                        this.mappedSubscriptIndexMap.put(packed, lhsPacked);
                    }
                    ++i;
                }
                if (foundMap) continue;
                InformationManagers.getInstance().getArrayManager().isTerminalSubscript(ar.getArrayName(), rhsSubscript, dim);
            }
        }
        return al;
    }

    public List<String> getRangeArraySubscriptDimensionPacked() {
        ArrayList<String> al = new ArrayList<String>();
        if (!this.hasRHSrangeSubscripts()) {
            return al;
        }
        for (String rangeSubscript : this.getRHSrangeSubscripts()) {
            for (ArrayReference ar : this.rhsArrayReferences) {
                List<String> subscripts = ar.getSubscripts();
                if (!subscripts.contains(rangeSubscript)) continue;
                int dim = subscripts.indexOf(rangeSubscript);
                String packed = this.pack(ar.getArrayName(), rangeSubscript, dim);
                if (al.contains(packed)) continue;
                al.add(packed);
            }
        }
        return al;
    }

    public String getOuterLoops() {
        StringBuffer code = new StringBuffer();
        List<Object> dimensionsRequiringIndexArray = new ArrayList();
        if (this.requiresOuterIndexArray) {
            dimensionsRequiringIndexArray = this.retrieveDimensions(this.arraysRequiringOuterIndexArray);
            for (String packed : this.arraysRequiringOuterIndexArray) {
                String[] unpacked = this.unpack(packed);
                unpacked[0] = unpacked[0].replace("lookup.", "");
                if (CodeGenerator.indexDefined(packed)) continue;
                if (!Translator.target.equals("C")) {
                    code.append("int[] ");
                } else {
                    code.append("int *");
                }
                code.append("indexArray_" + CodeGenerator.getLegalName(String.valueOf(unpacked[0]) + "_" + unpacked[1] + "_" + unpacked[2]) + "_ = newIntArray(" + InformationManagers.getInstance().getArrayManager().getNumIndicies(unpacked[0], Integer.parseInt(unpacked[2]), unpacked[1]) + "," + InformationManagers.getInstance().getArrayManager().getIndicies(unpacked[0], Integer.parseInt(unpacked[2]), unpacked[1]) + ");\n");
                CodeGenerator.defineIndex(packed);
            }
        }
        if (this.requiresMappedIndexArray) {
            code.append(this.generateMappedIndexArrays());
        }
        int dim = 0;
        while (dim < this.lhsArrayReference.getSubscripts().size()) {
            String sub = this.lhsArrayReference.getSubscripts().get(dim);
            if (dimensionsRequiringIndexArray.contains(dim)) {
                code.append("/* getOuterLoops 1 */\n");
                code.append("int outer" + dim + ";\n");
                code.append("int touter" + dim + ";\n");
                code.append("for (outer" + dim + " = 0; outer" + dim + " < " + InformationManagers.getInstance().getNamedSubscriptManager().getNumIndexFor(sub) + "; outer" + dim + "++) {\n");
                code.append("touter" + dim + " = outer" + dim + ";\n");
            } else {
                String data = InformationManagers.getInstance().getArrayManager().getIndiciesSorted(this.lhsArrayReference.getArrayName(), dim, sub);
                int num = data.split(",").length;
                if (!Translator.target.equals("C")) {
                    code.append("int[] ");
                } else {
                    code.append("int* ");
                }
                code.append("outer" + dim + "_index = newIntArray(" + num + "," + data + ");\n");
                code.append("int outer" + dim + ";\n");
                code.append("int touter" + dim + ";\n");
                code.append("for (touter" + dim + " = 0; touter" + dim + " < " + InformationManagers.getInstance().getNamedSubscriptManager().getNumIndexFor(sub) + "; touter" + dim + "++) {\n");
                code.append("outer" + dim + " = outer" + dim + "_index[touter" + dim + "];\n");
            }
            ++dim;
        }
        return code.toString();
    }

    public String generateMappedIndexForRHS(String eqLHSarray, String eqLHSsubscript, int eqLHSdimension, String eqRHSarray, String eqRHSsubscript, int eqRHSdimension) {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> lhs = new ArrayList<String>();
        ArrayList<String> rhs = new ArrayList<String>();
        for (String s : InformationManagers.getInstance().getNamedSubscriptManager().getValuesFor(eqLHSsubscript)) {
            lhs.add(s);
        }
        for (String lh : lhs) {
            rhs.add(InformationManagers.getInstance().getMappedSubscriptManager().getSubscriptMapping(eqLHSsubscript, lh, eqRHSsubscript));
        }
        String index = "indexMapArray_" + CodeGenerator.getLegalName(String.valueOf(eqRHSarray) + "_" + eqRHSsubscript + "_" + eqRHSdimension) + "_[touter" + eqLHSdimension + "]";
        sb.append(index);
        return sb.toString();
    }

    public String generateMappedIndexArrays() {
        StringBuffer sb = new StringBuffer();
        for (String packed : this.arraysRequiringMappedIndexArray) {
            String[] unpacked = this.unpack(packed);
            if (CodeGenerator.indexDefined(packed)) continue;
            if (!Translator.target.equals("C")) {
                sb.append("int[] ");
            } else {
                sb.append("int *");
            }
            int num = this.getMappedIndicies(packed).split(",").length;
            sb.append("indexMapArray_" + CodeGenerator.getLegalName(String.valueOf(unpacked[0]) + "_" + unpacked[1] + "_" + unpacked[2]) + "_ = newIntArray(" + num + "," + this.getMappedIndicies(packed) + ");\n");
            CodeGenerator.defineIndex(packed);
        }
        return sb.toString();
    }

    private String getMappedIndicies(String rhsPacked) {
        StringBuffer sb = new StringBuffer();
        String lhsPacked = this.mappedSubscriptIndexMap.get(rhsPacked);
        String[] rhsUnpacked = this.unpack(rhsPacked);
        String[] lhsUnpacked = this.unpack(lhsPacked);
        List<String> orderedLHS = InformationManagers.getInstance().getArrayManager().getOrderedSubscriptNames(lhsUnpacked[0], Integer.parseInt(lhsUnpacked[2]), lhsUnpacked[1]);
        ArrayList<String> orderedRHS = new ArrayList<String>();
        for (String lhsSubr : orderedLHS) {
            orderedRHS.add(InformationManagers.getInstance().getMappedSubscriptManager().getSubscriptMapping(lhsUnpacked[1], lhsSubr, rhsUnpacked[1]));
        }
        int index = 0;
        for (String rhsSubr : orderedRHS) {
            if (index++ > 0) {
                sb.append(", ");
            }
            sb.append(InformationManagers.getInstance().getArrayManager().getTerminalValue(rhsUnpacked[0], rhsSubr, Integer.parseInt(rhsUnpacked[2])));
        }
        return sb.toString();
    }

    public String generateMappedIndexForLHS(String eqLHSarray, String eqLHSsubscript, int eqLHSdimension) {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> lhs = new ArrayList<String>();
        for (String s : InformationManagers.getInstance().getNamedSubscriptManager().getValuesFor(eqLHSsubscript)) {
            lhs.add(s);
        }
        sb.append("// This will be a mapped range index array\n// ");
        for (String s : lhs) {
            sb.append("," + s);
        }
        sb.append("\n");
        return sb.toString();
    }

    public boolean requiresIndirection(String arrayName, String subscript, int dimension) {
        String packed = this.pack(arrayName, subscript, dimension);
        return this.arraysRequiringOuterIndexArray.contains(packed);
    }

    public String getSubscriptForImplementation(String arrayName, String subscript, int dimension) {
        String subr = "";
        String packed = this.pack(arrayName, subscript, dimension);
        int index = this.getOuterIndex(arrayName, subscript, dimension);
        if (this.isOuterSubscript(arrayName, subscript, dimension)) {
            subr = this.arraysRequiringOuterIndexArray.contains(packed) ? "indexArray_" + CodeGenerator.getLegalName(String.valueOf(arrayName) + "_" + subscript + "_" + dimension) + "_[outer" + index + "]" : "outer" + index;
        } else {
            int lhsSubrIndex = 0;
            for (String lhsSubr : this.lhsArrayReference.getSubscripts()) {
                if (InformationManagers.getInstance().getMappedSubscriptManager().isMapBetween(subscript, lhsSubr)) {
                    subr = this.generateMappedIndexForRHS(this.lhsArrayReference.getArrayName(), lhsSubr, lhsSubrIndex, arrayName, subscript, dimension);
                }
                ++lhsSubrIndex;
            }
        }
        return subr;
    }

    public String getRangeSubscriptForImplementation(String arrayName, String subscript, int dimension) {
        String subr = "";
        String noBang = subscript.replace("!", "");
        String packed = this.pack(arrayName, subscript, dimension);
        int index = this.getRangeIndexFor(subscript);
        if (this.arraysRequiringRangeIndexArray.contains(packed)) {
            subr = "indexArray_" + CodeGenerator.getLegalName(String.valueOf(arrayName) + "_" + noBang + "_" + dimension) + "_[range" + index + "]";
            CodeGenerator.defineIndex(packed);
        } else {
            subr = "range" + index;
        }
        return subr;
    }

    public int getRangeSubscriptIndexForImplementation(String arrayName, String subscript, int dimension) {
        String subr = "";
        String noBang = subscript.replace("!", "");
        String packed = this.pack(arrayName, subscript, dimension);
        int index = this.getRangeIndex(arrayName, noBang, dimension);
        return index;
    }

    public String getMappedSubscriptForImplementation(String arrayName, String subscript, int dimension) {
        String subr = "";
        String noBang = subscript.replace("!", "");
        String packed = this.pack(arrayName, subscript, dimension);
        int index = this.getRangeIndex(arrayName, noBang, dimension);
        subr = this.arraysRequiringRangeIndexArray.contains(packed) ? "indexMapArray_" + CodeGenerator.getLegalName(String.valueOf(arrayName) + "_" + noBang + "_" + dimension) + "_[range" + index + "]" : "range" + index;
        return subr;
    }

    public boolean isOuterSubscript(String arrayName, String subscript, int dimension) {
        if (this.lhsArrayReference == null) {
            return false;
        }
        return this.lhsArrayReference.getSubscripts().contains(subscript);
    }

    public int getRangeIndex(String arrayName, String subscript, int dimension) {
        int index = 0;
        for (String sub : this.getUniqueRHSarrayRangeSubscripts()) {
            if (sub.equals(subscript)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int getOuterIndex(String arrayName, String subscript, int dimension) {
        int index = 0;
        if (this.lhsArrayReference == null) {
            System.out.println("LHS Reference is null");
            System.out.println("ArrayName: " + arrayName);
            System.out.println("subscript: " + subscript);
            System.out.println("dimension: " + dimension);
        }
        for (String sub : this.lhsArrayReference.getSubscripts()) {
            if (sub.equals(subscript)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public String getLHSsubscript() {
        StringBuffer code = new StringBuffer();
        int subNum = 0;
        while (subNum < this.lhsArrayReference.getSubscripts().size()) {
            if (subNum > 0) {
                code.append("+");
            }
            code.append("\"[\"+outer" + subNum + "+\"]\"");
            ++subNum;
        }
        return code.toString();
    }

    public String getLHSassignmentName() {
        StringBuffer code = new StringBuffer();
        code.append("stringConcat(");
        code.append("\"");
        code.append(InformationManagers.getInstance().getNativeDataTypeManager().getOriginalName(InformationManagers.getInstance().getNativeDataTypeManager().getLegalName(this.lhsArrayReference.getArrayName())));
        code.append("\"");
        List<Object> dimensionsRequiringIndexArray = new ArrayList();
        if (this.requiresOuterIndexArray) {
            dimensionsRequiringIndexArray = this.retrieveDimensions(this.arraysRequiringOuterIndexArray);
        }
        int dim = 0;
        while (dim < this.lhsArrayReference.getSubscripts().size()) {
            String sub = this.lhsArrayReference.getSubscripts().get(dim);
            if (!dimensionsRequiringIndexArray.contains(dim)) {
                code.append(",\"[\",intToString(outer" + dim + "),\"]\"");
            } else {
                code.append(",\"[\",intToString(" + this.getSubscriptForImplementation(this.lhsArrayReference.getArrayName(), sub, dim) + "),\"]\"");
            }
            ++dim;
        }
        code.append(")");
        return code.toString();
    }

    public String getLHSassignment() {
        StringBuffer code = new StringBuffer();
        code.append(InformationManagers.getInstance().getNativeDataTypeManager().getLegalName(this.lhsArrayReference.getArrayName()));
        List<Object> dimensionsRequiringIndexArray = new ArrayList();
        if (this.requiresOuterIndexArray) {
            dimensionsRequiringIndexArray = this.retrieveDimensions(this.arraysRequiringOuterIndexArray);
        }
        int dim = 0;
        while (dim < this.lhsArrayReference.getSubscripts().size()) {
            String sub = this.lhsArrayReference.getSubscripts().get(dim);
            if (!dimensionsRequiringIndexArray.contains(dim)) {
                code.append("[outer" + dim + "]");
            } else {
                code.append("[" + this.getSubscriptForImplementation(this.lhsArrayReference.getArrayName(), sub, dim) + "]");
            }
            ++dim;
        }
        return code.toString();
    }

    public String getRangeLoops(List<Node> arrayReferences) {
        StringBuffer code = new StringBuffer();
        if (!this.hasRHSrangeArrayReference) {
            return code.toString();
        }
        if (arrayReferences.size() == 0) {
            return code.toString();
        }
        List<Object> dimensionsRequiringIndexArray = new ArrayList();
        HashSet<String> arSet = new HashSet<String>();
        for (Node node : arrayReferences) {
            ArrayReference ar = new ArrayReference(node.getToken());
            String arrayName = ar.getArrayName();
            int i = 0;
            while (i < ar.getSubscripts().size()) {
                String subr = ar.getSubscripts().get(i);
                if (ArrayReference.isRangeSubscript(subr)) {
                    arSet.add(this.pack(arrayName, subr, i));
                }
                ++i;
            }
        }
        if (this.requiresRangeIndexArray) {
            dimensionsRequiringIndexArray = this.retrieveDimensions(this.arraysRequiringRangeIndexArray);
            for (String packed : this.arraysRequiringRangeIndexArray) {
                if (!arSet.contains(packed)) continue;
                String[] unpacked = this.unpack(packed);
                unpacked[1] = unpacked[1].replace("!", "");
                if (CodeGenerator.indexDefined(this.pack(unpacked[0], unpacked[1], unpacked[2])) || this.localIndexArrays.contains(this.pack(unpacked[0], unpacked[1], unpacked[2]))) continue;
                if (!Translator.target.equals("C")) {
                    code.append("int[] ");
                } else {
                    code.append("int *");
                }
                code.append("indexArray_" + CodeGenerator.getLegalName(String.valueOf(unpacked[0]) + "_" + unpacked[1] + "_" + unpacked[2]) + "_ = newIntArray(" + InformationManagers.getInstance().getArrayManager().getNumIndicies(unpacked[0], Integer.parseInt(unpacked[2]), unpacked[1]) + "," + InformationManagers.getInstance().getArrayManager().getIndicies(unpacked[0], Integer.parseInt(unpacked[2]), unpacked[1]) + ");\n");
                this.localIndexArrays.add(this.pack(unpacked[0], unpacked[1], unpacked[2]));
                if (this.lhsArrayReference != null) continue;
                CodeGenerator.defineIndex(this.pack(unpacked[0], unpacked[1], unpacked[2]));
            }
        }
        code.append("{ /* MJB Range Issues*/ \n");
        List<String> subrs = this.getUniqueRHSarrayRangeSubscripts();
        Iterator<String> iterator = subrs.iterator();
        while (iterator.hasNext()) {
            String sub;
            String noBang = sub = iterator.next();
            String subr = String.valueOf(sub) + "!";
            if (!this.subscriptExistsIn(subr, arSet)) continue;
            int subIndex = this.rangeIndexMap.get(subr);
            code.append("int range" + subIndex + ";\n");
            if (!dimensionsRequiringIndexArray.contains(subIndex)) {
                code.append("for (range" + subIndex + " = 0; range" + subIndex + " < " + InformationManagers.getInstance().getNamedSubscriptManager().getNumIndexFor(subr.replace("!", "")) + "; range" + subIndex + "++) {\n");
                continue;
            }
            if (!Translator.target.equals("C")) {
                code.append("int[] ");
            } else {
                code.append("int *");
            }
            String numbers = InformationManagers.getInstance().getArrayManager().getIndiciesSorted(this.getArrayWithSubscriptDimension(this.arraysRequiringRangeIndexArray, subr, subIndex), subIndex, subr);
            int num = numbers.split(",").length;
            code.append("range" + subIndex + "_index = newIntArray(" + num + "," + numbers + ");\n");
            code.append("int trange" + subIndex + ";\n");
            code.append("for (trange" + subIndex + " = 0; trange" + subIndex + " < " + num + "; trange" + subIndex + "++) {\n");
            code.append("range" + subIndex + " = " + "range" + subIndex + "_index[" + "trange" + subIndex + "];\n");
        }
        return code.toString();
    }

    private boolean subscriptExistsIn(String sub, Set<String> arSet) {
        for (String packed : arSet) {
            String subr = this.unpack(packed)[1].replace("!", "");
            if (!sub.replace("!", "").equals(subr)) continue;
            return true;
        }
        return false;
    }

    public String getRangeLoopsXXX() {
        StringBuffer code = new StringBuffer();
        if (!this.hasRHSrangeArrayReference) {
            return code.toString();
        }
        List<Object> dimensionsRequiringIndexArray = new ArrayList();
        if (this.requiresRangeIndexArray) {
            dimensionsRequiringIndexArray = this.retrieveDimensions(this.arraysRequiringRangeIndexArray);
            for (String packed : this.arraysRequiringRangeIndexArray) {
                String[] unpacked = this.unpack(packed);
                unpacked[1] = unpacked[1].replace("!", "");
                if (CodeGenerator.indexDefined(this.pack(unpacked[0], unpacked[1], unpacked[2])) || this.localIndexArrays.contains(this.pack(unpacked[0], unpacked[1], unpacked[2]))) continue;
                if (!Translator.target.equals("C")) {
                    code.append("int[] ");
                } else {
                    code.append("int *");
                }
                code.append("indexArray_" + CodeGenerator.getLegalName(String.valueOf(unpacked[0]) + "_" + unpacked[1] + "_" + unpacked[2]) + "_ = newIntArray(" + InformationManagers.getInstance().getArrayManager().getNumIndicies(unpacked[0], Integer.parseInt(unpacked[2]), unpacked[1]) + "," + InformationManagers.getInstance().getArrayManager().getIndicies(unpacked[0], Integer.parseInt(unpacked[2]), unpacked[1]) + ");\n");
                this.localIndexArrays.add(this.pack(unpacked[0], unpacked[1], unpacked[2]));
                if (this.lhsArrayReference != null) continue;
                CodeGenerator.defineIndex(this.pack(unpacked[0], unpacked[1], unpacked[2]));
            }
        }
        List<String> subrs = this.getUniqueRHSarrayRangeSubscripts();
        int subIndex = 0;
        while (subIndex < subrs.size()) {
            String sub = subrs.get(subIndex);
            code.append("int range" + subIndex + ";\n");
            if (!dimensionsRequiringIndexArray.contains(subIndex)) {
                code.append("for (range" + subIndex + " = 0; range" + subIndex + " < " + InformationManagers.getInstance().getNamedSubscriptManager().getNumIndexFor(sub) + "; range" + subIndex + "++) {\n");
            } else {
                code.append("/* EARS 662 */ for (range" + subIndex + " :  new int[] {" + InformationManagers.getInstance().getArrayManager().getIndiciesSorted(this.getArrayWithSubscriptDimension(this.arraysRequiringRangeIndexArray, sub, subIndex), subIndex, sub) + "}) {\n");
            }
            ++subIndex;
        }
        return code.toString();
    }

    public String getArrayWithSubscriptDimension(List<String> packed, String sub, int dimension) {
        for (String s : packed) {
            String[] unpacked = this.unpack(s);
            if (!unpacked[1].equals(sub) || Integer.parseInt(unpacked[2]) != dimension) continue;
            return unpacked[0];
        }
        return "*ERROR*";
    }

    public List<Integer> retrieveDimensions(List<String> packed) {
        ArrayList<Integer> al = new ArrayList<Integer>();
        for (String p : packed) {
            String[] unpacked = this.unpack(p);
            Integer dim = Integer.parseInt(unpacked[2]);
            if (al.contains(dim)) continue;
            al.add(dim);
        }
        return al;
    }

    public int getOuterClosingCount() {
        return this.lhsArrayReference.getSubscripts().size();
    }

    public int getRangeClosingCount() {
        return this.getRHSrangeSubscripts().size();
    }

    public int getRangeClosingCount(List<Node> arrayReferences) {
        int closingParens = 0;
        HashSet<String> arSet = new HashSet<String>();
        for (Node node : arrayReferences) {
            ArrayReference ar = new ArrayReference(node.getToken());
            String arrayName = ar.getArrayName();
            int i = 0;
            while (i < ar.getSubscripts().size()) {
                String subr = ar.getSubscripts().get(i);
                if (ArrayReference.isRangeSubscript(subr)) {
                    arSet.add(this.pack(arrayName, subr, i));
                }
                ++i;
            }
        }
        List<String> subrs = this.getUniqueRHSarrayRangeSubscripts();
        int subIndex = 0;
        while (subIndex < subrs.size()) {
            String sub = subrs.get(subIndex);
            if (this.subscriptExistsIn(sub, arSet)) {
                ++closingParens;
            }
            ++subIndex;
        }
        return closingParens;
    }

    private String pack(String arrayName, String subscript, int dimension) {
        return String.valueOf(arrayName) + "###" + subscript + "###" + dimension;
    }

    private String pack(String arrayName, String subscript, String dimension) {
        return String.valueOf(arrayName) + "###" + subscript + "###" + dimension;
    }

    private void analyze() {
        List<Node> al = this.equation.getTreeAsList();
        if (al == null) {
            String lhs = this.equation.getTokens().get(0);
            if (lhs != null && ArrayReference.isArrayReference(lhs)) {
                this.hasLHSarrayReference = true;
                this.lhsArrayReference = new ArrayReference(lhs);
            }
            return;
        }
        if (this.equation.isArrayInitialization()) {
            this.arrayInitialization = true;
            Node lhs = al.get(0);
            this.numberArrayInitializers = al.size() - 1;
            if (lhs != null && ArrayReference.isArrayReference(lhs.getToken())) {
                this.hasLHSarrayReference = true;
                this.lhsArrayReference = new ArrayReference(lhs.getToken());
            }
        } else {
            Node lhs = al.get(0);
            if (lhs != null && ArrayReference.isArrayReference(lhs.getToken())) {
                this.hasLHSarrayReference = true;
                this.lhsArrayReference = new ArrayReference(lhs.getToken());
            }
            int i = 1;
            while (i < al.size()) {
                Node n = al.get(i);
                if (n != null && ArrayReference.isArrayReference(n.getToken())) {
                    this.hasRHSarrayReference = true;
                    this.rhsArrayReferences.add(new ArrayReference(n.getToken()));
                }
                ++i;
            }
            this.requiresOuterIndexArray = this.needOuterIndexArray();
            if (this.hasRHSrangeSubscripts()) {
                this.hasRHSrangeArrayReference = true;
            }
            if (this.hasRHSarray() && this.hasRHSrangeSubscripts()) {
                this.requiresRangeIndexArray = this.needRangeIndexArray();
            }
            this.hasRHSmappedArrayReference = this.requiresMappedIndexArray = this.needMappedIndexArray();
        }
    }

    private String getIndicies(String packed) {
        String[] unpacked = this.unpack(packed);
        return InformationManagers.getInstance().getArrayManager().getIndicies(unpacked[0], Integer.parseInt(unpacked[2]), unpacked[1]);
    }

    private String[] unpack(String packed) {
        String[] unpacked = packed.split("###");
        return unpacked;
    }

    public boolean hasLHSarray() {
        return this.lhsArrayReference != null;
    }

    public boolean hasRHSarray() {
        return this.rhsArrayReferences.size() > 0;
    }

    public boolean hasRHSrangeSubscripts() {
        boolean hasRangeSubscript = false;
        int index = 0;
        for (ArrayReference ar : this.rhsArrayReferences) {
            if (!ar.hasRangeSubscript()) continue;
            hasRangeSubscript = true;
            for (String subscript : ar.getRangeSubscripts()) {
                if (this.rangeIndexMap.containsKey(subscript)) continue;
                this.rangeIndexMap.put(subscript, index++);
            }
        }
        return hasRangeSubscript;
    }

    public int getRangeIndexFor(String rangeSubscript) {
        if (this.rangeIndexMap != null) {
            // empty if block
        }
        return this.rangeIndexMap.get(rangeSubscript);
    }

    public boolean hasRHSmappedSubscripts() {
        if (this.lhsArrayReference == null) {
            return false;
        }
        List<String> lhsSubscripts = this.lhsArrayReference.getSubscripts();
        for (ArrayReference ar : this.rhsArrayReferences) {
            for (String rhsSubscripts : ar.getSubscripts()) {
                if (lhsSubscripts.contains(rhsSubscripts)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getUniqueRHSarrayRangeSubscripts() {
        this.rangeSubscriptNames = new ArrayList<String>();
        for (ArrayReference ar : this.rhsArrayReferences) {
            if (!ar.hasRangeSubscript()) continue;
            for (String rSub : ar.getUniqueRangeSubscriptsNames()) {
                if (this.rangeSubscriptNames.contains(rSub)) continue;
                this.rangeSubscriptNames.add(rSub);
            }
        }
        return this.rangeSubscriptNames;
    }

    public List<String> getRHSarrayRangeSubscripts() {
        this.rangeSubscriptNames = new ArrayList<String>();
        for (ArrayReference ar : this.rhsArrayReferences) {
            if (!ar.hasRangeSubscript()) continue;
            for (String r : ar.getRangeSubscriptsWithDimension()) {
                String pair = String.valueOf(ar.getArrayName()) + "###" + r;
                if (this.rangeSubscriptNames.contains(pair)) continue;
                this.rangeSubscriptNames.add(pair);
            }
        }
        return this.rangeSubscriptNames;
    }

    public List<String> getRHSrangeSubscripts() {
        this.rangeSubscriptNames = new ArrayList<String>();
        for (ArrayReference ar : this.rhsArrayReferences) {
            if (!ar.hasRangeSubscript()) continue;
            for (String r : ar.getRangeSubscripts()) {
                if (this.rangeSubscriptNames.contains(r)) continue;
                this.rangeSubscriptNames.add(r);
            }
        }
        return this.rangeSubscriptNames;
    }

    public int getOuterSubscriptNumber(String subscript) {
        int pos = 0;
        for (String sub : this.lhsArrayReference.getSubscripts()) {
            if (sub.equals(subscript)) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public int getRangeSubscriptNumber(String subscript) {
        int pos = 0;
        if (this.rangeSubscriptNames == null) {
            this.getRHSrangeSubscripts();
        }
        for (String sub : this.rangeSubscriptNames) {
            if (sub.equals(subscript)) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public boolean needRangeIndexArray() {
        String[] info;
        boolean need = false;
        List<String> packedInfo = this.getRangeArraySubscriptDimensionPacked();
        for (String packed : packedInfo) {
            String indicies;
            List<String> bySubscript;
            info = packed.split("###");
            info[1] = info[1].replace("!", "");
            if (!this.uniqueBySubscript.containsKey(info[1])) {
                this.uniqueBySubscript.put(info[1], new ArrayList());
            }
            if ((bySubscript = this.uniqueBySubscript.get(info[1])).contains(indicies = InformationManagers.getInstance().getArrayManager().getIndicies(info[0], Integer.parseInt(info[2]), info[1]))) continue;
            bySubscript.add(indicies);
        }
        for (String packed : packedInfo) {
            info = packed.split("###");
            info[1] = info[1].replace("!", "");
            List<String> al = this.uniqueBySubscript.get(info[1]);
            if (al.size() <= 1) continue;
            this.arraysRequiringRangeIndexArray.add(packed);
            need = true;
        }
        return need;
    }

    public boolean needMappedIndexArray() {
        boolean need = false;
        List<String> packedInfo = this.getMappedArraySubscriptDimensionPacked();
        for (String packed : packedInfo) {
            this.arraysRequiringMappedIndexArray.add(packed);
            need = true;
        }
        return need;
    }

    public boolean needOuterIndexArray() {
        String[] info;
        boolean need = false;
        if (this.lhsArrayReference == null) {
            return need;
        }
        List<String> packedInfo = this.getOuterArraySubscriptDimensionPacked();
        for (String packed : packedInfo) {
            String indicies;
            List<String> bySybscript;
            info = packed.split("###");
            if (!this.uniqueBySubscript.containsKey(info[1])) {
                this.uniqueBySubscript.put(info[1], new ArrayList());
            }
            if ((bySybscript = this.uniqueBySubscript.get(info[1])).contains(indicies = InformationManagers.getInstance().getArrayManager().getIndicies(info[0], Integer.parseInt(info[2]), info[1]))) continue;
            bySybscript.add(indicies);
        }
        for (String packed : packedInfo) {
            info = packed.split("###");
            if (this.uniqueBySubscript.get(info[1]).size() <= 1) continue;
            this.arraysRequiringOuterIndexArray.add(packed);
            need = true;
        }
        return need;
    }

    public boolean isHasLHSarrayReference() {
        return this.hasLHSarrayReference;
    }

    public void setHasLHSarrayReference(boolean hasLHSarrayReference) {
        this.hasLHSarrayReference = hasLHSarrayReference;
    }

    public boolean isHasRHSarrayReference() {
        return this.hasRHSarrayReference;
    }

    public void setHasRHSarrayReference(boolean hasRHSarrayReference) {
        this.hasRHSarrayReference = hasRHSarrayReference;
    }

    public boolean isHasRHSrangeArrayReference() {
        return this.hasRHSrangeArrayReference;
    }

    public void setHasRHSrangeArrayReference(boolean hasRHSrangeArrayReference) {
        this.hasRHSrangeArrayReference = hasRHSrangeArrayReference;
    }

    public boolean isHasRHSmappedArrayReference() {
        return this.hasRHSmappedArrayReference;
    }

    public void setHasRHSmappedArrayReference(boolean hasRHSmappedArrayReference) {
        this.hasRHSmappedArrayReference = hasRHSmappedArrayReference;
    }

    public ArrayReference getLhsArrayReference() {
        return this.lhsArrayReference;
    }

    public void setLhsArrayReference(ArrayReference lhsArrayReference) {
        this.lhsArrayReference = lhsArrayReference;
    }

    public List<ArrayReference> getRhsArrayReferences() {
        return this.rhsArrayReferences;
    }

    public void setRhsArrayReferences(List<ArrayReference> rhsArrayReferences) {
        this.rhsArrayReferences = rhsArrayReferences;
    }

    public boolean isRequiresOuterIndexArray() {
        return this.requiresOuterIndexArray;
    }

    public void setRequiresOuterIndexArray(boolean requiresOuterIndexArray) {
        this.requiresOuterIndexArray = requiresOuterIndexArray;
    }

    public boolean isRequiresRangeIndexArray() {
        return this.requiresRangeIndexArray;
    }

    public void setRequiresRangeIndexArray(boolean requiresRangeIndexArray) {
        this.requiresRangeIndexArray = requiresRangeIndexArray;
    }

    public boolean isRequiresMappedIndexArray() {
        return this.requiresMappedIndexArray;
    }

    public void setRequiresMappedIndexArray(boolean requiresMappedIndexArray) {
        this.requiresMappedIndexArray = requiresMappedIndexArray;
    }
}

