/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import repast.simphony.systemdynamics.translator.Arrow;
import repast.simphony.systemdynamics.translator.Node;
import repast.simphony.systemdynamics.translator.SystemDynamicsObject;
import repast.simphony.systemdynamics.translator.SystemDynamicsObjectManager;

public class CausalAnalyzer {
    public void generateCausalTrees(SystemDynamicsObjectManager sdObjectManager) {
        Node root = null;
        for (SystemDynamicsObject stock : sdObjectManager.stockVariables()) {
            root = new Node(stock.getScreenName());
            this.extend(root, sdObjectManager);
            System.out.println("\n###################################################\n");
            CausalAnalyzer.printTreeCausal(root, 0, sdObjectManager);
        }
    }

    private void extend(Node node, SystemDynamicsObjectManager sdObjectManager) {
        if (node == null) {
            return;
        }
        Node currentNode = null;
        for (Arrow in : sdObjectManager.getIncomingArrows(node.getToken())) {
            Node n = new Node(in.getOtherEnd());
            if (currentNode == null) {
                node.setChild(n);
            } else {
                currentNode.setNext(n);
            }
            currentNode = n;
            SystemDynamicsObject obj = sdObjectManager.getObjectWithName(in.getOtherEnd());
            if (obj == null || obj.isStock()) continue;
            this.extend(n, sdObjectManager);
        }
    }

    public static void printTreeCausal(Node node, int level, SystemDynamicsObjectManager sdObjectManager) {
        if (node == null) {
            return;
        }
        String blanks = "";
        int i = 0;
        while (i < level) {
            blanks = String.valueOf(blanks) + "    ";
            ++i;
        }
        String stock = "";
        if (sdObjectManager.getObjectWithName(node.getToken()).isStock()) {
            stock = " <STOCK>";
        }
        System.out.println(String.valueOf(blanks) + "(" + level + ") " + node.getToken() + stock);
        CausalAnalyzer.printTreeCausal(node.getChild(), level + 1, sdObjectManager);
        CausalAnalyzer.printTreeCausal(node.getNext(), level, sdObjectManager);
    }
}

