/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import java.util.List;

public class Arrow {
    public static final String IN = "IN";
    public static final String OUT = "OUT";
    public static final String FLOW = "FLOW";
    public static final String INFLUENCE = "INFLUENCE";
    private String direction;
    private String type;
    private String otherEnd;

    public Arrow(String otherEnd, String direction, String type) {
        this.otherEnd = otherEnd;
        this.direction = direction;
        this.type = type;
    }

    public String toString() {
        return this.isIncoming() ? "FROM <" + this.otherEnd + "/" + this.direction + "/" + this.type + ">" : "TO <" + this.otherEnd + "/" + this.direction + "/" + this.type + ">";
    }

    public boolean isIncoming() {
        return this.direction.equals(IN);
    }

    public boolean outIncoming() {
        return this.direction.equals(OUT);
    }

    public boolean isFlow() {
        return this.type.equals(FLOW);
    }

    public boolean isInfluence() {
        return this.type.equals(INFLUENCE);
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOtherEnd() {
        return this.otherEnd;
    }

    public void setOtherEnd(String otherEnd) {
        this.otherEnd = otherEnd;
    }

    public static boolean listContainsArrowWithOtherEnd(List<Arrow> listOfArrows, String name) {
        for (Arrow arrow : listOfArrows) {
            if (!arrow.getOtherEnd().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static Arrow getArrowWithOtherEnd(List<Arrow> listOfArrows, String name) {
        for (Arrow arrow : listOfArrows) {
            if (!arrow.getOtherEnd().equals(name)) continue;
            return arrow;
        }
        return null;
    }
}

