/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import java.util.ArrayList;
import java.util.List;
import repast.simphony.systemdynamics.support.ArrayReference;
import repast.simphony.systemdynamics.translator.Equation;
import repast.simphony.systemdynamics.translator.EquationArrayReferenceStructure;
import repast.simphony.systemdynamics.translator.InformationManagers;

public class ArrayReferenceNative {
    private String arrayName;
    private List<String> subscripts;
    private Equation equation;

    public ArrayReferenceNative(String reference, Equation equation) {
        this.arrayName = this.extractArrayName(reference);
        this.subscripts = this.extractSubscripts(reference);
        this.equation = equation;
    }

    public ArrayReferenceNative(String reference) {
        this.arrayName = this.extractArrayName(reference);
        this.subscripts = this.extractSubscriptsNative(reference);
    }

    public ArrayReferenceNative(ArrayReference ar, Equation equation) {
        this.arrayName = new String(ar.getArrayName());
        this.subscripts = new ArrayList<String>(ar.getSubscripts());
        this.equation = equation;
    }

    public String generateLHSHeader(String valueVariable) {
        StringBuffer code = new StringBuffer();
        EquationArrayReferenceStructure ears = this.equation.getEars();
        code.append(ears.getOuterLoops());
        return code.toString();
    }

    public boolean hasRangeSubscript() {
        for (String sub : this.subscripts) {
            if (!ArrayReferenceNative.isRangeSubscript(sub)) continue;
            return true;
        }
        return false;
    }

    public String generateLHSFooter(String valueVariable, boolean logit) {
        StringBuffer code = new StringBuffer();
        EquationArrayReferenceStructure ears = this.equation.getEars();
        code.append(ears.getLHSassignment());
        code.append(" = " + valueVariable + ";\n");
        if (logit) {
            code.append("/* log1 */logit(");
            code.append(ears.getLHSassignmentName());
            code.append(",");
            code.append("time,");
            code.append(String.valueOf(valueVariable) + ",memory.get_SAVEPER());\n");
        }
        for (String sub : this.subscripts) {
            code.append("}\n");
        }
        return code.toString();
    }

    public String generateRHSImplementation() {
        StringBuffer code = new StringBuffer();
        EquationArrayReferenceStructure ears = this.equation.getEars();
        code.append(InformationManagers.getInstance().getNativeDataTypeManager().getLegalName(this.arrayName));
        int subNum = 0;
        for (String sub : this.subscripts) {
            if (ArrayReferenceNative.isRangeSubscript(sub)) {
                code.append("[" + this.equation.getEars().getRangeSubscriptForImplementation(this.arrayName, sub, subNum) + "]");
            } else if (InformationManagers.getInstance().getNamedSubscriptManager().isNamedSubscript(sub)) {
                code.append("[" + this.equation.getEars().getSubscriptForImplementation(this.arrayName, sub, subNum) + "]");
            } else if (this.equation.getEars().requiresIndirection(this.arrayName, sub, subNum)) {
                code.append("[" + this.equation.getEars().getSubscriptForImplementation(this.arrayName, sub, subNum) + "]");
            } else if (InformationManagers.getInstance().getArrayManager().isTerminalSubscript(this.arrayName, sub, subNum)) {
                code.append("[" + InformationManagers.getInstance().getArrayManager().getTerminalValue(this.arrayName, sub, subNum) + "]");
            } else {
                code.append("\n// PROBLEM: " + this.arrayName + " " + sub + " " + subNum + "\n");
                code.append("[" + sub.replace("!", "") + "]");
            }
            ++subNum;
        }
        return code.toString();
    }

    public String generateRHSOriginalName() {
        StringBuffer code = new StringBuffer();
        code.append("stringConcat(");
        code.append("\"");
        code.append(InformationManagers.getInstance().getNativeDataTypeManager().getOriginalName(InformationManagers.getInstance().getNativeDataTypeManager().getLegalName(this.arrayName)));
        for (String sub : this.subscripts) {
            if (ArrayReferenceNative.isRangeSubscript(sub)) {
                code.append("[\",intToString(range" + this.equation.getEars().getRangeSubscriptNumber(sub) + "),\"]");
                continue;
            }
            if (InformationManagers.getInstance().getNamedSubscriptManager().isNamedSubscript(sub)) {
                code.append("[\",intToString(outer" + this.equation.getEars().getOuterSubscriptNumber(sub) + "),\"]");
                continue;
            }
            code.append("[" + sub.replace("!", "") + "]");
        }
        code.append("\")");
        return code.toString();
    }

    public String generateRHSName() {
        StringBuffer code = new StringBuffer();
        code.append("stringConcat(");
        code.append("\"");
        code.append(InformationManagers.getInstance().getNativeDataTypeManager().getLegalName(this.arrayName));
        for (String sub : this.subscripts) {
            if (ArrayReferenceNative.isRangeSubscript(sub)) {
                code.append("[\",intToString(range" + this.equation.getEars().getRangeSubscriptNumber(sub) + "),\"]");
                continue;
            }
            if (InformationManagers.getInstance().getNamedSubscriptManager().isNamedSubscript(sub)) {
                code.append("[\",intToString(outer" + this.equation.getEars().getOuterSubscriptNumber(sub) + "),\"]");
                continue;
            }
            code.append("[" + sub.replace("!", "") + "]");
        }
        code.append("\")");
        return code.toString();
    }

    public static boolean isArrayReference(String token) {
        return token.startsWith("array.") && token.contains("[") && token.contains("]") || token.contains("[") && token.contains("]");
    }

    public static boolean isRangeSubscript(String subscript) {
        return subscript.endsWith("!");
    }

    private String extractArrayName(String reference) {
        return reference.split("\\[")[0].replace("array.", "").replace("lookup.", "").trim();
    }

    private List<String> extractSubscriptsNative(String reference) {
        ArrayList<String> subscripts = new ArrayList<String>();
        String[] subs = reference.split("\\[");
        String sub = "";
        int i = 1;
        while (i < subs.length) {
            sub = String.valueOf(sub) + "[" + subs[i];
            ++i;
        }
        subscripts.add(sub.trim());
        return subscripts;
    }

    private List<String> extractSubscripts(String reference) {
        ArrayList<String> subscripts = new ArrayList<String>();
        String[] stringArray = reference.split("\\[")[1].split("]")[0].split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String sub = stringArray[n2];
            subscripts.add(sub.trim());
            ++n2;
        }
        return subscripts;
    }

    public String[] getNonRangeSubscriptsAsArray() {
        List<String> al = this.getNonRangeSubscripts();
        return al.toArray(new String[al.size()]);
    }

    public List<String> getNonRangeSubscripts() {
        ArrayList<String> ranges = new ArrayList<String>();
        for (String sub : this.subscripts) {
            if (sub.contains("!")) continue;
            ranges.add(sub);
        }
        return ranges;
    }

    public String[] getRangeSubscriptsAsArray() {
        List<String> al = this.getRangeSubscripts();
        return al.toArray(new String[al.size()]);
    }

    public List<String> getRangeSubscripts() {
        ArrayList<String> ranges = new ArrayList<String>();
        for (String sub : this.subscripts) {
            if (!sub.contains("!")) continue;
            ranges.add(sub);
        }
        return ranges;
    }

    public String[] getRangeSubscriptsNamesAsArray() {
        List<String> al = this.getRangeSubscriptsNames();
        return al.toArray(new String[al.size()]);
    }

    public List<String> getRangeSubscriptsNames() {
        ArrayList<String> ranges = new ArrayList<String>();
        for (String sub : this.subscripts) {
            if (!sub.contains("!")) continue;
            ranges.add(sub.replace("[", "").replace("]", "").replace("!", ""));
        }
        return ranges;
    }

    public String getSubscriptsAsMethodParameters() {
        StringBuffer sb = new StringBuffer();
        for (String sub : this.subscripts) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("\"" + sub + "\"");
        }
        return sb.toString();
    }

    public String getArrayName() {
        return this.arrayName;
    }

    public void setArrayName(String arrayName) {
        this.arrayName = arrayName;
    }

    public List<String> getSubscripts() {
        return this.subscripts;
    }

    public String[] getSubscriptsAsArray() {
        String[] s = new String[this.subscripts.size()];
        int i = 0;
        for (String sub : this.subscripts) {
            s[i++] = sub;
        }
        return s;
    }

    public void setSubscripts(List<String> subscripts) {
        this.subscripts = subscripts;
    }

    public String getSubscript() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (String s : this.subscripts) {
            if (i++ > 0) {
                sb.append(",");
            }
            sb.append(s);
        }
        return sb.toString();
    }
}

