/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.translator;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import repast.simphony.systemdynamics.support.ArrayDefinition;
import repast.simphony.systemdynamics.support.ArrayReference;
import repast.simphony.systemdynamics.support.MutableBoolean;
import repast.simphony.systemdynamics.support.MutableInteger;
import repast.simphony.systemdynamics.support.NamedSubscriptManager;
import repast.simphony.systemdynamics.support.Subscript;
import repast.simphony.systemdynamics.support.SubscriptCombination;
import repast.simphony.systemdynamics.translator.Equation;
import repast.simphony.systemdynamics.translator.EquationProcessor;
import repast.simphony.systemdynamics.translator.InformationManagers;
import repast.simphony.systemdynamics.translator.NativeArray;
import repast.simphony.systemdynamics.translator.NativeDataTypeManager;
import repast.simphony.systemdynamics.translator.OperationResult;

public class ArrayManager {
    private Map<String, ArrayDefinition> arrays = new HashMap<String, ArrayDefinition>();
    private Set<String> arraysUsedAsLookup = new HashSet<String>();
    private Map<String, Map<Integer, Set<Subscript>>> subscriptSpace = new HashMap<String, Map<Integer, Set<Subscript>>>();
    public Map<String, Map<Integer, Map<String, Integer>>> allocatedIndicies = new HashMap<String, Map<Integer, Map<String, Integer>>>();
    private Map<String, Set<String>> uninitializedSubscriptCombinationsByArray = new HashMap<String, Set<String>>();

    public List<String> getOrderedSubscriptNames(String array, int dimension, String subscript) {
        ArrayList<String> orderedSubscripts = new ArrayList<String>();
        for (String s : InformationManagers.getInstance().getNamedSubscriptManager().getValuesFor(subscript)) {
            orderedSubscripts.add(s);
        }
        return orderedSubscripts;
    }

    public OperationResult validateLookupReference(Map<String, Equation> equations, Equation equation, MutableInteger pos, MutableBoolean lhs) {
        OperationResult or = new OperationResult();
        List<String> tokens = equation.getTokens();
        String token = tokens.get(pos.value());
        if (ArrayReference.isArrayReference(token)) {
            return this.validateArrayReference(equations, equation, pos, lhs);
        }
        return this.validateArrayReference(equations, equation, pos, lhs);
    }

    public OperationResult validateArrayReference(Map<String, Equation> equations, Equation equation, MutableInteger pos, MutableBoolean lhs) {
        OperationResult or = new OperationResult();
        List<String> tokens = equation.getTokens();
        String token = tokens.get(pos.value());
        if (lhs.value()) {
            return or;
        }
        NativeArray na = null;
        ArrayReference ar = null;
        if (ArrayReference.isArrayReference(token)) {
            ar = new ArrayReference(token);
            NativeDataTypeManager ndtm = InformationManagers.getInstance().getNativeDataTypeManager();
            if (ndtm.isScalar(ar.getArrayName())) {
                or.setErrorMessage("Referencing Scalar as an Array - " + token + " original name - " + ar.getArrayName());
                return or;
            }
            int numDimensions = 0;
            if (this.isUsedAsLookup(ar.getArrayName())) {
                na = InformationManagers.getInstance().getNativeDataTypeManager().getNativeArray(ar.getArrayName());
                numDimensions = na.getNumDimensions();
                numDimensions -= 2;
            } else {
                numDimensions = this.getNumDimensions(ar.getArrayName());
            }
            if (numDimensions != ar.getSubscripts().size()) {
                or.setErrorMessage(ar.getArrayName());
                or.setErrorMessage(equation.getTokensOneLine());
                or.setErrorMessage("Incorrect number of dimensions for " + token + " " + ar.getSubscripts().size() + " expecting " + numDimensions);
                if (na != null) {
                    or.setErrorMessage("NativeArray: " + na.toString());
                }
                return or;
            }
            this.validateSubscriptForArray(ar, or);
            return or;
        }
        if (this.isUsedAsLookup(token.replace("lookup.", ""))) {
            return or;
        }
        or.setErrorMessage(equation.getTokensOneLine());
        or.setErrorMessage("Invalid array reference " + token);
        return or;
    }

    private OperationResult validateSubscriptForArray(ArrayReference ar, OperationResult or) {
        String arrayName = ar.getArrayName();
        int numDimensions = this.getNumDimensions(ar.getArrayName());
        String[] subscripts = ar.getSubscriptsAsArray();
        Map<Integer, Map<String, Integer>> arrayMap = this.allocatedIndicies.get(arrayName);
        NamedSubscriptManager nsm = InformationManagers.getInstance().getNamedSubscriptManager();
        int dimension = 0;
        while (dimension < numDimensions) {
            Map<String, Integer> indexMap = arrayMap.get(dimension);
            if (nsm.isNamedSubscript(subscripts[dimension])) {
                List<String> values = nsm.getValuesFor(subscripts[dimension]);
                for (String value : values) {
                    if (indexMap.containsKey(value)) continue;
                    or.setErrorMessage(ar.getVensimReference());
                    or.setErrorMessage("   Incorrect Named subscript (" + value + ")" + subscripts[dimension] + " in dimension " + dimension);
                    or.setErrorMessage("   indexMap size = " + indexMap.size());
                    for (String s : indexMap.keySet()) {
                        or.setErrorMessage("   " + s);
                    }
                }
            } else if (!indexMap.containsKey(subscripts[dimension])) {
                or.setErrorMessage(ar.getVensimReference());
                or.setErrorMessage("   Incorrect subscript " + subscripts[dimension] + " in dimension " + dimension);
                or.setErrorMessage("   indexMap size = " + indexMap.size());
                for (String s : indexMap.keySet()) {
                    or.setErrorMessage("   " + s);
                }
            }
            ++dimension;
        }
        return or;
    }

    public String getVensimSubscript(String array, int dimension, int index) {
        Map<Integer, Map<String, Integer>> arrayMap = this.allocatedIndicies.get(array);
        Map<String, Integer> indexMap = arrayMap.get(dimension);
        for (String subscript : indexMap.keySet()) {
            int storedIndex = indexMap.get(subscript);
            if (storedIndex != index) continue;
            return subscript;
        }
        return "BOGUS$$$";
    }

    public boolean isUsedAsLookup(String arrayName) {
        Iterator<String> iter = this.arraysUsedAsLookup.iterator();
        return this.arraysUsedAsLookup.contains(arrayName);
    }

    public void setUsedAsLookup(String arrayName) {
        if (ArrayReference.isArrayReference(arrayName)) {
            ArrayReference ar = new ArrayReference(arrayName);
            this.arraysUsedAsLookup.add(ar.getArrayName());
        }
        this.arraysUsedAsLookup.add(arrayName);
    }

    public int getNumDimensions(String array) {
        if (this.allocatedIndicies.get(array) == null) {
            return 0;
        }
        return this.allocatedIndicies.get(array).size();
    }

    public int getNumIndicies(String array, int dimension, String subscript) {
        if (this.allocatedIndicies.get(array) == null) {
            return 0;
        }
        if (this.allocatedIndicies.get(array).get(dimension) == null) {
            return 0;
        }
        return InformationManagers.getInstance().getNamedSubscriptManager().getValuesFor(subscript).size();
    }

    public int getNumIndicies(String array, int dimension) {
        if (this.allocatedIndicies.get(array) == null) {
            return 0;
        }
        if (this.allocatedIndicies.get(array).get(dimension) == null) {
            return 0;
        }
        Map<String, Integer> indicies = this.allocatedIndicies.get(array).get(dimension);
        HashSet<Integer> indSet = new HashSet<Integer>();
        for (String key : indicies.keySet()) {
            indSet.add(indicies.get(key));
        }
        return indSet.size();
    }

    public String getIndicies(String arrayIn, int dimension, String subscript) {
        String array = new String(arrayIn);
        if (array.startsWith("lookup.")) {
            array = array.replace("lookup.", "");
        }
        Map<String, Integer> indicies = this.allocatedIndicies.get(array).get(dimension);
        int pos = 0;
        StringBuffer sb = new StringBuffer();
        for (String s : InformationManagers.getInstance().getNamedSubscriptManager().getValuesFor(subscript)) {
            if (pos++ > 0) {
                sb.append(", ");
            }
            sb.append(indicies.get(s));
        }
        return sb.toString();
    }

    public String getIndiciesSorted(String array, int dimension, String subscript) {
        Map<String, Integer> indicies = this.allocatedIndicies.get(array).get(dimension);
        ArrayList<Integer> ind = new ArrayList<Integer>();
        for (String s : InformationManagers.getInstance().getNamedSubscriptManager().getValuesFor(subscript.replace("!", ""))) {
            ind.add(indicies.get(s));
        }
        Collections.sort(ind);
        int pos = 0;
        StringBuffer sb = new StringBuffer();
        for (Integer s : ind) {
            if (pos++ > 0) {
                sb.append(", ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public void arrayReference(String arrayName, String ... subscripts) {
        if (!this.arrays.containsKey(arrayName)) {
            this.arrays.put(arrayName, new ArrayDefinition(arrayName, subscripts.length));
        }
        ArrayDefinition ad = this.arrays.get(arrayName);
        int i = 0;
        while (i < subscripts.length) {
            ad.addReference(i, subscripts[i]);
            ++i;
        }
    }

    public void arrayReference(String arrayName, List<String> subscripts) {
        if (!this.arrays.containsKey(arrayName)) {
            this.arrays.put(arrayName, new ArrayDefinition(arrayName, subscripts.size()));
        }
        ArrayDefinition ad = this.arrays.get(arrayName);
        int i = 0;
        while (i < subscripts.size()) {
            ad.addReference(i, subscripts.get(i).replace("!", ""));
            ++i;
        }
    }

    public void dumpSubscriptSpaceOrig(BufferedWriter bw) {
        try {
            bw.append("array,subNum,value,type,start,end\n");
            for (String array : this.subscriptSpace.keySet()) {
                Map<Integer, Set<Subscript>> map = this.subscriptSpace.get(array);
                int i = 0;
                while (i < map.keySet().size()) {
                    Set<Subscript> subs = map.get(i);
                    for (Subscript s : subs) {
                        bw.append(String.valueOf(array) + "," + i + "," + s.getValue() + "," + this.getIndicies(array, i, s.getValue()) + "\n");
                    }
                    ++i;
                }
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void dumpSubscriptSpace(BufferedWriter bw) {
        try {
            bw.append("array,subNum,alphabetic,numeric\n");
            for (String array : this.allocatedIndicies.keySet()) {
                Map<Integer, Map<String, Integer>> arrayMap = this.allocatedIndicies.get(array);
                int dimension = 0;
                while (dimension < arrayMap.keySet().size()) {
                    Map<String, Integer> indexMap = arrayMap.get(dimension);
                    for (String subscript : indexMap.keySet()) {
                        bw.append(String.valueOf(array) + "," + dimension + "," + subscript + "," + indexMap.get(subscript) + "\n");
                    }
                    ++dimension;
                }
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void printSubscriptSpace() {
        System.out.println("array,subNum,alphabetic,numeric");
        for (String array : this.allocatedIndicies.keySet()) {
            Map<Integer, Map<String, Integer>> arrayMap = this.allocatedIndicies.get(array);
            int dimension = 0;
            while (dimension < arrayMap.keySet().size()) {
                Map<String, Integer> indexMap = arrayMap.get(dimension);
                for (String subscript : indexMap.keySet()) {
                    System.out.println(String.valueOf(array) + "," + dimension + "," + subscript + "," + indexMap.get(subscript));
                }
                ++dimension;
            }
        }
    }

    public void populateArraySubscriptSpace() {
        for (String array : this.arrays.keySet()) {
            this.subscriptSpace.put(array, new HashMap());
            Map<Integer, Set<Subscript>> arraySubscriptSpace = this.subscriptSpace.get(array);
            this.allocatedIndicies.put(array, new HashMap());
            ArrayDefinition ad = this.arrays.get(array);
            int dim = 0;
            while (dim < ad.getNumDimensions()) {
                arraySubscriptSpace.put(dim, new HashSet());
                this.allocatedIndicies.get(array).put(dim, new HashMap());
                Set<Subscript> subscripts = arraySubscriptSpace.get(dim);
                for (String sub : ad.getSubscriptReferencesForPos(dim)) {
                    sub = sub.replace("!", "");
                    Subscript s = new Subscript(sub, InformationManagers.getInstance().getNamedSubscriptManager().isNamedSubscript(sub) ? Subscript.NAMED : "Terminal");
                    subscripts.add(s);
                    this.expand(s);
                    s.computeInitialStartEnd();
                }
                Map<String, Integer> allocatedIndiciesForArrayDimension = this.allocatedIndicies.get(array).get(dim);
                this.allocateIndicies(subscripts, allocatedIndiciesForArrayDimension);
                ++dim;
            }
        }
        for (String array : this.arrays.keySet()) {
            this.uninitializedSubscriptCombinationsByArray.put(array, this.generateCombinationsByPos(array));
        }
    }

    private void allocateIndicies(Set<Subscript> subscripts, Map<String, Integer> allocatedIndiciesForArrayDimension) {
        ArrayList<Subscript> subscriptsSortedByNumChildren = new ArrayList<Subscript>();
        subscriptsSortedByNumChildren.addAll(subscripts);
        Collections.sort(subscriptsSortedByNumChildren, new Comparator<Subscript>(){

            @Override
            public int compare(Subscript o1, Subscript o2) {
                int returnValue = 0;
                returnValue = o1.getChildren() == null && o2.getChildren() == null ? o1.getValue().compareTo(o2.getValue()) : (o1.getChildren() != null && o2.getChildren() == null ? -1 : (o1.getChildren() == null && o2.getChildren() != null ? 1 : (o1.getChildren().size() < o2.getChildren().size() ? 1 : (o1.getChildren().size() > o2.getChildren().size() ? -1 : o1.getChildren().get(0).getValue().compareTo(o2.getChildren().get(0).getValue())))));
                return returnValue;
            }
        });
        ArrayList<String> allTerminals = new ArrayList<String>();
        for (Subscript s : subscriptsSortedByNumChildren) {
            List<String> allTerm = InformationManagers.getInstance().getNamedSubscriptManager().getValuesFor(s.getValue());
            for (String t : allTerm) {
                if (allTerminals.contains(t)) continue;
                allTerminals.add(t);
            }
        }
        Iterator iter = allTerminals.iterator();
        int index = 0;
        while (iter.hasNext()) {
            String next = (String)iter.next();
            allocatedIndiciesForArrayDimension.put(next, index++);
        }
    }

    private List<Subscript> getNamed(Set<Subscript> subscripts) {
        ArrayList<Subscript> list = new ArrayList<Subscript>();
        for (Subscript subscript : subscripts) {
            if (!subscript.isNamed()) continue;
            list.add(subscript);
        }
        return list;
    }

    private List<Subscript> getTerminal(Set<Subscript> subscripts) {
        ArrayList<Subscript> list = new ArrayList<Subscript>();
        for (Subscript subscript : subscripts) {
            if (!subscript.isTerminal()) continue;
            list.add(subscript);
        }
        return list;
    }

    private void expand(Subscript subscript) {
        if (subscript.isTerminal()) {
            return;
        }
        List<String> values = InformationManagers.getInstance().getNamedSubscriptManager().getValuesFor(subscript.getValue());
        for (String sub : values) {
            sub = sub.replace("!", "");
            Subscript s = new Subscript(sub, InformationManagers.getInstance().getNamedSubscriptManager().isNamedSubscript(sub) ? Subscript.NAMED : "Terminal");
            subscript.addChild(s);
            this.expand(s);
        }
    }

    private Set<String> generateCombinationsByPos(String array) {
        HashSet<String> combos = new HashSet<String>();
        Map<Integer, Set<Subscript>> arraySubscriptSpace = this.subscriptSpace.get(array);
        ArrayDefinition ad = this.arrays.get(array);
        Integer[] sizeByPos = new Integer[ad.getNumDimensions()];
        int pos = 0;
        while (pos < ad.getNumDimensions()) {
            sizeByPos[pos] = arraySubscriptSpace.get(pos).size();
            ++pos;
        }
        ArrayList<String> posNames = new ArrayList<String>();
        int numPermutations = 1;
        int pos2 = 0;
        while (pos2 < ad.getNumDimensions()) {
            numPermutations *= sizeByPos[pos2].intValue();
            posNames.add(Integer.toString(pos2));
            ++pos2;
        }
        SubscriptCombination[] combinations = new SubscriptCombination[numPermutations];
        int i = 0;
        while (i < numPermutations) {
            combinations[i] = new SubscriptCombination(posNames);
            ++i;
        }
        int subscriptNumber = 0;
        while (subscriptNumber < ad.getNumDimensions()) {
            String[] subValues = new String[arraySubscriptSpace.get(subscriptNumber).size()];
            int s = 0;
            for (Subscript subr : arraySubscriptSpace.get(subscriptNumber)) {
                subValues[s++] = subr.getValue();
            }
            int numPerValue = 1;
            int i2 = subscriptNumber + 1;
            while (i2 < sizeByPos.length) {
                numPerValue *= sizeByPos[i2].intValue();
                ++i2;
            }
            int row = 0;
            while (row < numPermutations) {
                String[] stringArray = subValues;
                int n = subValues.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    int i3 = 0;
                    while (i3 < numPerValue) {
                        combinations[row].addSubscriptValue((String)posNames.get(subscriptNumber), value);
                        ++row;
                        ++i3;
                    }
                    ++n2;
                }
            }
            ++subscriptNumber;
        }
        i = 0;
        while (i < combinations.length) {
            combos.add(combinations[i].getSubscriptValue());
            ++i;
        }
        return combos;
    }

    public void initialized(String arrayReference) {
        ArrayReference ar = new ArrayReference(arrayReference);
        String arrayName = ar.getArrayName();
        Set<String> uninitialized = this.uninitializedSubscriptCombinationsByArray.get(arrayName);
        String[] subscripts = ar.getSubscriptsAsArray();
        for (SubscriptCombination sc : this.getSubscriptValueCombinations(subscripts)) {
            uninitialized.remove(sc.getSubscriptValue());
        }
    }

    public boolean isInitialized(String arrayReference) {
        ArrayReference ar = new ArrayReference(arrayReference);
        String arrayName = ar.getArrayName();
        Set<String> uninitialized = this.uninitializedSubscriptCombinationsByArray.get(arrayName);
        String[] subscripts = ar.getSubscriptsAsArray();
        for (SubscriptCombination sc : this.getSubscriptValueCombinations(subscripts)) {
            if (!uninitialized.contains(sc.getSubscriptValue())) continue;
            return false;
        }
        return true;
    }

    public List<SubscriptCombination> getSubscriptValueCombinations(String ... strings) {
        ArrayList<List<String>> bySubscriptValue = new ArrayList<List<String>>();
        ArrayList<SubscriptCombination> values = new ArrayList<SubscriptCombination>();
        ArrayList<String> order = new ArrayList<String>();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String subscriptName = stringArray[n2];
            bySubscriptValue.add(ArrayManager.extractSubscripts(this.getSubscriptValues(subscriptName)));
            order.add(subscriptName);
            ++n2;
        }
        int numPermutations = 1;
        int i = 0;
        while (i < bySubscriptValue.size()) {
            numPermutations *= ((List)bySubscriptValue.get(i)).size();
            ++i;
        }
        SubscriptCombination[] combinations = new SubscriptCombination[numPermutations];
        int i2 = 0;
        while (i2 < numPermutations) {
            combinations[i2] = new SubscriptCombination(order);
            ++i2;
        }
        int subscriptNumber = 0;
        while (subscriptNumber < strings.length) {
            int numPerValue = 1;
            int i3 = subscriptNumber + 1;
            while (i3 < bySubscriptValue.size()) {
                numPerValue *= ((List)bySubscriptValue.get(i3)).size();
                ++i3;
            }
            int row = 0;
            while (row < numPermutations) {
                for (String value : (List)bySubscriptValue.get(subscriptNumber)) {
                    int i4 = 0;
                    while (i4 < numPerValue) {
                        combinations[row].addSubscriptValue(strings[subscriptNumber], value);
                        ++row;
                        ++i4;
                    }
                }
            }
            ++subscriptNumber;
        }
        SubscriptCombination[] subscriptCombinationArray = combinations;
        int n3 = combinations.length;
        int n4 = 0;
        while (n4 < n3) {
            SubscriptCombination combo = subscriptCombinationArray[n4];
            values.add(combo);
            ++n4;
        }
        return values;
    }

    public List<String> getSubscriptValues(String subscriptName) {
        ArrayList<String> al = new ArrayList<String>();
        if (this.isNamedSubscript(subscriptName)) {
            for (String v : EquationProcessor.subscriptValues.get(subscriptName)) {
                if (this.isNamedSubscript(v)) {
                    al.addAll(this.getSubscriptValues(v));
                    continue;
                }
                al.add(v);
            }
        } else {
            al.add(subscriptName);
        }
        return al;
    }

    public boolean isNamedSubscript(String subscriptName) {
        return EquationProcessor.subscriptValues.containsKey(subscriptName);
    }

    public boolean isTerminalSubscript(String arrayName, String subscriptName, int dimension) {
        Map<Integer, Map<String, Integer>> alloc = this.allocatedIndicies.get(arrayName);
        if (alloc == null) {
            return false;
        }
        Map<String, Integer> indicies = alloc.get(dimension);
        if (indicies == null) {
            return false;
        }
        return indicies.containsKey(subscriptName);
    }

    public int getTerminalValue(String arrayName, String subscriptName, int dimension) {
        Map<Integer, Map<String, Integer>> alloc = this.allocatedIndicies.get(arrayName);
        if (alloc == null) {
            return -1;
        }
        Map<String, Integer> indicies = alloc.get(dimension);
        if (indicies == null) {
            return -1;
        }
        if (indicies.containsKey(subscriptName)) {
            return indicies.get(subscriptName);
        }
        return -1;
    }

    private static List<String> extractSubscripts(List<String> subscriptList) {
        ArrayList<String> al = new ArrayList<String>();
        for (String token : subscriptList) {
            if (token.equals("[") || token.equals(",") || token.equals("]")) continue;
            al.add(token);
        }
        return al;
    }

    public void getNumRowsAndCols(String arrayName, String subscript, MutableInteger numRows, MutableInteger numCols) {
        int numCol = -1;
        int numRow = 1;
        List<String> subs = this.extractSubscripts(subscript);
        int i = subs.size() - 1;
        while (i >= 0) {
            if (InformationManagers.getInstance().getNamedSubscriptManager().isNamedSubscript(subs.get(i))) {
                if (numCol == -1) {
                    numCol = InformationManagers.getInstance().getNamedSubscriptManager().getValuesFor(subs.get(i)).size();
                } else {
                    numRow *= InformationManagers.getInstance().getNamedSubscriptManager().getValuesFor(subs.get(i)).size();
                }
            }
            --i;
        }
        numRows.setValue(numRow);
        numCols.setValue(numCol);
    }

    private List<String> extractSubscripts(String subscriptList) {
        String[] subs = subscriptList.split(",");
        ArrayList<String> al = new ArrayList<String>();
        String[] stringArray = subs;
        int n = subs.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            al.add(token);
            ++n2;
        }
        return al;
    }

    public Set<String> expand(ArrayReference arrRef) {
        HashSet<String> al = new HashSet<String>();
        for (SubscriptCombination sc : this.getSubscriptValueCombinations(arrRef.getSubscriptsAsArray())) {
            al.add("array." + arrRef.getArrayName() + "[" + sc.getSubscriptValue() + "]");
        }
        return al;
    }

    public Set<String> expandRawSubscript(ArrayReference arrRef) {
        HashSet<String> al = new HashSet<String>();
        for (SubscriptCombination sc : this.getSubscriptValueCombinations(arrRef.getSubscriptsAsArray())) {
            al.add("[" + sc.getSubscriptValue() + "]");
        }
        return al;
    }

    public boolean areArraysUsed() {
        return this.arrays.size() > 0;
    }
}

