/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.support;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import repast.simphony.systemdynamics.support.ArrayReference;
import repast.simphony.systemdynamics.support.Data;
import repast.simphony.systemdynamics.support.SDModel;

public class VDM
extends Data {
    private String file;
    private int timePointer = 0;

    public VDM(SDModel model) {
        super(model);
    }

    public void advanceTime() {
        Data modelData = this.model.getData();
        for (String var : this.data.keySet()) {
            List values = (List)this.dataHistory.get(var);
            if (this.timePointer >= values.size()) {
                modelData.setValue(var, (Double)values.get(values.size() - 1));
                continue;
            }
            modelData.setValue(var, (Double)values.get(this.timePointer));
        }
        for (String array : this.arrays.keySet()) {
            modelData.registerArray(array);
            Map map = (Map)this.arraysHistory.get(array);
            for (String subscript : map.keySet()) {
                List values = (List)map.get(subscript);
                if (this.timePointer >= values.size()) {
                    modelData.arraySetValue(array, subscript, (Double)values.get(values.size() - 1));
                    continue;
                }
                modelData.arraySetValue(array, subscript, (Double)values.get(this.timePointer));
            }
        }
        ++this.timePointer;
    }

    public void loadFromFile() {
        this.loadFromFile(this.file);
    }

    public void loadFromFile(String file) {
        BufferedReader fileReader = null;
        try {
            fileReader = new BufferedReader(new FileReader(new File(file)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            String aLine = fileReader.readLine();
            while (aLine != null) {
                this.process(aLine);
                aLine = fileReader.readLine();
            }
            fileReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void process(String aLine) {
        String[] tokens = this.split(aLine);
        String variable = tokens[0].replace("\"", "");
        if (ArrayReference.isArrayReference(variable)) {
            ArrayReference ar = new ArrayReference(variable);
            this.registerArray(ar.getArrayName());
            int i = 1;
            while (i < tokens.length) {
                this.arraySetValue(ar.getArrayName(), ar.getSubscript(), Double.parseDouble(tokens[i]));
                ++i;
            }
        } else {
            int i = 1;
            while (i < tokens.length) {
                this.setValue(variable, Double.parseDouble(tokens[i]));
                ++i;
            }
        }
    }

    private String[] split(String line) {
        ArrayList<String> al = new ArrayList<String>();
        if (line.startsWith("\"")) {
            String[] x = line.split("\"");
            al.add(x[1]);
            String[] stringArray = x[2].substring(1).split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                al.add(s);
                ++n2;
            }
        } else {
            return line.split(",");
        }
        return al.toArray(new String[al.size()]);
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }
}

