/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.support;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import repast.simphony.systemdynamics.support.MutableInteger;

public class Utilities {
    public static BufferedWriter openFileForWriting(String filename) {
        BufferedWriter report = null;
        try {
            File aFile = new File(filename);
            report = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(aFile, false)));
        }
        catch (FileNotFoundException e) {
            System.out.println(String.valueOf(filename) + " FileNotFoundException");
            e.printStackTrace();
        }
        return report;
    }

    public static int getRowFromCellAddress(String cellAddress) {
        int row = 1;
        String rc = cellAddress;
        if (cellAddress.contains("!")) {
            rc = cellAddress.split("!")[1];
        }
        int rowPos = Utilities.getFirstNumberPosition(rc);
        row = Integer.parseInt(rc.substring(rowPos));
        return row;
    }

    public static int getColumnFromCellAddress(String cellAddress) {
        int column = 1;
        String rc = cellAddress;
        if (cellAddress.contains("!")) {
            rc = cellAddress.split("!")[1];
        }
        int rowPos = Utilities.getFirstNumberPosition(rc);
        column = Utilities.convertColumnToNumber(rc.substring(0, rowPos));
        return column;
    }

    public static int convertColumnToNumber(String column) {
        int num = 0;
        int pos = 0;
        char[] chars = column.toCharArray();
        int i = chars.length - 1;
        while (i >= 0) {
            num = (int)((double)num + (double)(Character.getNumericValue(chars[i]) - 9) * Math.pow(26.0, pos++));
            --i;
        }
        return num;
    }

    private static int getFirstNumberPosition(String address) {
        MutableInteger pos = new MutableInteger(0);
        while (Utilities.inRange(address, pos) && Character.isLetter(Utilities.characterAt(address, pos).toCharArray()[0])) {
            pos.add(1);
        }
        return pos.value();
    }

    private static boolean inRange(String equation, MutableInteger position) {
        return position.value() <= equation.length() - 1;
    }

    private static String characterAt(String equation, MutableInteger position) {
        return equation.substring(position.value(), position.value() + 1);
    }
}

