/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import repast.simphony.systemdynamics.support.ArrayReference;
import repast.simphony.systemdynamics.support.Data;
import repast.simphony.systemdynamics.translator.ArrayReferenceNative;

public class TimeSeriesData {
    public boolean nativeDataTypes = true;
    public static final int INTERPOLATE = 0;
    public static final int LOOK_FORWARD = 1;
    public static final int HOLD_BACKWORD = -1;
    private HashMap<String, Map<String, Map<Double, Double>>> timeSeriesData = new HashMap();
    private int betweenTimeMode = 0;

    public void addTimeSeries(Data data, String arrayOrScalar, String subscript, double[] time, double[] values, String btwnMode) {
        this.addTimeSeries(data, arrayOrScalar, subscript, time, values);
        if (btwnMode.equals(":INTERPOLATE:")) {
            this.betweenTimeMode = 0;
        } else if (btwnMode.equals(":LOOK FORWARD:")) {
            this.betweenTimeMode = 1;
        } else if (btwnMode.equals(":HOLD BACKWARD:")) {
            this.betweenTimeMode = -1;
        }
    }

    public void addTimeSeries(Data data, String arrayOrScalar, String subscript, double[] time, double[] values) {
        Map<String, Map<Double, Double>> timeSeries;
        if (!this.timeSeriesData.containsKey(arrayOrScalar)) {
            this.timeSeriesData.put(arrayOrScalar, new HashMap());
        }
        if (!(timeSeries = this.timeSeriesData.get(arrayOrScalar)).containsKey(subscript)) {
            timeSeries.put(subscript, new HashMap());
        }
        Map<Double, Double> series = timeSeries.get(subscript);
        int i = 0;
        while (i < time.length) {
            series.put(time[i], values[i]);
            ++i;
        }
        if (!subscript.equals("")) {
            data.registerArray(arrayOrScalar);
        }
    }

    public void advanceTime(Data data, double time) {
        for (String arrayOrScalar : this.timeSeriesData.keySet()) {
            Map<String, Map<Double, Double>> timeSeries = this.timeSeriesData.get(arrayOrScalar);
            for (String subscript : timeSeries.keySet()) {
                Map<Double, Double> series = timeSeries.get(subscript);
                if (series.containsKey(time)) {
                    if (subscript.equals("")) {
                        data.setValue(arrayOrScalar, series.get(time));
                        continue;
                    }
                    data.arraySetValue(arrayOrScalar, subscript, series.get(time));
                    continue;
                }
                if (subscript.equals("")) {
                    data.setValue(arrayOrScalar, this.getDataBetweenTimes(arrayOrScalar, time, this.betweenTimeMode));
                    continue;
                }
                if (!this.nativeDataTypes) {
                    data.arraySetValue(arrayOrScalar, subscript, this.getDataBetweenTimes(String.valueOf(arrayOrScalar) + "[" + subscript + "]", time, this.betweenTimeMode));
                    continue;
                }
                data.arraySetValue(arrayOrScalar, subscript, this.getDataBetweenTimes(String.valueOf(arrayOrScalar) + subscript, time, this.betweenTimeMode));
            }
        }
    }

    public double getDataForTime(String name, String subs, double time) {
        Map<Double, Double> map = this.timeSeriesData.get(name).get(subs);
        return map.get(time);
    }

    public List<Double> getTimesFor(String name, String subs) {
        ArrayList<Double> al = new ArrayList<Double>();
        Map<Double, Double> map = this.timeSeriesData.get(name).get(subs);
        for (Double time : map.keySet()) {
            al.add(time);
        }
        Collections.sort(al);
        return al;
    }

    public double getDataBetweenTimes(String tsDataName, double time, double mode) {
        Object ar;
        double result = 0.0;
        String name = null;
        String subs = null;
        if (!this.nativeDataTypes) {
            ar = new ArrayReference(tsDataName);
            name = ((ArrayReference)ar).getArrayName();
            subs = ((ArrayReference)ar).getSubscriptsAsMethodParameters().replace("\"", "");
        } else {
            ar = new ArrayReferenceNative(tsDataName);
            name = ((ArrayReferenceNative)ar).getArrayName();
            subs = ((ArrayReferenceNative)ar).getSubscriptsAsMethodParameters().replace("\"", "");
        }
        List<Double> times = this.getTimesFor(name, subs);
        if (mode == -1.0) {
            return this.getDataForTime(name, subs, this.getIndexPrior(times, time));
        }
        if (mode == 1.0) {
            return this.getDataForTime(name, subs, this.getIndexAfter(times, time));
        }
        int prior = this.getIndexPrior(times, time);
        if (prior == times.size() - 1) {
            return this.getDataForTime(name, subs, times.get(prior));
        }
        double v1 = this.getDataForTime(name, subs, times.get(prior));
        double v2 = this.getDataForTime(name, subs, times.get(prior + 1));
        double timeStep = times.get(prior + 1) - times.get(prior);
        double deltaT = time - times.get(prior);
        result = v1 + (v2 - v1) * deltaT / timeStep;
        return result;
    }

    private int getIndexPrior(List<Double> times, double time) {
        int index = 0;
        index = 0;
        while (index < times.size() - 1) {
            if (times.get(index) >= time) {
                return index == 0 ? 0 : index - 1;
            }
            ++index;
        }
        return times.size() - 1;
    }

    private int getIndexAfter(List<Double> times, double time) {
        return this.getIndexPrior(times, time) + 1;
    }

    public boolean hasTimeSeriesFor(String name) {
        String n = "";
        n = ArrayReference.isArrayReference(name) ? new ArrayReference(name).getArrayName() : name;
        return this.timeSeriesData.containsKey(n);
    }

    public boolean isNativeDataTypes() {
        return this.nativeDataTypes;
    }

    public void setNativeDataTypes(boolean nativeDataTypes) {
        this.nativeDataTypes = nativeDataTypes;
    }
}

