/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.support;

import java.util.ArrayList;
import java.util.List;

public class Subscript {
    public static String NAMED = "Named";
    public static final String TERMINAL = "Terminal";
    private String type;
    private String value;
    private int startPos;
    private int endPos;
    private List<Subscript> children;

    public Subscript(String value, String type) {
        this.value = value;
        this.type = type;
    }

    public void addChild(Subscript s) {
        if (this.children == null) {
            this.children = new ArrayList<Subscript>();
        }
        this.children.add(s);
    }

    public int getNumberOfTerminal() {
        return this.endPos - this.startPos + 1;
    }

    public void printDetail() {
        if (this.isNamed()) {
            System.out.println("Type: " + this.type + " Value: " + this.value);
            String spacing = "    ";
            for (Subscript s : this.children) {
                s.printDetail(spacing);
            }
        } else {
            System.out.println("Type: " + this.type + " Value: " + this.value);
        }
    }

    private void printDetail(String spacing) {
        if (this.isNamed()) {
            System.out.println(String.valueOf(spacing) + " Type: " + this.type + " Value: " + this.value);
            spacing = String.valueOf(spacing) + "    ";
            for (Subscript s : this.children) {
                s.printDetail(spacing);
            }
        } else {
            System.out.println(String.valueOf(spacing) + " Type: " + this.type + " Value: " + this.value);
        }
    }

    public void addOffset(int offset) {
        this.startPos += offset;
        this.endPos += offset;
    }

    public void computeInitialStartEnd() {
        this.startPos = 0;
        this.endPos = this.computeEnd(this) - 1;
    }

    public int computeEnd(Subscript subscript) {
        if (subscript.getType().equals(TERMINAL)) {
            return 1;
        }
        int end = 0;
        for (Subscript s : subscript.getChildren()) {
            end += this.computeEnd(s);
        }
        return end;
    }

    public boolean isTerminal() {
        return this.type.equals(TERMINAL);
    }

    public boolean isNamed() {
        return this.type.equals(NAMED);
    }

    public String toString() {
        return String.valueOf(this.value) + "," + this.type + "," + this.startPos + "," + this.endPos;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public void setStartPos(int startPos) {
        this.startPos = startPos;
    }

    public int getEndPos() {
        return this.endPos;
    }

    public void setEndPos(int endPos) {
        this.endPos = endPos;
    }

    public List<Subscript> getChildren() {
        return this.children;
    }

    public void setChildren(List<Subscript> children) {
        this.children = children;
    }
}

