/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.support;

import cern.jet.random.Beta;
import cern.jet.random.Binomial;
import cern.jet.random.Exponential;
import cern.jet.random.Gamma;
import cern.jet.random.Normal;
import cern.jet.random.Poisson;
import cern.jet.random.Uniform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import repast.simphony.systemdynamics.support.SDFunctions;
import repast.simphony.systemdynamics.support.SDModel;
import repast.simphony.systemdynamics.support.TimeSeriesInstance;
import repast.simphony.systemdynamics.support.Utilities;

public class SDFunctionsWithXLSColt
extends SDFunctions {
    private Map<String, XSSFWorkbook> workbooks = new HashMap<String, XSSFWorkbook>();
    private Uniform uniformDistribution = null;
    private Beta betaDistribution = null;
    private Binomial binomialDistribution = null;
    private Exponential exponentialDistribution = null;
    private Gamma gammaDistribution = null;
    private Normal normalDistribution = null;
    private Poisson poissonDistribution = null;

    public SDFunctionsWithXLSColt(SDModel model) {
        super(model);
    }

    private XSSFWorkbook getWorkbook(String name) {
        try {
            if (!this.workbooks.containsKey(name)) {
                this.workbooks.put(name, new XSSFWorkbook(name));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.workbooks.get(name);
    }

    public double GETXLSCONSTANTS(String book, String tab, String cell) {
        XSSFWorkbook wb = this.getWorkbook(book);
        XSSFSheet sheet = wb.getSheet(tab);
        return this.getNumericDataInCell(sheet, cell);
    }

    public double[] GETXLSCONSTANTS(String book, String tab, String cell, int numRows, int numColumns) {
        double[] fromXls = new double[numRows * numColumns];
        int startRow = this.getRowNumberFromCellAddress(cell);
        int startCol = this.getColumnNumberFromCellAddress(cell);
        XSSFWorkbook wb = this.getWorkbook(book);
        XSSFSheet sheet = wb.getSheet(tab);
        int pos = 0;
        int r = startRow;
        while (r < startRow + numRows) {
            int c = startCol;
            while (c < startCol + numColumns) {
                fromXls[pos++] = this.getNumericDataInCell(sheet, r, c);
                ++c;
            }
            ++r;
        }
        return fromXls;
    }

    public double GETXLSCONSTANTS(String varName, double currentValue, double time, double timeStep, String book, String tab, String cell) {
        XSSFWorkbook wb = this.getWorkbook(book);
        XSSFSheet sheet = wb.getSheet(tab);
        return this.getNumericDataInCell(sheet, cell);
    }

    private double getNumericDataInCell(XSSFSheet sheet, int row, int col) {
        Cell aCell;
        block7: {
            Iterator rowIt = sheet.rowIterator();
            int currentRow = 0;
            int currentColumn = 0;
            Row aRow = null;
            aCell = null;
            while (rowIt.hasNext()) {
                aRow = (Row)rowIt.next();
                currentRow = aRow.getRowNum() + 1;
                if (currentRow == row) break;
            }
            if (currentRow < row) {
                return -1.0;
            }
            Iterator cellIt = aRow.cellIterator();
            while (cellIt.hasNext()) {
                aCell = (Cell)cellIt.next();
                currentColumn = aCell.getColumnIndex() + 1;
                if (currentColumn == col) break;
            }
            if (currentColumn < col) {
                return -1.0;
            }
            try {
                int t = aCell.getCellType();
                if (t != 1) break block7;
                String s = aCell.getStringCellValue();
                return -1.0;
            }
            catch (Exception e) {
                return -1.0;
            }
        }
        double val = aCell.getNumericCellValue();
        return val;
    }

    private double getNumericDataInCell(XSSFSheet sheet, String cell) {
        return this.getNumericDataInCell(sheet, this.getRowNumberFromCellAddress(cell), this.getColumnNumberFromCellAddress(cell));
    }

    private double[] getTimeValues(XSSFSheet sheet, String timeRowOrCol, int startRow, int startCol) {
        double value;
        int col;
        int row;
        ArrayList<Double> timeList = new ArrayList<Double>();
        double[] timeArray = null;
        boolean byRow = SDFunctionsWithXLSColt.isInteger(timeRowOrCol);
        double previousValue = -1.0;
        if (byRow) {
            row = Integer.parseInt(timeRowOrCol);
            col = startCol;
            value = this.getNumericDataInCell(sheet, row, col++);
            while (value >= 0.0 && value > previousValue) {
                timeList.add(value);
                previousValue = value;
                value = this.getNumericDataInCell(sheet, row, col++);
            }
        } else {
            row = startRow;
            col = Utilities.convertColumnToNumber(timeRowOrCol);
            value = this.getNumericDataInCell(sheet, row++, col);
            while (value >= 0.0 && value > previousValue) {
                timeList.add(value);
                previousValue = value;
                value = this.getNumericDataInCell(sheet, row++, col);
            }
        }
        timeArray = new double[timeList.size()];
        int pos = 0;
        Iterator iterator = timeList.iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            timeArray[pos++] = d;
        }
        return timeArray;
    }

    public double GETXLSDATA(String varName, double currentValue, double time, double timeStep, String book, String tab, String timeRowOrCol, String cell) {
        this.notImplemented();
        return -999.0;
    }

    public TimeSeriesInstance GETXLSLOOKUPS(String book, String tab, String timeRowOrCol, String cell, int numRows, int numColumns) {
        return this.GETXLSDATA(book, tab, timeRowOrCol, cell, numRows, numColumns);
    }

    public TimeSeriesInstance GETXLSDATA(String book, String tab, String timeRowOrCol, String cell, int numRows, int numColumns) {
        TimeSeriesInstance tsi = null;
        XSSFWorkbook wb = this.getWorkbook(book);
        XSSFSheet sheet = wb.getSheet(tab);
        boolean byRow = SDFunctionsWithXLSColt.isInteger(timeRowOrCol);
        int startRow = this.getRowNumberFromCellAddress(cell);
        int startCol = this.getColumnNumberFromCellAddress(cell);
        double[] timeValues = this.getTimeValues(sheet, timeRowOrCol, startRow, startCol);
        double[] fromXls = new double[numRows * numColumns * timeValues.length];
        int pos = 0;
        if (byRow) {
            int r = startRow;
            while (r < startRow + numRows) {
                int c = startCol;
                while (c < startCol + timeValues.length) {
                    fromXls[pos++] = this.getNumericDataInCell(sheet, r, c);
                    ++c;
                }
                ++r;
            }
        } else {
            int c = startCol;
            while (c < startCol + numColumns) {
                int r = startRow;
                while (r < startRow + timeValues.length) {
                    fromXls[pos++] = this.getNumericDataInCell(sheet, r, c);
                    ++r;
                }
                ++c;
            }
        }
        tsi = new TimeSeriesInstance(timeValues, fromXls);
        return tsi;
    }

    public double RANDOMUNIFORM(String varName, double currentValue, double time, double timeStep, double arg1, double arg2, double arg3) {
        if (this.uniformDistribution == null) {
            this.uniformDistribution = new Uniform(arg1, arg2, (int)arg3);
        }
        return this.uniformDistribution.nextDouble();
    }
}

