/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.support;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import repast.simphony.systemdynamics.support.DelayedMapping;
import repast.simphony.systemdynamics.support.SubscriptCombination;
import repast.simphony.systemdynamics.translator.InformationManagers;

public class MappedSubscriptManager {
    public Map<String, Map<String, Map<String, String>>> subscriptNameMap = new HashMap<String, Map<String, Map<String, String>>>();
    private List<DelayedMapping> delayedMappings = new ArrayList<DelayedMapping>();

    public boolean isMapBetween(String equationRHS, String equationLHS) {
        boolean map = false;
        if (this.subscriptNameMap.containsKey(equationRHS)) {
            Map<String, Map<String, String>> level1 = this.subscriptNameMap.get(equationRHS);
            return level1.containsKey(equationLHS);
        }
        return map;
    }

    public void addSubscriptNameMapping(String definitionLHS, String definitionRHS) {
        Map<String, Map<String, String>> mappings;
        if (!this.subscriptNameMap.containsKey(definitionLHS)) {
            this.subscriptNameMap.put(definitionLHS, new HashMap());
        }
        if (!(mappings = this.subscriptNameMap.get(definitionLHS)).containsKey(definitionRHS)) {
            mappings.put(definitionRHS, new HashMap());
        }
    }

    public void addSubscriptNameFullSubrangeMapping(String definitionLHS, String definitionRHS) {
        this.addSubscriptNameMapping(definitionLHS, definitionRHS);
        this.delayedMappings.add(new DelayedMapping(definitionLHS, definitionRHS));
    }

    public void addSubscriptValueMapping(String definitionLHS, String definitionRHS, String definitionLHSValue, String definitionRHSValue) {
        Map<String, Map<String, String>> mappings = this.subscriptNameMap.get(definitionLHS);
        Map<String, String> valueMap = mappings.get(definitionRHS);
        valueMap.put(definitionRHSValue, definitionLHSValue);
    }

    public void addSubscriptValueMappingDelayed(String definitionLHS, String definitionRHS, List<String> definitionLHSValues) {
        this.delayedMappings.add(new DelayedMapping(definitionLHS, definitionRHS, definitionLHSValues));
    }

    public void addSubscriptValueMappingDelayed(String definitionLHS, String definitionRHS, List<String> definitionLHSValues, List<String> definitionRHSValues) {
        this.delayedMappings.add(new DelayedMapping(definitionLHS, definitionRHS, definitionLHSValues, definitionRHSValues));
    }

    public void makeConsistent() {
        for (DelayedMapping delayedMapping : this.delayedMappings) {
            List<String> definitionLHSValues = delayedMapping.getDefinitionLHSValues();
            List<String> definitionRHSValues = delayedMapping.getDefinitionRHSValues();
            if (definitionLHSValues == null) {
                definitionLHSValues = InformationManagers.getInstance().getNamedSubscriptManager().isNamedSubscript(delayedMapping.getDefinitionLHS()) ? InformationManagers.getInstance().getNamedSubscriptManager().getValuesFor(delayedMapping.getDefinitionLHS()) : InformationManagers.getInstance().getNamedSubscriptManager().getValuesFor(delayedMapping.getDefinitionRHS());
            }
            if (definitionRHSValues == null) {
                definitionRHSValues = InformationManagers.getInstance().getNamedSubscriptManager().isNamedSubscript(delayedMapping.getDefinitionRHS()) ? InformationManagers.getInstance().getNamedSubscriptManager().getValuesFor(delayedMapping.getDefinitionRHS()) : InformationManagers.getInstance().getNamedSubscriptManager().getValuesFor(delayedMapping.getDefinitionLHS());
            }
            if (definitionLHSValues.size() <= 0) continue;
            int i = 0;
            while (i < definitionLHSValues.size()) {
                this.addSubscriptValueMapping(delayedMapping.getDefinitionLHS(), delayedMapping.getDefinitionRHS(), definitionLHSValues.get(i), definitionRHSValues.get(i));
                ++i;
            }
        }
        this.delayedMappings.clear();
        for (String definitionLHS : this.subscriptNameMap.keySet()) {
            Map<String, Map<String, String>> mappings = this.subscriptNameMap.get(definitionLHS);
            for (String definitionRHS : mappings.keySet()) {
                Map<String, String> valueMap = mappings.get(definitionRHS);
                if (valueMap.size() > 0) continue;
                for (String value : InformationManagers.getInstance().getNamedSubscriptManager().getValuesFor(definitionRHS)) {
                    this.addSubscriptValueMapping(definitionLHS, definitionRHS, value, value);
                }
            }
        }
        ArrayList<String> level1Key = new ArrayList<String>();
        for (String key : this.subscriptNameMap.keySet()) {
            level1Key.add(key);
        }
        Collections.sort(level1Key);
        for (String key1 : level1Key) {
            Map<String, Map<String, String>> level2Map = this.subscriptNameMap.get(key1);
            ArrayList<String> level2Key = new ArrayList<String>();
            for (String key : level2Map.keySet()) {
                level2Key.add(key);
            }
            Collections.sort(level2Key);
            for (String key2 : level2Key) {
                Map<String, String> level3Map = level2Map.get(key2);
                ArrayList<String> level3Key = new ArrayList<String>();
                for (String key : level3Map.keySet()) {
                    level3Key.add(key);
                }
                Collections.sort(level3Key);
                for (String key3 : level3Key) {
                    if (!InformationManagers.getInstance().getNamedSubscriptManager().isNamedSubscript(key3)) continue;
                    for (String terminal : InformationManagers.getInstance().getNamedSubscriptManager().getValuesFor(key3)) {
                        this.addSubscriptValueMapping(key1, key2, level3Map.get(key3), terminal);
                    }
                }
            }
        }
    }

    public String getSubscriptMapping(String eqLHSnamed, String eqLHSterminal, String eqRHSnamed) {
        Map<String, Map<String, String>> level2Map = this.subscriptNameMap.get(eqRHSnamed);
        Map<String, String> level3Map = level2Map.get(eqLHSnamed);
        String mapped = level3Map.get(eqLHSterminal);
        if (mapped == null) {
            mapped = "MissingMap!";
        }
        return mapped;
    }

    public String getMappedValue(String definitionLHS, String definitionRHS, SubscriptCombination subscriptCombination) {
        if (!this.subscriptNameMap.containsKey(definitionLHS)) {
            return null;
        }
        Map<String, Map<String, String>> mappings = this.subscriptNameMap.get(definitionLHS);
        Map<String, String> valueMap = mappings.get(definitionRHS);
        if (valueMap == null) {
            return null;
        }
        if (valueMap.containsKey(subscriptCombination.getSubscriptValue(definitionRHS))) {
            return valueMap.get(subscriptCombination.getSubscriptValue(definitionRHS));
        }
        return null;
    }

    public String getMappedValue(String definitionLHS, List<String> allDefinitionRHS, SubscriptCombination subscriptCombination) {
        String mappedValue;
        for (String definitionRHS : allDefinitionRHS) {
            mappedValue = this.getMappedValue(definitionLHS, definitionRHS, subscriptCombination);
            if (mappedValue == null) continue;
            return mappedValue;
        }
        for (String lhsSubscript : allDefinitionRHS) {
            mappedValue = this.getMappedValue(definitionLHS, lhsSubscript, subscriptCombination);
            if (mappedValue == null) continue;
            return mappedValue;
        }
        return null;
    }

    public void generateCode(BufferedWriter bw) {
        try {
            for (String definitionLHS : this.subscriptNameMap.keySet()) {
                Map<String, Map<String, String>> mappings = this.subscriptNameMap.get(definitionLHS);
                for (String definitionRHS : mappings.keySet()) {
                    bw.append("MappedSubscriptManager.addSubscriptNameMapping( \"" + definitionLHS + "\", \"" + definitionRHS + "\");\n");
                    Map<String, String> valueMap = mappings.get(definitionRHS);
                    for (String definitionRHSVal : valueMap.keySet()) {
                        bw.append("MappedSubscriptManager.addSubscriptValueMapping( \"" + definitionLHS + "\", \"" + definitionRHS + "\", \"" + valueMap.get(definitionRHSVal) + "\", \"" + definitionRHSVal + "\");\n");
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void dumpMappings(BufferedWriter bw) {
        ArrayList<String> level1Key = new ArrayList<String>();
        try {
            bw.append("EQ RHS,EQ LHS,EQ LHS Sub,EQ RHS Sub,EQ LHS Sub Named,EQ RHS Sub Named,LHS Index,RHS Index\n");
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        for (String key : this.subscriptNameMap.keySet()) {
            level1Key.add(key);
        }
        Collections.sort(level1Key);
        for (String key1 : level1Key) {
            Map<String, Map<String, String>> level2Map = this.subscriptNameMap.get(key1);
            ArrayList<String> level2Key = new ArrayList<String>();
            for (String key : level2Map.keySet()) {
                level2Key.add(key);
            }
            Collections.sort(level2Key);
            for (String key2 : level2Key) {
                Map<String, String> level3Map = level2Map.get(key2);
                ArrayList<String> level3Key = new ArrayList<String>();
                for (String key : level3Map.keySet()) {
                    level3Key.add(key);
                }
                Collections.sort(level3Key);
                for (String key3 : level3Key) {
                    try {
                        bw.append(String.valueOf(key1) + "," + key2 + "," + key3 + "," + level3Map.get(key3) + "," + InformationManagers.getInstance().getNamedSubscriptManager().isNamedSubscript(key3) + "," + InformationManagers.getInstance().getNamedSubscriptManager().isNamedSubscript(level3Map.get(key3)) + "," + InformationManagers.getInstance().getNamedSubscriptManager().getIndex(key2, key3) + "," + InformationManagers.getInstance().getNamedSubscriptManager().getIndex(key1, level3Map.get(key3)) + "\n");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        try {
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

