/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.support;

public class Lookup {
    private String name;
    private double[] xVals;
    private double[] yVals;
    private int outOfBoundsCount = 0;
    private static int MAX_OB = 10;
    private double minX;
    private double minXY;
    private double maxX;
    private double maxXY;

    public Lookup(String name, double minX, double minXY, double maxX, double maxXY, double ... ds) {
        this(name, ds);
        this.minX = minX;
        this.minXY = minXY;
        this.maxX = maxX;
        this.maxXY = maxXY;
    }

    public Lookup(String name, double ... ds) {
        this.name = name;
        int numVals = ds.length / 2;
        this.xVals = new double[numVals];
        this.yVals = new double[numVals];
        int i = 0;
        while (i < numVals) {
            this.xVals[i] = ds[i];
            this.yVals[i] = ds[i + numVals];
            ++i;
        }
    }

    public Lookup(String name, double[] xvals, double[] yvals) {
        this.name = name;
        this.xVals = new double[xvals.length];
        this.yVals = new double[xvals.length];
        int i = 0;
        while (i < xvals.length) {
            this.xVals[i] = xvals[i];
            this.yVals[i] = yvals[i];
            ++i;
        }
    }

    public Double getValue(double x) {
        Double yVal = null;
        if (x < this.xVals[0]) {
            if (++this.outOfBoundsCount <= MAX_OB) {
                System.out.println("WARNING: Below Out of range access to lookup.java: " + this.name + " " + x + " range: " + this.xVals[0] + " - " + this.xVals[this.xVals.length - 1]);
            }
            return this.yVals[0];
        }
        if (x > this.xVals[this.xVals.length - 1]) {
            if (++this.outOfBoundsCount <= MAX_OB) {
                System.out.println("WARNING: Above Out of range access to lookup.java: " + this.name + " " + x + " range: " + this.xVals[0] + " - " + this.xVals[this.xVals.length - 1]);
            }
            return this.yVals[this.yVals.length - 1];
        }
        int pos = 0;
        int i = 0;
        while (i < this.xVals.length) {
            if (this.xVals[i] == x) {
                return this.yVals[i];
            }
            if (x < this.xVals[i]) {
                pos = i - 1;
                break;
            }
            ++i;
        }
        if (this.xVals[pos] == this.xVals[pos + 1]) {
            return null;
        }
        yVal = this.yVals[pos] * (x - this.xVals[pos + 1]) / (this.xVals[pos] - this.xVals[pos + 1]) + this.yVals[pos + 1] * (x - this.xVals[pos]) / (this.xVals[pos + 1] - this.xVals[pos]);
        return yVal;
    }

    public double[][] getAsArray() {
        double[][] look = new double[][]{this.xVals, this.yVals};
        return look;
    }
}

