/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.support;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LogConverter {
    private Map<String, Map<Integer, Map<Integer, String>>> lookup;

    public static void main(String[] args) {
        LogConverter logConverter = new LogConverter();
        logConverter.convert(args);
    }

    public void convert(String[] args) {
        ArrayList<LogRecord> logRecords = new ArrayList();
        ArrayList<SubscriptRecord> subscriptRecords = new ArrayList();
        BufferedReader logReader = LogConverter.openForRead(args[0]);
        BufferedReader subscriptReader = LogConverter.openForRead(args[1]);
        BufferedWriter csvWriter = LogConverter.openForWrite(args[2]);
        logRecords = this.loadLog(logReader);
        subscriptRecords = this.loadSubscript(subscriptReader);
        this.lookup = this.createLookup(subscriptRecords);
        this.mergeAndWrite(logRecords, csvWriter);
    }

    public Map<String, Map<Integer, Map<Integer, String>>> createLookup(List<SubscriptRecord> subscriptRecords) {
        HashMap<String, Map<Integer, Map<Integer, String>>> lookup = new HashMap<String, Map<Integer, Map<Integer, String>>>();
        for (SubscriptRecord rec : subscriptRecords) {
            Map dimensionMap;
            String array = rec.getVariable();
            int dimension = rec.getDimension();
            String subscript = rec.getSubscript();
            int index = rec.getIndex();
            if (!lookup.containsKey(array)) {
                lookup.put(array, new HashMap());
            }
            if (!(dimensionMap = (Map)lookup.get(array)).containsKey(dimension)) {
                dimensionMap.put(dimension, new HashMap());
            }
            Map indexMap = (Map)dimensionMap.get(dimension);
            indexMap.put(index, subscript);
        }
        return lookup;
    }

    public void mergeAndWrite(List<LogRecord> logRecords, BufferedWriter csvWriter) {
        HashMap valueMap = new HashMap();
        for (LogRecord record : logRecords) {
            String variable = record.getVariable();
            List<String> subscripts = record.getSubscripts();
            double time = record.getTime();
            double value = record.getValue();
            String vensimVariable = this.getVensimVariable(variable, subscripts);
            if (!valueMap.containsKey(vensimVariable)) {
                valueMap.put(vensimVariable, new ArrayList());
            }
            List values = (List)valueMap.get(vensimVariable);
            values.add(value);
        }
        try {
            String columnHeaders = this.getColumnHeaders(logRecords);
            int numTimePeriods = columnHeaders.split(",").length - 1;
            csvWriter.append(columnHeaders);
            for (String variable : valueMap.keySet()) {
                csvWriter.append(variable);
                List values = (List)valueMap.get(variable);
                if (values.size() == 1) {
                    Double value = (Double)values.get(0);
                    int i = 0;
                    while (i < numTimePeriods) {
                        csvWriter.append("," + value);
                        ++i;
                    }
                } else {
                    for (Double value : values) {
                        csvWriter.append("," + value);
                    }
                }
                csvWriter.append("\n");
            }
            csvWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getColumnHeaders(List<LogRecord> logRecords) {
        StringBuffer sb = new StringBuffer();
        ArrayList<Double> timeValues = new ArrayList<Double>();
        for (LogRecord logRecord : logRecords) {
            if (timeValues.contains(logRecord.getTime())) continue;
            timeValues.add(logRecord.getTime());
        }
        sb.append("Variable/Time");
        for (Double tv : timeValues) {
            sb.append(",");
            sb.append(tv);
        }
        sb.append("\n");
        return sb.toString();
    }

    public String getVensimVariable(String variable, List<String> subscripts) {
        StringBuffer vensimVariable = new StringBuffer();
        if (subscripts.size() == 0) {
            return variable;
        }
        vensimVariable.append("\"" + variable);
        vensimVariable.append("[");
        int dimension = 0;
        for (String subscript : subscripts) {
            if (dimension > 0) {
                vensimVariable.append(",");
            }
            vensimVariable.append(this.getAlphabeticSubscript(variable, dimension, Integer.parseInt(subscript)));
            ++dimension;
        }
        vensimVariable.append("]\"");
        return vensimVariable.toString();
    }

    public String getAlphabeticSubscript(String array, int dimension, int index) {
        return this.lookup.get(array).get(dimension).get(index);
    }

    public List<LogRecord> loadLog(BufferedReader reader) {
        ArrayList<LogRecord> al = new ArrayList<LogRecord>();
        String aLine = null;
        try {
            aLine = reader.readLine();
            while (aLine != null) {
                al.add(new LogRecord(aLine));
                aLine = reader.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return al;
    }

    public List<SubscriptRecord> loadSubscript(BufferedReader reader) {
        ArrayList<SubscriptRecord> al = new ArrayList<SubscriptRecord>();
        String aLine = null;
        try {
            aLine = reader.readLine();
            aLine = reader.readLine();
            while (aLine != null) {
                al.add(new SubscriptRecord(aLine));
                aLine = reader.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return al;
    }

    public static BufferedWriter openForWrite(String filename) {
        BufferedWriter report = null;
        try {
            File aFile = new File(filename);
            report = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(aFile, false)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return report;
    }

    public static BufferedReader openForRead(String filename) {
        BufferedReader fileReader = null;
        try {
            fileReader = new BufferedReader(new FileReader(new File(filename)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return fileReader;
    }

    public class LogRecord {
        String variable;
        List<String> subscripts;
        double time;
        double value;

        public LogRecord(String aLine) {
            this.parse(aLine);
        }

        public void parse(String aLine) {
            String[] columns = aLine.split(",");
            this.variable = this.extractVariable(columns[0].trim());
            this.subscripts = this.extractSubscripts(columns[0].trim());
            this.time = Double.parseDouble(columns[1].trim());
            this.value = Double.parseDouble(columns[2].trim());
        }

        public String extractVariable(String variable) {
            String var = variable;
            if (!variable.contains("[")) {
                return var;
            }
            var = variable.split("\\[")[0];
            return var;
        }

        public List<String> extractSubscripts(String variable) {
            ArrayList<String> al = new ArrayList<String>();
            if (!variable.contains("[")) {
                return al;
            }
            String[] var = variable.split("\\[");
            int i = 1;
            while (i < var.length) {
                al.add(var[i].replace("]", "").trim());
                ++i;
            }
            return al;
        }

        public String getVariable() {
            return this.variable;
        }

        public void setVariable(String variable) {
            this.variable = variable;
        }

        public List<String> getSubscripts() {
            return this.subscripts;
        }

        public void setSubscripts(List<String> subscripts) {
            this.subscripts = subscripts;
        }

        public double getTime() {
            return this.time;
        }

        public void setTime(double time) {
            this.time = time;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }
    }

    public class SubscriptRecord {
        String variable;
        int dimension;
        String subscript;
        int index;

        public SubscriptRecord(String aLine) {
            this.parse(aLine);
        }

        public void parse(String aLine) {
            String[] columns = aLine.split(",");
            this.variable = columns[0].trim();
            this.dimension = Integer.parseInt(columns[1].trim());
            this.subscript = columns[2].trim();
            this.index = Integer.parseInt(columns[3].trim());
        }

        public String getVariable() {
            return this.variable;
        }

        public void setVariable(String variable) {
            this.variable = variable;
        }

        public int getDimension() {
            return this.dimension;
        }

        public void setDimension(int dimension) {
            this.dimension = dimension;
        }

        public String getSubscript() {
            return this.subscript;
        }

        public void setSubscript(String subscript) {
            this.subscript = subscript;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }
}

