/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.ode;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import repast.simphony.systemdynamics.ode.Constructor;
import repast.simphony.systemdynamics.ode.MethodCalculations;
import repast.simphony.systemdynamics.ode.MethodFooter;
import repast.simphony.systemdynamics.ode.MethodHeader;
import repast.simphony.systemdynamics.ode.ODEAnalyzer;
import repast.simphony.systemdynamics.ode.ObjectFooter;
import repast.simphony.systemdynamics.ode.ObjectHeader;
import repast.simphony.systemdynamics.ode.SetterGetter;
import repast.simphony.systemdynamics.translator.Equation;
import repast.simphony.systemdynamics.translator.InformationManagers;
import repast.simphony.systemdynamics.translator.NativeDataTypeManager;
import repast.simphony.systemdynamics.translator.Node;
import repast.simphony.systemdynamics.translator.Parser;
import repast.simphony.systemdynamics.translator.Translator;
import repast.simphony.systemdynamics.translator.TreeTraversal;

public class ODECodeGenerator {
    private ODEAnalyzer analyzer;
    private String className;
    private String packageName;
    private String runnerName;
    private String contextName;

    public ODECodeGenerator(Map<String, Equation> equations, List<String> orderedEquations, String packageName, String className) {
        this.packageName = packageName;
        this.className = className;
        this.analyzer = new ODEAnalyzer(equations, orderedEquations);
        this.analyzer.analyze();
    }

    public void generateDerivativeClass(BufferedWriter code) {
        ObjectHeader.generate(this, code, this.analyzer, this.packageName, this.className);
        Constructor.generate(this, code, this.analyzer, this.packageName, this.className);
        MethodHeader.generate(this, code, this.analyzer);
        MethodCalculations.generate(this, code, this.analyzer);
        MethodFooter.generate(this, code, this.analyzer);
        SetterGetter.generate(this, code, this.analyzer);
        ObjectFooter.generate(this, code, this.analyzer);
    }

    public void generateRunnerClass(BufferedWriter code, String myClassName) {
        NativeDataTypeManager ndtm = InformationManagers.getInstance().getNativeDataTypeManager();
        this.runnerName = myClassName;
        try {
            Equation eqn;
            String lhs;
            code.append("package " + this.packageName + ";\n\n");
            code.append("import org.apache.commons.math3.ode.FirstOrderIntegrator;\n");
            code.append("import org.apache.commons.math3.ode.nonstiff.EulerIntegrator;\n\n");
            code.append("import repast.simphony.engine.environment.RunEnvironment;\n");
            code.append("import repast.simphony.engine.schedule.ScheduledMethod;\n");
            code.append("import repast.simphony.parameter.Parameters;\n\n");
            code.append("public class " + myClassName + " {\n\n");
            code.append("private double y[] = new double[" + this.analyzer.getNumberODE() + "];\n");
            code.append("FirstOrderIntegrator integrator;\n");
            code.append(this.className + " ode;\n");
            code.append("double timeDelta;\n\n");
            code.append("public " + myClassName + "() {\n\n");
            code.append("\tParameters params = RunEnvironment.getInstance().getParameters();\n");
            code.append("\ttimeDelta = (Double) params.getValue(\"SAVEPER\");\n");
            code.append("\tintegrator = new EulerIntegrator((Double) params.getValue(\"TIME_STEP\"));\n");
            code.append("\tode = new " + this.className + "(\n");
            int i = 0;
            for (Equation eqn2 : this.analyzer.getAuxiliariesForConstructor()) {
                if (i++ > 0) {
                    code.append(",\n");
                }
                code.append("\t\t(Double) params.getValue(\"" + ndtm.makeLegal(eqn2.getLhs()) + "\")");
            }
            code.append("\n\t);\n");
            int n = 0;
            while (n < this.analyzer.getNumberODE()) {
                lhs = this.analyzer.getStockFor(Integer.toString(n));
                eqn = this.analyzer.getEquationForLHS(lhs);
                String initVal = eqn.getIntialValue();
                if (Parser.isNumber(initVal)) {
                    code.append("\ty[" + n + "] = " + initVal + ";\n");
                } else {
                    code.append("\ty[" + n + "] = (Double) params.getValue(\"" + ndtm.makeLegal(initVal) + "\");\n");
                }
                ++n;
            }
            code.append("}\n\n");
            code.append("@ScheduledMethod(start = 1,interval = 1,shuffle = true)\n");
            code.append("public void step() {\n");
            code.append("\tintegrator.integrate(ode, 0.0, y, timeDelta, y);\n");
            code.append("}\n\n");
            code.append("public String getID() {\n");
            code.append("\treturn \"" + myClassName + "\";\n");
            code.append("}\n");
            code.append("public " + this.className + " getOde() {\n");
            code.append("\treturn ode;\n");
            code.append("}\n");
            n = 0;
            while (n < this.analyzer.getNumberODE()) {
                lhs = this.analyzer.getStockFor(Integer.toString(n));
                eqn = this.analyzer.getEquationForLHS(lhs);
                code.append("public double getY" + n + "() {\n");
                code.append("\treturn y[" + n + "];\n");
                code.append("}\n\n");
                ++n;
            }
            code.append("}\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void generateContextBuilderClass(BufferedWriter code, String myClassName, String runnerName) {
        this.contextName = myClassName;
        NativeDataTypeManager ndtm = InformationManagers.getInstance().getNativeDataTypeManager();
        try {
            code.append("package " + this.packageName + ";\n\n");
            code.append("import repast.simphony.context.Context;\n");
            code.append("import repast.simphony.dataLoader.ContextBuilder;\n");
            code.append("import repast.simphony.engine.environment.RunEnvironment;\n");
            code.append("import repast.simphony.parameter.Parameters;\n\n");
            code.append("public class " + myClassName + " implements ContextBuilder<Object> {\n");
            code.append("\t@Override\n");
            code.append("\tpublic Context<Object> build(Context<Object> context) {\n");
            code.append("\t\t" + runnerName + " ode = new " + runnerName + "();\n");
            code.append("\t\tcontext.setId(\"" + this.className + "\");\n");
            code.append("\t\tcontext.add(ode);\n");
            code.append("\t\tcontext.add(ode.getOde());\n\n");
            code.append("\t\tParameters params = RunEnvironment.getInstance().getParameters();\n");
            code.append("\t\tRunEnvironment.getInstance().endAt((Double) params.getValue(\"FINAL_TIME\"));\n");
            code.append("\t\treturn context;\n");
            code.append("\t}\n");
            code.append("}\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String generateExpression(Node node) {
        StringBuffer sb = new StringBuffer();
        if (node != null) {
            if (Parser.isArithmeticOperator(node.getToken()) || Parser.isEqualSign(node.getToken()) || Parser.isRelationalOperator(node.getToken())) {
                if (!Parser.isEqualSign(node.getToken())) {
                    sb.append("(");
                }
                if (!Parser.isUnaryOperator(node.getToken())) {
                    sb.append(this.generateExpression(TreeTraversal.getLhs(node)));
                    sb.append(node.getToken());
                    sb.append(this.generateExpression(TreeTraversal.getRhs(node)));
                } else {
                    sb.append(Parser.translateUnaryOperator(node.getToken()));
                    sb.append(this.generateExpression(node.getChild()));
                }
                if (!Parser.isEqualSign(node.getToken())) {
                    sb.append(")");
                }
                return sb.toString();
            }
            if (Parser.isFunctionInvocation(node.getToken())) {
                sb.append(this.generateFunctionCall(node));
            } else {
                sb.append(node.getToken());
            }
        }
        return sb.toString();
    }

    public String generateFunctionCall(Node node) {
        StringBuffer sb = new StringBuffer();
        if (node != null) {
            sb.append(node.getToken());
            sb.append("(");
            int i = 0;
            Node arg = TreeTraversal.getFunctionArgument(node, 1);
            while (arg != null) {
                if (i++ > 0) {
                    sb.append(",");
                }
                sb.append(this.generateExpression(arg));
                arg = arg.getNext();
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public void makeLocal(Node node) {
        if (node == null) {
            return;
        }
        node.setToken(NativeDataTypeManager.getAsJavaLocalVariable(node.getToken()));
        this.makeLocal(node.getChild());
        this.makeLocal(node.getNext());
    }

    public void makeODESolverCompatible(Node node) {
        this.makeLHSCompatible(TreeTraversal.getLhs(node));
        this.makeRHSCompatible(TreeTraversal.getRhs(node));
    }

    public void makeLHSCompatible(Node node) {
        if (node == null) {
            return;
        }
        if (this.analyzer.isStock(node.getToken())) {
            String index = this.analyzer.getIndexFor(node.getToken());
            node.setToken("yDot[" + index + "]");
        }
    }

    public void makeRHSCompatible(Node node) {
        if (node == null) {
            return;
        }
        if (this.analyzer.isStock(node.getToken())) {
            String index = this.analyzer.getIndexFor(node.getToken());
            node.setToken("y[" + index + "]");
        }
        this.makeRHSCompatible(node.getChild());
        this.makeRHSCompatible(node.getNext());
    }

    public Node alterEquationTreeForStock(Equation stockEqn) {
        String stock = stockEqn.getLhs();
        Node stockRoot = stockEqn.getCopyOfTree();
        Node stockLhs = stockRoot.getChild();
        Node functionNode = stockLhs.getNext();
        Node rateNode = TreeTraversal.getFunctionArgument(functionNode, 1);
        String origRateName = InformationManagers.getInstance().getNativeDataTypeManager().getOriginalName(rateNode.getToken());
        stockLhs.setNext(rateNode);
        rateNode.setPrevious(stockLhs);
        rateNode.setNext(null);
        return stockRoot;
    }

    public void generateScenarioDirectoryFiles(String scenarioDirectory) {
        String odeScenarioDirectory = String.valueOf(scenarioDirectory.replace(".rs/", "")) + "ODE.rs/";
        this.generateContextXml(Translator.openReport(String.valueOf(odeScenarioDirectory) + "context.xml"), this.className);
        this.generateUserPathXml(Translator.openReport(String.valueOf(odeScenarioDirectory) + "user_path.xml"), this.className);
        this.generateClassLoaderXml(Translator.openReport(String.valueOf(odeScenarioDirectory) + "repast.simphony.dataLoader.engine.ClassNameDataLoaderAction_1.xml"), this.className);
        this.generateScenarioXml(Translator.openReport(String.valueOf(odeScenarioDirectory) + "scenario.xml"), this.className);
        this.generateParametersXml(Translator.openReport(String.valueOf(odeScenarioDirectory) + "parameters.xml"));
    }

    public void generateScenarioXml(BufferedWriter source, String name) {
        try {
            source.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
            source.append("<Scenario>\n");
            source.append("<repast.simphony.dataLoader.engine.ClassNameDataLoaderAction context=\"" + name + "\" " + "file=\"repast.simphony.dataLoader.engine.ClassNameDataLoaderAction_1.xml\" />\n");
            source.append("</Scenario>\n");
            source.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void generateContextXml(BufferedWriter source, String name) {
        try {
            source.append("<context id=\"" + name + "\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " + "xsi:noNamespaceSchemaLocation=\"http://repast.org/scenario/context\">\n");
            source.append("</context>\n");
            source.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void generateClassLoaderXml(BufferedWriter source, String name) {
        try {
            source.append("<string>" + this.packageName + ".ContextBuilder" + name + "</string>\n");
            source.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void generateUserPathXml(BufferedWriter source, String name) {
        try {
            source.append("<model name=\"" + name + "\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " + "xsi:noNamespaceSchemaLocation=\"http://repast.org/scenario/user_path\">\n");
            source.append("<classpath>\n");
            source.append("<agents path=\"../bin\" />\n");
            source.append("<entry path=\"../lib\" />\n");
            source.append("</classpath>\n");
            source.append("</model>\n");
            source.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void generateParametersXml(BufferedWriter source) {
        HashMap<String, String> initialValues = new HashMap<String, String>();
        for (Equation eqn : this.analyzer.getEquationIterator()) {
            if (!eqn.isAssignment() || !eqn.isOneTime()) continue;
            String[] bothSides = eqn.getEquation().split("=", 2);
            initialValues.put(InformationManagers.getInstance().getNativeDataTypeManager().getLegalName(bothSides[0].replace("\"", "").trim()), bothSides[1].replace("\"", "").trim());
        }
        try {
            source.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
            source.append("<parameters>\n");
            source.append("<parameter name=\"randomSeed\" displayName=\"Default Random Seed\" type=\"int\"\n");
            source.append("\tdefaultValue=\"__NULL__\"\n");
            source.append("\tisReadOnly=\"false\" \n");
            source.append("\tconverter=\"repast.simphony.parameter.StringConverterFactory$IntConverter\"\n");
            source.append("/>\n");
            for (String var : initialValues.keySet()) {
                String value = (String)initialValues.get(var);
                String legalVar = InformationManagers.getInstance().getNativeDataTypeManager().makeLegal(var.replace("memory.", ""));
                source.append("<parameter name=\"" + legalVar + "\" displayName=\"" + InformationManagers.getInstance().getNativeDataTypeManager().getOriginalName(var) + "\" type=\"double\" \n");
                source.append("\tdefaultValue=\"" + value + "\" \n");
                source.append("\tisReadOnly=\"false\" \n");
                source.append("\tconverter=\"repast.simphony.parameter.StringConverterFactory$DoubleConverter\"\n");
                source.append("/>\n");
            }
            source.append("</parameters>\n");
            source.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

