/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.ode;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import repast.simphony.systemdynamics.ode.ODEAnalyzer;
import repast.simphony.systemdynamics.ode.ODECodeGenerator;
import repast.simphony.systemdynamics.translator.Equation;
import repast.simphony.systemdynamics.translator.Node;

public class MethodCalculations {
    public static void generate(ODECodeGenerator odeCG, BufferedWriter code, ODEAnalyzer analyzer) {
        List<Equation> equations = analyzer.getEquationIterator();
        try {
            Node root;
            code.append("\n\t// auxiliary assignments\n\n");
            for (Equation eqn : equations) {
                if (eqn.isStock() || eqn.isOneTime()) continue;
                root = eqn.getTreeRoot();
                odeCG.makeLocal(root);
                odeCG.makeODESolverCompatible(root);
                code.append("/*\n");
                code.append("\t" + StringEscapeUtils.escapeHtml((String)eqn.getVensimEquationOnly()) + "\n");
                code.append("*/\n");
                code.append("\t" + odeCG.generateExpression(root) + ";\n\n");
            }
            code.append("\n\t// \"stock\" delta assignments\n\n");
            for (Equation eqn : equations) {
                if (!eqn.isStock()) continue;
                root = odeCG.alterEquationTreeForStock(eqn);
                odeCG.makeLocal(root);
                odeCG.makeODESolverCompatible(root);
                code.append("/*\n");
                code.append("\t" + StringEscapeUtils.escapeHtml((String)eqn.getVensimEquationOnly()) + "\n");
                code.append("*/\n");
                code.append("\t" + odeCG.generateExpression(root) + ";\n\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

