/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.generator;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class DirectoryCleaner {
    private static Set<String> excludes = new HashSet<String>();

    static {
        excludes.add("CVS");
        excludes.add(".cvsignore");
        excludes.add(".svn");
        excludes.add(".gitignore");
    }

    public void run(String root, String uuid) {
        File f = new File(root);
        this.process(f, uuid);
    }

    private IFile getIFile(File file) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath location = Path.fromOSString((String)file.getAbsolutePath());
        return workspace.getRoot().getFileForLocation(location);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void process(File file, String uuid) {
        if (excludes.contains(file.getName())) return;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.process(child, uuid);
                if (file.list().length == 0) {
                    file.delete();
                }
                ++n2;
            }
            return;
        } else {
            IFile ifile = this.getIFile(file);
            IJavaElement element = JavaCore.create((IFile)ifile);
            if (element == null || element.getElementType() != 5) return;
            try {
                IType type;
                IAnnotation ann;
                if (((ICompilationUnit)element).getTypes() == null || ((ICompilationUnit)element).getTypes().length <= 0 || (ann = (type = ((ICompilationUnit)element).getTypes()[0]).getAnnotation("GeneratedFor")) == null || !ann.getMemberValuePairs()[0].getValue().equals(uuid)) return;
                element = null;
                ifile.delete(true, null);
                return;
            }
            catch (JavaModelException javaModelException) {
                return;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }
}

