/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.generator;

import java.util.Map;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xpand2.output.FileHandle;
import org.eclipse.xpand2.output.PostProcessor;

public class CodeBeautifier
implements PostProcessor {
    private CodeFormatter codeFormatter;

    public void beforeWriteAndClose(FileHandle file) {
        if (file.getAbsolutePath() != null && file.getAbsolutePath().endsWith("java")) {
            Document doc = new Document(file.getBuffer().toString());
            TextEdit edit = this.getCodeFormatter().format(8, doc.get(), 0, doc.get().length(), 0, null);
            if (edit != null) {
                try {
                    edit.apply((IDocument)doc);
                    file.setBuffer((CharSequence)new StringBuffer(doc.get()));
                }
                catch (MalformedTreeException malformedTreeException) {
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    private CodeFormatter getCodeFormatter() {
        if (this.codeFormatter == null) {
            Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
            options.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
            options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
            options.put("org.eclipse.jdt.core.compiler.source", "1.6");
            this.codeFormatter = ToolFactory.createCodeFormatter((Map)options);
        }
        return this.codeFormatter;
    }

    public void afterClose(FileHandle impl) {
    }
}

