/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.analysis;

public class ArgumentBuilder {
    public static final int NUM_ITERATIONS = 10;
    private double[][] arguments;
    private int numArgs;
    private int indexToVary;

    public ArgumentBuilder() {
    }

    public ArgumentBuilder(int numArgs, int indexToVary) {
        this.numArgs = numArgs;
        this.indexToVary = indexToVary;
        this.arguments = new double[10][numArgs];
        this.initializeForIndex(indexToVary);
        this.print();
    }

    public ArgumentBuilder(int numArgs) {
        this.numArgs = numArgs;
        this.arguments = new double[10 * numArgs][numArgs];
        this.initializeForAllArrows();
        this.print();
    }

    private void initializeForIndex(int varyingIndex) {
        int i = 0;
        while (i < this.numArgs) {
            int j = 0;
            while (j < 10) {
                this.arguments[j][i] = i == varyingIndex ? (double)(j + 1) : 1.0;
                ++j;
            }
            ++i;
        }
    }

    private void initializeForAllArrows() {
        int varyingIndex = 0;
        while (varyingIndex < this.numArgs) {
            int i = 0;
            while (i < this.numArgs) {
                int j = 0;
                while (j < 10) {
                    this.arguments[j + varyingIndex * 10][i] = i == varyingIndex ? (double)(j + 1) : 1.0;
                    ++j;
                }
                ++i;
            }
            ++varyingIndex;
        }
    }

    private void print() {
        int i = 0;
        while (i < this.arguments.length) {
            int j = 0;
            while (j < this.arguments[i].length) {
                System.out.print(String.valueOf(this.arguments[i][j]) + (j + 1 == this.arguments[i].length ? "\n" : "  "));
                ++j;
            }
            ++i;
        }
    }

    public double[][] getArguments() {
        return this.arguments;
    }
}

