/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.relogo.styles;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.Map;
import repast.simphony.relogo.image.NLImage;
import repast.simphony.relogo.image.NLImagePrimitive;
import repast.simphony.relogo.styles.ReLogoSpatialSource;
import saf.v3d.NamedShapeCreator;
import saf.v3d.ShapeFactory2D;

public class NLImageSpatialSource
implements ReLogoSpatialSource {
    private NLImage image;
    private boolean rotate;
    private float offset;
    private String ID;
    private boolean simple;

    public NLImageSpatialSource(NLImage image) {
        this.image = image;
        this.rotate = image.isRotates();
        this.offset = 0.0f;
        this.ID = image.getName();
        this.simple = true;
    }

    @Override
    public boolean doRotate() {
        return this.rotate;
    }

    public String getID() {
        return this.ID;
    }

    @Override
    public float getOffset() {
        return this.offset;
    }

    @Override
    public boolean isSimple() {
        return this.simple;
    }

    public void registerSource(ShapeFactory2D shapeFactory, Map<String, String> props) throws IOException {
        int width = 15;
        int height = 15;
        if (props.containsKey("width")) {
            width = Integer.parseInt(props.get("width"));
        }
        if (props.containsKey("height")) {
            width = Integer.parseInt(props.get("height"));
        }
        NamedShapeCreator creator = shapeFactory.createNamedShape(this.image.getName());
        for (NLImagePrimitive prim : this.image.getPrimitives()) {
            Shape shape = prim.renderingShape(new Rectangle(0, 0, width, height));
            shape = AffineTransform.getScaleInstance(1.0, -1.0).createTransformedShape(shape);
            creator.addShape(shape, prim.getColor(), prim.isChangingColor());
        }
        creator.registerShape();
    }
}

