/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.relogo.image;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.List;
import repast.simphony.relogo.image.NLImagePrimitive;

public class NLImage
implements Comparable {
    String name;
    boolean rotates;
    int changingColor;
    List<NLImagePrimitive> primitives;

    public List<NLImagePrimitive> getPrimitives() {
        return this.primitives;
    }

    public NLImage(String n, boolean rot, int cc, List<NLImagePrimitive> prims) {
        this.name = n;
        this.rotates = rot;
        this.changingColor = cc;
        this.primitives = prims;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRotates() {
        return this.rotates;
    }

    public void render(Graphics gc, Rectangle rect, Color color) {
        for (NLImagePrimitive prim : this.primitives) {
            prim.render(gc, rect, color);
        }
    }

    public void render(Graphics gc, Rectangle rect, double rotation, Color color) {
        Graphics2D gc2 = (Graphics2D)gc;
        AffineTransform rot = AffineTransform.getRotateInstance(rotation, rect.x + rect.width / 2, rect.y + rect.height / 2);
        for (NLImagePrimitive prim : this.primitives) {
            Shape shape = prim.renderingShape(rect);
            shape = rot.createTransformedShape(shape);
            Color previousColor = gc.getColor();
            if (prim.changingColor) {
                gc.setColor(color);
            } else {
                gc.setColor(prim.color);
            }
            if (prim.fill) {
                gc2.fill(shape);
            } else {
                gc2.draw(shape);
            }
            gc.setColor(previousColor);
        }
    }

    public String renderingCode(Rectangle rect) {
        StringBuffer sb = new StringBuffer();
        sb.append("new NLIcon() {\npublic void render(Graphics gc) {\n");
        for (NLImagePrimitive prim : this.primitives) {
            sb.append(prim.renderingCode(rect));
        }
        sb.append("}\n}\n");
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("NLImage(");
        sb.append("\"");
        sb.append(this.name);
        sb.append("\", ");
        sb.append(this.rotates ? "rotates, " : "fixed, ");
        sb.append("color-index=");
        sb.append(this.changingColor);
        sb.append(", ");
        sb.append(this.primitives);
        sb.append(")");
        return sb.toString();
    }

    public int compareTo(Object o) {
        return this.name.compareTo(((NLImage)o).name);
    }
}

