/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.relogo.factories;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import repast.simphony.relogo.BaseTurtle;
import repast.simphony.relogo.Observer;
import repast.simphony.relogo.Plural;
import repast.simphony.relogo.Turtle;
import repast.simphony.relogo.Utility;
import repast.simphony.relogo.factories.ReLogoImplementingClassesFinder;
import repast.simphony.space.continuous.NdPoint;
import simphony.util.messages.MessageCenter;

public class TurtleFactory {
    private static MessageCenter msgCenter = MessageCenter.getMessageCenter(TurtleFactory.class);
    private Observer observer = null;
    Map<String, Class<? extends BaseTurtle>> turtleTypesMap = new ConcurrentHashMap<String, Class<? extends BaseTurtle>>();
    Map<String, String> defaultShapeMap = new ConcurrentHashMap<String, String>();

    public Class<?> getTurtleTypeClass(String turtleType) {
        String standardizedTurtleType = turtleType.toLowerCase();
        return this.turtleTypesMap.get(standardizedTurtleType);
    }

    public Map<String, String> getDefaultShapeMap() {
        return this.defaultShapeMap;
    }

    public TurtleFactory(Class<? extends BaseTurtle> turtleType, Collection<Class<? extends BaseTurtle>> turtleTypes) {
        String defaultPluralName;
        for (Class<? extends BaseTurtle> clazz : turtleTypes) {
            if (BaseTurtle.class.isAssignableFrom(clazz)) continue;
            throw new RuntimeException("Argument " + clazz + " to TurtleFactoryImpl constructor needs to extend BaseTurtle.");
        }
        if (!BaseTurtle.class.isAssignableFrom(turtleType)) {
            throw new RuntimeException("Argument " + turtleType + " to TurtleFactoryImpl constructor needs to extend BaseTurtle.");
        }
        this.turtleTypesMap.put("default", turtleType);
        this.defaultShapeMap.put("default", "default");
        String defaultSingularName = turtleType.getSimpleName();
        this.turtleTypesMap.put(defaultSingularName.toLowerCase(), turtleType);
        this.defaultShapeMap.put(defaultSingularName.toLowerCase(), "default");
        Plural ann = turtleType.getAnnotation(Plural.class);
        if (ann != null) {
            Plural pluralAnn = ann;
            defaultPluralName = pluralAnn.value();
        } else {
            defaultPluralName = String.valueOf(defaultSingularName) + "s";
        }
        this.turtleTypesMap.put(defaultPluralName.toLowerCase(), turtleType);
        this.defaultShapeMap.put(defaultPluralName.toLowerCase(), "default");
        for (Class<? extends BaseTurtle> clazz : turtleTypes) {
            String pluralName;
            String singularName = clazz.getSimpleName();
            this.turtleTypesMap.put(singularName.toLowerCase(), clazz);
            this.defaultShapeMap.put(singularName.toLowerCase(), "default");
            ann = clazz.getAnnotation(Plural.class);
            if (ann != null) {
                Plural pluralAnn = ann;
                pluralName = pluralAnn.value();
            } else {
                pluralName = String.valueOf(singularName) + "s";
            }
            this.turtleTypesMap.put(pluralName.toLowerCase(), clazz);
            this.defaultShapeMap.put(pluralName.toLowerCase(), "default");
        }
    }

    public TurtleFactory(Class<? extends BaseTurtle> turtleType) {
        this(turtleType, ReLogoImplementingClassesFinder.find(BaseTurtle.class));
    }

    public void init(Observer observer) {
        this.observer = observer;
    }

    public Turtle createIdenticalTurtle(Turtle parent) {
        String parentTurtleType = parent.getClass().getSimpleName();
        return this.createIdenticalTurtle(parent, parentTurtleType);
    }

    public Turtle createIdenticalTurtle(Turtle parent, String childType) {
        BaseTurtle newTurtle = (BaseTurtle)this.createTurtle(childType, parent.getHeading(), parent.getColor(), new NdPoint(parent.getTurtleLocation().toDoubleArray(null)));
        newTurtle.setUserDefinedVariables(parent);
        return newTurtle;
    }

    public Turtle createTurtle() {
        return this.createTurtle("default", Utility.randomFloat(360), Utility.randomFloat(140), new NdPoint(new double[]{0.0, 0.0}));
    }

    public Turtle createTurtle(String turtleType) {
        return this.createTurtle(turtleType, Utility.randomFloat(360), Utility.randomFloat(140), new NdPoint(new double[]{0.0, 0.0}));
    }

    public Turtle createTurtle(NdPoint loc) {
        return this.createTurtle("default", Utility.randomFloat(360), Utility.randomFloat(140), loc);
    }

    public Turtle createTurtle(String turtleType, NdPoint loc) {
        return this.createTurtle(turtleType, Utility.randomFloat(360), Utility.randomFloat(140), loc);
    }

    public Turtle createTurtle(double heading) {
        return this.createTurtle("default", heading, Utility.randomFloat(140), new NdPoint(new double[]{0.0, 0.0}));
    }

    public Turtle createTurtle(String turtleType, double heading) {
        return this.createTurtle(turtleType, heading, Utility.randomFloat(140), new NdPoint(new double[]{0.0, 0.0}));
    }

    public Turtle createTurtle(String turtleType, double heading, double color, NdPoint loc) {
        if (this.observer == null) {
            throw new RuntimeException("The TurtleFactoryImpl init method needs to be called before instantiating Turtles.");
        }
        BaseTurtle turtle = null;
        String standardizedTurtleType = turtleType.toLowerCase();
        try {
            Class<? extends BaseTurtle> turtleClass;
            if (standardizedTurtleType.equals("turtles")) {
                standardizedTurtleType = "default";
            }
            if ((turtleClass = this.turtleTypesMap.get(standardizedTurtleType)) == null) {
                System.out.println("the turtleType " + turtleType + " is not in the turtleTypesMap");
            }
            turtle = turtleClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        String defaultTypeShape = this.defaultShapeMap.get(standardizedTurtleType);
        turtle.setBaseTurtleProperties(this.observer, this, defaultTypeShape, heading, color, loc);
        return turtle;
    }

    public void setDefaultShape(String typeName, String shapeName) {
        String standardizedTurtleType = typeName.toLowerCase();
        if (standardizedTurtleType.equals("turtles")) {
            Set<String> allTypes = this.defaultShapeMap.keySet();
            for (String type : allTypes) {
                this.defaultShapeMap.put(type, shapeName);
            }
        } else {
            Class<? extends BaseTurtle> turtleClass = this.turtleTypesMap.get(standardizedTurtleType);
            ArrayList<String> list = new ArrayList<String>();
            for (String k : this.turtleTypesMap.keySet()) {
                if (!this.turtleTypesMap.get(k).equals(turtleClass)) continue;
                list.add(k);
            }
            for (String k : list) {
                this.defaultShapeMap.put(k, shapeName);
            }
        }
    }
}

