/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.relogo.factories;

import repast.simphony.context.Context;
import repast.simphony.context.DefaultContext;
import repast.simphony.context.space.continuous.ContinuousSpaceFactoryFinder;
import repast.simphony.context.space.grid.GridFactoryFinder;
import repast.simphony.relogo.Observer;
import repast.simphony.relogo.Patch;
import repast.simphony.relogo.factories.LinkFactory;
import repast.simphony.relogo.factories.PatchFactory;
import repast.simphony.relogo.factories.RLWorldDimensions;
import repast.simphony.relogo.factories.TurtleFactory;
import repast.simphony.space.continuous.ContinuousAdder;
import repast.simphony.space.continuous.ContinuousSpace;
import repast.simphony.space.continuous.RandomCartesianAdder;
import repast.simphony.space.grid.Grid;
import repast.simphony.space.grid.GridAdder;
import repast.simphony.space.grid.GridBuilderParameters;
import repast.simphony.space.grid.RandomGridAdder;

public class ReLogoWorldFactory {
    Context parentContext;
    Context context;
    Grid grid;
    ContinuousSpace space;
    RLWorldDimensions rLWorldDimensions;
    TurtleFactory turtleFactory;
    PatchFactory patchFactory;
    LinkFactory linkFactory;

    public Context getContext() {
        return this.context;
    }

    public RLWorldDimensions getrLWorldDimensions() {
        return this.rLWorldDimensions;
    }

    public TurtleFactory getTurtleFactory() {
        return this.turtleFactory;
    }

    public PatchFactory getPatchFactory() {
        return this.patchFactory;
    }

    public LinkFactory getLinkFactory() {
        return this.linkFactory;
    }

    public ReLogoWorldFactory(Context parentContext, String worldID, RLWorldDimensions rLWorldDimensions, TurtleFactory turtleFactory, PatchFactory patchFactory, LinkFactory linkFactory) {
        this.parentContext = parentContext;
        this.context = new DefaultContext((Object)worldID);
        this.rLWorldDimensions = rLWorldDimensions;
        this.turtleFactory = turtleFactory;
        this.patchFactory = patchFactory;
        this.linkFactory = linkFactory;
    }

    public void createWorld(Observer observer) {
        this.turtleFactory.init(observer);
        this.patchFactory.init(observer);
        this.linkFactory.init(observer);
        this.addGrid();
        this.addContinuousSpace();
        this.addPatches();
        this.parentContext.addSubContext(this.context);
    }

    public void addGrid() {
        this.grid = GridFactoryFinder.createGridFactory(null).createGrid("Grid2d", this.context, new GridBuilderParameters(this.rLWorldDimensions.getPgt(), (GridAdder)new RandomGridAdder(), true, this.rLWorldDimensions.getDims(), this.rLWorldDimensions.getOrigin()));
    }

    public void addContinuousSpace() {
        this.space = ContinuousSpaceFactoryFinder.createContinuousSpaceFactory(null).createContinuousSpace("Space2d", this.context, (ContinuousAdder)new RandomCartesianAdder(), this.rLWorldDimensions.getPt(), this.rLWorldDimensions.getDDims(), this.rLWorldDimensions.getDOrigin());
    }

    public void addPatches() {
        int i = this.rLWorldDimensions.getMinPxcor();
        while (i <= this.rLWorldDimensions.getMaxPxcor()) {
            int j = this.rLWorldDimensions.getMinPycor();
            while (j <= this.rLWorldDimensions.getMaxPycor()) {
                Patch patch = this.patchFactory.createPatch();
                this.context.add((Object)patch);
                this.grid.moveTo((Object)patch, new int[]{i, j});
                this.space.moveTo((Object)patch, new double[]{i, j});
                ++j;
            }
            ++i;
        }
    }
}

