/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.relogo.factories;

import repast.simphony.space.continuous.AbstractPointTranslator;
import repast.simphony.space.continuous.PointTranslator;
import repast.simphony.space.continuous.StickyBorders;
import repast.simphony.space.grid.BouncyBorders;
import repast.simphony.space.grid.GridPointTranslator;
import repast.simphony.space.grid.WrapAroundBorders;

public class RLWorldDimensions {
    private int minPxcor;
    private int maxPxcor;
    private int minPycor;
    private int maxPycor;
    private GridPointTranslator pgt;
    private PointTranslator pt;

    public GridPointTranslator getPgt() {
        return this.pgt;
    }

    public PointTranslator getPt() {
        return this.pt;
    }

    public RLWorldDimensions(int minPxcor, int maxPxcor, int minPycor, int maxPycor) {
        this(minPxcor, maxPxcor, minPycor, maxPycor, (PointTranslator)new repast.simphony.space.continuous.WrapAroundBorders());
    }

    public RLWorldDimensions(int minPxcor, int maxPxcor, int minPycor, int maxPycor, WorldType worldType) {
        this(minPxcor, maxPxcor, minPycor, maxPycor, (PointTranslator)RLWorldDimensions.getContinuousPointTranslator(worldType));
    }

    private static AbstractPointTranslator getContinuousPointTranslator(WorldType worldType) {
        switch (worldType) {
            case WRAP: {
                return new repast.simphony.space.continuous.WrapAroundBorders();
            }
            case BOUNCY: {
                return new repast.simphony.space.continuous.BouncyBorders();
            }
            case STICKY: {
                return new StickyBorders();
            }
        }
        return null;
    }

    protected RLWorldDimensions(int minPxcor, int maxPxcor, int minPycor, int maxPycor, PointTranslator pt) {
        this.minPxcor = minPxcor;
        this.maxPxcor = maxPxcor;
        this.minPycor = minPycor;
        this.maxPycor = maxPycor;
        this.pt = pt;
        if (pt.getClass() == repast.simphony.space.continuous.WrapAroundBorders.class) {
            this.pgt = new WrapAroundBorders();
        } else if (pt.getClass() == repast.simphony.space.continuous.BouncyBorders.class) {
            this.pgt = new BouncyBorders();
        } else if (pt.getClass() == StickyBorders.class) {
            this.pgt = new repast.simphony.space.grid.StickyBorders();
        } else {
            throw new RuntimeException("The point translator " + pt + " is not currently supported.");
        }
    }

    public int getMinPxcor() {
        return this.minPxcor;
    }

    public int getMaxPxcor() {
        return this.maxPxcor;
    }

    public int getMinPycor() {
        return this.minPycor;
    }

    public int getMaxPycor() {
        return this.maxPycor;
    }

    public int getXdim() {
        return -this.minPxcor + this.maxPxcor + 1;
    }

    public int getYdim() {
        return -this.minPycor + this.maxPycor + 1;
    }

    public int[] getDims() {
        int[] dims = new int[]{this.getXdim(), this.getYdim()};
        return dims;
    }

    public int[] getOrigin() {
        int[] origin = new int[]{-this.minPxcor, -this.minPycor};
        return origin;
    }

    public double[] getDDims() {
        double[] dDims = new double[]{this.getXdim(), this.getYdim()};
        return dDims;
    }

    public double[] getDOrigin() {
        int[] origin = this.getOrigin();
        double[] dOrigin = new double[]{(double)origin[0] + 0.5, (double)origin[1] + 0.5};
        return dOrigin;
    }

    public static enum WorldType {
        WRAP,
        BOUNCY,
        STICKY;

    }
}

