/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.relogo;

import cern.jet.random.Uniform;
import groovy.lang.Closure;
import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javolution.util.FastSet;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.functors.EqualPredicate;
import org.apache.commons.collections15.functors.InstanceofPredicate;
import org.apache.commons.collections15.functors.NotPredicate;
import repast.simphony.context.Context;
import repast.simphony.data2.DataSetRegistry;
import repast.simphony.data2.FileDataSink;
import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.engine.environment.RunState;
import repast.simphony.query.PropertyEquals;
import repast.simphony.random.RandomHelper;
import repast.simphony.relogo.AgentSet;
import repast.simphony.relogo.Link;
import repast.simphony.relogo.Observer;
import repast.simphony.relogo.Patch;
import repast.simphony.relogo.ReLogoAgent;
import repast.simphony.relogo.ReLogoModel;
import repast.simphony.relogo.Turtle;
import repast.simphony.relogo.UtilityG;
import repast.simphony.relogo.WayPoint;
import repast.simphony.space.SpatialException;
import repast.simphony.space.SpatialMath;
import repast.simphony.space.continuous.ContinuousSpace;
import repast.simphony.space.continuous.NdPoint;
import repast.simphony.space.graph.Network;
import repast.simphony.space.grid.Grid;
import repast.simphony.space.grid.GridPoint;
import repast.simphony.ui.RSApplication;
import repast.simphony.util.SimUtilities;
import repast.simphony.util.collections.FilteredIterator;

public class Utility {
    public static final int PEN_UP = 0;
    public static final int PEN_DOWN = 1;
    public static final int PEN_ERASE = 2;

    public static double randomFloat(Number num) {
        if (num.doubleValue() == 0.0) {
            return 0.0;
        }
        return num.doubleValue() > 0.0 ? RandomHelper.nextDoubleFromTo((double)0.0, (double)num.doubleValue()) : RandomHelper.nextDoubleFromTo((double)num.doubleValue(), (double)0.0);
    }

    public static int random(Number num) {
        if (num.doubleValue() == 0.0) {
            return 0;
        }
        return num.doubleValue() > 0.0 ? RandomHelper.nextIntFromTo((int)0, (int)(num.intValue() - 1)) : RandomHelper.nextIntFromTo((int)(num.intValue() + 1), (int)0);
    }

    public static void observerStop() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Utility.pauseReLogo();
                Utility.resetAllToggleButtons();
            }
        });
    }

    public static void resetAllToggleButtons() {
        Map actionMap = ReLogoModel.getInstance().getActions();
        Set keys = actionMap.keySet();
        Map modelParams = ReLogoModel.getInstance().getModelParams();
        for (Object key : keys) {
            modelParams.put(key, false);
        }
    }

    public static void pauseReLogo() {
        if (!RSApplication.getRSApplicationInstance().isStartSim()) {
            RunEnvironment.getInstance().pauseRun();
        }
    }

    public static void resumeReLogo() {
        if (RSApplication.getRSApplicationInstance().isStartSim()) {
            RSApplication.getRSApplicationInstance().start();
            RunEnvironment.getInstance().resumeRun();
        } else {
            SwingWorker worker = new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    RunEnvironment.getInstance().resumeRun();
                    return null;
                }
            };
            worker.execute();
        }
    }

    public static void checkToPause() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (ReLogoModel.getInstance().getActiveButtons() == 0) {
                        Utility.pauseReLogo();
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static double randomXcorU(Observer observer) {
        return RandomHelper.nextDoubleFromTo((double)((double)observer.getRLDimensions().getMinPxcor() - 0.5), (double)((double)observer.getRLDimensions().getMaxPxcor() + 0.5));
    }

    public static double randomYcorU(Observer observer) {
        return RandomHelper.nextDoubleFromTo((double)((double)observer.getRLDimensions().getMinPycor() - 0.5), (double)((double)observer.getRLDimensions().getMaxPycor() + 0.5));
    }

    public static int randomPxcorU(Observer observer) {
        return RandomHelper.nextIntFromTo((int)observer.getRLDimensions().getMinPxcor(), (int)observer.getRLDimensions().getMaxPxcor());
    }

    public static int randomPycorU(Observer observer) {
        return RandomHelper.nextIntFromTo((int)observer.getRLDimensions().getMinPycor(), (int)observer.getRLDimensions().getMaxPycor());
    }

    public static int worldHeightU(Observer observer) {
        return observer.getRLDimensions().getYdim();
    }

    public static int worldWidthU(Observer observer) {
        return observer.getRLDimensions().getXdim();
    }

    public static int getMinPxcorU(Observer observer) {
        return observer.getRLDimensions().getMinPxcor();
    }

    public static int getMaxPxcorU(Observer observer) {
        return observer.getRLDimensions().getMaxPxcor();
    }

    public static int getMinPycorU(Observer observer) {
        return observer.getRLDimensions().getMinPycor();
    }

    public static int getMaxPycorU(Observer observer) {
        return observer.getRLDimensions().getMaxPycor();
    }

    public static int[] ndPointToIntArray(NdPoint loc) {
        int[] gridLocation = new int[loc.dimensionCount()];
        if (loc != null) {
            int i = 0;
            while (i < loc.dimensionCount()) {
                double coord = loc.getCoord(i);
                gridLocation[i] = (int)Math.round(coord);
                ++i;
            }
        }
        return gridLocation;
    }

    public static GridPoint ndPointToGridPoint(NdPoint loc) {
        return new GridPoint(Utility.ndPointToIntArray(loc));
    }

    public static double angleFromDisplacement(double dX, double dY) {
        if (dY == 0.0) {
            return dX >= 0.0 ? 90.0 : 270.0;
        }
        double angRad = Math.atan(dX / dY);
        if (dY > 0.0) {
            return angRad < 0.0 ? Math.toDegrees(Math.PI * 2 + angRad) : Math.toDegrees(angRad);
        }
        return Math.toDegrees(Math.PI + angRad);
    }

    public static AgentSet agentSetFromIterable(Iterable i) {
        AgentSet a = new AgentSet();
        for (Object o : i) {
            a.add(o);
        }
        return a;
    }

    public static <E extends ReLogoAgent> AgentSet<E> agentSetFromIterator(Iterator<E> i) {
        AgentSet<ReLogoAgent> a = new AgentSet<ReLogoAgent>();
        while (i.hasNext()) {
            a.add((ReLogoAgent)i.next());
        }
        return a;
    }

    public static AgentSet<Turtle> getTurtlesOnGridPoint(GridPoint patchLocation, Observer observer) {
        Grid grid = observer.getGrid();
        Iterable objectsAt = grid.getObjectsAt(patchLocation.toIntArray(null));
        FilteredIterator turtlesAt = new FilteredIterator(objectsAt.iterator(), (Predicate)new InstanceofPredicate(Turtle.class));
        return Utility.agentSetFromIterator(turtlesAt);
    }

    public static AgentSet<Turtle> getTurtlesOnGridPoint(GridPoint patchLocation, Observer observer, Class type) {
        Grid grid = observer.getGrid();
        Iterable objectsAt = grid.getObjectsAt(patchLocation.toIntArray(null));
        FilteredIterator turtlesAt = new FilteredIterator(objectsAt.iterator(), (Predicate)new InstanceofPredicate(type));
        return Utility.agentSetFromIterator(turtlesAt);
    }

    public static AgentSet<Turtle> getTurtlesOnGridPoint(GridPoint patchLocation, Observer observer, String typeName) {
        Grid grid = observer.getGrid();
        Iterable objectsAt = grid.getObjectsAt(patchLocation.toIntArray(null));
        Class<?> clazz = observer.getTurtleFactory().getTurtleTypeClass(typeName);
        FilteredIterator turtlesAt = new FilteredIterator(objectsAt.iterator(), (Predicate)new InstanceofPredicate(clazz));
        return Utility.agentSetFromIterator(turtlesAt);
    }

    public static Patch getPatchAtLocation(GridPoint gridPoint, Observer observer) {
        Grid grid = observer.getGrid();
        Iterable objectsAt = grid.getObjectsAt(gridPoint.toIntArray(null));
        FilteredIterator patchAt = new FilteredIterator(objectsAt.iterator(), (Predicate)new InstanceofPredicate(Patch.class));
        return (Patch)patchAt.next();
    }

    public static Patch patchU(double x, double y, Observer observer) {
        try {
            return Utility.getPatchAtLocation(Utility.ndPointToGridPoint(new NdPoint(new double[]{x, y})), observer);
        }
        catch (SpatialException e) {
            return null;
        }
    }

    public static Link linkU(int oneEnd, int otherEnd, Observer observer) {
        Link link = Utility.linkDir(oneEnd, otherEnd, observer);
        if (link != null) {
            return link;
        }
        return Utility.linkUndir(oneEnd, otherEnd, observer);
    }

    public static Link linkDir(int oneEnd, int otherEnd, Observer observer) {
        return (Link)observer.getNetwork("DirectedLinks").getEdge((Object)Utility.turtleU(oneEnd, observer), (Object)Utility.turtleU(otherEnd, observer));
    }

    public static Link linkUndir(int oneEnd, int otherEnd, Observer observer) {
        return (Link)observer.getNetwork("UndirectedLinks").getEdge((Object)Utility.turtleU(oneEnd, observer), (Object)Utility.turtleU(otherEnd, observer));
    }

    public static Turtle turtleU(int number, Observer observer) {
        Context tpc = observer.getContext();
        PropertyEquals query = new PropertyEquals(tpc, "who", (Object)number);
        Iterator result = query.query().iterator();
        if (result.hasNext()) {
            return (Turtle)result.next();
        }
        return null;
    }

    public static GridPoint getGridPointAtDisplacement(NdPoint currentLocation, double[] displacement, Observer observer) {
        ContinuousSpace space = observer.getSpace();
        double[] dLoc = new double[2];
        space.getPointTranslator().translate(currentLocation, dLoc, displacement);
        NdPoint newLocation = new NdPoint(dLoc);
        return new GridPoint(Utility.ndPointToIntArray(newLocation));
    }

    public static double getNLAngle(double angleInDegrees) {
        double tempHeading = angleInDegrees % 360.0;
        return tempHeading < 0.0 ? tempHeading + 360.0 : tempHeading;
    }

    public static double[] getDisplacementFromHeadingAndDistance(double heading, double distance) {
        double[] anglesForDisplacement = new double[]{1.5707963267948966 - Math.toRadians(heading), 0.0};
        return SpatialMath.getDisplacement((int)2, (int)0, (double)distance, (double[])anglesForDisplacement);
    }

    public static boolean isTurtleQ(Object o) {
        return o instanceof Turtle;
    }

    public static boolean isPatchQ(Object o) {
        return o instanceof Patch;
    }

    public static boolean isListQ(Object o) {
        return o instanceof List;
    }

    public static boolean isStringQ(Object o) {
        return o instanceof String;
    }

    public static boolean isDirectedLinkQ(Object o) {
        if (o instanceof Link) {
            Link l = (Link)o;
            return l.isDirected();
        }
        return false;
    }

    public static boolean isUndirectedLinkQ(Object o) {
        if (o instanceof Link) {
            Link l = (Link)o;
            return !l.isDirected();
        }
        return false;
    }

    public static boolean isLinkQ(Object o) {
        return o instanceof Link;
    }

    public static boolean isLinkSetQ(Object o) {
        if (o instanceof AgentSet) {
            AgentSet a = (AgentSet)o;
            if (a.size() == 0) {
                return true;
            }
            return a.get(0) instanceof Link;
        }
        return false;
    }

    public static boolean isPatchSetQ(Object o) {
        if (o instanceof AgentSet) {
            AgentSet a = (AgentSet)o;
            if (a.size() == 0) {
                return true;
            }
            return a.get(0) instanceof Patch;
        }
        return false;
    }

    public static boolean isTurtleSetQ(Object o) {
        if (o instanceof AgentSet) {
            AgentSet a = (AgentSet)o;
            if (a.size() == 0) {
                return true;
            }
            return a.get(0) instanceof Turtle;
        }
        return false;
    }

    public static boolean isNumberQ(Object o) {
        return o instanceof Number;
    }

    public static boolean isBooleanQ(Object o) {
        return o instanceof Boolean;
    }

    public static boolean isAgentSetQ(Object o) {
        return o instanceof AgentSet;
    }

    public static boolean isAgentQ(Object o) {
        return o instanceof ReLogoAgent || o instanceof Observer;
    }

    public static boolean anyQ(Collection a) {
        return !a.isEmpty();
    }

    public static boolean allQU(Collection<? extends ReLogoAgent> a, Closure closure) {
        return Utility.allQU(null, a, closure);
    }

    public static boolean allQU(Object caller, Collection<? extends ReLogoAgent> a, Closure closure) {
        if (caller != null) {
            for (ReLogoAgent reLogoAgent : a) {
                reLogoAgent.setMyself(caller);
            }
        }
        closure.setResolveStrategy(1);
        for (ReLogoAgent reLogoAgent : a) {
            closure.setDelegate((Object)reLogoAgent);
            if (((Boolean)closure.call((Object)reLogoAgent)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static AgentSet<Turtle> noTurtles() {
        return new AgentSet<Turtle>();
    }

    public static AgentSet<Patch> noPatches() {
        return new AgentSet<Patch>();
    }

    public static AgentSet<Link> noLinks() {
        return new AgentSet<Link>();
    }

    public static double subtractHeadings(double to, double from) {
        double temp = (to - from) % 360.0;
        temp = temp < 0.0 ? temp + 360.0 : temp;
        return temp > 180.0 ? temp - 360.0 : temp;
    }

    public static <E> E first(List<E> a) {
        if (a.size() > 0) {
            return a.get(0);
        }
        return null;
    }

    public static String first(String s) {
        if (s.length() > 0) {
            return s.substring(0, 1);
        }
        return null;
    }

    public static ArrayList fput(Object item, List list) {
        ArrayList<Object> resultList = new ArrayList<Object>(list);
        resultList.add(0, item);
        return resultList;
    }

    public static ArrayList lput(Object item, List list) {
        ArrayList<Object> resultList = new ArrayList<Object>(list);
        resultList.add(item);
        return resultList;
    }

    public static <E> E item(int i, List<E> a) {
        return a.get(i);
    }

    public static String item(int i, String s) {
        return s.substring(i, i + 1);
    }

    public static <E> E last(List<E> a) {
        int len = a.size();
        if (len > 0) {
            return a.get(len - 1);
        }
        return null;
    }

    public static String last(String s) {
        int len = s.length();
        if (len > 0) {
            return s.substring(len - 1, len);
        }
        return null;
    }

    public static int length(Collection c) {
        return c.size();
    }

    public static int length(String s) {
        return s.length();
    }

    public static <E> ArrayList<E> shuffle(List<E> a) {
        ArrayList<E> result = new ArrayList<E>(a);
        SimUtilities.shuffle(result, (Uniform)RandomHelper.getUniform());
        return result;
    }

    public static boolean emptyQ(String string) {
        return string.equals("");
    }

    public static boolean emptyQ(Collection c) {
        return c.isEmpty();
    }

    public static String substring(String string, int position1, int position2) {
        return string.substring(position1, position2);
    }

    public static double acos(Number a) {
        return Math.toDegrees(Math.acos(a.doubleValue()));
    }

    public static double asin(Number a) {
        return Math.toDegrees(Math.asin(a.doubleValue()));
    }

    public static double atan(Number x, Number y) {
        return Utility.angleFromDisplacement(x.doubleValue(), y.doubleValue());
    }

    public static double ceiling(Number num) {
        return Math.ceil(num.doubleValue());
    }

    public static double floor(Number num) {
        return Math.floor(num.doubleValue());
    }

    public static double sin(Number aDeg) {
        return Math.sin(Math.toRadians(aDeg.doubleValue()));
    }

    public static double cos(Number num) {
        return Math.cos(Math.toRadians(num.doubleValue()));
    }

    public static double tan(Number num) {
        return Math.tan(Math.toRadians(num.doubleValue()));
    }

    public static double e() {
        return Math.E;
    }

    public static double pi() {
        return Math.PI;
    }

    public static int intPart(Number num) {
        return num.intValue();
    }

    public static double ln(Number num) {
        return Math.log(num.doubleValue());
    }

    public static double log(Number num, Number base) {
        return Math.log(num.doubleValue()) / Math.log(base.doubleValue());
    }

    public static double mod(Number number1, Number number2) {
        return number1.doubleValue() - Math.floor(number1.doubleValue() / number2.doubleValue()) * number2.doubleValue();
    }

    public static int newSeed() {
        return RandomHelper.getUniform().nextIntFromTo(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static BigDecimal precision(BigDecimal b, int places) {
        return b.setScale(places, 4);
    }

    public static double randomExponential(Number mean) {
        return RandomHelper.createExponential((double)mean.doubleValue()).nextDouble();
    }

    public static double randomGamma(Number alpha, Number lambda) {
        return RandomHelper.createGamma((double)alpha.doubleValue(), (double)lambda.doubleValue()).nextDouble();
    }

    public static double randomNormal(Number mean, Number standardDeviation) {
        return RandomHelper.createNormal((double)mean.doubleValue(), (double)standardDeviation.doubleValue()).nextDouble();
    }

    public static int randomPoisson(Number mean) {
        return RandomHelper.createPoisson((double)mean.doubleValue()).nextInt();
    }

    public static void randomSeed(int seed) {
        RandomHelper.setSeed((int)seed);
    }

    public static double remainder(Number number1, Number number2) {
        return number1.doubleValue() - (double)Utility.intPart(number1.doubleValue() / number2.doubleValue()) * number2.doubleValue();
    }

    public static int round(Number number) {
        return (int)Math.round(number.doubleValue());
    }

    public static void wait(Number timeInSecs) {
        Double timeInMillisecs = timeInSecs.doubleValue() * 1000.0;
        try {
            Thread.sleep(timeInMillisecs.longValue());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void setCurrentPlot(String string) {
    }

    public static void setCurrentPlotPen(String string) {
    }

    public static void plot(Number point) {
    }

    public static void setPlotYRange(Number left, Number right) {
    }

    public static void setPlotXRange(Number left, Number right) {
    }

    public static boolean autoplotQ() {
        return false;
    }

    public static void autoPlotOff() {
    }

    public static void autoPlotOn() {
    }

    public static void clearAllPlots() {
    }

    public static void clearPlot() {
    }

    public static void createTemporaryPlotPen() {
    }

    public static void histogram() {
    }

    public static String plotName() {
        return "plotName";
    }

    public static boolean plotPenExistsQ() {
        return false;
    }

    public static void plotPenDown() {
    }

    public static void plotPenReset() {
    }

    public static void plotPenUp() {
    }

    public static double plotXMax() {
        return 0.0;
    }

    public static double plotXMin() {
        return 0.0;
    }

    public static double plotYMax() {
        return 0.0;
    }

    public static double plotYMin() {
        return 0.0;
    }

    public static void plotxy(Number num1, Number num2) {
    }

    public static void setHistogramNumBars(Number num) {
    }

    public static void setPlotPenColor(Number color) {
    }

    public static void setPlotPenInterval(Number color) {
    }

    public static void setPlotPenMode(Number color) {
    }

    public static void display() {
    }

    public static AgentSet<Turtle> getTurtleAgentSetOfType(String typeName, Observer observer) {
        Class<?> clazz = observer.getTurtleFactory().getTurtleTypeClass(typeName);
        return Utility.getAgentSetOfClass(clazz, observer);
    }

    public static AgentSet<Turtle> turtlesU(Observer observer) {
        return Utility.getAgentSetOfClass(Turtle.class, observer);
    }

    public static AgentSet<Patch> patchesU(Observer observer) {
        return Utility.getAgentSetOfClass(Patch.class, observer);
    }

    public static AgentSet<Link> allLinksU(Observer observer) {
        return Utility.getAgentSetOfClass(Link.class, observer);
    }

    public static AgentSet<Link> linksU(Observer observer) {
        AgentSet a = Utility.agentSetFromIterable(observer.getNetwork("UndirectedLinks").getEdges());
        AgentSet d = Utility.agentSetFromIterable(observer.getNetwork("DirectedLinks").getEdges());
        a.addAll(d);
        return a;
    }

    public static AgentSet getAgentSetOfClass(Class E, Observer observer) {
        Context tpc = observer.getContext();
        AgentSet a = new AgentSet();
        for (Object e : tpc.getObjects(E)) {
            a.add(e);
        }
        return a;
    }

    public static ArrayList getWayPoints(Observer observer) {
        Context tpc = observer.getContext();
        ArrayList a = new ArrayList();
        for (Object w : tpc.getObjects(WayPoint.class)) {
            a.add(w);
        }
        return a;
    }

    public static AgentSet combineAgentSets(AgentSet a1, AgentSet a2) {
        FastSet s = new FastSet();
        s.addAll((Collection)a1);
        s.addAll((Collection)a2);
        return new AgentSet(s);
    }

    public static ReLogoAgent minOneOfU(Collection<? extends ReLogoAgent> a, Closure closure) {
        return Utility.minOneOfU(null, a, closure);
    }

    public static ReLogoAgent minOneOfU(Object caller, Collection<? extends ReLogoAgent> a, Closure closure) {
        ArrayList<? extends ReLogoAgent> b = new ArrayList<ReLogoAgent>(a);
        if (b.size() == 0) {
            return null;
        }
        if (b.size() > 0 && !(b.get(0) instanceof ReLogoAgent)) {
            System.err.println("minOneOf expects a collection of ReLogoAgents.");
            return null;
        }
        SimUtilities.shuffle(b, (Uniform)RandomHelper.getUniform());
        if (caller != null) {
            for (ReLogoAgent reLogoAgent : b) {
                reLogoAgent.setMyself(caller);
            }
        }
        closure.setResolveStrategy(1);
        double d = Double.POSITIVE_INFINITY;
        ReLogoAgent currentMinAgent = null;
        for (ReLogoAgent reLogoAgent : b) {
            closure.setDelegate((Object)reLogoAgent);
            Number result = (Number)closure.call((Object)reLogoAgent);
            if (!(result.doubleValue() < d)) continue;
            d = result.doubleValue();
            currentMinAgent = reLogoAgent;
        }
        return currentMinAgent;
    }

    public static AgentSet minNOfU(int number, Collection<? extends ReLogoAgent> a, Closure closure) {
        return Utility.minNOfU(null, number, a, closure);
    }

    public static AgentSet minNOfU(Object caller, int number, Collection<? extends ReLogoAgent> a, final Closure closure) {
        ArrayList<? extends ReLogoAgent> b = new ArrayList<ReLogoAgent>(a);
        int l = b.size();
        if (l == 0) {
            return new AgentSet();
        }
        if (l > 0 && !(b.get(0) instanceof ReLogoAgent)) {
            System.err.println("minNOf expects a collection of ReLogoAgents.");
            return new AgentSet();
        }
        SimUtilities.shuffle(b, (Uniform)RandomHelper.getUniform());
        if (caller != null) {
            for (ReLogoAgent reLogoAgent : b) {
                reLogoAgent.setMyself(caller);
            }
        }
        closure.setResolveStrategy(1);
        Collections.sort(b, new Comparator(){

            public int compare(Object o1, Object o2) {
                closure.setDelegate(o1);
                Number n1 = (Number)closure.call(o1);
                closure.setDelegate(o2);
                Number n2 = (Number)closure.call(o2);
                return n1.doubleValue() < n2.doubleValue() ? -1 : (n1.doubleValue() == n2.doubleValue() ? 0 : 1);
            }
        });
        AgentSet<ReLogoAgent> agentSet = new AgentSet<ReLogoAgent>();
        int i = 0;
        while (i < l && i < number) {
            agentSet.add((ReLogoAgent)b.get(i));
            ++i;
        }
        return agentSet;
    }

    public static ReLogoAgent maxOneOfU(Collection<? extends ReLogoAgent> a, Closure closure) {
        return Utility.maxOneOfU(null, a, closure);
    }

    public static ReLogoAgent maxOneOfU(Object caller, Collection<? extends ReLogoAgent> a, Closure closure) {
        ArrayList<? extends ReLogoAgent> b = new ArrayList<ReLogoAgent>(a);
        if (b.size() == 0) {
            return null;
        }
        if (b.size() > 0 && !(b.get(0) instanceof ReLogoAgent)) {
            System.err.println("maxOneOf expects a collection of ReLogoAgents.");
            return null;
        }
        SimUtilities.shuffle(b, (Uniform)RandomHelper.getUniform());
        if (caller != null) {
            for (ReLogoAgent reLogoAgent : b) {
                reLogoAgent.setMyself(caller);
            }
        }
        closure.setResolveStrategy(1);
        double d = Double.NEGATIVE_INFINITY;
        ReLogoAgent currentMaxAgent = null;
        for (ReLogoAgent reLogoAgent : b) {
            closure.setDelegate((Object)reLogoAgent);
            Number result = (Number)closure.call((Object)reLogoAgent);
            if (!(result.doubleValue() > d)) continue;
            d = result.doubleValue();
            currentMaxAgent = reLogoAgent;
        }
        return currentMaxAgent;
    }

    public static AgentSet maxNOfU(int number, Collection<? extends ReLogoAgent> a, Closure closure) {
        return Utility.maxNOfU(null, number, a, closure);
    }

    public static AgentSet maxNOfU(Object caller, int number, Collection<? extends ReLogoAgent> c, final Closure closure) {
        ArrayList<? extends ReLogoAgent> b = new ArrayList<ReLogoAgent>(c);
        int l = b.size();
        if (l == 0) {
            return new AgentSet();
        }
        if (l > 0 && !(b.get(0) instanceof ReLogoAgent)) {
            System.err.println("maxNOf expects a collection of ReLogoAgents.");
            return new AgentSet();
        }
        SimUtilities.shuffle(b, (Uniform)RandomHelper.getUniform());
        if (caller != null) {
            for (ReLogoAgent reLogoAgent : b) {
                reLogoAgent.setMyself(caller);
            }
        }
        closure.setResolveStrategy(1);
        Collections.sort(b, new Comparator(){

            public int compare(Object o1, Object o2) {
                closure.setDelegate(o1);
                Number n1 = (Number)closure.call(o1);
                closure.setDelegate(o2);
                Number n2 = (Number)closure.call(o2);
                return n1.doubleValue() < n2.doubleValue() ? 1 : (n1.doubleValue() == n2.doubleValue() ? 0 : -1);
            }
        });
        AgentSet<ReLogoAgent> agentSet = new AgentSet<ReLogoAgent>();
        int i = 0;
        while (i < l && i < number) {
            agentSet.add((ReLogoAgent)b.get(i));
            ++i;
        }
        return agentSet;
    }

    public static AgentSet removeLinkFromAgentSet(AgentSet a, Link l) {
        Predicate pr = NotPredicate.getInstance((Predicate)EqualPredicate.getInstance((Object)l));
        FilteredIterator result = new FilteredIterator(a.iterator(), pr);
        AgentSet<Object> b = new AgentSet<Object>();
        while (result.hasNext()) {
            b.add(result.next());
        }
        return b;
    }

    public static AgentSet removeLinkFromCollection(Collection a, Link l) {
        while (a.remove(l)) {
        }
        return new AgentSet(a);
    }

    public static AgentSet removePatchFromAgentSet(AgentSet a, Patch p) {
        Predicate pr = NotPredicate.getInstance((Predicate)EqualPredicate.getInstance((Object)p));
        FilteredIterator result = new FilteredIterator(a.iterator(), pr);
        AgentSet<Object> b = new AgentSet<Object>();
        while (result.hasNext()) {
            b.add(result.next());
        }
        return b;
    }

    public static AgentSet removePatchFromCollection(Collection a, Patch p) {
        while (a.remove(p)) {
        }
        return new AgentSet(a);
    }

    public static AgentSet removeTurtleFromAgentSet(AgentSet a, Turtle t) {
        Predicate pr = NotPredicate.getInstance((Predicate)EqualPredicate.getInstance((Object)t));
        FilteredIterator result = new FilteredIterator(a.iterator(), pr);
        AgentSet<Object> b = new AgentSet<Object>();
        while (result.hasNext()) {
            b.add(result.next());
        }
        return b;
    }

    public static AgentSet removeTurtleFromCollection(Collection a, Turtle t) {
        while (a.remove(t)) {
        }
        return new AgentSet(a);
    }

    public static AgentSet<Turtle> turtleSet(Object ... args) {
        HashSet<Turtle> tempSet = new HashSet<Turtle>();
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o != null) {
                if (o instanceof AgentSet) {
                    tempSet.addAll((AgentSet)o);
                } else if (o instanceof Turtle) {
                    tempSet.add((Turtle)o);
                } else if (o instanceof Collection) {
                    tempSet.addAll(Utility.flatten((Collection)o));
                }
            }
            ++n2;
        }
        return new AgentSet<Turtle>((Collection<Turtle>)tempSet);
    }

    public static Collection flatten(Collection c) {
        return UtilityG.gflatten(c);
    }

    public static AgentSet<Patch> patchSet(Object ... args) {
        HashSet<Patch> tempSet = new HashSet<Patch>();
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o != null) {
                if (o instanceof AgentSet) {
                    tempSet.addAll((AgentSet)o);
                } else if (o instanceof Patch) {
                    tempSet.add((Patch)o);
                } else if (o instanceof Collection) {
                    tempSet.addAll(Utility.flatten((Collection)o));
                }
            }
            ++n2;
        }
        return new AgentSet<Patch>((Collection<Patch>)tempSet);
    }

    public static AgentSet<Link> linkSet(Object ... args) {
        HashSet<Link> tempSet = new HashSet<Link>();
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o != null) {
                if (o instanceof AgentSet) {
                    tempSet.addAll((AgentSet)o);
                } else if (o instanceof Patch) {
                    tempSet.add((Link)o);
                } else if (o instanceof Collection) {
                    tempSet.addAll(Utility.flatten((Collection)o));
                }
            }
            ++n2;
        }
        return new AgentSet<Link>((Collection<Link>)tempSet);
    }

    public static <E> List<E> butFirst(List<E> a) {
        if (a.size() > 1) {
            ArrayList<E> result = new ArrayList<E>(a);
            result.subList(0, 1).clear();
            return result;
        }
        return new ArrayList();
    }

    public static String butFirst(String s) {
        int length = s.length();
        if (length > 1) {
            return s.substring(1);
        }
        return "";
    }

    public static <E> List<E> butLast(List<E> a) {
        int size = a.size();
        if (size > 1) {
            ArrayList<E> result = new ArrayList<E>(a);
            result.subList(size - 1, size).clear();
            return result;
        }
        return new ArrayList();
    }

    public static String butLast(String s) {
        int length = s.length();
        if (length > 1) {
            return s.substring(0, length - 1);
        }
        return "";
    }

    public static boolean memberQ(Object value, Collection c) {
        return c.contains(value);
    }

    public static boolean memberQ(String string1, String string2) {
        return string2.contains(string1);
    }

    public static <E extends ReLogoAgent> AgentSet<E> nOf(int number, AgentSet<E> a) {
        int size = a.size();
        if (size <= number) {
            return a;
        }
        AgentSet<E> b = new AgentSet<E>(a);
        SimUtilities.shuffle(b, (Uniform)RandomHelper.getUniform());
        b.subList(number, size).clear();
        return b;
    }

    public static <E> List<E> nOf(int number, Collection<E> c) {
        ArrayList<E> a = new ArrayList<E>(c);
        int size = a.size();
        if (size <= number) {
            return a;
        }
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int i = 0;
        while (i < number) {
            indices.add(i);
            ++i;
        }
        SimUtilities.shuffle(indices, (Uniform)RandomHelper.getUniform());
        indices.subList(number, size).clear();
        Collections.sort(indices);
        ArrayList result = new ArrayList();
        for (Integer o : indices) {
            result.add(a.get(o));
        }
        return result;
    }

    public static List nValues(int number, Closure closure) {
        ArrayList<Object> temp = new ArrayList<Object>();
        int i = 0;
        while (i < number) {
            temp.add(closure.call((Object)i));
            ++i;
        }
        return temp;
    }

    public static Object position(Object item, List list) {
        int index = list.indexOf(item);
        return index == -1 ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(index);
    }

    public static Object position(String string1, String string2) {
        int index = string2.indexOf(string1);
        return index == -1 ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(index);
    }

    public static <X> X oneOf(Collection<X> c) {
        if (c.size() == 0) {
            return null;
        }
        int index = RandomHelper.nextIntFromTo((int)0, (int)(c.size() - 1));
        return new ArrayList<X>(c).get(index);
    }

    public static <E> Collection<E> remove(Object item, Collection<E> c) {
        while (c.remove(item)) {
        }
        return c;
    }

    public static String remove(String string1, String string2) {
        return string2.replace(string1, "");
    }

    public static <E> List<E> removeDuplicates(List<E> list) {
        HashSet<E> set = new HashSet<E>();
        ArrayList<E> newList = new ArrayList<E>();
        for (E o : list) {
            if (!set.add(o)) continue;
            newList.add(o);
        }
        return newList;
    }

    public static <E> List<E> removeItem(int index, List<E> list) {
        ArrayList<E> temp = new ArrayList<E>(list);
        temp.remove(index);
        return temp;
    }

    public static String removeItem(int index, String string) {
        int length = string.length();
        if (index >= length) {
            return string;
        }
        String one = string.substring(0, index);
        if (index == length - 1) {
            return one;
        }
        String two = string.substring(index + 1);
        return one.concat(two);
    }

    public static ArrayList replaceItem(int index, List list, Object value) {
        ArrayList<Object> temp = new ArrayList<Object>(list);
        temp.set(index, value);
        return temp;
    }

    public static String replaceItem(int index, String string1, String string2) {
        int length = string1.length();
        if (index >= length) {
            return string1;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(string1.substring(0, index));
        sb.append(string2);
        if (index == length - 1) {
            return sb.toString();
        }
        sb.append(string1.substring(index + 1));
        return sb.toString();
    }

    public static <E> List<E> reverse(List<E> list) {
        ArrayList<E> result = new ArrayList<E>(list);
        Collections.reverse(result);
        return result;
    }

    public static String reverse(String string) {
        StringBuffer sb = new StringBuffer();
        int length = string.length();
        int i = length - 1;
        while (i >= 0) {
            sb.append(string.charAt(i));
            --i;
        }
        return sb.toString();
    }

    public static List sentence(Object ... args) {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof Collection) {
                result.addAll((Collection)o);
            } else {
                result.add(o);
            }
            ++n2;
        }
        return result;
    }

    public static List sort(List a) {
        int size = a.size();
        if (size <= 1) {
            return a;
        }
        ArrayList result = new ArrayList(a);
        Object firstItem = a.get(0);
        if (firstItem instanceof Number || firstItem instanceof String) {
            Collections.sort(result);
            return result;
        }
        return a;
    }

    public static List sort(AgentSet a) {
        ArrayList temp = new ArrayList(a);
        Collections.sort(temp);
        return temp;
    }

    public static <E> List<E> sublist(List<E> a, int position1, int position2) {
        return new ArrayList<E>(a.subList(position1, position2));
    }

    public static String word(Object ... args) {
        StringBuffer sb = new StringBuffer();
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            sb.append(o.toString());
            ++n2;
        }
        return sb.toString();
    }

    public static Number max(Collection c) {
        return Collections.max(c, new Comparator<Number>(){

            @Override
            public int compare(Number o1, Number o2) {
                if (!(o1 instanceof Number) || !(o2 instanceof Number)) {
                    return 0;
                }
                if (o1 instanceof Number) {
                    if (!(o2 instanceof Number)) {
                        return 1;
                    }
                    return o1.doubleValue() < o2.doubleValue() ? -1 : (o1.doubleValue() == o2.doubleValue() ? 0 : 1);
                }
                return -1;
            }
        });
    }

    public static Number min(Collection c) {
        return Collections.min(c, new Comparator<Number>(){

            @Override
            public int compare(Number o1, Number o2) {
                if (!(o1 instanceof Number) || !(o2 instanceof Number)) {
                    return 0;
                }
                if (o1 instanceof Number) {
                    if (!(o2 instanceof Number)) {
                        return -1;
                    }
                    return o1.doubleValue() < o2.doubleValue() ? -1 : (o1.doubleValue() == o2.doubleValue() ? 0 : 1);
                }
                return 1;
            }
        });
    }

    public static double mean(Collection a) {
        if (a.size() == 0) {
            return 0.0;
        }
        int numericalMembers = 0;
        double sum = 0.0;
        for (Object o : a) {
            if (!(o instanceof Number)) continue;
            ++numericalMembers;
            sum += ((Number)o).doubleValue();
        }
        if (numericalMembers == 0) {
            return 0.0;
        }
        return sum / (double)numericalMembers;
    }

    public static double median(Collection a) {
        ArrayList<Double> temp = new ArrayList<Double>();
        for (Object o : a) {
            if (!(o instanceof Number)) continue;
            temp.add(((Number)o).doubleValue());
        }
        Collections.sort(temp);
        int middle = temp.size() / 2;
        if (temp.size() % 2 == 1) {
            return (Double)temp.get(middle);
        }
        return ((Double)temp.get(middle - 1) + (Double)temp.get(middle)) / 2.0;
    }

    public static double standardDeviation(Collection a) {
        return Math.sqrt(Utility.variance(a));
    }

    public static double sqrt(Number n) {
        return Math.sqrt(n.doubleValue());
    }

    public static double abs(Number n) {
        return Math.abs(n.doubleValue());
    }

    public static double variance(Collection a) {
        double mean = Utility.mean(a);
        ArrayList<Double> temp = new ArrayList<Double>();
        for (Object o : a) {
            if (!(o instanceof Number)) continue;
            temp.add(((Number)o).doubleValue());
        }
        double sum = 0.0;
        int tempSize = temp.size();
        if (tempSize <= 1) {
            return 0.0;
        }
        int i = 0;
        while (i < tempSize) {
            double v = (Double)temp.get(i) - mean;
            sum += v * v;
            ++i;
        }
        return sum / (double)(tempSize - 1);
    }

    public static double sum(Collection a) {
        if (a.size() == 0) {
            return 0.0;
        }
        double sum = 0.0;
        for (Object o : a) {
            if (!(o instanceof Number)) continue;
            sum += ((Number)o).doubleValue();
        }
        return sum;
    }

    public static void repeat(Number number, Closure commands) {
        int i = 0;
        while (i < number.intValue()) {
            commands.call();
            ++i;
        }
    }

    public static void withLocalRandomness(Closure commands) {
        commands.call();
    }

    public static String dateAndTime() {
        String pattern = "hh:mm:ss.SSS a dd-MMM-yyyy";
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        return formatter.format(new Date());
    }

    public static double timer() {
        long lastTimer = ReLogoModel.getInstance().getLastTimer();
        long currentTime = new Date().getTime();
        double result = currentTime - lastTimer;
        return result / 1000.0;
    }

    public static void resetTimer() {
        ReLogoModel.getInstance().setLastTimer(new Date().getTime());
    }

    public static Observer getObserverByID(String observerID) {
        Context context = RunState.getInstance().getMasterContext();
        PropertyEquals query = new PropertyEquals(context, "observerID", (Object)observerID);
        Iterator result = query.query().iterator();
        if (result.hasNext()) {
            return (Observer)result.next();
        }
        return null;
    }

    public static List<Network> getDirectedNetworks(Observer observer) {
        Iterable networks = observer.getContext().getProjections(Network.class);
        ArrayList<Network> directedNetworks = new ArrayList<Network>();
        for (Object network : networks) {
            if (!((Network)network).isDirected()) continue;
            directedNetworks.add((Network)network);
        }
        return directedNetworks;
    }

    public static List<Network> getUndirectedNetworks(Observer observer) {
        Iterable networks = observer.getContext().getProjections(Network.class);
        ArrayList<Network> undirectedNetworks = new ArrayList<Network>();
        for (Object network : networks) {
            if (((Network)network).isDirected()) continue;
            undirectedNetworks.add((Network)network);
        }
        return undirectedNetworks;
    }

    public static void resetTicks() {
        ReLogoModel.getInstance().setTicks(0.0);
    }

    public static void tick() {
        double currentTicks = ReLogoModel.getInstance().getTicks();
        ReLogoModel.getInstance().setTicks(currentTicks + 1.0);
    }

    public static void tickAdvance(Number num) {
        double currentTicks = ReLogoModel.getInstance().getTicks();
        if (num.doubleValue() >= 0.0) {
            ReLogoModel.getInstance().setTicks(currentTicks + num.doubleValue());
        }
    }

    public static double ticks() {
        return ReLogoModel.getInstance().getTicks();
    }

    public static int count(Collection a) {
        return a.size();
    }

    public static void approximateHsb() {
    }

    public static void approximateRgb() {
    }

    public static void extractHsb(Number color) {
    }

    public static void extractRgb(Number color) {
    }

    public static List baseColors() {
        Integer[] baseColorsList = new Integer[]{5, 15, 25, 35, 45, 55, 65, 75, 85, 95, 105, 115, 125, 135};
        return new ArrayList<Integer>(Arrays.asList(baseColorsList));
    }

    public static List hsb(Number hh, Number ss, Number bb) {
        int rgb = Color.HSBtoRGB(hh.floatValue(), ss.floatValue(), bb.floatValue());
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        int[] color = new int[]{red, green, blue};
        return new ArrayList(Arrays.asList(new int[][]{color}));
    }

    public static List rgb(Number rr, Number gg, Number bb) {
        int r = rr.intValue();
        if (r < 0 || r > 255) {
            throw new IllegalArgumentException("RGB component out of range.");
        }
        int g = gg.intValue();
        if (g < 0 || g > 255) {
            throw new IllegalArgumentException("RGB component out of range.");
        }
        int b = bb.intValue();
        if (b < 0 || b > 255) {
            throw new IllegalArgumentException("RGB component out of range.");
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(r);
        result.add(g);
        result.add(b);
        return result;
    }

    public static double scaleColor(Number color, Number nVariableValue, Number nR1, Number nR2) {
        double r2;
        double minValueForColor = (double)((int)(color.doubleValue() / 10.0)) * 10.0;
        double variableValue = nVariableValue.doubleValue();
        double r1 = nR1.doubleValue();
        if (r1 <= (r2 = nR2.doubleValue())) {
            if (variableValue < r1) {
                return minValueForColor;
            }
            if (variableValue > r2) {
                return minValueForColor + 9.9999;
            }
            double range = r2 - r1;
            double valueInRange = variableValue - r1;
            if (range != 0.0 && valueInRange != range) {
                return minValueForColor + 10.0 * (valueInRange / range);
            }
            if (range == 0.0) {
                return minValueForColor + 5.0;
            }
            return minValueForColor + 9.9999;
        }
        if (variableValue < r2) {
            return minValueForColor + 9.9999;
        }
        if (variableValue > r1) {
            return minValueForColor;
        }
        double range = r1 - r2;
        double valueInRange = r1 - variableValue;
        if (range != 0.0 && valueInRange != range) {
            return minValueForColor + 10.0 * (valueInRange / range);
        }
        if (range == 0.0) {
            return minValueForColor + 5.0;
        }
        return minValueForColor + 9.9999;
    }

    public static boolean shadeOfQ(Number nColor1, Number nColor2) {
        double minValue = (double)((int)(nColor1.doubleValue() / 10.0)) * 10.0;
        double color2 = nColor2.doubleValue();
        return color2 >= minValue && color2 < minValue + 10.0;
    }

    public static double wrapColor(Number inputColor) {
        double d;
        block3: {
            block2: {
                d = inputColor.doubleValue();
                if (!(d < 0.0)) break block2;
                while (d < 0.0) {
                    d += 140.0;
                }
                break block3;
            }
            if (!(d >= 140.0)) break block3;
            while (d >= 140.0) {
                d -= 140.0;
            }
        }
        return d;
    }

    public static double black() {
        return 0.0;
    }

    public static double gray() {
        return 5.0;
    }

    public static double white() {
        return 9.99;
    }

    public static double red() {
        return 15.0;
    }

    public static double orange() {
        return 25.0;
    }

    public static double brown() {
        return 35.0;
    }

    public static double yellow() {
        return 45.0;
    }

    public static double green() {
        return 55.0;
    }

    public static double lime() {
        return 65.0;
    }

    public static double turquoise() {
        return 75.0;
    }

    public static double cyan() {
        return 85.0;
    }

    public static double sky() {
        return 95.0;
    }

    public static double blue() {
        return 105.0;
    }

    public static double violet() {
        return 115.0;
    }

    public static double magenta() {
        return 125.0;
    }

    public static double pink() {
        return 135.0;
    }

    public static void resetPerspective() {
    }

    public static void flushFileSinks() {
        DataSetRegistry registry = (DataSetRegistry)RunState.getInstance().getFromRegistry((Object)"repast.simphony.data.logging.registry");
        for (FileDataSink fds : registry.fileSinks()) {
            fds.flush();
        }
    }

    public static void stop() {
        RunEnvironment.getInstance().endRun();
    }

    public static void pause() {
        RunEnvironment.getInstance().pauseRun();
    }
}

