/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.relogo;

import cern.colt.function.Double9Function;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import java.util.ArrayList;
import repast.simphony.relogo.AgentSet;
import repast.simphony.relogo.Diffuse4Body;
import repast.simphony.relogo.DiffuseBody;
import repast.simphony.space.continuous.ContinuousSpace;
import repast.simphony.space.continuous.NdPoint;

public class JavaUtility {
    public static AgentSet inRadiusUtility(AgentSet a, Number num, ContinuousSpace space, NdPoint location) {
        double distSq = num.doubleValue() * num.doubleValue();
        ArrayList list = new ArrayList();
        for (Object o : a) {
            if (!(space.getDistanceSq(location, space.getLocation(o)) <= distSq)) continue;
            list.add(o);
        }
        return new AgentSet(list);
    }

    public static void diffuse(DoubleMatrix2D ddm, DoubleMatrix2D ddm2, double diffusionCoeff, boolean isMoore, boolean isPeriodic) {
        if (isPeriodic) {
            JavaUtility.diffuseP(ddm, ddm2, diffusionCoeff, isMoore);
        } else {
            JavaUtility.diffuseNP(ddm, ddm2, diffusionCoeff, isMoore);
        }
    }

    private static void diffuseP(DoubleMatrix2D ddm, DoubleMatrix2D ddm2, double diffusionCoeff, boolean isMoore) {
        int origRows = ddm.rows();
        int origCols = ddm.columns();
        DoubleMatrix2D tempBuffered = JavaUtility.bufferMatrix1(ddm);
        ddm = new DenseDoubleMatrix2D(tempBuffered.rows(), tempBuffered.columns());
        if (isMoore) {
            tempBuffered.zAssign8Neighbors(ddm, (Double9Function)new DiffuseBody(diffusionCoeff));
        } else {
            tempBuffered.zAssign8Neighbors(ddm, (Double9Function)new Diffuse4Body(diffusionCoeff));
        }
        ddm2.assign(ddm.viewPart(1, 1, origRows, origCols));
    }

    protected static DoubleMatrix2D bufferMatrix1(DoubleMatrix2D ddm) {
        DoubleFactory2D F = DoubleFactory2D.dense;
        int[] zero = new int[1];
        int[] aRows = new int[]{ddm.rows() - 1};
        int[] aColumns = new int[]{ddm.columns() - 1};
        DoubleMatrix2D[][] parts = new DoubleMatrix2D[][]{{ddm.viewSelection(aRows, aColumns), ddm.viewSelection(aRows, null), ddm.viewSelection(aRows, zero)}, {ddm.viewSelection(null, aColumns), ddm, ddm.viewSelection(null, zero)}, {ddm.viewSelection(zero, aColumns), ddm.viewSelection(zero, null), ddm.viewSelection(zero, zero)}};
        return F.compose((DoubleMatrix2D[][])parts);
    }

    private static void diffuseNP(DoubleMatrix2D ddm, DoubleMatrix2D ddm2, double diffusionCoeff, boolean isMoore) {
        if (isMoore) {
            JavaUtility.diffuseNPMoore(ddm, ddm2, diffusionCoeff);
        } else {
            JavaUtility.diffuseNPVN(ddm, ddm2, diffusionCoeff);
        }
    }

    private static void diffuseNPMoore(DoubleMatrix2D ddm, DoubleMatrix2D ddm2, double diffusionCoeff) {
        ddm.zAssign8Neighbors(ddm2, (Double9Function)new DiffuseBody(diffusionCoeff));
        int[][] nArrayArray = new int[5][];
        int[] nArray = new int[2];
        nArray[1] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        nArrayArray[1] = nArray2;
        nArrayArray[2] = new int[]{1, -1};
        int[] nArray3 = new int[2];
        nArray3[0] = 1;
        nArrayArray[3] = nArray3;
        nArrayArray[4] = new int[]{1, 1};
        int[][] firstRowNeighbors = nArrayArray;
        int[][] nArrayArray2 = new int[5][];
        int[] nArray4 = new int[2];
        nArray4[1] = -1;
        nArrayArray2[0] = nArray4;
        int[] nArray5 = new int[2];
        nArray5[1] = 1;
        nArrayArray2[1] = nArray5;
        nArrayArray2[2] = new int[]{-1, -1};
        int[] nArray6 = new int[2];
        nArray6[0] = -1;
        nArrayArray2[3] = nArray6;
        nArrayArray2[4] = new int[]{-1, 1};
        int[][] lastRowNeighbors = nArrayArray2;
        int[][] nArrayArray3 = new int[5][];
        int[] nArray7 = new int[2];
        nArray7[0] = -1;
        nArrayArray3[0] = nArray7;
        int[] nArray8 = new int[2];
        nArray8[0] = 1;
        nArrayArray3[1] = nArray8;
        nArrayArray3[2] = new int[]{-1, 1};
        int[] nArray9 = new int[2];
        nArray9[1] = 1;
        nArrayArray3[3] = nArray9;
        nArrayArray3[4] = new int[]{1, 1};
        int[][] firstColNeighbors = nArrayArray3;
        int[][] nArrayArray4 = new int[5][];
        int[] nArray10 = new int[2];
        nArray10[0] = -1;
        nArrayArray4[0] = nArray10;
        int[] nArray11 = new int[2];
        nArray11[0] = 1;
        nArrayArray4[1] = nArray11;
        nArrayArray4[2] = new int[]{-1, -1};
        int[] nArray12 = new int[2];
        nArray12[1] = -1;
        nArrayArray4[3] = nArray12;
        nArrayArray4[4] = new int[]{1, -1};
        int[][] lastColNeighbors = nArrayArray4;
        int[][] nArrayArray5 = new int[3][];
        int[] nArray13 = new int[2];
        nArray13[1] = 1;
        nArrayArray5[0] = nArray13;
        int[] nArray14 = new int[2];
        nArray14[0] = 1;
        nArrayArray5[1] = nArray14;
        nArrayArray5[2] = new int[]{1, 1};
        int[][] topLeftNeighbors = nArrayArray5;
        int[][] nArrayArray6 = new int[3][];
        int[] nArray15 = new int[2];
        nArray15[1] = -1;
        nArrayArray6[0] = nArray15;
        int[] nArray16 = new int[2];
        nArray16[0] = 1;
        nArrayArray6[1] = nArray16;
        nArrayArray6[2] = new int[]{1, -1};
        int[][] topRightNeighbors = nArrayArray6;
        int[][] nArrayArray7 = new int[3][];
        int[] nArray17 = new int[2];
        nArray17[1] = 1;
        nArrayArray7[0] = nArray17;
        int[] nArray18 = new int[2];
        nArray18[0] = -1;
        nArrayArray7[1] = nArray18;
        nArrayArray7[2] = new int[]{-1, 1};
        int[][] bottomLeftNeighbors = nArrayArray7;
        int[][] nArrayArray8 = new int[3][];
        int[] nArray19 = new int[2];
        nArray19[1] = -1;
        nArrayArray8[0] = nArray19;
        int[] nArray20 = new int[2];
        nArray20[0] = -1;
        nArrayArray8[1] = nArray20;
        nArrayArray8[2] = new int[]{-1, -1};
        int[][] bottomRightNeighbors = nArrayArray8;
        JavaUtility.allEdgeDiffuse(ddm, ddm2, firstRowNeighbors, lastRowNeighbors, firstColNeighbors, lastColNeighbors, topLeftNeighbors, topRightNeighbors, bottomLeftNeighbors, bottomRightNeighbors, diffusionCoeff, true);
    }

    private static void diffuseNPVN(DoubleMatrix2D ddm, DoubleMatrix2D ddm2, double diffusionCoeff) {
        ddm.zAssign8Neighbors(ddm2, (Double9Function)new Diffuse4Body(diffusionCoeff));
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[2];
        nArray[1] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[0] = 1;
        nArrayArray[2] = nArray3;
        int[][] firstRowNeighbors = nArrayArray;
        int[][] nArrayArray2 = new int[3][];
        int[] nArray4 = new int[2];
        nArray4[1] = -1;
        nArrayArray2[0] = nArray4;
        int[] nArray5 = new int[2];
        nArray5[1] = 1;
        nArrayArray2[1] = nArray5;
        int[] nArray6 = new int[2];
        nArray6[0] = -1;
        nArrayArray2[2] = nArray6;
        int[][] lastRowNeighbors = nArrayArray2;
        int[][] nArrayArray3 = new int[3][];
        int[] nArray7 = new int[2];
        nArray7[0] = -1;
        nArrayArray3[0] = nArray7;
        int[] nArray8 = new int[2];
        nArray8[0] = 1;
        nArrayArray3[1] = nArray8;
        int[] nArray9 = new int[2];
        nArray9[1] = 1;
        nArrayArray3[2] = nArray9;
        int[][] firstColNeighbors = nArrayArray3;
        int[][] nArrayArray4 = new int[3][];
        int[] nArray10 = new int[2];
        nArray10[0] = -1;
        nArrayArray4[0] = nArray10;
        int[] nArray11 = new int[2];
        nArray11[0] = 1;
        nArrayArray4[1] = nArray11;
        int[] nArray12 = new int[2];
        nArray12[1] = -1;
        nArrayArray4[2] = nArray12;
        int[][] lastColNeighbors = nArrayArray4;
        int[][] nArrayArray5 = new int[2][];
        int[] nArray13 = new int[2];
        nArray13[1] = 1;
        nArrayArray5[0] = nArray13;
        int[] nArray14 = new int[2];
        nArray14[0] = 1;
        nArrayArray5[1] = nArray14;
        int[][] topLeftNeighbors = nArrayArray5;
        int[][] nArrayArray6 = new int[2][];
        int[] nArray15 = new int[2];
        nArray15[1] = -1;
        nArrayArray6[0] = nArray15;
        int[] nArray16 = new int[2];
        nArray16[0] = 1;
        nArrayArray6[1] = nArray16;
        int[][] topRightNeighbors = nArrayArray6;
        int[][] nArrayArray7 = new int[2][];
        int[] nArray17 = new int[2];
        nArray17[1] = 1;
        nArrayArray7[0] = nArray17;
        int[] nArray18 = new int[2];
        nArray18[0] = -1;
        nArrayArray7[1] = nArray18;
        int[][] bottomLeftNeighbors = nArrayArray7;
        int[][] nArrayArray8 = new int[2][];
        int[] nArray19 = new int[2];
        nArray19[1] = -1;
        nArrayArray8[0] = nArray19;
        int[] nArray20 = new int[2];
        nArray20[0] = -1;
        nArrayArray8[1] = nArray20;
        int[][] bottomRightNeighbors = nArrayArray8;
        JavaUtility.allEdgeDiffuse(ddm, ddm2, firstRowNeighbors, lastRowNeighbors, firstColNeighbors, lastColNeighbors, topLeftNeighbors, topRightNeighbors, bottomLeftNeighbors, bottomRightNeighbors, diffusionCoeff, false);
    }

    private static void allEdgeDiffuse(DoubleMatrix2D ddm, DoubleMatrix2D ddm2, int[][] firstRowNeighbors, int[][] lastRowNeighbors, int[][] firstColNeighbors, int[][] lastColNeighbors, int[][] topLeftNeighbors, int[][] topRightNeighbors, int[][] bottomLeftNeighbors, int[][] bottomRightNeighbors, double diffusionCoeff, boolean isMoore) {
        int rows = ddm.rows();
        int columns = ddm.columns();
        JavaUtility.edgeDiffuse(ddm, ddm2, firstRowNeighbors, 0, 0, 1, columns - 2, diffusionCoeff, isMoore);
        JavaUtility.edgeDiffuse(ddm, ddm2, lastRowNeighbors, rows - 1, rows - 1, 1, columns - 2, diffusionCoeff, isMoore);
        JavaUtility.edgeDiffuse(ddm, ddm2, firstColNeighbors, 1, rows - 2, 0, 0, diffusionCoeff, isMoore);
        JavaUtility.edgeDiffuse(ddm, ddm2, lastColNeighbors, 1, rows - 2, columns - 1, columns - 1, diffusionCoeff, isMoore);
        JavaUtility.edgeDiffuse(ddm, ddm2, topLeftNeighbors, 0, 0, 0, 0, diffusionCoeff, isMoore);
        JavaUtility.edgeDiffuse(ddm, ddm2, topRightNeighbors, 0, 0, columns - 1, columns - 1, diffusionCoeff, isMoore);
        JavaUtility.edgeDiffuse(ddm, ddm2, bottomLeftNeighbors, rows - 1, rows - 1, 0, 0, diffusionCoeff, isMoore);
        JavaUtility.edgeDiffuse(ddm, ddm2, bottomRightNeighbors, rows - 1, rows - 1, columns - 1, columns - 1, diffusionCoeff, isMoore);
    }

    public static void edgeDiffuse(DoubleMatrix2D ddm, DoubleMatrix2D ddm2, int[][] neighbors, int rowMin, int rowMax, int colMin, int colMax, double diffusionCoeff, boolean isMoore) {
        int totalPossibleNeighbors = isMoore ? 8 : 4;
        int maxRow = ddm.rows() - 1;
        int maxCol = ddm.columns() - 1;
        int row = rowMin;
        while (row <= rowMax) {
            int col = colMin;
            while (col <= colMax) {
                double neighborTally = 0.0;
                int numNeighbors = 0;
                int neighbor = 0;
                while (neighbor < neighbors.length) {
                    int rowIndex = neighbors[neighbor][0] + row;
                    int colIndex = neighbors[neighbor][1] + col;
                    if (rowIndex >= 0 && rowIndex <= maxRow && colIndex >= 0 && colIndex <= maxCol) {
                        neighborTally += ddm.getQuick(rowIndex, colIndex);
                        ++numNeighbors;
                    }
                    ++neighbor;
                }
                ddm2.setQuick(row, col, ddm.getQuick(row, col) * (1.0 - diffusionCoeff * (double)numNeighbors / (double)totalPossibleNeighbors) + neighborTally * diffusionCoeff / (double)totalPossibleNeighbors);
                ++col;
            }
            ++row;
        }
    }
}

