/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.relogo;

import groovy.lang.Closure;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import repast.simphony.context.Context;
import repast.simphony.relogo.AgentSet;
import repast.simphony.relogo.BaseTurtle;
import repast.simphony.relogo.Link;
import repast.simphony.relogo.Observer;
import repast.simphony.relogo.OutOfContextSubject;
import repast.simphony.relogo.OutOfContextSubscriber;
import repast.simphony.relogo.Patch;
import repast.simphony.relogo.ReLogoAgent;
import repast.simphony.relogo.Stop;
import repast.simphony.relogo.TrackingEdge;
import repast.simphony.relogo.Turtle;
import repast.simphony.relogo.Utility;
import repast.simphony.relogo.UtilityG;
import repast.simphony.relogo.WayPoint;
import repast.simphony.relogo.factories.TurtleFactory;
import repast.simphony.space.SpatialException;
import repast.simphony.space.continuous.ContinuousSpace;
import repast.simphony.space.continuous.NdPoint;
import repast.simphony.space.continuous.PointTranslator;
import repast.simphony.space.continuous.WrapAroundBorders;
import repast.simphony.space.graph.Network;
import repast.simphony.space.grid.Grid;
import repast.simphony.space.grid.GridPoint;

public abstract class AbstractTurtle
implements Turtle {
    private Object myselfObject;
    Map props;
    Set<Turtle> fixedLeaves = Collections.synchronizedSet(new HashSet());
    Set<Turtle> freeLeaves = Collections.synchronizedSet(new HashSet());
    boolean moved = false;
    boolean shapeChanged = false;
    boolean visibilityChanged = false;
    Set<OutOfContextSubscriber> outOfContextSubscribers = Collections.synchronizedSet(new HashSet());
    WayPoint lastWayPoint;
    Object label;
    Observer myObserver;
    TurtleFactory myTurtleFactory;
    static int whoCounter = 0;
    double color;
    double heading = 0.0;
    public boolean hiddenQ = false;
    double labelColor = Utility.white();
    int penMode = 0;
    int penSize = 1;
    String shape = "default";
    double size = 1.0;
    int who;
    private NdPoint loc = new NdPoint(new double[]{0.0, 0.0});

    @Override
    public void setMyself(Object o) {
        this.myselfObject = o;
    }

    @Override
    public boolean isShapeChanged() {
        return this.shapeChanged;
    }

    @Override
    public void setShapeChanged(boolean shapeChanged) {
        this.shapeChanged = shapeChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean fixedLeavesContains(Turtle t) {
        Set<Turtle> set = this.fixedLeaves;
        synchronized (set) {
            return this.fixedLeaves.contains(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromFixedLeaves(OutOfContextSubject t) {
        Set<Turtle> set = this.fixedLeaves;
        synchronized (set) {
            this.fixedLeaves.remove(t);
        }
        t.removeSubscriber(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToFixedLeaves(Turtle t) {
        Set<Turtle> set = this.fixedLeaves;
        synchronized (set) {
            this.fixedLeaves.add(t);
        }
        t.registerSubscriber(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean freeLeavesContains(Object o) {
        Set<Turtle> set = this.freeLeaves;
        synchronized (set) {
            return this.freeLeaves.contains(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromFreeLeaves(Turtle o) {
        Set<Turtle> set = this.freeLeaves;
        synchronized (set) {
            this.freeLeaves.remove(o);
        }
        o.removeSubscriber(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToFreeLeaves(Turtle o) {
        Set<Turtle> set = this.freeLeaves;
        synchronized (set) {
            this.freeLeaves.add(o);
        }
        o.registerSubscriber(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSubscriber(Turtle t) {
        Set<OutOfContextSubscriber> set = this.outOfContextSubscribers;
        synchronized (set) {
            this.outOfContextSubscribers.add(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubscriber(Turtle t) {
        Set<OutOfContextSubscriber> set = this.outOfContextSubscribers;
        synchronized (set) {
            this.outOfContextSubscribers.remove(t);
        }
    }

    @Override
    public void notifySubscribers() {
        for (OutOfContextSubscriber o : this.outOfContextSubscribers) {
            o.update(this);
        }
    }

    @Override
    public void update(Turtle o) {
        this.removeFromFixedLeaves(o);
        this.removeFromFreeLeaves(o);
    }

    @Override
    public Object myself() {
        return this.myselfObject;
    }

    @Override
    public Turtle self() {
        return this;
    }

    public Observer getMyObserver() {
        return this.myObserver;
    }

    public void setMyObserver(Observer myObserver) {
        this.myObserver = myObserver;
    }

    public TurtleFactory getMyTurtleFactory() {
        return this.myTurtleFactory;
    }

    public void setMyTurtleFactory(TurtleFactory myTurtleFactory) {
        this.myTurtleFactory = myTurtleFactory;
    }

    public void setBaseTurtleProperties(Observer observer, TurtleFactory turtleFactory, String turtleShape, double heading, double color, NdPoint loc) {
        this.setMyObserver(observer);
        this.setMyTurtleFactory(turtleFactory);
        this.shape = turtleShape;
        this.setHeading(heading);
        this.setColor(color);
        observer.getContext().add((Object)this);
        this.setxy(loc.getX(), loc.getY());
        this.who = whoCounter++;
    }

    @Override
    public AgentSet<Turtle> hatch(Number number) {
        return this.hatch(number, null);
    }

    @Override
    public AgentSet<Turtle> hatch(Number number, Closure closure) {
        AgentSet<Turtle> newTurtles = new AgentSet<Turtle>();
        int i = 0;
        while (i < number.intValue()) {
            newTurtles.add(this.getMyTurtleFactory().createIdenticalTurtle(this));
            ++i;
        }
        if (closure != null) {
            this.ask(newTurtles, closure);
        }
        return newTurtles;
    }

    @Override
    public AgentSet<Turtle> hatch(Number number, Closure closure, String childType) {
        AgentSet<Turtle> newTurtles = new AgentSet<Turtle>();
        int i = 0;
        while (i < number.intValue()) {
            newTurtles.add(this.getMyTurtleFactory().createIdenticalTurtle(this, childType));
            ++i;
        }
        if (closure != null) {
            this.ask(newTurtles, closure);
        }
        return newTurtles;
    }

    @Override
    public AgentSet<Turtle> hatch(Number number, Closure closure, Class childType) {
        return this.hatch(number, closure, childType.getSimpleName());
    }

    @Override
    public void ask(AgentSet<? extends ReLogoAgent> a, Closure askBlock) {
        try {
            for (ReLogoAgent reLogoAgent : a) {
                reLogoAgent.setMyself(this);
            }
            try {
                a.askAgentSet(askBlock);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            System.err.println("ask(" + a + ") failed.");
            System.err.println("ask(AgentSet) requires all members of AgentSet to extend ReLogoAgent.");
        }
    }

    @Override
    public void ask(Collection<? extends ReLogoAgent> c, Closure askBlock) {
        try {
            for (ReLogoAgent reLogoAgent : c) {
                reLogoAgent.setMyself(this);
            }
            try {
                this.askCollection(c, askBlock);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            System.err.println("ask(" + c + ") failed.");
            System.err.println("ask(List) requires all members of List to extend ReLogoAgent.");
        }
    }

    public void askCollection(Collection<? extends ReLogoAgent> l, Closure cl) {
        cl.setResolveStrategy(1);
        for (ReLogoAgent reLogoAgent : l) {
            cl.setDelegate((Object)reLogoAgent);
            cl.call((Object)reLogoAgent);
        }
    }

    @Override
    public void ask(Turtle t, Closure askBlock) {
        t.setMyself(this);
        t.askTurtle(askBlock);
    }

    @Override
    public void ask(Patch p, Closure askBlock) {
        p.setMyself(this);
        p.askPatch(askBlock);
    }

    @Override
    public void ask(Link l, Closure askBlock) {
        l.setMyself(this);
        l.askLink(askBlock);
    }

    @Override
    public void askTurtle(Closure cl) {
        cl.setResolveStrategy(1);
        cl.setDelegate((Object)this);
        cl.call((Object)this);
    }

    @Override
    public void run(String string) {
        UtilityG.runU(string, this);
    }

    @Override
    public Object runresult(String string) {
        return UtilityG.runresultU(string, this);
    }

    public String getTurtleType() {
        return this.getClass().getSimpleName();
    }

    public void setUserDefinedVariables(Turtle parent) {
        ArrayList parentHierarchy = new ArrayList();
        ArrayList thisHierarchy = new ArrayList();
        Class<?> parentClass = parent.getClass();
        while (parentClass != BaseTurtle.class) {
            parentHierarchy.add(parentClass);
            parentClass = parentClass.getSuperclass();
        }
        Collections.reverse(parentHierarchy);
        Class<?> thisClass = this.getClass();
        while (thisClass != BaseTurtle.class) {
            thisHierarchy.add(thisClass);
            thisClass = thisClass.getSuperclass();
        }
        Collections.reverse(thisHierarchy);
        int i = 0;
        while (i < thisHierarchy.size() && i < parentHierarchy.size() && thisHierarchy.get(i) == parentHierarchy.get(i)) {
            Field[] fieldArray = ((Class)thisHierarchy.get(i)).getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                int modifier = field.getModifiers();
                if (!Modifier.isStatic(modifier) && !Modifier.isTransient(modifier)) {
                    field.setAccessible(true);
                    try {
                        field.set(this, field.get(parent));
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
            ++i;
        }
    }

    @Override
    public double getXcor() {
        return this.getTurtleLocation().getX();
    }

    @Override
    public void setXcor(Number number) {
        this.setxy(number, this.getTurtleLocation().getY());
    }

    @Override
    public double getYcor() {
        return this.getTurtleLocation().getY();
    }

    @Override
    public void setYcor(Number number) {
        this.setxy(this.getTurtleLocation().getX(), number);
    }

    @Override
    public NdPoint getTurtleLocation() {
        return this.loc;
    }

    @Override
    public double getPcolor() {
        return this.patchHere().getPcolor();
    }

    @Override
    public void setPcolor(Number color) {
        this.patchHere().setPcolor(color.doubleValue());
    }

    @Override
    public int getPxcor() {
        return this.patchHere().getPxcor();
    }

    @Override
    public int getPycor() {
        return this.patchHere().getPycor();
    }

    @Override
    public void setColor(Number color) {
        this.color = Utility.wrapColor(color.doubleValue());
    }

    @Override
    public double getHeading() {
        return this.heading;
    }

    @Override
    public double getHeadingInRads() {
        return this.heading * Math.PI / 180.0;
    }

    @Override
    public void setHeading(Number nNum) {
        double num = nNum.doubleValue();
        if (!this.moved) {
            this.moved = true;
            double priorHeading = this.getHeading();
            double tempHeading = num % 360.0;
            double d = this.heading = tempHeading < 0.0 ? tempHeading + 360.0 : tempHeading;
            if (!this.fixedLeaves.isEmpty() || !this.freeLeaves.isEmpty()) {
                double angleTurned = Utility.subtractHeadings(this.getHeading(), priorHeading);
                Context context = this.getMyObserver().getContext();
                HashSet<Turtle> temporarySet = new HashSet<Turtle>(this.fixedLeaves);
                temporarySet.addAll(this.freeLeaves);
                for (Turtle t : temporarySet) {
                    double initialLinkAngle = this.towards(t);
                    double distanceToLeaf = this.distance(t);
                    double[] displacementToLeaf = Utility.getDisplacementFromHeadingAndDistance(Utility.getNLAngle(initialLinkAngle + angleTurned), distanceToLeaf);
                    double[] leafLocation = new double[]{displacementToLeaf[0] + this.getXcor(), displacementToLeaf[1] + this.getYcor()};
                    t.setxy(leafLocation[0], leafLocation[1]);
                }
                for (Turtle t : this.fixedLeaves) {
                    t.setHeading(t.getHeading() + angleTurned);
                }
            }
            this.moved = false;
        }
    }

    @Override
    public double getColor() {
        return this.color;
    }

    @Override
    public boolean isHiddenQ() {
        return this.hiddenQ;
    }

    @Override
    public boolean isVisibilityChanged() {
        return this.visibilityChanged;
    }

    @Override
    public void setVisibilityChanged(boolean visibilityChanged) {
        this.visibilityChanged = visibilityChanged;
    }

    @Override
    public void setHiddenQ(boolean hidden) {
        if (this.hiddenQ != hidden) {
            this.setVisibilityChanged(true);
        }
        this.hiddenQ = hidden;
    }

    @Override
    public Object getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(Object label) {
        this.label = label;
    }

    @Override
    public double getLabelColor() {
        return this.labelColor;
    }

    @Override
    public void setLabelColor(Number labelColor) {
        this.labelColor = Utility.wrapColor(labelColor.doubleValue());
    }

    @Override
    public int getPenMode() {
        return this.penMode;
    }

    @Override
    public void setPenMode(Number penMode) {
        this.penMode = penMode.intValue();
    }

    @Override
    public void pu() {
        this.penUp();
    }

    @Override
    public void penUp() {
        this.setPenMode(0);
        this.lastWayPoint = null;
    }

    @Override
    public void pd() {
        this.penDown();
    }

    @Override
    public void penDown() {
        this.setPenMode(1);
    }

    @Override
    public void pe() {
        this.penErase();
    }

    @Override
    public void penErase() {
    }

    @Override
    public int getPenSize() {
        return this.penSize;
    }

    @Override
    public void setPenSize(Number penSize) {
        this.penSize = penSize.intValue();
    }

    @Override
    public String getShape() {
        return this.shape;
    }

    @Override
    public void setShape(String shape) {
        this.shape = shape;
        this.setShapeChanged(true);
    }

    @Override
    public double getSize() {
        return this.size;
    }

    @Override
    public void setSize(Number size) {
        this.size = size.doubleValue();
    }

    @Override
    public int getWho() {
        return this.who;
    }

    @Override
    public void rt(Number num) {
        this.setHeading(this.heading + num.doubleValue());
    }

    @Override
    public void right(Number num) {
        this.rt(num);
    }

    @Override
    public void lt(Number num) {
        this.setHeading(this.heading - num.doubleValue());
    }

    @Override
    public void left(Number num) {
        this.lt(num);
    }

    @Override
    public void fd(Number num) {
        this.mv(num);
    }

    @Override
    public void forward(Number num) {
        this.fd(num);
    }

    @Override
    public void bk(Number num) {
        this.mv(-num.doubleValue());
    }

    @Override
    public void back(Number num) {
        this.bk(num);
    }

    @Override
    public void jump(Number num) {
        if (this.canMoveQ(num)) {
            this.fd(num);
        }
    }

    public void move(Number nNumber) {
        this.mv(nNumber);
    }

    @Override
    public void mv(Number nNumber) {
        double number = nNumber.doubleValue();
        if (!this.moved) {
            this.moved = true;
            ContinuousSpace space = this.getMyObserver().getSpace();
            if (this.penMode == 1 && this.lastWayPoint == null) {
                this.lastWayPoint = new WayPoint();
                this.getMyObserver().getContext().add((Object)this.lastWayPoint);
                space.moveTo((Object)this.lastWayPoint, space.getLocation((Object)this).toDoubleArray(null));
            }
            double[] anglesForMoveByVector = new double[]{1.5707963267948966 - this.getHeadingInRads(), 0.0};
            NdPoint oldLocation = new NdPoint(this.getTurtleLocation().toDoubleArray(null));
            this.loc = space.moveByVector((Object)this, number, anglesForMoveByVector);
            this.getMyObserver().getGrid().moveTo((Object)this, Utility.ndPointToIntArray(this.getTurtleLocation()));
            if (!this.fixedLeaves.isEmpty() || !this.freeLeaves.isEmpty()) {
                double[] displacement = space.getDisplacement(oldLocation, this.getTurtleLocation());
                HashSet<Turtle> temporarySet = new HashSet<Turtle>(this.fixedLeaves);
                temporarySet.addAll(this.freeLeaves);
                for (Turtle t : temporarySet) {
                    this.setxy(t.getXcor() + displacement[0], t.getYcor() + displacement[1]);
                }
            }
            if (this.penMode == 1) {
                boolean newLocationWrapped = false;
                if (space.isPeriodic()) {
                    newLocationWrapped = ((WrapAroundBorders)space.getPointTranslator()).isNewLocationWrapped();
                }
                WayPoint newWayPoint = new WayPoint();
                this.getMyObserver().getContext().add((Object)newWayPoint);
                space.moveTo((Object)newWayPoint, space.getLocation((Object)this).toDoubleArray(null));
                if (!newLocationWrapped) {
                    Network net = (Network)this.getMyObserver().getContext().getProjection("Tracking Network");
                    TrackingEdge trackingEdge = (TrackingEdge)net.addEdge((Object)this.lastWayPoint, (Object)newWayPoint);
                    trackingEdge.setColor(this.getColor());
                    trackingEdge.setSize(this.getPenSize());
                }
                this.lastWayPoint = newWayPoint;
            }
            this.moved = false;
        }
    }

    @Override
    public void setxy(Number nX, Number nY) {
        double x = nX.doubleValue();
        double y = nY.doubleValue();
        if (!this.moved) {
            this.moved = true;
            ContinuousSpace space = this.getMyObserver().getSpace();
            if (this.penMode == 1 && this.lastWayPoint == null) {
                this.lastWayPoint = new WayPoint();
                this.getMyObserver().getContext().add((Object)this.lastWayPoint);
                space.moveTo((Object)this.lastWayPoint, space.getLocation((Object)this).toDoubleArray(null));
            }
            double[] point = new double[]{x, y};
            NdPoint oldLocation = new NdPoint(this.getTurtleLocation().toDoubleArray(null));
            this.getMyObserver().getSpace().moveTo((Object)this, point);
            this.loc = this.getMyObserver().getSpace().getLocation((Object)this);
            this.getMyObserver().getGrid().moveTo((Object)this, Utility.ndPointToIntArray(this.getTurtleLocation()));
            if (!this.fixedLeaves.isEmpty() || !this.freeLeaves.isEmpty()) {
                double[] displacement = space.getDisplacement(oldLocation, this.getTurtleLocation());
                HashSet<Turtle> temporarySet = new HashSet<Turtle>(this.fixedLeaves);
                temporarySet.addAll(this.freeLeaves);
                for (Turtle t : temporarySet) {
                    this.setxy(t.getXcor() + displacement[0], t.getYcor() + displacement[1]);
                }
            }
            if (this.penMode == 1) {
                WayPoint newWayPoint = new WayPoint();
                this.getMyObserver().getContext().add((Object)newWayPoint);
                space.moveTo((Object)newWayPoint, space.getLocation((Object)this).toDoubleArray(null));
                Network net = (Network)this.getMyObserver().getContext().getProjection("Tracking Network");
                TrackingEdge trackingEdge = (TrackingEdge)net.addEdge((Object)this.lastWayPoint, (Object)newWayPoint);
                trackingEdge.setColor(this.getColor());
                trackingEdge.setSize(this.getPenSize());
                this.lastWayPoint = newWayPoint;
            }
            this.moved = false;
        }
    }

    @Override
    public void die() {
        this.getMyObserver().getContext().remove((Object)this);
        this.notifySubscribers();
    }

    @Override
    public void ht() {
        this.setHiddenQ(true);
    }

    @Override
    public void hideTurtle() {
        this.ht();
    }

    @Override
    public void st() {
        this.setHiddenQ(false);
    }

    @Override
    public void showTurtle() {
        this.st();
    }

    @Override
    public void home() {
        this.setxy(0.0, 0.0);
    }

    @Override
    public double dx() {
        return Math.sin(this.heading * Math.PI / 180.0);
    }

    @Override
    public double dy() {
        return Math.cos(this.heading * Math.PI / 180.0);
    }

    @Override
    public double distance(Turtle t) {
        return this.getMyObserver().getSpace().getDistance(this.getTurtleLocation(), t.getTurtleLocation());
    }

    @Override
    public double distance(Patch p) {
        return this.getMyObserver().getSpace().getDistance(this.getTurtleLocation(), p.getGridLocationAsNdPoint());
    }

    @Override
    public double distancexy(Number nX, Number nY) {
        double x = nX.doubleValue();
        double y = nY.doubleValue();
        return this.getMyObserver().getSpace().getDistance(this.getTurtleLocation(), new NdPoint(new double[]{x, y}));
    }

    @Override
    public double towards(Turtle t) {
        double[] displacement = this.getMyObserver().getSpace().getDisplacement(this.getTurtleLocation(), t.getTurtleLocation());
        return Utility.angleFromDisplacement(displacement[0], displacement[1]);
    }

    @Override
    public double towards(Patch p) {
        double[] displacement = this.getMyObserver().getSpace().getDisplacement(this.getTurtleLocation(), p.getGridLocationAsNdPoint());
        return Utility.angleFromDisplacement(displacement[0], displacement[1]);
    }

    @Override
    public double towardsxy(Number nX, Number nY) {
        double x = nX.doubleValue();
        double y = nY.doubleValue();
        double[] displacement = this.getMyObserver().getSpace().getDisplacement(this.getTurtleLocation(), new NdPoint(new double[]{x, y}));
        return Utility.angleFromDisplacement(displacement[0], displacement[1]);
    }

    @Override
    public void face(Turtle t) {
        if (!t.getTurtleLocation().equals((Object)this.getTurtleLocation())) {
            this.setHeading(this.towards(t));
        }
    }

    @Override
    public void face(Patch p) {
        if (!p.getGridLocationAsNdPoint().equals((Object)this.getTurtleLocation())) {
            this.setHeading(this.towards(p));
        }
    }

    @Override
    public void facexy(Number nX, Number nY) {
        double x = nX.doubleValue();
        double y = nY.doubleValue();
        if (!this.getTurtleLocation().equals((Object)new NdPoint(new double[]{x, y}))) {
            this.setHeading(this.towardsxy(x, y));
        }
    }

    @Override
    public boolean canMoveQ(Number nDist) {
        double dist = nDist.doubleValue();
        double xDisp = this.getTurtleLocation().getX() + dist * this.dx();
        double yDisp = this.getTurtleLocation().getY() + dist * this.dy();
        PointTranslator pt = this.getMyObserver().getSpace().getPointTranslator();
        try {
            double[] temp = new double[2];
            pt.translate(this.getTurtleLocation(), temp, new double[]{xDisp, yDisp});
            return true;
        }
        catch (SpatialException se) {
            return false;
        }
    }

    @Override
    public void moveTo(Turtle t) {
        this.setxy(t.getTurtleLocation().getX(), t.getTurtleLocation().getY());
    }

    @Override
    public void moveTo(Patch p) {
        this.setxy(p.getGridLocationAsNdPoint().getX(), p.getGridLocationAsNdPoint().getY());
    }

    @Override
    public AgentSet<Turtle> turtlesAt(Number nX, Number nY) {
        double dx = nX.doubleValue();
        double dy = nY.doubleValue();
        double[] displacement = new double[]{dx, dy};
        try {
            GridPoint gridPoint = Utility.getGridPointAtDisplacement(this.getTurtleLocation(), displacement, this.getMyObserver());
            return Utility.getTurtlesOnGridPoint(gridPoint, this.getMyObserver());
        }
        catch (SpatialException e) {
            return null;
        }
    }

    @Override
    public AgentSet<Turtle> turtlesHere() {
        Grid grid = this.getMyObserver().getGrid();
        GridPoint gridPoint = grid.getLocation((Object)this);
        return Utility.getTurtlesOnGridPoint(gridPoint, this.getMyObserver());
    }

    @Override
    public AgentSet<Turtle> turtlesOn(Patch p) {
        return Utility.getTurtlesOnGridPoint(p.getGridLocation(), this.getMyObserver());
    }

    @Override
    public AgentSet<Turtle> turtlesOn(Turtle t) {
        return Utility.getTurtlesOnGridPoint(Utility.ndPointToGridPoint(t.getTurtleLocation()), this.getMyObserver());
    }

    @Override
    public AgentSet<Turtle> turtlesOn(Collection a) {
        if (a == null || a.isEmpty()) {
            return new AgentSet<Turtle>();
        }
        HashSet<Turtle> total = new HashSet<Turtle>();
        if (a.iterator().next() instanceof Turtle) {
            for (Object t : a) {
                NdPoint location = ((Turtle)t).getTurtleLocation();
                AgentSet<Turtle> temp = Utility.getTurtlesOnGridPoint(Utility.ndPointToGridPoint(location), this.getMyObserver());
                total.addAll(temp);
            }
        } else {
            for (Object p : a) {
                GridPoint location = ((Patch)p).getGridLocation();
                AgentSet<Turtle> temp = Utility.getTurtlesOnGridPoint(location, this.getMyObserver());
                total.addAll(temp);
            }
        }
        return new AgentSet<Turtle>((Collection<Turtle>)total);
    }

    @Override
    public Patch patchHere() {
        return Utility.getPatchAtLocation(Utility.ndPointToGridPoint(this.getTurtleLocation()), this.getMyObserver());
    }

    @Override
    public Patch patchAhead(Number distance) {
        double[] displacement = Utility.getDisplacementFromHeadingAndDistance(this.heading, distance.doubleValue());
        try {
            return Utility.getPatchAtLocation(Utility.getGridPointAtDisplacement(this.getTurtleLocation(), displacement, this.getMyObserver()), this.getMyObserver());
        }
        catch (SpatialException e) {
            return null;
        }
    }

    @Override
    public Patch patchAt(Number nX, Number nY) {
        double dx = nX.doubleValue();
        double dy = nY.doubleValue();
        double[] displacement = new double[]{dx, dy};
        try {
            return Utility.getPatchAtLocation(Utility.getGridPointAtDisplacement(this.getTurtleLocation(), displacement, this.getMyObserver()), this.getMyObserver());
        }
        catch (SpatialException e) {
            return null;
        }
    }

    @Override
    public Patch patchAtHeadingAndDistance(Number nHeading, Number nDistance) {
        double[] displacement = Utility.getDisplacementFromHeadingAndDistance(nHeading.doubleValue(), nDistance.doubleValue());
        try {
            return Utility.getPatchAtLocation(Utility.getGridPointAtDisplacement(this.getTurtleLocation(), displacement, this.getMyObserver()), this.getMyObserver());
        }
        catch (SpatialException e) {
            return null;
        }
    }

    @Override
    public Patch patchLeftAndAhead(Number nAngle, Number nDistance) {
        double angle = nAngle.doubleValue();
        double distance = nDistance.doubleValue();
        double heading = Utility.getNLAngle(this.heading - angle);
        double[] displacement = Utility.getDisplacementFromHeadingAndDistance(heading, distance);
        try {
            return Utility.getPatchAtLocation(Utility.getGridPointAtDisplacement(this.getTurtleLocation(), displacement, this.getMyObserver()), this.getMyObserver());
        }
        catch (SpatialException e) {
            return null;
        }
    }

    @Override
    public Patch patchRightAndAhead(Number nAngle, Number nDistance) {
        double angle = nAngle.doubleValue();
        double distance = nDistance.doubleValue();
        double heading = Utility.getNLAngle(this.heading + angle);
        double[] displacement = Utility.getDisplacementFromHeadingAndDistance(heading, distance);
        try {
            return Utility.getPatchAtLocation(Utility.getGridPointAtDisplacement(this.getTurtleLocation(), displacement, this.getMyObserver()), this.getMyObserver());
        }
        catch (SpatialException e) {
            return null;
        }
    }

    @Override
    public AgentSet<Patch> neighbors() {
        return this.patchHere().neighbors();
    }

    @Override
    public AgentSet<Patch> neighbors(int extent) {
        return this.patchHere().neighbors(extent, extent);
    }

    @Override
    public AgentSet<Patch> neighbors(int extentX, int extentY) {
        return this.patchHere().neighbors(extentX, extentY);
    }

    @Override
    public AgentSet<Patch> neighbors4() {
        return this.patchHere().neighbors4();
    }

    @Override
    public AgentSet<Patch> neighbors4(int extent) {
        return this.patchHere().neighbors4(extent, extent);
    }

    @Override
    public AgentSet<Patch> neighbors4(int extentX, int extentY) {
        return this.patchHere().neighbors4(extentX, extentY);
    }

    @Override
    public AgentSet inRadius(Collection a, Number num) {
        ContinuousSpace space = this.getMyObserver().getSpace();
        double distSq = num.doubleValue() * num.doubleValue();
        AgentSet list = new AgentSet();
        for (Object o : a) {
            if (!(space.getDistanceSq(this.getTurtleLocation(), space.getLocation(o)) <= distSq)) continue;
            list.add(o);
        }
        return list;
    }

    @Override
    public AgentSet inCone(Collection a, Number num, Number angle) {
        if (angle.doubleValue() >= 360.0) {
            return this.inRadius(a, num);
        }
        ContinuousSpace space = this.getMyObserver().getSpace();
        double distSq = num.doubleValue() * num.doubleValue();
        AgentSet list = new AgentSet();
        for (Object o : a) {
            double candidateHeading;
            if (!(space.getDistanceSq(this.getTurtleLocation(), space.getLocation(o)) <= distSq)) continue;
            if (o instanceof Turtle) {
                candidateHeading = this.towards((Turtle)o);
                if (Math.abs(Utility.subtractHeadings(this.getHeading(), candidateHeading)) < angle.doubleValue() / 2.0) {
                    list.add(o);
                }
            }
            if (!(o instanceof Patch)) continue;
            candidateHeading = this.towards((Patch)o);
            if (!(Math.abs(Utility.subtractHeadings(this.getHeading(), candidateHeading)) < angle.doubleValue() / 2.0)) continue;
            list.add(o);
        }
        return list;
    }

    @Override
    public AgentSet other(Collection a) {
        return Utility.removeTurtleFromCollection(a, this);
    }

    public static int getWhoCounter() {
        return whoCounter;
    }

    public static void setWhoCounter(Number whoCounter) {
        BaseTurtle.whoCounter = whoCounter.intValue();
    }

    @Override
    public void fileShow(Object value) {
        UtilityG.fileShowU(this.toString(), value);
    }

    @Override
    public void show(Object value) {
        UtilityG.showU(this.toString(), value);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getTurtleType()) + " " + this.getWho();
    }

    @Override
    public Link createLinkFrom(Turtle t) {
        return this.createLinkFrom(t, null);
    }

    @Override
    public Link createLinkFrom(Turtle t, Closure closure) {
        Network network = this.getMyObserver().getNetwork("DirectedLinks");
        Link link = (Link)network.addEdge((Object)t, (Object)this);
        if (closure != null) {
            this.ask(link, closure);
        }
        return link;
    }

    @Override
    public Link createLinkTo(Turtle t) {
        return this.createLinkTo(t, null);
    }

    @Override
    public Link createLinkTo(Turtle t, Closure closure) {
        Network network = this.getMyObserver().getNetwork("DirectedLinks");
        Link link = (Link)network.addEdge((Object)this, (Object)t);
        if (closure != null) {
            this.ask(link, closure);
        }
        return link;
    }

    @Override
    public Link createLinkWith(Turtle t) {
        return this.createLinkWith(t, null);
    }

    @Override
    public Link createLinkWith(Turtle t, Closure closure) {
        Network network = this.getMyObserver().getNetwork("UndirectedLinks");
        Link link = (Link)network.addEdge((Object)this, (Object)t);
        if (closure != null) {
            this.ask(link, closure);
        }
        return link;
    }

    @Override
    public AgentSet<Link> createLinksFrom(Collection<? extends Turtle> a) {
        return this.createLinksFrom(a, null);
    }

    @Override
    public AgentSet<Link> createLinksFrom(Collection<? extends Turtle> a, Closure closure) {
        Network network = this.getMyObserver().getNetwork("DirectedLinks");
        AgentSet<Link> links = new AgentSet<Link>();
        for (Turtle turtle : a) {
            links.add((Link)network.addEdge((Object)turtle, (Object)this));
        }
        if (closure != null) {
            this.ask(links, closure);
        }
        return links;
    }

    @Override
    public AgentSet<Link> createLinksTo(Collection<? extends Turtle> a) {
        return this.createLinksTo(a, null);
    }

    @Override
    public AgentSet<Link> createLinksTo(Collection<? extends Turtle> a, Closure closure) {
        Network network = this.getMyObserver().getNetwork("DirectedLinks");
        AgentSet<Link> links = new AgentSet<Link>();
        for (Turtle turtle : a) {
            links.add((Link)network.addEdge((Object)this, (Object)turtle));
        }
        if (closure != null) {
            this.ask(links, closure);
        }
        return links;
    }

    @Override
    public AgentSet<Link> createLinksWith(Collection<? extends Turtle> a) {
        return this.createLinksWith(a, null);
    }

    @Override
    public AgentSet<Link> createLinksWith(Collection<? extends Turtle> a, Closure closure) {
        Network network = this.getMyObserver().getNetwork("UndirectedLinks");
        AgentSet<Link> links = new AgentSet<Link>();
        for (Turtle turtle : a) {
            links.add((Link)network.addEdge((Object)this, (Object)turtle));
        }
        if (closure != null) {
            this.ask(links, closure);
        }
        return links;
    }

    @Override
    public boolean inLinkNeighborQ(Turtle t) {
        Network network = this.getMyObserver().getNetwork("DirectedLinks");
        return network.isPredecessor((Object)t, (Object)this);
    }

    @Override
    public boolean outLinkNeighborQ(Turtle t) {
        Network network = this.getMyObserver().getNetwork("DirectedLinks");
        return network.isPredecessor((Object)this, (Object)t);
    }

    @Override
    public boolean linkNeighborQ(Turtle t) {
        Network network = this.getMyObserver().getNetwork("UndirectedLinks");
        return network.isAdjacent((Object)this, (Object)t);
    }

    @Override
    public AgentSet<Turtle> inLinkNeighbors() {
        Network network = this.getMyObserver().getNetwork("DirectedLinks");
        return Utility.agentSetFromIterable(network.getPredecessors((Object)this));
    }

    @Override
    public AgentSet<Turtle> outLinkNeighbors() {
        Network network = this.getMyObserver().getNetwork("DirectedLinks");
        return Utility.agentSetFromIterable(network.getSuccessors((Object)this));
    }

    @Override
    public AgentSet<Turtle> linkNeighbors() {
        Network network = this.getMyObserver().getNetwork("UndirectedLinks");
        return Utility.agentSetFromIterable(network.getAdjacent((Object)this));
    }

    @Override
    public Link inLinkFrom(Turtle t) {
        Network network = this.getMyObserver().getNetwork("DirectedLinks");
        return (Link)network.getEdge((Object)t, (Object)this);
    }

    @Override
    public Link outLinkTo(Turtle t) {
        Network network = this.getMyObserver().getNetwork("DirectedLinks");
        return (Link)network.getEdge((Object)this, (Object)t);
    }

    @Override
    public Link linkWith(Turtle t) {
        Network network = this.getMyObserver().getNetwork("UndirectedLinks");
        return (Link)network.getEdge((Object)this, (Object)t);
    }

    @Override
    public AgentSet<Link> allMyInLinks() {
        ArrayList list = new ArrayList();
        List<Network> directedNetworks = Utility.getDirectedNetworks(this.getMyObserver());
        for (Network n : directedNetworks) {
            for (Object l : n.getInEdges((Object)this)) {
                list.add(l);
            }
        }
        return new AgentSet<Link>((Collection<Link>)list);
    }

    @Override
    public AgentSet<Link> myInLinks() {
        return Utility.agentSetFromIterable(this.getMyObserver().getNetwork("DirectedLinks").getInEdges((Object)this));
    }

    @Override
    public AgentSet<Link> allMyOutLinks() {
        ArrayList list = new ArrayList();
        List<Network> directedNetworks = Utility.getDirectedNetworks(this.getMyObserver());
        for (Network n : directedNetworks) {
            for (Object l : n.getOutEdges((Object)this)) {
                list.add(l);
            }
        }
        return new AgentSet<Link>((Collection<Link>)list);
    }

    @Override
    public AgentSet<Link> myOutLinks() {
        return Utility.agentSetFromIterable(this.getMyObserver().getNetwork("DirectedLinks").getOutEdges((Object)this));
    }

    @Override
    public AgentSet<Link> allMyLinks() {
        ArrayList list = new ArrayList();
        List<Network> directedNetworks = Utility.getUndirectedNetworks(this.getMyObserver());
        for (Network n : directedNetworks) {
            for (Object l : n.getEdges((Object)this)) {
                list.add(l);
            }
        }
        return new AgentSet<Link>((Collection<Link>)list);
    }

    @Override
    public AgentSet<Link> myLinks() {
        return Utility.agentSetFromIterable(this.getMyObserver().getNetwork("UndirectedLinks").getEdges((Object)this));
    }

    @Override
    public Turtle otherEnd() {
        return (Turtle)this.other(((Link)this.myself()).bothEnds()).get(0);
    }

    @Override
    public Turtle turtle(Number number) {
        return Utility.turtleU(number.intValue(), this.getMyObserver());
    }

    @Override
    public AgentSet<Turtle> turtles() {
        return Utility.turtlesU(this.getMyObserver());
    }

    @Override
    public double randomXcor() {
        return Utility.randomXcorU(this.getMyObserver());
    }

    @Override
    public double randomYcor() {
        return Utility.randomYcorU(this.getMyObserver());
    }

    @Override
    public int getMinPxcor() {
        return Utility.getMinPxcorU(this.getMyObserver());
    }

    @Override
    public int getMaxPxcor() {
        return Utility.getMaxPxcorU(this.getMyObserver());
    }

    @Override
    public int getMinPycor() {
        return Utility.getMinPycorU(this.getMyObserver());
    }

    @Override
    public int getMaxPycor() {
        return Utility.getMaxPycorU(this.getMyObserver());
    }

    @Override
    public int randomPxcor() {
        return Utility.randomPxcorU(this.getMyObserver());
    }

    @Override
    public int randomPycor() {
        return Utility.randomPycorU(this.getMyObserver());
    }

    @Override
    public Patch patch(Number nX, Number nY) {
        double x = nX.doubleValue();
        double y = nY.doubleValue();
        return Utility.patchU(x, y, this.getMyObserver());
    }

    @Override
    public AgentSet<Patch> patches() {
        return this.getMyObserver().patches();
    }

    @Override
    public Link link(Number oneEnd, Number otherEnd) {
        return Utility.linkU(oneEnd.intValue(), otherEnd.intValue(), this.getMyObserver());
    }

    @Override
    public Link link(Turtle oneEnd, Turtle otherEnd) {
        return this.link(oneEnd.getWho(), otherEnd.getWho());
    }

    @Override
    public AgentSet<Link> allLinks() {
        return Utility.allLinksU(this.getMyObserver());
    }

    @Override
    public AgentSet<Link> links() {
        return Utility.linksU(this.getMyObserver());
    }

    @Override
    public int worldHeight() {
        return Utility.worldHeightU(this.getMyObserver());
    }

    @Override
    public int worldWidth() {
        return Utility.worldWidthU(this.getMyObserver());
    }

    @Override
    public void watchMe() {
    }

    @Override
    public int compareTo(Turtle t) {
        return this.who == t.getWho() ? 0 : (this.who < t.getWho() ? -1 : 1);
    }

    @Override
    @Deprecated
    public Stop oldStop() {
        return Stop.TRUE;
    }

    @Override
    public ReLogoAgent minOneOf(Collection<? extends ReLogoAgent> a, Closure closure) {
        return Utility.minOneOfU(this, a, closure);
    }

    @Override
    public AgentSet minNOf(int number, Collection<? extends ReLogoAgent> a, Closure closure) {
        return Utility.minNOfU(this, number, a, closure);
    }

    @Override
    public ReLogoAgent maxOneOf(Collection<? extends ReLogoAgent> a, Closure closure) {
        return Utility.maxOneOfU(this, a, closure);
    }

    @Override
    public AgentSet maxNOf(int number, Collection<? extends ReLogoAgent> a, Closure closure) {
        return Utility.maxNOfU(this, number, a, closure);
    }

    @Override
    public boolean allQ(Collection a, Closure closure) {
        return Utility.allQU(this, a, closure);
    }
}

