/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.relogo;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.PredicateUtils;
import repast.simphony.query.QueryUtils;
import repast.simphony.query.space.continuous.ContinuousWithin;
import repast.simphony.query.space.grid.MooreQuery;
import repast.simphony.query.space.grid.VNQuery;
import repast.simphony.relogo.AgentSet;
import repast.simphony.relogo.Link;
import repast.simphony.relogo.Observer;
import repast.simphony.relogo.Patch;
import repast.simphony.relogo.ReLogoAgent;
import repast.simphony.relogo.Stop;
import repast.simphony.relogo.Turtle;
import repast.simphony.relogo.Utility;
import repast.simphony.relogo.UtilityG;
import repast.simphony.relogo.factories.PatchFactory;
import repast.simphony.space.SpatialException;
import repast.simphony.space.continuous.NdPoint;
import repast.simphony.space.grid.Grid;
import repast.simphony.space.grid.GridPoint;
import repast.simphony.util.collections.Contains;
import repast.simphony.util.collections.FilteredIterator;

public abstract class AbstractPatch
implements Patch {
    private Object myselfObject;
    private Observer myObserver;
    private PatchFactory myPatchFactory;
    public double pcolor = Utility.black();
    public double plabelColor = Utility.white();
    Object plabel;
    private List rowAndColumn = null;

    public Observer getMyObserver() {
        return this.myObserver;
    }

    public void setMyObserver(Observer myObserver) {
        this.myObserver = myObserver;
    }

    public PatchFactory getMyPatchFactory() {
        return this.myPatchFactory;
    }

    public void setMyPatchFactory(PatchFactory myPatchFactory) {
        this.myPatchFactory = myPatchFactory;
    }

    @Override
    public void setMyself(Object o) {
        this.myselfObject = o;
    }

    @Override
    public Object myself() {
        return this.myselfObject;
    }

    @Override
    public void setToDefault() {
        this.pcolor = Utility.black();
        this.plabel = null;
        this.plabelColor = Utility.white();
    }

    @Override
    public int getPxcor() {
        return this.getGridLocation().getX();
    }

    @Override
    public int getPycor() {
        return this.getGridLocation().getY();
    }

    @Override
    public GridPoint getGridLocation() {
        return this.getMyObserver().getGrid().getLocation((Object)this);
    }

    public int[] getXY() {
        int x = this.getPxcor() + this.getMinPxcor();
        int y = this.getPycor() + this.getMinPycor();
        int[] result = new int[]{x, y};
        return result;
    }

    @Override
    public Turtle turtle(Number number) {
        return Utility.turtleU(number.intValue(), this.getMyObserver());
    }

    @Override
    public AgentSet<Turtle> turtles() {
        return Utility.turtlesU(this.getMyObserver());
    }

    @Override
    public double randomXcor() {
        return Utility.randomXcorU(this.getMyObserver());
    }

    @Override
    public double randomYcor() {
        return Utility.randomYcorU(this.getMyObserver());
    }

    @Override
    public int getMinPxcor() {
        return Utility.getMinPxcorU(this.getMyObserver());
    }

    @Override
    public int getMaxPxcor() {
        return Utility.getMaxPxcorU(this.getMyObserver());
    }

    @Override
    public int getMinPycor() {
        return Utility.getMinPycorU(this.getMyObserver());
    }

    @Override
    public int getMaxPycor() {
        return Utility.getMaxPycorU(this.getMyObserver());
    }

    @Override
    public int randomPxcor() {
        return Utility.randomPxcorU(this.getMyObserver());
    }

    @Override
    public int randomPycor() {
        return Utility.randomPycorU(this.getMyObserver());
    }

    @Override
    public Patch patch(Number nX, Number nY) {
        double x = nX.doubleValue();
        double y = nY.doubleValue();
        return Utility.patchU(x, y, this.getMyObserver());
    }

    @Override
    public AgentSet<Patch> patches() {
        return this.getMyObserver().patches();
    }

    @Override
    public List getRowCol() {
        if (this.rowAndColumn == null) {
            this.rowAndColumn = new ArrayList();
            this.rowAndColumn.add(0, this.worldHeight() - (this.getPycor() - this.getMinPycor()) - 1);
            this.rowAndColumn.add(1, this.getPxcor() - this.getMinPxcor());
        }
        return this.rowAndColumn;
    }

    @Override
    public Link link(Number oneEnd, Number otherEnd) {
        return Utility.linkU(oneEnd.intValue(), otherEnd.intValue(), this.getMyObserver());
    }

    @Override
    public Link link(Turtle oneEnd, Turtle otherEnd) {
        return this.link(oneEnd.getWho(), otherEnd.getWho());
    }

    @Override
    public AgentSet<Link> allLinks() {
        return Utility.allLinksU(this.getMyObserver());
    }

    @Override
    public AgentSet<Link> links() {
        return Utility.linksU(this.getMyObserver());
    }

    @Override
    public int worldHeight() {
        return Utility.worldHeightU(this.getMyObserver());
    }

    @Override
    public int worldWidth() {
        return Utility.worldWidthU(this.getMyObserver());
    }

    @Override
    public void watchMe() {
    }

    @Override
    public NdPoint getGridLocationAsNdPoint() {
        GridPoint loc = this.getGridLocation();
        return new NdPoint(new double[]{loc.getX(), loc.getY()});
    }

    @Override
    public double getPcolor() {
        return this.pcolor;
    }

    @Override
    public void setPcolor(double pcolor) {
        this.pcolor = Utility.wrapColor(pcolor);
    }

    @Override
    public Object getPlabel() {
        return this.plabel;
    }

    @Override
    public void setPlabel(Object plabel) {
        this.plabel = plabel;
    }

    @Override
    public double getPlabelColor() {
        return this.plabelColor;
    }

    @Override
    public void setPlabelColor(Number plabelColor) {
        this.plabelColor = Utility.wrapColor(plabelColor.doubleValue());
    }

    @Override
    public double distance(Turtle t) {
        return this.getMyObserver().getSpace().getDistance(this.getGridLocationAsNdPoint(), t.getTurtleLocation());
    }

    @Override
    public double distance(Patch p) {
        return this.getMyObserver().getSpace().getDistance(this.getGridLocationAsNdPoint(), p.getGridLocationAsNdPoint());
    }

    @Override
    public double distancexy(Number nx, Number ny) {
        double x = nx.doubleValue();
        double y = ny.doubleValue();
        return this.getMyObserver().getSpace().getDistance(this.getGridLocationAsNdPoint(), new NdPoint(new double[]{x, y}));
    }

    @Override
    public Patch self() {
        return this;
    }

    private AgentSet<Patch> mooreNeighbors2D(int ... extents) {
        MooreQuery mq = new MooreQuery(this.getMyObserver().getGrid(), (Object)this, extents);
        Iterable i = mq.query();
        Predicate pr = PredicateUtils.andPredicate((Predicate)PredicateUtils.instanceofPredicate(Patch.class), (Predicate)PredicateUtils.notPredicate((Predicate)PredicateUtils.equalPredicate((Object)this)));
        FilteredIterator patchesAt = new FilteredIterator(i.iterator(), pr);
        return Utility.agentSetFromIterator(patchesAt);
    }

    @Override
    public AgentSet<Patch> neighbors() {
        return this.mooreNeighbors2D(1, 1);
    }

    @Override
    public AgentSet<Patch> neighbors(int extent) {
        return this.mooreNeighbors2D(extent, extent);
    }

    @Override
    public AgentSet<Patch> neighbors(int extentX, int extentY) {
        return this.mooreNeighbors2D(extentX, extentY);
    }

    private AgentSet<Patch> vnNeighbors2D(int ... extents) {
        VNQuery mq = new VNQuery(this.getMyObserver().getGrid(), (Object)this, extents);
        Iterable i = mq.query();
        Predicate pr = PredicateUtils.andPredicate((Predicate)PredicateUtils.instanceofPredicate(Patch.class), (Predicate)PredicateUtils.notPredicate((Predicate)PredicateUtils.equalPredicate((Object)this)));
        FilteredIterator patchesAt = new FilteredIterator(i.iterator(), pr);
        return Utility.agentSetFromIterator(patchesAt);
    }

    @Override
    public AgentSet<Patch> neighbors4() {
        return this.vnNeighbors2D(1, 1);
    }

    @Override
    public AgentSet<Patch> neighbors4(int extent) {
        return this.vnNeighbors2D(extent, extent);
    }

    @Override
    public AgentSet<Patch> neighbors4(int extentX, int extentY) {
        return this.vnNeighbors2D(extentX, extentY);
    }

    @Override
    public AgentSet inRadius(Collection a, Number num) {
        ContinuousWithin cwq = new ContinuousWithin(this.getMyObserver().getSpace(), (Object)this, num.doubleValue());
        Contains pr = QueryUtils.createContains((Iterable)cwq.query());
        FilteredIterator result = new FilteredIterator(a.iterator(), (Predicate)pr);
        ArrayList<Object> temp = new ArrayList<Object>();
        while (result.hasNext()) {
            temp.add(result.next());
        }
        return new AgentSet(temp);
    }

    @Override
    public AgentSet other(Collection a) {
        return Utility.removePatchFromCollection(a, this);
    }

    @Override
    public AgentSet<Turtle> turtlesAt(Number ndx, Number ndy) {
        double dx = ndx.doubleValue();
        double dy = ndy.doubleValue();
        double[] displacement = new double[]{dx, dy};
        try {
            GridPoint gridPoint = Utility.getGridPointAtDisplacement(this.getGridLocationAsNdPoint(), displacement, this.getMyObserver());
            return Utility.getTurtlesOnGridPoint(gridPoint, this.getMyObserver());
        }
        catch (SpatialException e) {
            return null;
        }
    }

    @Override
    public AgentSet<Turtle> turtlesHere() {
        Grid grid = this.getMyObserver().getGrid();
        GridPoint gridPoint = grid.getLocation((Object)this);
        return Utility.getTurtlesOnGridPoint(gridPoint, this.getMyObserver());
    }

    @Override
    public AgentSet<Turtle> turtlesOn(Patch p) {
        return Utility.getTurtlesOnGridPoint(p.getGridLocation(), this.getMyObserver());
    }

    @Override
    public AgentSet<Turtle> turtlesOn(Turtle t) {
        return Utility.getTurtlesOnGridPoint(Utility.ndPointToGridPoint(t.getTurtleLocation()), this.getMyObserver());
    }

    @Override
    public AgentSet<Turtle> turtlesOn(Collection a) {
        if (a == null || a.isEmpty()) {
            return new AgentSet<Turtle>();
        }
        HashSet<Turtle> total = new HashSet<Turtle>();
        if (a.iterator().next() instanceof Turtle) {
            for (Object t : a) {
                NdPoint location = ((Turtle)t).getTurtleLocation();
                AgentSet<Turtle> temp = Utility.getTurtlesOnGridPoint(Utility.ndPointToGridPoint(location), this.getMyObserver());
                total.addAll(temp);
            }
        } else {
            for (Object p : a) {
                GridPoint location = ((Patch)p).getGridLocation();
                AgentSet<Turtle> temp = Utility.getTurtlesOnGridPoint(location, this.getMyObserver());
                total.addAll(temp);
            }
        }
        return new AgentSet<Turtle>((Collection<Turtle>)total);
    }

    @Override
    public Patch patchAt(Number ndx, Number ndy) {
        double dx = ndx.doubleValue();
        double dy = ndy.doubleValue();
        double[] displacement = new double[]{dx, dy};
        try {
            return Utility.getPatchAtLocation(Utility.getGridPointAtDisplacement(this.getGridLocationAsNdPoint(), displacement, this.getMyObserver()), this.getMyObserver());
        }
        catch (SpatialException e) {
            return null;
        }
    }

    @Override
    public Patch patchAtHeadingAndDistance(Number heading, Number distance) {
        double[] displacement = Utility.getDisplacementFromHeadingAndDistance(heading.doubleValue(), distance.doubleValue());
        try {
            return Utility.getPatchAtLocation(Utility.getGridPointAtDisplacement(this.getGridLocationAsNdPoint(), displacement, this.getMyObserver()), this.getMyObserver());
        }
        catch (SpatialException e) {
            return null;
        }
    }

    @Override
    public void ask(AgentSet<? extends ReLogoAgent> a, Closure askBlock) {
        try {
            for (ReLogoAgent reLogoAgent : a) {
                reLogoAgent.setMyself(this);
            }
            try {
                a.askAgentSet(askBlock);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            System.err.println("ask(" + a + ") failed.");
            System.err.println("ask(AgentSet) requires all members of AgentSet to extend ReLogoAgent.");
        }
    }

    @Override
    public void ask(Collection<? extends ReLogoAgent> c, Closure askBlock) {
        try {
            for (ReLogoAgent reLogoAgent : c) {
                reLogoAgent.setMyself(this);
            }
            try {
                this.askCollection(c, askBlock);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            System.err.println("ask(" + c + ") failed.");
            System.err.println("ask(List) requires all members of List to extend ReLogoAgent.");
        }
    }

    public void askCollection(Collection<? extends ReLogoAgent> c, Closure cl) {
        cl.setResolveStrategy(1);
        for (ReLogoAgent reLogoAgent : c) {
            cl.setDelegate((Object)reLogoAgent);
            cl.call((Object)reLogoAgent);
        }
    }

    @Override
    public void ask(Turtle t, Closure askBlock) {
        t.setMyself(this);
        t.askTurtle(askBlock);
    }

    @Override
    public void ask(Patch p, Closure askBlock) {
        p.setMyself(this);
        p.askPatch(askBlock);
    }

    @Override
    public void ask(Link l, Closure askBlock) {
        l.setMyself(this);
        l.askLink(askBlock);
    }

    @Override
    public void askPatch(Closure cl) {
        cl.setResolveStrategy(1);
        cl.setDelegate((Object)this);
        cl.call((Object)this);
    }

    @Override
    public AgentSet<Turtle> sprout(Number number) {
        return this.sprout(number, null);
    }

    @Override
    public AgentSet<Turtle> sprout(Number number, Closure closure) {
        return this.sprout(number, null, "default");
    }

    @Override
    public AgentSet<Turtle> sprout(Number number, Closure closure, String turtleType) {
        AgentSet<Turtle> newTurtles = new AgentSet<Turtle>();
        int i = 0;
        while (i < number.intValue()) {
            newTurtles.add(this.getMyObserver().getTurtleFactory().createTurtle(turtleType, this.getGridLocationAsNdPoint()));
            ++i;
        }
        if (closure != null) {
            this.ask(newTurtles, closure);
        }
        return newTurtles;
    }

    @Override
    public AgentSet<Turtle> sprout(Number number, Closure closure, Class turtleType) {
        return this.sprout(number, closure, turtleType.getSimpleName());
    }

    @Override
    public void fileShow(Object value) {
        UtilityG.fileShowU(this.toString(), value);
    }

    @Override
    public void show(Object value) {
        UtilityG.showU(this.toString(), value);
    }

    @Override
    public String toString() {
        return "patch " + this.getPxcor() + " " + this.getPycor();
    }

    @Override
    public int compareTo(Patch p) {
        int thisPxcor = this.getPxcor();
        int thisPycor = this.getPycor();
        int pPxcor = p.getPxcor();
        int pPycor = p.getPycor();
        if (thisPxcor == pPxcor && thisPycor == pPycor) {
            return 0;
        }
        if (thisPycor != pPycor) {
            return thisPycor > pPycor ? -1 : 1;
        }
        return thisPxcor < pPxcor ? -1 : 1;
    }

    @Override
    @Deprecated
    public Stop oldStop() {
        return Stop.TRUE;
    }

    @Override
    public ReLogoAgent minOneOf(Collection<? extends ReLogoAgent> a, Closure closure) {
        return Utility.minOneOfU(this, a, closure);
    }

    @Override
    public AgentSet minNOf(int number, Collection<? extends ReLogoAgent> a, Closure closure) {
        return Utility.minNOfU(this, number, a, closure);
    }

    @Override
    public ReLogoAgent maxOneOf(Collection<? extends ReLogoAgent> a, Closure closure) {
        return Utility.maxOneOfU(this, a, closure);
    }

    @Override
    public AgentSet maxNOf(int number, Collection<? extends ReLogoAgent> a, Closure closure) {
        return Utility.maxNOfU(this, number, a, closure);
    }

    @Override
    public boolean allQ(Collection a, Closure closure) {
        return Utility.allQU(this, a, closure);
    }

    @Override
    public void run(String string) {
        UtilityG.runU(string, this);
    }

    @Override
    public Object runresult(String string) {
        return UtilityG.runresultU(string, this);
    }
}

