/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.relogo;

import cern.colt.function.DoubleFunction;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.jet.math.Functions;
import groovy.lang.Closure;
import groovy.util.ObservableMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import repast.simphony.context.Context;
import repast.simphony.relogo.AgentSet;
import repast.simphony.relogo.BaseTurtle;
import repast.simphony.relogo.DiffusiblePatchVariable;
import repast.simphony.relogo.JavaUtility;
import repast.simphony.relogo.Link;
import repast.simphony.relogo.Observer;
import repast.simphony.relogo.Patch;
import repast.simphony.relogo.ReLogoAgent;
import repast.simphony.relogo.ReLogoModel;
import repast.simphony.relogo.Stop;
import repast.simphony.relogo.Turtle;
import repast.simphony.relogo.Utility;
import repast.simphony.relogo.UtilityG;
import repast.simphony.relogo.factories.LinkFactory;
import repast.simphony.relogo.factories.PatchFactory;
import repast.simphony.relogo.factories.RLWorldDimensions;
import repast.simphony.relogo.factories.TurtleFactory;
import repast.simphony.space.continuous.ContinuousSpace;
import repast.simphony.space.continuous.NdPoint;
import repast.simphony.space.graph.Network;
import repast.simphony.space.grid.Grid;
import repast.simphony.space.grid.GridPoint;
import repast.simphony.space.projection.ProjectionEvent;
import repast.simphony.statecharts.StateChartScheduler;

public abstract class AbstractObserver
implements Observer {
    TurtleFactory tf;
    PatchFactory pf;
    LinkFactory lf;
    Context context;
    RLWorldDimensions rLWorldDimensions;
    AgentSet<Patch> cachedPatches;
    String observerID;
    Map<String, DenseDoubleMatrix2D> patchesVarsMap = new ConcurrentHashMap<String, DenseDoubleMatrix2D>();
    Set<DiffusiblePatchVariable> dpvs = new HashSet<DiffusiblePatchVariable>();
    private Map<String, PropertyChangeListener> modelParamsListenersMap = new HashMap<String, PropertyChangeListener>();

    @Override
    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public String getObserverID() {
        return this.observerID;
    }

    public void setObserverID(String observerID) {
        this.observerID = observerID;
    }

    private Set<DiffusiblePatchVariable> getPatchVars() {
        return this.dpvs;
    }

    public DenseDoubleMatrix2D getPatchVarMatrix(String varName) {
        return this.patchesVarsMap.get(varName);
    }

    @Override
    public void createPatchVar(DiffusiblePatchVariable var) {
        this.dpvs.add(var);
        int xdim = this.worldWidth();
        int ydim = this.worldHeight();
        DenseDoubleMatrix2D ddm = new DenseDoubleMatrix2D(ydim, xdim);
        int x = 0;
        while (x < xdim) {
            int y = 0;
            while (y < ydim) {
                ddm.setQuick(y, x, var.getDefaultValue());
                ++y;
            }
            ++x;
        }
        this.setPatchVarMatrix(var.getName(), ddm);
    }

    public void setPatchVarMatrix(String varName, DenseDoubleMatrix2D mat) {
        this.patchesVarsMap.put(varName, mat);
    }

    public LinkFactory getLinkFactory() {
        return this.lf;
    }

    @Override
    public TurtleFactory getTurtleFactory() {
        return this.tf;
    }

    @Override
    public RLWorldDimensions getRLDimensions() {
        return this.rLWorldDimensions;
    }

    public void setRLWorldDimensions(RLWorldDimensions rLD) {
        this.rLWorldDimensions = rLD;
    }

    public void projectionEventOccurred(ProjectionEvent p) {
        if (p.getType() == ProjectionEvent.EDGE_REMOVED) {
            this.context.remove(p.getSubject());
        }
    }

    public void initializeBaseObserver(String observerID, Context context, TurtleFactory tf, PatchFactory pf, LinkFactory lf, RLWorldDimensions rLD) {
        this.setObserverID(observerID);
        this.setContext(context);
        this.setRLWorldDimensions(rLD);
        this.tf = tf;
        this.pf = pf;
        this.lf = lf;
    }

    @Override
    public void ask(AgentSet<? extends ReLogoAgent> a, Closure askBlock) {
        try {
            for (ReLogoAgent reLogoAgent : a) {
                reLogoAgent.setMyself(this);
            }
            try {
                a.askAgentSet(askBlock);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            System.err.println("ask(" + a + ") failed.");
            System.err.println("ask(AgentSet) requires all members of AgentSet to extend ReLogoAgent.");
        }
    }

    @Override
    public void ask(Collection<? extends ReLogoAgent> c, Closure askBlock) {
        try {
            for (ReLogoAgent reLogoAgent : c) {
                reLogoAgent.setMyself(this);
            }
            try {
                this.askCollection(c, askBlock);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            System.err.println("ask(" + c + ") failed.");
            System.err.println("ask(List) requires all members of List to extend ReLogoAgent.");
        }
    }

    public void askCollection(Collection<? extends ReLogoAgent> c, Closure cl) {
        cl.setResolveStrategy(1);
        for (ReLogoAgent reLogoAgent : c) {
            cl.setDelegate((Object)reLogoAgent);
            cl.call((Object)reLogoAgent);
        }
    }

    @Override
    public void ask(Turtle t, Closure askBlock) {
        t.setMyself(this);
        t.askTurtle(askBlock);
    }

    @Override
    public void ask(Patch p, Closure askBlock) {
        p.setMyself(this);
        p.askPatch(askBlock);
    }

    @Override
    public void ask(Link l, Closure askBlock) {
        l.setMyself(this);
        l.askLink(askBlock);
    }

    @Override
    public void ca() {
        ReLogoModel.getInstance().setTicks(0.0);
        this.ct();
        this.cp();
        this.clearTrackingNetwork();
        StateChartScheduler.INSTANCE.initialize();
    }

    @Override
    public void clearAll() {
        this.ca();
    }

    @Override
    public void ct() {
        AgentSet<Turtle> ts = this.turtles();
        for (Turtle t : ts) {
            t.die();
        }
        BaseTurtle.setWhoCounter(0);
    }

    @Override
    public void clearTurtles() {
        this.ct();
    }

    @Override
    public AgentSet<Turtle> turtles() {
        return Utility.turtlesU(this);
    }

    @Override
    public AgentSet<Turtle> turtlesOn(Patch p) {
        return Utility.getTurtlesOnGridPoint(p.getGridLocation(), this);
    }

    @Override
    public AgentSet<Turtle> turtlesOn(Turtle t) {
        return Utility.getTurtlesOnGridPoint(Utility.ndPointToGridPoint(t.getTurtleLocation()), this);
    }

    @Override
    public AgentSet<Turtle> turtlesOn(Collection a) {
        if (a == null || a.isEmpty()) {
            return new AgentSet<Turtle>();
        }
        HashSet<Turtle> total = new HashSet<Turtle>();
        if (a.iterator().next() instanceof Turtle) {
            for (Object t : a) {
                NdPoint location = ((Turtle)t).getTurtleLocation();
                AgentSet<Turtle> temp = Utility.getTurtlesOnGridPoint(Utility.ndPointToGridPoint(location), this);
                total.addAll(temp);
            }
        } else {
            for (Object p : a) {
                GridPoint location = ((Patch)p).getGridLocation();
                AgentSet<Turtle> temp = Utility.getTurtlesOnGridPoint(location, this);
                total.addAll(temp);
            }
        }
        return new AgentSet<Turtle>((Collection<Turtle>)total);
    }

    @Override
    public void clearLinks() {
        AgentSet<Link> ls = this.allLinks();
        for (Link l : ls) {
            l.die();
        }
    }

    @Override
    public AgentSet<Link> links() {
        return Utility.linksU(this);
    }

    @Override
    public AgentSet<Link> allLinks() {
        return Utility.allLinksU(this);
    }

    @Override
    public void clearPatches() {
        this.cp();
    }

    @Override
    public void clearTrackingNetwork() {
        for (Object o : Utility.getWayPoints(this)) {
            this.context.remove(o);
        }
    }

    @Override
    public void cp() {
        AgentSet<Patch> a = this.patches();
        for (Patch p : a) {
            p.setToDefault();
        }
        for (DiffusiblePatchVariable var : this.getPatchVars()) {
            this.getPatchVarMatrix(var.getName()).assign(var.getDefaultValue());
        }
    }

    @Override
    public AgentSet<Turtle> crt(int number) {
        return this.crt(number, null);
    }

    @Override
    public AgentSet<Turtle> crt(int number, Closure closure) {
        return this.crt(number, closure, "default");
    }

    @Override
    public AgentSet<Turtle> crt(int number, Closure closure, String type) {
        AgentSet<Turtle> newTurtles = new AgentSet<Turtle>();
        int i = 0;
        while (i < number) {
            newTurtles.add(this.tf.createTurtle(type));
            ++i;
        }
        if (closure != null) {
            this.ask(newTurtles, closure);
        }
        return newTurtles;
    }

    @Override
    public AgentSet<Turtle> crt(int number, Closure closure, Class type) {
        return this.crt(number, closure, type.getSimpleName());
    }

    @Override
    public AgentSet<Turtle> createTurtles(int number, Closure closure, String type) {
        return this.crt(number, closure, type);
    }

    @Override
    public AgentSet<Turtle> createTurtles(int number, Closure closure, Class type) {
        return this.crt(number, closure, type.getSimpleName());
    }

    @Override
    public AgentSet<Turtle> createTurtles(int number) {
        return this.crt(number, null);
    }

    @Override
    public AgentSet<Turtle> createTurtles(int number, Closure closure) {
        return this.crt(number, closure);
    }

    @Override
    public AgentSet<Turtle> cro(int number) {
        return this.cro(number, null);
    }

    @Override
    public AgentSet<Turtle> cro(int number, Closure closure) {
        return this.cro(number, closure, "default");
    }

    @Override
    public AgentSet<Turtle> cro(int number, Closure closure, String type) {
        AgentSet<Turtle> newTurtles = new AgentSet<Turtle>();
        double headingIncrement = 360.0 / (double)number;
        int i = 0;
        while (i < number) {
            newTurtles.add(this.tf.createTurtle(type, (double)i * headingIncrement));
            ++i;
        }
        if (closure != null) {
            this.ask(newTurtles, closure);
        }
        return newTurtles;
    }

    @Override
    public AgentSet<Turtle> createOrderedTurtles(int number, Closure closure, String type) {
        return this.cro(number, closure, type);
    }

    @Override
    public AgentSet<Turtle> createOrderedTurtles(int number, Closure closure, Class type) {
        return this.cro(number, closure, type);
    }

    @Override
    public AgentSet<Turtle> cro(int number, Closure closure, Class type) {
        return this.cro(number, closure, type.getSimpleName());
    }

    @Override
    public AgentSet<Turtle> createOrderedTurtles(int number) {
        return this.cro(number, null);
    }

    @Override
    public AgentSet<Turtle> createOrderedTurtles(int number, Closure closure) {
        return this.cro(number, closure);
    }

    @Override
    public void setDefaultShape(String turtleType, String shape) {
        this.tf.setDefaultShape(turtleType, shape);
    }

    @Override
    public void setDefaultShape(Class turtleType, String shape) {
        this.tf.setDefaultShape(turtleType.getSimpleName(), shape);
    }

    @Override
    public void fileShow(Object value) {
        UtilityG.fileShowU(this.toString(), value);
    }

    @Override
    public void show(Object value) {
        UtilityG.showU(this.toString(), value);
    }

    @Override
    public String toString() {
        return this.observerID;
    }

    @Override
    public Grid getGrid() {
        return (Grid)this.context.getProjection("Grid2d");
    }

    @Override
    public ContinuousSpace getSpace() {
        return (ContinuousSpace)this.context.getProjection("Space2d");
    }

    @Override
    public Network getNetwork(String name) {
        return (Network)this.context.getProjection(name);
    }

    @Override
    public Turtle turtle(Number number) {
        return Utility.turtleU(number.intValue(), this);
    }

    @Override
    public double randomXcor() {
        return Utility.randomXcorU(this);
    }

    @Override
    public double randomYcor() {
        return Utility.randomYcorU(this);
    }

    @Override
    public int randomPxcor() {
        return Utility.randomPxcorU(this);
    }

    @Override
    public int randomPycor() {
        return Utility.randomPycorU(this);
    }

    @Override
    public Patch patch(Number nX, Number nY) {
        double x = nX.doubleValue();
        double y = nY.doubleValue();
        return Utility.patchU(x, y, this);
    }

    @Override
    public AgentSet<Patch> patches() {
        if (this.cachedPatches == null) {
            this.cachedPatches = Utility.patchesU(this);
        }
        return this.cachedPatches;
    }

    @Override
    public Link link(Number oneEnd, Number otherEnd) {
        return Utility.linkU(oneEnd.intValue(), otherEnd.intValue(), this);
    }

    @Override
    public Link link(Turtle oneEnd, Turtle otherEnd) {
        return this.link(oneEnd.getWho(), otherEnd.getWho());
    }

    @Override
    public int worldHeight() {
        return Utility.worldHeightU(this);
    }

    @Override
    public int worldWidth() {
        return Utility.worldWidthU(this);
    }

    @Override
    public int getMinPxcor() {
        return Utility.getMinPxcorU(this);
    }

    @Override
    public int getMaxPxcor() {
        return Utility.getMaxPxcorU(this);
    }

    @Override
    public int getMinPycor() {
        return Utility.getMinPycorU(this);
    }

    @Override
    public int getMaxPycor() {
        return Utility.getMaxPycorU(this);
    }

    @Override
    public void diffuse(String patchVariable, double number) {
        this.diff(patchVariable, number, true);
    }

    @Override
    public void diffuse4(String patchVariable, double number) {
        this.diff(patchVariable, number, false);
    }

    private void diff(String patchVariable, double number, boolean isMoore) {
        DenseDoubleMatrix2D ddm = this.getPatchVarMatrix(patchVariable);
        DenseDoubleMatrix2D ddm2 = new DenseDoubleMatrix2D(ddm.rows(), ddm.columns());
        Grid grid = this.getGrid();
        if (grid != null) {
            boolean isPeriodic = grid.isPeriodic();
            JavaUtility.diffuse((DoubleMatrix2D)ddm, (DoubleMatrix2D)ddm2, number, isMoore, isPeriodic);
            this.setPatchVarMatrix(patchVariable, ddm2);
        }
    }

    @Override
    public void diffusibleMultiply(String patchVariable, Number number) {
        this.getPatchVarMatrix(patchVariable).assign(Functions.mult((double)number.doubleValue()));
    }

    @Override
    public void diffusibleDivide(String patchVariable, Number number) {
        this.getPatchVarMatrix(patchVariable).assign(Functions.div((double)number.doubleValue()));
    }

    @Override
    public void diffusibleAdd(String patchVariable, Number number) {
        this.getPatchVarMatrix(patchVariable).assign(Functions.plus((double)number.doubleValue()));
    }

    @Override
    public void diffusibleSubtract(String patchVariable, Number number) {
        this.getPatchVarMatrix(patchVariable).assign(Functions.minus((double)number.doubleValue()));
    }

    @Override
    public void diffusibleApply(String patchVariable, DoubleFunction function) {
        this.getPatchVarMatrix(patchVariable).assign(function);
    }

    @Override
    @Deprecated
    public Stop oldStop() {
        return Stop.TRUE;
    }

    @Override
    public ReLogoAgent minOneOf(Collection<? extends ReLogoAgent> a, Closure closure) {
        return Utility.minOneOfU(this, a, closure);
    }

    @Override
    public AgentSet minNOf(int number, Collection<? extends ReLogoAgent> a, Closure closure) {
        return Utility.minNOfU(this, number, a, closure);
    }

    @Override
    public ReLogoAgent maxOneOf(Collection<? extends ReLogoAgent> a, Closure closure) {
        return Utility.maxOneOfU(this, a, closure);
    }

    @Override
    public AgentSet maxNOf(int number, Collection<? extends ReLogoAgent> a, Closure closure) {
        return Utility.maxNOfU(this, number, a, closure);
    }

    @Override
    public boolean allQ(Collection a, Closure closure) {
        return Utility.allQU(this, a, closure);
    }

    @Override
    public void run(String string) {
        UtilityG.runU(string, this);
    }

    @Override
    public Object runresult(String string) {
        return UtilityG.runresultU(string, this);
    }

    @Override
    public void registerModelParameterListener(String varName, final Closure closure) {
        ObservableMap oMap = (ObservableMap)ReLogoModel.getInstance().getModelParams();
        PropertyChangeListener pcl = this.modelParamsListenersMap.get(varName);
        if (pcl != null) {
            oMap.removePropertyChangeListener(pcl);
        }
        pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                closure.call((Object)evt);
            }
        };
        oMap.addPropertyChangeListener(varName, pcl);
    }
}

