/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.relogo;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import repast.simphony.context.Context;
import repast.simphony.relogo.AgentSet;
import repast.simphony.relogo.Link;
import repast.simphony.relogo.Observer;
import repast.simphony.relogo.Patch;
import repast.simphony.relogo.ReLogoAgent;
import repast.simphony.relogo.Stop;
import repast.simphony.relogo.Turtle;
import repast.simphony.relogo.Utility;
import repast.simphony.relogo.UtilityG;
import repast.simphony.relogo.factories.LinkFactory;
import repast.simphony.space.continuous.NdPoint;
import repast.simphony.space.graph.Network;
import repast.simphony.space.graph.RepastEdge;
import repast.simphony.space.grid.GridPoint;

public abstract class AbstractLink<T>
extends Link<T> {
    private T end1;
    private T end2;
    private Object myselfObject;
    private Observer myObserver;
    private LinkFactory myLinkFactory;
    public double color = Utility.white();
    public boolean hiddenQ = false;
    public Object label;
    public double labelColor = Utility.white();
    public String shape = "default";
    public int thickness = 0;
    public String tieMode = "none";

    @Override
    public T getEnd1() {
        return this.end1;
    }

    @Override
    public void setEnd1(T end1) {
        this.end1 = end1;
    }

    @Override
    public T getEnd2() {
        return this.end2;
    }

    @Override
    public void setEnd2(T end2) {
        this.end2 = end2;
    }

    @Override
    public void setColor(Number color) {
        this.color = Utility.wrapColor(color.doubleValue());
    }

    @Override
    public double getColor() {
        return this.color;
    }

    @Override
    public Object myself() {
        return this.myselfObject;
    }

    @Override
    public Link self() {
        return this;
    }

    public Observer getMyObserver() {
        return this.myObserver;
    }

    public void setMyObserver(Observer myObserver) {
        this.myObserver = myObserver;
    }

    public LinkFactory getMyLinkFactory() {
        return this.myLinkFactory;
    }

    public void setMyLinkFactory(LinkFactory myLinkFactory) {
        this.myLinkFactory = myLinkFactory;
    }

    @Override
    public void setMyself(Object o) {
        this.myselfObject = o;
    }

    @Override
    public AgentSet<Patch> patches() {
        return this.getMyObserver().patches();
    }

    @Override
    public AgentSet<Link> allLinks() {
        return Utility.allLinksU(this.getMyObserver());
    }

    @Override
    public AgentSet<Link> links() {
        return Utility.linksU(this.getMyObserver());
    }

    @Override
    public AgentSet<Turtle> turtlesOn(Patch p) {
        return Utility.getTurtlesOnGridPoint(p.getGridLocation(), this.getMyObserver());
    }

    @Override
    public AgentSet<Turtle> turtlesOn(Turtle t) {
        return Utility.getTurtlesOnGridPoint(Utility.ndPointToGridPoint(t.getTurtleLocation()), this.getMyObserver());
    }

    @Override
    public AgentSet<Turtle> turtlesOn(Collection a) {
        if (a == null || a.isEmpty()) {
            return new AgentSet<Turtle>();
        }
        HashSet<Turtle> total = new HashSet<Turtle>();
        if (a.iterator().next() instanceof Turtle) {
            for (Object t : a) {
                NdPoint location = ((Turtle)t).getTurtleLocation();
                AgentSet<Turtle> temp = Utility.getTurtlesOnGridPoint(Utility.ndPointToGridPoint(location), this.getMyObserver());
                total.addAll(temp);
            }
        } else {
            for (Object p : a) {
                GridPoint location = ((Patch)p).getGridLocation();
                AgentSet<Turtle> temp = Utility.getTurtlesOnGridPoint(location, this.getMyObserver());
                total.addAll(temp);
            }
        }
        return new AgentSet<Turtle>((Collection<Turtle>)total);
    }

    public void setBaseLinkProperties(Observer observer, LinkFactory linkFactory, T source, T target, boolean directed, Number weight) {
        this.setMyObserver(observer);
        this.setMyLinkFactory(linkFactory);
        this.setSource(source);
        this.setTarget(target);
        this.setDirected(directed);
        this.setWeight(weight.doubleValue());
        if (directed) {
            this.setEnd1(source);
            this.setEnd2(target);
        } else if (source instanceof Turtle) {
            if (((Turtle)source).getWho() < ((Turtle)target).getWho()) {
                this.setEnd1(source);
                this.setEnd2(target);
            } else {
                this.setEnd1(target);
                this.setEnd2(source);
            }
        } else {
            this.setEnd1(source);
            this.setEnd2(target);
        }
        Context context = observer.getContext();
        context.add((Object)this);
    }

    @Override
    public void tie() {
        this.tieMode = "fixed";
        Turtle e1 = (Turtle)this.getEnd1();
        Turtle e2 = (Turtle)this.getEnd2();
        if (this.isDirected()) {
            e1.removeFromFreeLeaves(e2);
            e1.addToFixedLeaves(e2);
        } else {
            e1.removeFromFreeLeaves(e2);
            e2.removeFromFreeLeaves(e1);
            e1.addToFixedLeaves(e2);
            e2.addToFixedLeaves(e1);
        }
    }

    @Override
    public void untie() {
        this.tieMode = "none";
        Turtle e1 = (Turtle)this.end1;
        Turtle e2 = (Turtle)this.end2;
        if (this.isDirected()) {
            e1.removeFromFreeLeaves(e2);
            e1.removeFromFixedLeaves(e2);
        } else {
            e1.removeFromFreeLeaves(e2);
            e1.removeFromFixedLeaves(e2);
            e2.removeFromFreeLeaves(e1);
            e2.removeFromFixedLeaves(e1);
        }
    }

    @Override
    public void free() {
        this.tieMode = "free";
        Turtle e1 = (Turtle)this.end1;
        Turtle e2 = (Turtle)this.end2;
        if (this.isDirected()) {
            e1.removeFromFixedLeaves(e2);
            e1.addToFreeLeaves(e2);
        } else {
            e1.removeFromFixedLeaves(e2);
            e2.removeFromFixedLeaves(e1);
            e1.addToFreeLeaves(e2);
            e2.addToFreeLeaves(e1);
        }
    }

    @Override
    public void setHiddenQ(boolean hidden) {
        this.hiddenQ = hidden;
    }

    @Override
    public boolean isHiddenQ() {
        return this.hiddenQ;
    }

    @Override
    public void hideLink() {
        this.setHiddenQ(true);
    }

    @Override
    public void showLink() {
        this.setHiddenQ(false);
    }

    @Override
    public String getLinkType() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void fileShow(Object value) {
        UtilityG.fileShowU(this.toString(), value);
    }

    @Override
    public void show(Object value) {
        UtilityG.showU(this.toString(), value);
    }

    public String toString() {
        return String.valueOf(this.getLinkType()) + " " + ((Turtle)this.end1).getWho() + " " + ((Turtle)this.end2).getWho();
    }

    @Override
    public void ask(AgentSet<? extends ReLogoAgent> a, Closure askBlock) {
        try {
            for (ReLogoAgent reLogoAgent : a) {
                reLogoAgent.setMyself(this);
            }
            try {
                a.askAgentSet(askBlock);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            System.err.println("ask(" + a + ") failed.");
            System.err.println("ask(AgentSet) requires all members of AgentSet to extend ReLogoAgent.");
        }
    }

    @Override
    public void ask(Collection<? extends ReLogoAgent> c, Closure askBlock) {
        try {
            for (ReLogoAgent reLogoAgent : c) {
                reLogoAgent.setMyself(this);
            }
            try {
                this.askCollection(c, askBlock);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            System.err.println("ask(" + c + ") failed.");
            System.err.println("ask(List) requires all members of List to extend ReLogoAgent.");
        }
    }

    public void askCollection(Collection<? extends ReLogoAgent> c, Closure cl) {
        cl.setResolveStrategy(1);
        for (ReLogoAgent reLogoAgent : c) {
            cl.setDelegate((Object)reLogoAgent);
            cl.call((Object)reLogoAgent);
        }
    }

    @Override
    public void ask(Turtle t, Closure askBlock) {
        t.setMyself(this);
        t.askTurtle(askBlock);
    }

    @Override
    public void ask(Patch p, Closure askBlock) {
        p.setMyself(this);
        p.askPatch(askBlock);
    }

    @Override
    public void ask(Link l, Closure askBlock) {
        l.setMyself(this);
        l.askLink(askBlock);
    }

    @Override
    public void askLink(Closure cl) {
        cl.setResolveStrategy(1);
        cl.setDelegate((Object)this);
        cl.call((Object)this);
    }

    @Override
    public AgentSet<Turtle> bothEnds() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.getSource());
        list.add(this.getTarget());
        return new AgentSet<Turtle>((Collection<Turtle>)list);
    }

    @Override
    public void die() {
        this.myObserver.getContext().remove((Object)this);
        Network n1 = this.myObserver.getNetwork(this.getLinkType());
        if (n1.containsEdge((RepastEdge)this)) {
            n1.removeEdge((RepastEdge)this);
        } else {
            ArrayList<Network> networks = new ArrayList<Network>();
            networks.add(this.myObserver.getNetwork("DirectedLinks"));
            networks.add(this.myObserver.getNetwork("UndirectedLinks"));
            for (Network n : networks) {
                if (!n.containsEdge((RepastEdge)this)) continue;
                n.removeEdge((RepastEdge)this);
                break;
            }
        }
    }

    @Override
    public double linkHeading() {
        return ((Turtle)this.end1).towards((Turtle)this.end2);
    }

    @Override
    public double linkLength() {
        return ((Turtle)this.end1).distance((Turtle)this.end2);
    }

    @Override
    public Turtle otherEnd() {
        AgentSet<Turtle> a = this.bothEnds();
        if (a.get(0) == this.myself()) {
            return (Turtle)a.get(1);
        }
        return (Turtle)a.get(0);
    }

    @Override
    public void run(String string) {
        UtilityG.runU(string, this);
    }

    @Override
    public Object runresult(String string) {
        return UtilityG.runresultU(string, this);
    }

    @Override
    public Turtle turtle(Number number) {
        return Utility.turtleU(number.intValue(), this.getMyObserver());
    }

    @Override
    public AgentSet<Turtle> turtles() {
        return Utility.turtlesU(this.getMyObserver());
    }

    @Override
    public double randomXcor() {
        return Utility.randomXcorU(this.getMyObserver());
    }

    @Override
    public double randomYcor() {
        return Utility.randomYcorU(this.getMyObserver());
    }

    @Override
    public int getMinPxcor() {
        return Utility.getMinPxcorU(this.getMyObserver());
    }

    @Override
    public int getMaxPxcor() {
        return Utility.getMaxPxcorU(this.getMyObserver());
    }

    @Override
    public int getMinPycor() {
        return Utility.getMinPycorU(this.getMyObserver());
    }

    @Override
    public int getMaxPycor() {
        return Utility.getMaxPycorU(this.getMyObserver());
    }

    @Override
    public int randomPxcor() {
        return Utility.randomPxcorU(this.getMyObserver());
    }

    @Override
    public int randomPycor() {
        return Utility.randomPycorU(this.getMyObserver());
    }

    @Override
    public Patch patch(Number nX, Number nY) {
        double x = nX.doubleValue();
        double y = nY.doubleValue();
        return Utility.patchU(x, y, this.getMyObserver());
    }

    @Override
    public Link link(Number oneEnd, Number otherEnd) {
        return Utility.linkU(oneEnd.intValue(), otherEnd.intValue(), this.getMyObserver());
    }

    @Override
    public Link link(Turtle oneEnd, Turtle otherEnd) {
        return this.link(oneEnd.getWho(), otherEnd.getWho());
    }

    @Override
    public int worldHeight() {
        return Utility.worldHeightU(this.getMyObserver());
    }

    @Override
    public int worldWidth() {
        return Utility.worldWidthU(this.getMyObserver());
    }

    @Override
    public int compareTo(Link l) {
        if (this.getEnd1() != l.getEnd1()) {
            return ((Turtle)this.getEnd1()).compareTo((Turtle)l.getEnd1());
        }
        if (this.getEnd2() != l.getEnd2()) {
            return ((Turtle)this.getEnd2()).compareTo((Turtle)l.getEnd2());
        }
        return this.getLinkType().compareTo(l.getLinkType());
    }

    @Override
    @Deprecated
    public Stop oldStop() {
        return Stop.TRUE;
    }

    @Override
    public ReLogoAgent minOneOf(Collection<? extends ReLogoAgent> a, Closure closure) {
        return Utility.minOneOfU(this, a, closure);
    }

    @Override
    public AgentSet minNOf(int number, Collection<? extends ReLogoAgent> a, Closure closure) {
        return Utility.minNOfU(this, number, a, closure);
    }

    @Override
    public ReLogoAgent maxOneOf(Collection<? extends ReLogoAgent> a, Closure closure) {
        return Utility.maxOneOfU(this, a, closure);
    }

    @Override
    public AgentSet maxNOf(int number, Collection<? extends ReLogoAgent> a, Closure closure) {
        return Utility.maxNOfU(this, number, a, closure);
    }

    @Override
    public boolean allQ(Collection a, Closure closure) {
        return Utility.allQU(this, a, closure);
    }

    @Override
    public AgentSet other(Collection a) {
        return Utility.removeLinkFromCollection(a, this);
    }

    @Override
    public double getLabelColor() {
        return this.labelColor;
    }

    @Override
    public void setLabelColor(Number labelColor) {
        this.labelColor = Utility.wrapColor(labelColor.doubleValue());
    }
}

