/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.integration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import junit.framework.TestCase;
import repast.simphony.integration.RandomAccessWriter;

public class RandomAccessWriterTest
extends TestCase {
    private File testFile;

    private void checkFile(String expected) throws IOException {
        FileInputStream file = new FileInputStream(this.testFile);
        byte[] b = new byte[file.available()];
        file.read(b);
        file.close();
        String result = new String(b);
        RandomAccessWriterTest.assertEquals((String)expected, (String)result);
        file.close();
    }

    protected void setUp() throws Exception {
        this.testFile = File.createTempFile("randomaccesswritertest", ".txt");
        this.testFile.deleteOnExit();
    }

    protected void tearDown() throws Exception {
        if (this.testFile.exists()) {
            this.testFile.delete();
        }
    }

    public void testMarkWriteResetTruncate() throws IOException {
        RandomAccessWriter writer = new RandomAccessWriter(this.testFile);
        writer.mark();
        writer.write("asdfasdfasdfasdf");
        writer.reset();
        writer.write("1234");
        writer.truncate("asdfasdfasdfasdf".length());
        writer.close();
        this.checkFile("1234asdfasdfasdf");
    }

    public void testWriteMarkResetTruncate() throws IOException {
        RandomAccessWriter writer = new RandomAccessWriter(this.testFile);
        writer.write("asdf");
        writer.mark();
        writer.reset();
        writer.truncateToPosition();
        writer.close();
        this.checkFile("asdf");
    }

    public void testAgain() throws IOException {
        RandomAccessWriter writer = new RandomAccessWriter(this.testFile);
        writer.write("asdf");
        writer.mark();
        writer.write("asdf");
        writer.reset();
        writer.close();
        this.checkFile("asdfasdf");
    }

    public void testAgain2() throws Exception {
        RandomAccessWriter writer = new RandomAccessWriter(this.testFile.getPath());
        writer.write("asdf");
        writer.mark();
        writer.write("as34");
        writer.reset();
        writer.write("12");
        writer.mark();
        writer.write("df");
        writer.reset();
        writer.write("34");
        writer.popMark();
        writer.popMark();
        writer.popMark();
        writer.close();
        this.checkFile("asdf1234");
    }

    public void testAgain3() throws Exception {
        RandomAccessWriter writer = new RandomAccessWriter(this.testFile.getPath());
        writer.write("asdf");
        writer.mark();
        writer.write("as34");
        writer.reset();
        writer.truncateToPosition();
        writer.write("xyzw");
        writer.truncate("asdfxy".length());
        writer.reset();
        writer.close();
        this.checkFile("asdfxy");
    }
}

